{
        Object-Oriented Archive-viewer: ZOO-part
}

unit OOAVZoo;

interface

uses      Dos,OOAV;

const     SIZ_TEXT=20;
const     FNAMESIZE=13;
const     MAX_PACK=1;
const     LO_TAG=$a7dc;
const     HI_TAG=$fdc4;


type      ZFHeader=record
                     lo_tag:word;
                     hi_tag:word;
                     _type:byte;
                     packing_method:byte;
                     next:longint;      { pos'n of next directory entry }
                     offset:longint;
                     date:word;         { DOS format date }
                     time:word;         { DOS format time }
                     file_crc:word;     { CRC of this file }
                     org_size:longint;
                     size_now:longint;
                     major_ver:byte;
                     minor_ver:byte;
                     deleted:boolean;
                     comment:longint;   { points to comment;  zero if none }
                     cmt_size:word;     { length of comment, 0 if none }
                     unknown:byte;
                     fname:array[0..FNAMESIZE-1] of char;
                   end;

type      PZooArchive=^TZooArchive;
          TZooArchive=object(TGeneralArchive)
                        constructor Init;
                        procedure FindFirst(var sr:SearchRec);virtual;
                        procedure FindNext(var sr:SearchRec);virtual;
                      private
                        _FHdr:ZFHeader;
                        procedure GetHeader;
                        procedure GetEntry(var sr:SearchRec);
                      end;

implementation



type      zooHeader=record
                      text:array[0..SIZ_TEXT-1] of char;
                      lo_tag:word;
                      hi_tag:word;
                      start:longint;
                      minus:longint;
                      major_ver:char;
                      minor_ver:char;
                    end;


constructor TZooArchive.Init;
begin
  FillChar(_FHdr,sizeof(_FHdr),0);
end;


procedure TZooArchive.GetHeader;
var       hdr:zooHeader;
          bc:word;
begin
  seek(_FArchive,0);
  BlockRead(_FArchive,hdr,sizeof(hdr),bc);
  seek(_FArchive,hdr.start);
end;


procedure TZooArchive.GetEntry(var sr:SearchRec);
var       bc:word;
          b:byte;
begin
  FillChar(_FHdr,SizeOf(_FHdr),#0);
  BlockRead(_FArchive,_FHdr,sizeof(_FHdr),bc);
  with _FHdr do
  begin
    if _Type<>0 then
    begin
      b:=0;sr.Name:='';
      while FName[b]<>#0 do
      begin
        if FName[b]='/' then
          sr.Name:=''
        else
          sr.Name:=sr.Name+FName[b];
        inc(b);
      end;
      sr.Size:=Org_Size;
      if _Type=0 then sr.Size:=0;
      sr.Time:=Date*longint(256*256)+Time;
      Seek(_FArchive,_FHdr.next);
    end;
  end;
end;


procedure TZooArchive.FindFirst(var sr:SearchRec);
begin
 GetHeader;
 GetEntry(sr);
end;


procedure TZooArchive.FindNext(var sr:SearchRec);
begin
 GetEntry(sr);
end;


end.