#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#define ALPHA_CONST 26
#define GROUP 5
#define SPACE ' '
#define MAX_INPUT_LEN 30
#define INVOCATION_ERROR 20
#define FILE_ERR 11
#define BUFFERSIZE 8192
#define CMD *argv[1]

typedef enum { ENCODE, DECODE } Codeflag;

int convert( int ch, Codeflag C );
long code( Codeflag Operation);





void main( int argc, char **argv )
{
   char answer[ MAX_INPUT_LEN ];

   if( CMD == 'e' || CMD == 'E' )
	 code( ENCODE );
   else
	 if( CMD == 'd' || CMD == 'D' )
	    code ( DECODE );
   else
	 {
	 puts( "Encode or Decode? ");
	 gets( answer );

	 if( *answer == 'e' || *answer == 'E' )
	    code ( ENCODE );
	 else
	    if( *answer == 'd' || *answer == 'D' )
		  code ( DECODE );
	 else
	    exit ( INVOCATION_ERROR );

	 }

}




long code( Codeflag Operation)
{

   register int c,
			 ck,
			 t;

   long number = 0L;  //Number of characters operated on.

   FILE *plaintxt,
	   *codekey,
	   *encfile,
	   *filename;

      if( NULL == ( codekey = fopen( "code.key", "r" ) ) )
          exit( FILE_ERR );
      if( setvbuf( codekey, NULL, _IOFBF, BUFFERSIZE ) )
          exit( FILE_ERR );

   if( Operation == ENCODE )
	{
      if( NULL == ( plaintxt = fopen( "plain.txt", "r" ) ) )
          exit( FILE_ERR );
      if( setvbuf( plaintxt, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_ERR );

      if( NULL == ( encfile = fopen( "encr.xxx", "a" ) ) )
          exit ( FILE_ERR );
      if( setvbuf( encfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_ERR );
	}
   else
	{
      if( NULL == ( plaintxt = fopen( "decr.txt", "w" ) ) )
         exit( FILE_ERR );
      if( setvbuf( plaintxt, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_ERR );

      if( NULL == ( encfile = fopen( "encr.xxx", "r" ) ) )
         exit ( FILE_ERR );
      if( setvbuf( encfile, NULL, _IOFBF, BUFFERSIZE ) )
         exit( FILE_ERR );
	}

  if( Operation == ENCODE )
	filename = plaintxt;
  else
	filename = encfile;

   while( EOF != ( c = fgetc( filename ) ) )
	 if( isalpha( c ) )
	   {
	   number++;

	   c = tolower( c );
	   ck = fgetc( codekey );

	   if( Operation == ENCODE )
		 c += ck;
	   else
		 c -= ck;

	   t = convert( c, Operation );

	   if( Operation == ENCODE )
		 fputc( t, encfile );
	   else
		 fputc( t, plaintxt );

	   if( !( number % GROUP ) && Operation == ENCODE )
		 fputc( SPACE, encfile );

	   }

   fcloseall();

   return( number );

}

int convert( int ch, Codeflag C )
{


	 while ( !islower( ch ) )
	    if( C == ENCODE )
		  ch -= ALPHA_CONST;
	    else
		  ch += ALPHA_CONST;


	  return( ch );

}

