// Copyright Maurizio Maccani - 1994
#ifndef IDATE_CONTROL
#define IDATE_CONTROL
#include <windows.h>
#include <time.h>
/*********************************************************************/
/*                                                                   */
/*                       Intenationalization Data Structure          */
/*                                                                   */
/*********************************************************************/
struct _far intData {
        char  shMonths[12][20];
        char  loMonths[12][20];
        char  veShDays[7][20];
        char  shDays[7][20];
        char  loDays[7][20];              
        BOOL   shortMonth ;
        BOOL   shortDay;
        BOOL   shortYear;
        int    longDateMonthFormat;
        int    longDateYearFormat;
        int    longDateWeekDayFormat;
        int    longDateDayFormat;
        int    longDateSequence;
        char   longDateFirstSeparator[6];
        char   longDateSecondSeparator[6];
        char   longDateThirdSeparator[6];
        int    dateFormat;
        char   dateSeparator;

        int    iTime;
        BOOL   iTLZero;
        char   sTime[4]; 
        char   am[7];
        char   pm[7]; 

        int    iCurrency;
        int    iCurrDigits;
        char   SZCurrency[5];
        int    iNegCurr;
        int    iLZero;

        int    iDigits;
        int    iMeasure;
        char   iThousand[2];
        char   iDecimal[2]; 
        int language;
};
extern "C" intData * FAR PASCAL _export GetIntStructure();
extern "C" void FAR PASCAL _export SetEnvTime(LPCSTR env);
// set dayligh etc.. , for the library.
// return the filled structure

/********************************************************/
/*                                                                                                              */
/*                DATE CONTROL                          */
/*                                                                                                              */
/********************************************************/

/* Date Control Messages */
#define SET_SHORT_DATE_KEY              WM_USER+7003  // Set the key that insert the short date in a date control Default F8
#define SET_CALENDAR_KEY                WM_USER+7002  // Set the key that show the calendar     in a date control Default F2

/* Date Control Styles */
#define DS_AUTODATE                     0X00008000L // Automatically show the current date

/* Date Control Functions */
extern "C" BOOL   FAR PASCAL _export   GetDateTm(HWND hwnd,tm _far *tmIn);
// fill the tm structure with the date contained in the control
extern "C" time_t FAR PASCAL _export   GetDateTime_t(HWND hwnd);
// Return the date contained in the control
extern "C" BOOL   FAR PASCAL _export   GetDateString(HWND hwnd,LPSTR dateIn);
// Fill the dateIn string with the date contained in the control
extern "C" BOOL   FAR PASCAL _export   SetDateTm(HWND hwnd,tm _far tmIn);
// Set the control to the date contained in the tm structure
extern "C" BOOL   FAR PASCAL _export   SetDateTime_t(HWND hwnd,time_t time_tIn);
// Set the control to the time_t value
extern "C" BOOL   FAR PASCAL _export   SetDateString(HWND hwnd,LPSTR dateIn);
// Set the control to the date contained in the string

/* Date Functions */
extern "C" BOOL   FAR PASCAL _export   GetLongDate(tm t,LPSTR buff);
// convert the struct t to a long date
extern "C" LPSTR  FAR PASCAL _export   GetDayName(time_t  in, LPSTR buff);
// get the week day
extern "C" LPSTR  FAR PASCAL _export   GetMonthName(time_t in, LPSTR buff);
// Get the month name

/********************************************************/
/*                                                                                                              */
/*                TIME CONTROL                          */
/*                                                                                                              */
/********************************************************/

/* Time control styles */
#define TS_SECONDS                          0X00008000L // Show also seconds
#define TS_AUTOTIME                 0X00002000L // Fill with the current time                 
#define TS_CLOCK                            0X00004000L // Show a clock                 

/* Time control function */
extern "C" int    FAR PASCAL _export   GetHours(HWND);
// Return The Hours
extern "C" int    FAR PASCAL _export   GetMinutes(HWND);
// Return The Minutes
extern "C" int    FAR PASCAL _export   GetSeconds(HWND);
// Return The Seconds
extern "C" BOOL   FAR PASCAL _export   SetHours(HWND,int);
// Set The Hours
extern "C" BOOL   FAR PASCAL _export   SetMinutes(HWND,int);
// Set The Minutes
extern "C" BOOL   FAR PASCAL _export   SetSeconds(HWND,int);
// Set The Seconds

/********************************************************/
/*                                                                                                              */
/*                CURRENCY CONTROL                      */
/*                                                                                                              */
/********************************************************/

extern "C" long   FAR PASCAL _export   GetDollar(HWND);
// Return the dollar value
extern "C" int    FAR PASCAL _export   GetCentimes(HWND);
// Return the Cents value
extern "C" void   FAR PASCAL _export   SetDollar(HWND,long);
// Return the dollar value
extern "C" BOOL   FAR PASCAL _export   SetCentimes(HWND,int);
// Return the Cents value
extern "C" void   FAR PASCAL _export   SetSign(HWND,int);
// Put the number to a negative value.

/********************************************************/
/*                                                                                                              */
/*                NUMBER   CONTROL                      */
/*                                                                                                              */
/********************************************************/
extern "C" long   FAR PASCAL _export   GetInteger(HWND);
// Return the number integer part
extern "C" long   FAR PASCAL _export   GetFraction(HWND);
// Return the number Fractional part
extern "C" void   FAR PASCAL _export   SetInteger(HWND,long);
// Set the number integer part
extern "C" void   FAR PASCAL _export   SetFraction(HWND,long);
// Set the number Fractional part

#endif
