; ULTRASND environment variable grabber by Patch - hamell@cs.pdx.edu

.model large
.386

.data
ultrasnd        db      'ULTRASND='
ULTRALEN        EQU      $-ultrasnd
PUBLIC          _GUS_port
                _GUS_port       dw      240h
PUBLIC          _GUS_dma
                _GUS_dma        db      7
PUBLIC          _GUS_irq
                _GUS_irq        db      5

.code

; BYTE Get_Gus_Env(void);
;          +-------------- GUS port
;          |   +---------- GUS playback DMA
;          |   | +-------- GUS record DMA
;          |   | | +------ GUS IRQ
;          |   | | | +---- SB MIDI IRQ
; ULTRASND=240,7,7,5,5
; 0 = ULTRASND environment variable not found
; 1 = ULTRASND environment variable found
;     Fills GUSport, GUSdma, and GUSirq with values from ULTRASND

                        PUBLIC  _Get_GUS_Env
_Get_GUS_Env            PROC    FAR
                push    bx cx dx di es

                mov     ah,62h
                int     21h
                mov     es,bx
                mov     bx,es:[2Ch]             ; environment segment
                mov     es,bx
                xor     di,di
                mov     dx,offset ultrasnd
checkvar:       mov     cl,ULTRALEN
                mov     bx,dx
scanvar:        mov     al,byte ptr es:[di]
                cmp     al,byte ptr [bx]
                jne     skipvar
                inc     di
                inc     bx
                dec     cl
                jnz     scanvar

                mov     ax,1                    ; exit with 1, success
                xor     bx,bx
                mov     cl,3
getgusport:
                shl     bx,4
                mov     dl,byte ptr es:[di]
                inc     di
                sub     dl,'0'
                or      bl,dl
                dec     cl
                jnz     getgusport

                mov     [_GUS_port],bx
                inc     di                      ; skip past comma

getgusdma:      cmp     byte ptr es:[di+2],','
                je      gusdma1x
                mov     bl,byte ptr es:[di]
                sub     bl,'0'
                mov     [_GUS_dma],bl
                add     di,2                    ; skip past comma
                jmp     skiprecdma
gusdma1x:       mov     bl,byte ptr es:[di+1]
                sub     bl,'0'
                add     bl,10
                mov     [_GUS_dma],bl
                add     di,3                    ; skip past comma
skiprecdma:     inc     di
                cmp     byte ptr es:[di],','
                jne     skiprecdma
                inc     di

getgusirq:      cmp     byte ptr es:[di+2],','
                je      gusirq1x
                mov     bl,byte ptr es:[di]
                sub     bl,'0'
                mov     [_GUS_irq],bl
                jmp     exitgus
gusirq1x:       mov     bl,byte ptr es:[di+1]
                sub     bl,'0'
                add     bl,10
                mov     [_GUS_irq],bl
                jmp     exitgus

skipvar:        inc     di
                mov     al,es:[di]
                or      al,al
                jnz     skipvar
                inc     di
                mov     al,es:[di]
                or      al,al
                jnz     checkvar

                xor     ax,ax
exitgus:        pop     es di dx cx bx
                ret
_Get_GUS_Env            ENDP

                        END
