/* Copyright (C) 1991, 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* zfilter2.c */
/* Additional filter creation */
#include "memory_.h"
#include "ghost.h"
#include "errors.h"
#include "oper.h"
#include "gsstruct.h"
#include "ialloc.h"
#include "idict.h"
#include "idparam.h"
#include "store.h"
#include "strimpl.h"
#include "sfilter.h"
#include "scfx.h"
#include "slzwx.h"
#include "ifilter.h"

/* Import the CCITTFax setup code from zfdecode.c */
int zcf_setup(P2(os_ptr op, stream_CF_state *pcfs));

/* ------ CCITTFaxEncode filter ------ */

/* <target> <dict> CCITTFaxEncode/filter <file> */
private int
zCFE(os_ptr op)
{	stream_CFE_state cfs;
	int code;
	check_type(*op, t_dictionary);
	check_dict_read(*op);
	code = zcf_setup(op, (stream_CF_state *)&cfs);
	if ( code < 0 )
	  return code;
	return filter_write(op, 1, &s_CFE_template, (stream_state *)&cfs, 0);
}

/* ------ Generalized LZW/GIF encoding filter ------ */

/* <target> LZWEncode/filter <file> */
private int
zLZWE(os_ptr op)
{	return filter_write(op, 0, &s_LZWE_template, NULL, 0);
}

/* ================ Initialization procedure ================ */

BEGIN_OP_DEFS(zfilter2_op_defs) {
		op_def_begin_filter(),
	{"2CCITTFaxEncode", zCFE},
	{"1LZWEncode", zLZWE},
END_OP_DEFS(0) }
