/* Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* iminst.h */
/* Definition of interpreter instance */
#include "imain.h"

/* Define whether or not to look in the current directory first. */
/* This is wrong by any reasonable criterion, but users insist on it. */
#ifndef SEARCH_HERE_FIRST
#  define SEARCH_HERE_FIRST 1
#endif

/* Here is where we actually define the structure of interpreter instances. */
/* Clients normally do not include this. */
struct gs_main_instance_s {
		/* The following are set during initialization. */
	FILE *fstdin;
	FILE *fstdout;
	FILE *fstderr;
	uint memory_chunk_size;		/* 'wholesale' allocation unit */
	ulong name_table_size;
	int init_done;			/* highest init done so far */
	int user_errors;		/* define what to do with errors */
	bool search_here_first;		/* if true, make '.' first lib dir */
	const char **lib_paths;		/* library search list */
	  uint lib_count;		/* # of lib_paths */
	const char *lib_env_path;	/* value of GS_LIB env var or 0 */
};
#define gs_main_instance_default_init_values\
 0, 0, 0, 20000, 0, -1, 0, SEARCH_HERE_FIRST
