#    Copyright (C) 1994, 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for DesqView/X/gcc/X11 configuration.
# Note: this makefile assumes you are using gcc in ANSI mode.

#****************************************************************#
#   If you want to change options, DO NOT edit dvx-gcc.mak       #
#   or makefile.  Edit dgc-head.mak and run the tar_cat script.  #
#****************************************************************#

# ------------------------------- Options ------------------------------- #

####### The following are the only parts of the file you should need to edit.

# ------ Generic options ------ #

# Define the installation commands and target directories for
# executables and files.  The commands are only relevant to `make install';
# the directories also define the default search path for the
# initialization files (gs_*.ps) and the fonts.

INSTALL = install -c
INSTALL_PROGRAM = $(INSTALL) -m 755
INSTALL_DATA = $(INSTALL) -m 644

prefix = c:/bin
bindir = c:/bin
gsdatadir = c:/gs
gsfontdir = c:/gsfonts

docdir=$(gsdatadir)/doc
exdir=$(gsdatadir)/examples
GS_DOCDIR=$(docdir)

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with a ;.

GS_LIB_DEFAULT="$(gsdatadir);$(gsfontdir)"

# Define the name of the interpreter initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# -DDEBUG
#	includes debugging features (-Z switch) in the code.
#	  Code runs substantially slower even if no debugging switches
#	  are set.
# -DNOPRIVATE
#	makes private (static) procedures and variables public,
#	  so they are visible to the debugger and profiler.
#	  No execution time or space penalty.

GENOPT=

# Define the name of the executable file.

GS=gs

# Define the directory where the IJG JPEG library sources are stored,
# and the major version of the library that is stored there.
# You may have to change this if the IJG library version changes.
# See jpeg.mak for more information.

JSRCDIR=jpeg-6
JVERSION=6

# Define the configuration ID.  Read gs.mak carefully before changing this.

CONFIG=

# ------ Platform-specific options ------ #

# Define the name of the C compiler.

CC=gcc

# Define the other compilation flags.
# Add -DBSD4_2 for 4.2bsd systems.
# Add -DSYSV for System V or DG/UX.
# Add -DSYSV -D__SVR3 for SCO ODT, ISC Unix 2.2 or before,
#   or any System III Unix, or System V release 3-or-older Unix.
# Add -DSVR4 (not -DSYSV) for System V release 4.
# XCFLAGS can be set from the command line.
# We don't include -ansi, because this gets in the way of the platform-
#   specific stuff that <math.h> typically needs; nevertheless, we expect
#   gcc to accept ANSI-style function prototypes and function definitions.

# Under DJGPP, since we strip the executable by default, we may as
# well *not* use '-g'.

# CFLAGS=-g -O $(XCFLAGS)
CFLAGS=-O $(XCFLAGS)

# Define platform flags for ld.
# Ultrix wants -x.
# SunOS 4.n may need -Bstatic.
# XLDFLAGS can be set from the command line.

LDFLAGS=$(XLDFLAGS)

# Define any extra libraries to link into the executable.
# ISC Unix 2.2 wants -linet.
# SCO Unix needs -lsocket if you aren't including the X11 driver.
# (Libraries required by individual drivers are handled automatically.)

EXTRALIBS=-lsys -lc

# Define the include switch(es) for the X11 header files.
# This can be null if handled in some other way (e.g., the files are
# in /usr/include, or the directory is supplied by an environment variable);
# in particular, SCO Xenix, Unix, and ODT just want
#XINCLUDE=
# Note that x_.h expects to find the header files in $(XINCLUDE)/X11,
# not in $(XINCLUDE).

XINCLUDE=

# Define the directory/ies and library names for the X11 library files.
# The former can be null if these files are in the default linker search path.
# Unfortunately, Quarterdeck's old libraries did not conform to the
# X11 conventions for naming, in that the main Xlib library was called
# libx.a, not libx11.a.  To make things worse, both are provided in
# the v2.00 library.  Creation dates indicate that 'libx.a' is left
# over from a previous build (or this could just be on my system, but
# others who have upgraded from the early version will have the same
# problem---SJT).  Thus I will make the default to look for
# 'libx11.a', since v1.0x does *not* have it and the linker will
# complain.  With the reverse default, the linker will find to the
# obsolete library on some systems.

XLIBDIRS=
# reverse the comments if you have QDDVX10x or the prerelease version
# of QDLIB200 (still available on some Simtel mirrors, unfortunately)
# XLIBS=Xt Xext X
XLIBS=Xt Xext X11

# Define whether this platform has floating point hardware:
#	FPU_TYPE=2 means floating point is faster than fixed point.
# (This is the case on some RISCs with multiple instruction dispatch.)
#	FPU_TYPE=1 means floating point is at worst only slightly slower
# than fixed point.
#	FPU_TYPE=0 means that floating point may be considerably slower.
#	FPU_TYPE=-1 means that floating point is always much slower than
# fixed point.

FPU_TYPE=1

# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See gs.mak for details.

FEATURE_DEVS=level2.dev writeppm.dev pdf.dev

# Choose whether to compile the .ps initialization files into the executable.
# See gs.mak for details.

COMPILE_INITS=0

# Choose the device(s) to include.  See devs.mak for details.

DEVICE_DEVS=x11.dev
DEVICE_DEVS3=deskjet.dev djet500.dev laserjet.dev ljetplus.dev ljet2p.dev ljet3.dev ljet4.dev
DEVICE_DEVS4=cdeskjet.dev cdjcolor.dev cdjmono.dev cdj550.dev pj.dev pjxl.dev pjxl300.dev
DEVICE_DEVS5=paintjet.dev pjetxl.dev
DEVICE_DEVS9=pbm.dev pbmraw.dev pgm.dev pgmraw.dev pgnm.dev pgnmraw.dev pnm.dev pnmraw.dev ppm.dev ppmraw.dev
DEVICE_DEVS10=tiffcrle.dev tiffg3.dev tiffg32d.dev tiffg4.dev tifflzw.dev tiffpack.dev
DEVICE_DEVS11=tiff24nc.dev
DEVICE_DEVS12=psmono.dev bit.dev bitrgb.dev bitcmyk.dev

# ---------------------------- End of options --------------------------- #

# Define the name of the partial makefile that specifies options --
# used in dependencies.

MAKEFILE=dgc-head.mak

# Define the ANSI-to-K&R dependency.  (gcc accepts ANSI syntax.)

AK=

# Define the compilation rules and flags.

CCC=$(CC) $(CCFLAGS) -c
CCLEAF=$(CCC) -fomit-frame-pointer

# --------------------------- Generic makefile ---------------------------- #

# The remainder of the makefile (unixhead.mak, gs.mak, devs.mak, unixtail.mak)
# is generic.  tar_cat concatenates all these together.
#    Copyright (C) 1994 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# Partial makefile, common to all Desqview/X configurations.

# This part of the makefile gets inserted after the compiler-specific part
# (xxx-head.mak) and before gs.mak and devs.mak.

# ----------------------------- Generic stuff ----------------------------- #

# Define the platform name.

PLATFORM=dvx_

# Define the syntax for command, object, and executable files.

CMD=.bat
O=-o ./
OBJ=o
XE=.exe
XEAUX=.exe

# Define the current directory prefix and command invocations.

CAT=type
D=\\
EXP=
SHELL=
SH=
SHP=

# Define the arguments for genconf.

CONFILES=-p -pl &-l%%s -ol ld.tr

# Define the compilation rules and flags.

CCFLAGS=$(GENOPT) $(CFLAGS)

.c.o: $(AK)
	$(CCC) $*.c

CCCF=$(CCC)
CCD=$(CCC)
CCINT=$(CCC)

# Patch a couple of PC-specific things that aren't relevant to DV/X builds,
# but that cause `make' to produce warnings.

BGIDIR=***UNUSED***
PCFBASM=
#    Copyright (C) 1989, 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# Generic makefile, common to all platforms.
# The platform-specific makefiles `include' this file.
# They define the following symbols:
#	GS - the name of the executable (without the extension, if any).
#	GS_LIB_DEFAULT - the default directory/ies for searching for the
#	    initialization and font files at run time.
#	GS_DOCDIR - the directory where documentation will be available
#	    at run time.
#	JSRCDIR - the directory where the IJG JPEG library source code
#	    is stored (at compilation time).
#	JVERSION - the major version number of the IJG JPEG library.
#	CONFIG - a configuration ID, added at the request of a customer,
#	    that is supposed to help in maintaining multiple variants in
#	    a single directory.  Normally this is an empty string;
#	    it may be any string that is legal as part of a file name.
#	DEVICE_DEVS - the devices to include in the executable.
#	    See devs.mak for details.
#	DEVICE_DEVS1...DEVICE_DEVS15 - additional devices, if the definition
#	    of DEVICE_DEVS doesn't fit on one line.  See devs.mak for details.
#	FEATURE_DEVS - what features to include in the executable.
#	    Normally this is one of:
#		    level1 - a standard PostScript Level 1 language
#			interpreter.
#		    level2 - a standard PostScript Level 2 language
#			interpreter.
#		    pdf - a PDF-capable interpreter.
#	    You may include both level1 and pdf, or both level2 and pdf.
#	    The following feature may be added to either of the standard
#		configurations:
#		    ccfonts - precompile fonts into C, and link them
#			with the executable.  See fonts.doc for details.
#	    The remaining features are of interest primarily to developers
#		who want to "mix and match" features to create custom
#		configurations:
#		    dps - (partial) support for Display PostScript extensions:
#			see language.doc for details.
#		    btoken - support for binary token encodings.
#			Included automatically in the dps and level2 features.
#		    color - support for the Level 1 CMYK color extensions.
#			Included automatically in the dps and level2 features.
#		    compfont - support for composite (type 0) fonts.
#			Included automatically in the level2 feature.
#		    dct - support for DCTEncode/Decode filters.
#			Included automatically in the level2 feature.
#		    filter - support for Level 2 filters (other than eexec,
#			ASCIIHexEncode/Decode, NullEncode, PFBDecode,
#			RunLengthEncode/Decode, and SubFileDecode, which are
#			always included, and DCTEncode/Decode,
#			which are separate).
#			Included automatically in the level2 feature.
#		    type1 - support for Type 1 fonts and eexec;
#			normally included automatically in all configurations.
#		There are quite a number of other sub-features that can be
#		selectively included in or excluded from a configuration,
#		but the above are the ones that are most likely to be of
#		interest.
#	COMPILE_INITS - normally 0; if set to 1, compiles the PostScript
#	    language initialization files (gs_init.ps et al) into the
#	    executable, eliminating the need for these files to be present
#	    at run time.
#	EXTEND_NAMES - a value N between 0 and 6, indicating that the name
#	    table should have a capacity of 2^(16+N) names.  This normally
#	    should be set to 0 (or left undefined), since non-zero values
#	    result in a larger fixed space overhead and slightly slower code.
#	    EXTEND_NAMES is ignored in 16-bit environments.
#
# It is very unlikely that anyone would want to edit the remaining
#   symbols, but we describe them here for completeness:
#	GS_INIT - the name of the initialization file for the interpreter,
#		normally gs_init.ps.
#	PLATFORM - a "device" name for the platform, so that platforms can
#		add various kinds of resources like devices and features.
#	CMD - the suffix for shell command files (e.g., null or .bat).
#		(This is only needed in a few places.)
#	D - the directory separator character (\ for MS-DOS, / for Unix).
#	O - the string for specifying the output file from the C compiler
#		(-o for MS-DOS, -o ./ for Unix).
#	OBJ - the extension for relocatable object files (e.g., o or obj).
#	XE - the extension for executable files (e.g., null or .exe).
#	XEAUX - the extension for the executable files (e.g., null or .exe)
#		for the utility programs (ansi2knr and those compiled with
#		CCAUX).
#	BEGINFILES - the list of files that `make begin' and `make clean'
#		should delete.
#	CCA2K - the C invocation for the ansi2knr program, which is the only
#		one that doesn't use ANSI C syntax.  (It is only needed if
#		the main C compiler also isn't an ANSI compiler.)
#	CCAUX - the C invocation for auxiliary programs (echogs, genarch,
#		genconf, geninit).
#	CCBEGIN - the compilation command for `make begin', normally
#		$(CCC) *.c.
#	CCC - the C invocation for normal compilation.
#	CCD - the C invocation for files that store into frame buffers or
#		device registers.  Needed because some optimizing compilers
#		will eliminate necessary stores.
#	CCCF - the C invocation for compiled fonts and other large,
#		self-contained data modules.  Needed because MS-DOS
#		requires using the 'huge' memory model for these.
#	CCINT - the C invocation for compiling the main interpreter module,
#		normally the same as CCC: this is needed because the
#		Borland compiler generates *worse* code for this module
#		(but only this module) when optimization (-O) is turned on.
#	CCLEAF - the C invocation for compiling modules that contain only
#		leaf procedures, which don't need to build stack frames.
#		This is needed only because many compilers aren't able to
#		recognize leaf procedures on their own.
#	AK - if source files must be converted from ANSI to K&R syntax,
#		this is $(ANSI2KNR_XE); if not, it is null.
#		If a particular platform requires other utility programs
#		to be built, AK must include them too.
#	SHP - the prefix for invoking a shell script in the current directory
#		(null for MS-DOS, $(SH) ./ for Unix).
#	EXPP, EXP - the prefix for invoking an executable program in the
#		current directory (null for MS-DOS, ./ for Unix).
#	SH - the shell for scripts (null on MS-DOS, sh on Unix).
#	CONFILES - the arguments for genconf to generate the appropriate
#		linker control files (various).
#
# The platform-specific makefiles must also include rules for creating
# certain dynamically generated files:
#	gconfig_.h - this indicates the presence or absence of
#	    certain system header files that are located in different
#	    places on different systems.  (It could be generated by
#	    the GNU `configure' program.)
#	gconfigv.h - this indicates the status of certain machine-
#	    and configuration-specific features derived from definitions
#	    in the platform-specific makefile.

# Define the name of this makefile.
GS_MAK=gs.mak

# Define the names of the executables.
GS_XE=$(GS)$(XE)
ANSI2KNR_XE=ansi2knr$(XEAUX)
ECHOGS_XE=echogs$(XEAUX)
GENARCH_XE=genarch$(XEAUX)
GENCONF_XE=genconf$(XEAUX)
GENINIT_XE=geninit$(XEAUX)

# Define the names of the CONFIG-dependent header files.
# gconfig*.h are generated dynamically.
gconfig_h=gconfigx$(CONFIG).h
gconfigf_h=gconfigc$(CONFIG).h

# Watcom make insists that rules have a non-empty body!
all default: $(GS_XE)
	rm -f _temp_*

distclean maintainer-clean realclean: clean
	rm -f makefile

clean: mostlyclean
	rm -f $(GS_XE)

mostlyclean:
	rm -f *.$(OBJ) *.a core gmon.out
	rm -f *.dev *.d_* arch.h devs*.tr gconfig*.h j*.h o*.tr l*.tr
	rm -f gconfig*.c iconfig*.c
	rm -f _temp_* _temp_*.* *.map *.sym
	rm -f $(ANSI2KNR_XE) $(ECHOGS_XE) $(GENARCH_XE) $(GENCONF_XE) $(GENINIT_XE)
	rm -f gs_init.c $(BEGINFILES)

# Remove only configuration-dependent information.
config-clean:
	rm -f *.dev devs*.tr gconfig*.h o*.tr l*.tr

# A rule to do a quick and dirty compilation attempt when first installing
# the interpreter.  Many of the compilations will fail:
# follow this with 'make'.

begin:
	rm -f arch.h gconfig*.h $(GENARCH_XE) $(GS_XE)
	rm -f gconfig*.c iconfig*.c
	rm -f gs_init.c $(BEGINFILES)
	make arch.h gconfigv.h
	- $(CCBEGIN)
	rm -f gconfig.$(OBJ) gdev*.$(OBJ) gp_*.$(OBJ) gsmisc.$(OBJ)
	rm -f ccfontab.$(OBJ) iconfig.$(OBJ) iinit.$(OBJ) interp.$(OBJ)

# Auxiliary programs

arch.h: $(GENARCH_XE)
	$(EXPP) $(EXP)genarch arch.h

# Macros for constructing the *.dev files that describe features and
# devices.
SETDEV=$(EXP)echogs -e .dev -w- -Q-dev -F -s -Q-obj
SETPDEV=$(EXP)echogs -e .dev -w- -Q-dev -F -s -Q-include -Qpage -Q-obj
SETMOD=$(EXP)echogs -e .dev -w- -Q-obj
ADDMOD=$(EXP)echogs -e .dev -a-

######################## How to define new 'features' #######################
#
# One defines new 'features' exactly like devices (see devs.mak for details).
# For example, one would define a feature abc by adding the following to
# gs.mak:
#
#	abc_=abc1.$(OBJ) ...
#	abc.dev: $(GS_MAK) $(ECHOGS_XE) $(abc_)
#		$(SETMOD) abc $(abc_)
#		$(ADDMOD) abc -obj ... [if needed]
#		$(ADDMOD) abc -oper ... [if appropriate]
#		$(ADDMOD) abc -ps ... [if appropriate]
#
# If the abc feature requires the presence of some other features jkl and
# pqr, then the rules must look like this:
#
#	abc_=abc1.$(OBJ) ...
#	abc.dev: $(GS_MAK) $(ECHOGS_XE) $(abc_) jkl.dev pqr.dev
#		$(SETMOD) abc $(abc_)
#		...
#		$(ADDMOD) abc -include jkl pqr

# --------------------- Configuration-dependent files --------------------- #

# gconfig.h shouldn't have to depend on DEVS_ALL, but that would
# involve rewriting gsconfig to only save the device name, not the
# contents of the <device>.dev files.
# FEATURE_DEVS must precede DEVICE_DEVS so that devices can override
# features in obscure cases.

DEVS_ALL=$(PLATFORM).dev $(FEATURE_DEVS) \
  $(DEVICE_DEVS) $(DEVICE_DEVS1) \
  $(DEVICE_DEVS2) $(DEVICE_DEVS3) $(DEVICE_DEVS4) $(DEVICE_DEVS5) \
  $(DEVICE_DEVS6) $(DEVICE_DEVS7) $(DEVICE_DEVS8) $(DEVICE_DEVS9) \
  $(DEVICE_DEVS10) $(DEVICE_DEVS11) $(DEVICE_DEVS12) $(DEVICE_DEVS13) \
  $(DEVICE_DEVS14) $(DEVICE_DEVS15)

devs_tr=devs.tr$(CONFIG)
$(devs_tr): $(GS_MAK) $(MAKEFILE) $(ECHOGS_XE)
	$(EXP)echogs -w $(devs_tr) - $(PLATFORM).dev
	$(EXP)echogs -a $(devs_tr) - $(FEATURE_DEVS)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS1)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS2)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS3)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS4)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS5)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS6)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS7)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS8)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS9)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS10)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS11)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS12)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS13)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS14)
	$(EXP)echogs -a $(devs_tr) - $(DEVICE_DEVS15)

# GCONFIG_EXTRAS can be set on the command line.
# Note that it consists of arguments for echogs, i.e.,
# it isn't just literal text.

ld_tr=ld$(CONFIG).tr
$(gconfig_h) obj.tr objw.tr $(ld_tr) lib.tr: \
  $(MAKEFILE) $(GENCONF_XE) $(ECHOGS_XE) $(devs_tr) $(DEVS_ALL) libcore.dev
	$(EXP)genconf @$(devs_tr) libcore.dev -h $(gconfig_h) $(CONFILES)
	$(EXP)echogs -a $(gconfig_h) -x 23 define GS_LIB_DEFAULT -x 2022 $(GS_LIB_DEFAULT) -x 22
	$(EXP)echogs -a $(gconfig_h) -x 23 define GS_DOCDIR -x 2022 $(GS_DOCDIR) -x 22
	$(EXP)echogs -a $(gconfig_h) -x 23 define GS_INIT -x 2022 $(GS_INIT) -x 22
	$(EXP)echogs -a $(gconfig_h) $(GCONFIG_EXTRAS)

################################################################
# The other platform-independent makefiles are concatenated
# (or included) after this one:
#	lib.mak
#	int.mak
#	jpeg.mak
#	devs.mak
################################################################
#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# (Platform-independent) makefile for graphics library and other support code.
# See the end of gs.mak for where this fits into the build process.

# Define the name of this makefile.
LIB_MAK=lib.mak

# Define the inter-dependencies of the .h files.
# Since not all versions of `make' defer expansion of macros,
# we must list these in bottom-to-top order.

# Generic files

arch_h=arch.h
stdpre_h=stdpre.h
std_h=std.h $(arch_h) $(stdpre_h)

# Platform interfaces

gp_h=gp.h
gpcheck_h=gpcheck.h

# Configuration definitions

# gconfig*.h are generated dynamically.
gconfig__h=gconfig_.h
gconfigv_h=gconfigv.h
gscdefs_h=gscdefs.h

# C library interfaces

# Because of variations in the "standard" header files between systems, and
# because we must include std.h before any file that includes sys/types.h,
# we define local include files named *_.h to substitute for <*.h>.

vmsmath_h=vmsmath.h

dos__h=dos_.h
ctype__h=ctype_.h $(std_h)
dirent__h=dirent_.h $(std_h) $(gconfig__h)
errno__h=errno_.h
malloc__h=malloc_.h $(std_h)
math__h=math_.h $(std_h) $(vmsmath_h)
memory__h=memory_.h $(std_h)
stat__h=stat_.h $(std_h)
stdio__h=stdio_.h $(std_h)
string__h=string_.h $(std_h)
time__h=time_.h $(std_h) $(gconfig__h)
windows__h=windows_.h

# Miscellaneous

gdebug_h=gdebug.h
gsalloc_h=gsalloc.h
gserror_h=gserror.h
gserrors_h=gserrors.h
gsexit_h=gsexit.h
gsio_h=gsio.h
gsmemory_h=gsmemory.h
gsrefct_h=gsrefct.h
gsstruct_h=gsstruct.h
gstypes_h=gstypes.h
gx_h=gx.h $(stdio__h) $(gdebug_h) $(gserror_h) $(gsio_h) $(gsmemory_h) $(gstypes_h)

GX=$(AK) $(gx_h)
GXERR=$(GX) $(gserrors_h)

###### Support

### Include files

gsbitops_h=gsbitops.h
gsbittab_h=gsbittab.h
gsuid_h=gsuid.h
gsutil_h=gsutil.h
gxarith_h=gxarith.h
gxbitmap_h=gxbitmap.h
gxfarith_h=gxfarith.h $(gconfigv_h) $(gxarith_h)
gxfixed_h=gxfixed.h
gxobj_h=gxobj.h $(gxbitmap_h)
# Out of order
gxalloc_h=gxalloc.h $(gsalloc_h) $(gxobj_h)

### Executable code

gsalloc.$(OBJ): gsalloc.c $(GX) $(memory__h) \
  $(gsstruct_h) $(gxalloc_h)

gsbitops.$(OBJ): gsbitops.c $(AK) $(std_h) $(memory__h) $(gsbitops_h)

gsbittab.$(OBJ): gsbittab.c $(AK) $(stdpre_h) $(gsbittab_h)

gsmemory.$(OBJ): gsmemory.c $(GX) \
  $(gsrefct_h) $(gsstruct_h)

gsmisc.$(OBJ): gsmisc.c $(GXERR) $(gconfigv_h) \
  $(math__h) $(memory__h) $(gxfarith_h) $(gxfixed_h)

gsutil.$(OBJ): gsutil.c $(AK) $(gconfigv_h) \
  $(std_h) $(gsuid_h) $(gsutil_h)

###### Low-level facilities and utilities

### Include files

gdevmrop_h=gdevmrop.h

gsccode_h=gsccode.h
gsccolor_h=gsccolor.h $(gsstruct_h)
gscie_h=gscie.h $(gsrefct_h)
gscolor1_h=gscolor.h
gscoord_h=gscoord.h
gscpm_h=gscpm.h
gsdevice_h=gsdevice.h
gsfont_h=gsfont.h
gshsb_h=gshsb.h
gsht_h=gsht.h
gsht1_h=gsht1.h $(gsht_h)
gsimage_h=gsimage.h
gsjconf_h=gsjconf.h $(std_h)
gslib_h=gslib.h $(stdio__h)
gsline_h=gsline.h
gsmatrix_h=gsmatrix.h
gspaint_h=gspaint.h
gsparam_h=gsparam.h
gspath_h=gspath.h
gspath2_h=gspath2.h
gsropt_h=gsropt.h
gsxfont_h=gsxfont.h
# Out of order
gschar_h=gschar.h $(gsccode_h) $(gscpm_h)
gscolor2_h=gscolor2.h $(gsccolor_h) $(gsuid_h) $(gxbitmap_h)

gxchar_h=gxchar.h $(gschar_h)
gxcindex_h=gxcindex.h
gxclio_h=gxclio.h
gxclist_h=gxclist.h $(gxclio_h)
gxclip2_h=gxclip2.h
gxcolor2_h=gxcolor2.h $(gscolor2_h) $(gsrefct_h) $(gxbitmap_h)
gxcoord_h=gxcoord.h $(gscoord_h)
gxcpath_h=gxcpath.h
gxctable_h=gxctable.h
gxdcolor_h=gxdcolor.h $(gsrefct_h) $(gsropt_h) $(gsstruct_h) $(gxbitmap_h) $(gxcindex_h)
gxdda_h=gxdda.h
gxdevice_h=gxdevice.h $(gsmatrix_h) $(gsropt_h) $(gsstruct_h) $(gsxfont_h) $(gxbitmap_h) $(gxcindex_h)
gxdevmem_h=gxdevmem.h
gxdht_h=gxdht.h
gxdither_h=gxdither.h
gxdraw_h=gxdraw.h
gxfcache_h=gxfcache.h $(gsuid_h) $(gsxfont_h)
gxfont_h=gxfont.h $(gsfont_h) $(gsuid_h) $(gsstruct_h)
gxfont0_h=gxfont0.h
gxfrac_h=gxfrac.h
gxiodev_h=gxiodev.h $(stat__h)
gxlum_h=gxlum.h
gxmatrix_h=gxmatrix.h $(gsmatrix_h)
gxpaint_h=gxpaint.h
gxpath_h=gxpath.h $(gscpm_h) $(gspath_h)
gxpcolor_h=gxpcolor.h
gxtmap_h=gxtmap.h
gxxfont_h=gxxfont.h $(gsccode_h) $(gsmatrix_h) $(gsuid_h) $(gsxfont_h)
# The following are out of order because they include other files.
gscspace_h=gscspace.h $(gsccolor_h) $(gsstruct_h) $(gxfrac_h)
gxdcconv_h=gxdcconv.h $(gxfrac_h) $(gsccolor_h)
gxfmap_h=gxfmap.h $(gsrefct_h) $(gxfrac_h) $(gxtmap_h)
gxcmap_h=gxcmap.h $(gxfmap_h)
gxht_h=gxht.h $(gsht1_h) $(gxtmap_h)
gscolor_h=gscolor.h $(gxtmap_h)
gsstate_h=gsstate.h $(gscolor_h) $(gsdevice_h) $(gsht_h) $(gsline_h)

gzcpath_h=gzcpath.h $(gxcpath_h)
gzht_h=gzht.h $(gxdht_h) $(gxfmap_h) $(gxht_h)
gzline_h=gzline.h $(gsline_h)
gzpath_h=gzpath.h $(gsstruct_h) $(gxpath_h)
gzstate_h=gzstate.h $(gsropt_h) $(gsstate_h) $(gxdcolor_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevice_h) $(gxtmap_h)

gdevprn_h=gdevprn.h $(memory__h) $(string__h) $(gx_h) \
  $(gserrors_h) $(gsmatrix_h) $(gsutil_h) \
  $(gxdevice_h) $(gxdevmem_h) $(gxclist_h)

scommon_h=scommon.h $(gsmemory_h) $(gstypes_h) $(gsstruct_h)
shc_h=shc.h $(gsbittab_h)
siscale_h=siscale.h
slzwx_h=slzwx.h
srlx_h=srlx.h
strimpl_h=strimpl.h $(scommon_h) $(gstypes_h) $(gsstruct_h)
# Out of order
gximage_h=gximage.h $(gscspace_h) $(gsimage_h) $(gxdda_h) \
  $(siscale_h) $(strimpl_h)
gxcldev_h=gxcldev.h $(gxclist_h) $(gsropt_h) $(gxfixed_h) $(gzline_h) $(gzpath_h) \
  $(strimpl_h) $(srlx_h)
scf_h=scf.h $(shc_h)
scfx_h=scfx.h $(shc_h)

### Executable code

# gconfig is handled specially.  Currently it goes in psbase rather than
# libcore, which is clearly wrong.
gconfig=gconfig$(CONFIG)
$(gconfig).$(OBJ): gconf.c $(GX) \
  $(gscdefs_h) $(gconfig_h) $(gxdevice_h) $(gxiodev_h) $(MAKEFILE)
	rm -f gconfig.h $(gconfig).c
	cp $(gconfig_h) gconfig.h
	cp gconf.c $(gconfig).c
	$(CCC) $(gconfig).c
	rm -f $(gconfig).c

gxacpath.$(OBJ): gxacpath.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxcpath_h) $(gxdcolor_h) $(gxfixed_h) \
  $(gxpaint_h) $(gzcpath_h) $(gzpath_h)

gxccache.$(OBJ): gxccache.c $(GXERR) $(gpcheck_h) \
  $(gscspace_h) $(gsimage_h) $(gsstruct_h) \
  $(gxchar_h) $(gxdevmem_h) $(gxfcache_h) \
  $(gxfixed_h) $(gxfont_h) $(gxmatrix_h) $(gxxfont_h) \
  $(gzstate_h) $(gzpath_h) $(gzcpath_h) 

gxccman.$(OBJ): gxccman.c $(GXERR) $(gpcheck_h) \
  $(gsbitops_h) $(gsstruct_h) $(gsutil_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gxdevmem_h) $(gxfont_h) $(gxfcache_h) $(gxchar_h) \
  $(gxxfont_h) $(gzstate_h) $(gzpath_h)

gxcht.$(OBJ): gxcht.c $(GXERR) \
  $(gsutil_h) \
  $(gxcmap_h) $(gxdcolor_h) $(gxdevice_h) $(gxfixed_h) $(gxmatrix_h) $(gzht_h) $(gzstate_h)

gxcmap.$(OBJ): gxcmap.c $(GXERR) \
  $(gsccolor_h) $(gscspace_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) $(gxdither_h) \
  $(gxfarith_h) $(gxfrac_h) $(gxlum_h) $(gzstate_h)

gxcpath.$(OBJ): gxcpath.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxfixed_h) $(gzpath_h) $(gzcpath_h)

gxdcconv.$(OBJ): gxdcconv.c $(GX) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdcolor_h) $(gxdevice_h) \
  $(gxfarith_h) $(gxlum_h) $(gzstate_h)

gxdither.$(OBJ): gxdither.c $(GX) \
  $(gsstruct_h) $(gxcmap_h) $(gxdcolor_h) $(gxdevice_h) $(gxdither_h) $(gxlum_h) $(gzht_h)

gxdraw.$(OBJ): gxdraw.c $(GXERR) $(math__h) $(gpcheck_h) \
  $(gxbitmap_h) $(gxdraw_h) $(gxfixed_h) $(gxmatrix_h) $(gzht_h) $(gzstate_h)

gxfill.$(OBJ): gxfill.c $(GXERR) \
  $(gsstruct_h) \
  $(gxdevice_h) $(gxdraw_h) $(gxfixed_h) $(gxmatrix_h) $(gxpaint_h) \
  $(gzcpath_h) $(gzpath_h) $(gzstate_h)

gxht.$(OBJ): gxht.c $(GXERR) \
  $(gsbitops_h) $(gsstruct_h) $(gsutil_h) \
  $(gxfixed_h) $(gxdevice_h) $(gzstate_h) $(gzht_h)

gxpath.$(OBJ): gxpath.c $(GXERR) \
  $(gsstruct_h) $(gxfixed_h) $(gzpath_h)

gxpath2.$(OBJ): gxpath2.c $(GXERR) $(math__h) \
  $(gxfixed_h) $(gxarith_h) $(gzpath_h)

gxpcopy.$(OBJ): gxpcopy.c $(GXERR) $(math__h) \
  $(gsmatrix_h) $(gscoord_h) $(gxfixed_h) $(gxarith_h) $(gzline_h) $(gzpath_h)

gxstroke.$(OBJ): gxstroke.c $(GXERR) $(math__h) $(gpcheck_h) \
  $(gscoord_h) \
  $(gxdraw_h) $(gxfixed_h) $(gxarith_h) $(gxmatrix_h) $(gxpaint_h) \
  $(gzline_h) $(gzpath_h) $(gzstate_h)

###### High-level facilities

gschar.$(OBJ): gschar.c $(GXERR) \
  $(gsstruct_h) \
  $(gxfixed_h) $(gxarith_h) $(gxmatrix_h) $(gxcoord_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h) $(gxfcache_h) $(gzpath_h) $(gzstate_h)

gscolor.$(OBJ): gscolor.c $(GXERR) \
  $(gsccolor_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) $(gzstate_h)

gscoord.$(OBJ): gscoord.c $(GXERR) $(math__h) \
  $(gsccode_h) $(gxcoord_h) $(gxfarith_h) $(gxfixed_h) $(gxfont_h) \
  $(gxmatrix_h) $(gxpath_h) $(gzstate_h)

gsdevice.$(OBJ): gsdevice.c $(GXERR) $(memory__h) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gsparam_h) $(gspath_h) $(gsstruct_h) \
  $(gxarith_h) $(gxbitmap_h) $(gxcmap_h) $(gxdevmem_h) $(gzstate_h)

gsdevmem.$(OBJ): gsdevmem.c $(GXERR) $(math__h) $(memory__h) \
  $(gxarith_h) $(gxdevice_h) $(gxdevmem_h)

gsdparam.$(OBJ): gsdparam.c $(GXERR) $(memory__h) $(string__h) \
  $(gsparam_h) $(gxdevice_h) $(gxfixed_h)

gsfont.$(OBJ): gsfont.c $(GXERR) \
  $(gsstruct_h) \
  $(gxdevice_h) $(gxfixed_h) $(gxmatrix_h) $(gxfont_h) $(gxfcache_h) \
  $(gzstate_h)

gsht.$(OBJ): gsht.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

gshtscr.$(OBJ): gshtscr.c $(GXERR) $(math__h) \
  $(gsstruct_h) $(gxarith_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

gsimage.$(OBJ): gsimage.c $(GXERR) $(math__h) $(gpcheck_h) \
  $(gsccolor_h) $(gspaint_h) $(gsstruct_h) \
  $(gxfixed_h) $(gxfrac_h) $(gxarith_h) $(gxmatrix_h) \
  $(gxdevice_h) $(gzpath_h) $(gzstate_h) \
  $(gzcpath_h) $(gxdevmem_h) $(gximage_h) $(gdevmrop_h)

gsimage0.$(OBJ): gsimage0.c $(GXERR) \
  $(gxcpath_h) $(gxdevice_h) $(gxfixed_h) $(gximage_h) \
  $(gzpath_h) $(gzstate_h)

gsimage1.$(OBJ): gsimage1.c $(GXERR) $(gpcheck_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) $(gsutil_h) \
  $(gxarith_h) $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) \
  $(gxdraw_h) $(gxfixed_h) $(gximage_h) $(gxmatrix_h) \
  $(gzht_h) $(gzpath_h) $(gzstate_h)

gsimage2.$(OBJ): gsimage2.c $(GXERR) $(gpcheck_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) \
  $(gxarith_h) $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) \
  $(gxdraw_h) $(gxfixed_h) $(gximage_h) $(gxmatrix_h) \
  $(gzht_h) $(gzpath_h) $(gzstate_h)

gsimage3.$(OBJ): gsimage3.c $(GXERR) $(gpcheck_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) \
  $(gxarith_h) $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) \
  $(gxdraw_h) $(gxfixed_h) $(gximage_h) $(gxmatrix_h) \
  $(gzht_h) $(gzpath_h) $(gzstate_h)

gsimpath.$(OBJ): gsimpath.c $(GXERR) \
  $(gsmatrix_h) $(gsstate_h) $(gspath_h)

gsinit.$(OBJ): gsinit.c $(memory__h) $(stdio__h) \
  $(gdebug_h) $(gp_h) $(gslib_h) $(gsmemory_h)

gsiodev.$(OBJ): gsiodev.c $(GXERR) $(errno__h) $(string__h) \
  $(gp_h) $(gsparam_h) $(gxiodev_h)

gsline.$(OBJ): gsline.c $(GXERR) $(math__h) \
  $(gxfixed_h) $(gxmatrix_h) $(gzstate_h) $(gzline_h)

gsmatrix.$(OBJ): gsmatrix.c $(GXERR) $(math__h) \
  $(gxfarith_h) $(gxfixed_h) $(gxmatrix_h)

gspaint.$(OBJ): gspaint.c $(GXERR) $(gpcheck_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gspaint_h) $(gxpaint_h) \
  $(gzpath_h) $(gzstate_h) $(gxcpath_h) $(gxdevmem_h) $(gximage_h)

gsparam.$(OBJ): gspaint.c $(GXERR) $(memory__h) $(string__h) \
  $(gsparam_h) $(gsstruct_h)

gspath.$(OBJ): gspath.c $(GXERR) \
  $(gscoord_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzcpath_h) $(gzpath_h) $(gzstate_h)

gsstate.$(OBJ): gsstate.c $(GXERR) \
  $(gscie_h) $(gscolor2_h) $(gscoord_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) \
  $(gzstate_h) $(gzht_h) $(gzline_h) $(gzpath_h) $(gzcpath_h)

###### The internal devices

gdevmem_h=gdevmem.h $(gsbitops_h)

gdevabuf.$(OBJ): gdevabuf.c $(GXERR) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevmem.$(OBJ): gdevmem.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm1.$(OBJ): gdevm1.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm2.$(OBJ): gdevm2.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm4.$(OBJ): gdevm4.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm8.$(OBJ): gdevm8.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm16.$(OBJ): gdevm16.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm24.$(OBJ): gdevm24.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm32.$(OBJ): gdevm32.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevmpla.$(OBJ): gdevmpla.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

# Create a pseudo-"feature" for the entire graphics core library.

LIB1=gsalloc.$(OBJ) gsbitops.$(OBJ) gsbittab.$(OBJ)
LIB2=gschar.$(OBJ) gscolor.$(OBJ) gscoord.$(OBJ) gsdevice.$(OBJ) gsdevmem.$(OBJ)
LIB3=gsdparam.$(OBJ) gsfont.$(OBJ) gsht.$(OBJ) gshtscr.$(OBJ)
LIB4=gsimage.$(OBJ) gsimage0.$(OBJ) gsimage1.$(OBJ) gsimage2.$(OBJ) gsimage3.$(OBJ)
LIB5=gsimpath.$(OBJ) gsinit.$(OBJ) gsiodev.$(OBJ)
LIB6=gsline.$(OBJ) gsmatrix.$(OBJ) gsmemory.$(OBJ) gsmisc.$(OBJ)
LIB7=gspaint.$(OBJ) gsparam.$(OBJ) gspath.$(OBJ) gsstate.$(OBJ) gsutil.$(OBJ)
LIB8=gxacpath.$(OBJ) gxccache.$(OBJ) gxccman.$(OBJ)
LIB9=gxcht.$(OBJ) gxcmap.$(OBJ) gxcpath.$(OBJ)
LIB10=gxdcconv.$(OBJ) gxdither.$(OBJ) gxdraw.$(OBJ) gxfill.$(OBJ)
LIB11=gxht.$(OBJ) gxpath.$(OBJ) gxpath2.$(OBJ) gxpcopy.$(OBJ) gxstroke.$(OBJ)
LIB12=gdevabuf.$(OBJ) gdevmem.$(OBJ) gdevm1.$(OBJ) gdevm2.$(OBJ) gdevm4.$(OBJ)
LIB13=gdevm8.$(OBJ) gdevm16.$(OBJ) gdevm24.$(OBJ) gdevm32.$(OBJ)
LIB14=gdevmpla.$(OBJ)
LIB_ALL=$(LIB1) $(LIB2) $(LIB3) $(LIB4) $(LIB5) $(LIB6) $(LIB7) $(LIB8) \
  $(LIB9) $(LIB10) $(LIB11) $(LIB12) $(LIB13) $(LIB14)
libcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(LIB_ALL) iscale.dev ropcore.dev
	$(EXP)echogs -w libcore.dev $(LIB1)
	$(EXP)echogs -a libcore.dev $(LIB2)
	$(EXP)echogs -a libcore.dev $(LIB3)
	$(EXP)echogs -a libcore.dev $(LIB4)
	$(EXP)echogs -a libcore.dev $(LIB5)
	$(EXP)echogs -a libcore.dev $(LIB6)
	$(EXP)echogs -a libcore.dev $(LIB7)
	$(EXP)echogs -a libcore.dev $(LIB8)
	$(EXP)echogs -a libcore.dev $(LIB9)
	$(EXP)echogs -a libcore.dev $(LIB10)
	$(EXP)echogs -a libcore.dev $(LIB11)
	$(EXP)echogs -a libcore.dev $(LIB12)
	$(EXP)echogs -a libcore.dev $(LIB13)
	$(EXP)echogs -a libcore.dev $(LIB14)
	$(ADDMOD) libcore -dev nullpage
	$(ADDMOD) libcore -include iscale ropcore

# ---------------- CCITTFax filters ---------------- #
# These are used by some drivers, as well as by Level 2 in general.
# Someday we may use them for compressing characters in the cache.

cfe_=scfe.$(OBJ) scfetab.$(OBJ) shc.$(OBJ)
cfe.dev: $(LIB_MAK) $(ECHOGS_XE) $(cfe_)
	$(SETMOD) cfe $(cfe_)

scfe.$(OBJ): scfe.c $(AK) $(stdio__h) $(gdebug_h)\
  $(scf_h) $(strimpl_h) $(scfx_h)

scfetab.$(OBJ): scfetab.c $(AK) $(std_h) $(scommon_h) $(scf_h)

shc.$(OBJ): shc.c $(AK) $(std_h) $(shc_h)

cfd_=scfd.$(OBJ) scfdtab.$(OBJ)
cfd.dev: $(LIB_MAK) $(ECHOGS_XE) $(cfd_)
	$(SETMOD) cfd $(cfd_)

scfd.$(OBJ): scfd.c $(AK) $(stdio__h) $(gdebug_h)\
  $(scf_h) $(strimpl_h) $(scfx_h)

scfdtab.$(OBJ): scfdtab.c $(AK) $(std_h) $(scommon_h) $(scf_h)

# ---------------- RunLength filters ---------------- #
# These are used by clists and also by Level 2 in general.

rle_=srle.$(OBJ)
rle.dev: $(LIB_MAK) $(ECHOGS_XE) $(rle_)
	$(SETMOD) rle $(rle_)

srle.$(OBJ): srld.c $(AK) $(stdio__h) $(memory__h) \
  $(srlx_h) $(strimpl_h)

rld_=srld.$(OBJ)
rld.dev: $(LIB_MAK) $(ECHOGS_XE) $(rld_)
	$(SETMOD) rld $(rld_)

srld.$(OBJ): srld.c $(AK) $(stdio__h) $(memory__h) \
  $(srlx_h) $(strimpl_h)

# ---------------- LZW filters ---------------- #
# These are used by clists and also by Level 2 in general.

#lzwe_=slzwce.$(OBJ)
lzwe_=slzwe.$(OBJ) slzwc.$(OBJ)
lzwe.dev: $(LIB_MAK) $(ECHOGS_XE) $(lzwe_)
	$(SETMOD) lzwe $(lzwe_)

slzwce.$(OBJ): slzwce.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

slzwe.$(OBJ): slzwe.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

slzwc.$(OBJ): slzwc.c $(AK) $(std_h)\
  $(slzwx_h) $(strimpl_h)

lzwd_=slzwd.$(OBJ) slzwc.$(OBJ)
lzwd.dev: $(LIB_MAK) $(ECHOGS_XE) $(lzwd_)
	$(SETMOD) lzwd $(lzwd_)

slzwd.$(OBJ): slzwd.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

# ---------------- Command lists ---------------- #

# Choose between clfile and clmem.  Someday this might be dynamic....
cl_impl=clfile
clist_=gxclist.$(OBJ) gxclread.$(OBJ)
clist.dev: $(LIB_MAK) $(ECHOGS_XE) $(clist_) $(cl_impl).dev rle.dev rld.dev
	$(SETMOD) clist $(clist_)
	$(ADDMOD) clist -include $(cl_impl) rle rld

gxclist.$(OBJ): gxclist.c $(GXERR) $(gpcheck_h) \
  $(gsbitops_h) $(gsmatrix_h) $(gsutil_h) \
  $(gxbitmap_h) $(gxcldev_h) $(gxdevice_h) $(gxdevmem_h)

gxclread.$(OBJ): gxclread.c $(GXERR) $(gpcheck_h) \
  $(gsbitops_h) $(gsdevice_h) $(gsmatrix_h) \
  $(gxbitmap_h) $(gxcldev_h) $(gxdevice_h) $(gxdevmem_h)

# Implement band lists on files.

clfile_=gxclfile.$(OBJ)
clfile.dev: $(LIB_MAK) $(ECHOGS_XE) $(clfile_)
	$(SETMOD) clfile $(clfile_)

gxclfile.$(OBJ): gxclfile.c $(stdio__h) $(string__h) \
  $(gp_h) $(gsmemory_h) $(gserror_h) $(gserrors_h) $(gxclio_h)

# Implement band lists in memory (RAM).

clmem_=gxclmem.$(OBJ)
clmem.dev: $(LIB_MAK) $(ECHOGS_XE) $(clmem_) lzwe.dev lzwd.dev
	$(SETMOD) clmem $(clmem_)
	$(ADDMOD) clmem -include lzwe lzwd

gxclmem_h=gxclmem.h $(gxclio_h)

gxclmem.$(OBJ): gxclmem.c $(GXERR) \
  $(gxclmem_h)

# ---------------- Page devices ---------------- #
# We include this here, rather than in devs.mak, because it is more like
# a feature than a simple device.

page_=gdevprn.$(OBJ)
page.dev: $(LIB_MAK) $(ECHOGS_XE) $(page_) clist.dev
	$(SETMOD) page $(page_)
	$(ADDMOD) page -include clist

gdevprn.$(OBJ): gdevprn.c $(ctype__h) \
  $(gdevprn_h) $(gp_h) $(gsparam_h) $(gxclio_h)

# ---------------- Image scaling filter ---------------- #
# Currently this module is required even in Level 1 systems,
# but it should be optional in Level 1 and required only in Level 2.

iscale_=siscale.$(OBJ)
iscale.dev: $(LIB_MAK) $(ECHOGS_XE) $(iscale_)
	$(SETMOD) iscale $(iscale_)

siscale.$(OBJ): siscale.c $(AK) $(math__h) $(memory__h) $(stdio__h) \
  $(siscale_h) $(strimpl_h)

# ---------------- RasterOp et al ---------------- #
# Currently this module is required, but it should be optional.

gsrop_h=gsrop.h $(gsropt_h)

ropcore_=gdevmrop.$(OBJ) gsrop.$(OBJ) gsroptab.$(OBJ)
ropcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(ropcore_)
	$(SETMOD) ropcore $(ropcore_)

gdevmrop.$(OBJ): gdevmrop.c $(GXERR) $(memory__h) \
  $(gsbittab_h) $(gsropt_h) \
  $(gxdcolor_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h) $(gdevmrop_h)

gsrop.$(OBJ): gsrop.c $(GXERR) \
  $(gsrop_h) $(gzstate_h)

gsroptab.$(OBJ): gsroptab.c $(stdpre_h) $(gsropt_h)
	$(CCLEAF) gsroptab.c

# -------- Composite (PostScript Type 0) font support -------- #

psf0core_=gschar0.$(OBJ) gsfont0.$(OBJ)
psf0core.dev: $(LIB_MAK) $(ECHOGS_XE) $(psf0core_)
	$(SETMOD) psf0core $(psf0core_)

gschar0.$(OBJ): gschar0.c $(GXERR) \
  $(gsstruct_h) $(gxfixed_h) $(gxdevice_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h)

gsfont0.$(OBJ): gsfont0.c $(GXERR) \
  $(gsmatrix_h) $(gsstruct_h) $(gxfixed_h) $(gxdevmem_h) $(gxfcache_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h) $(gxdevice_h)

# ---------------- Pattern color ---------------- #

patcore_=gspcolor.$(OBJ) gxclip2.$(OBJ) gxpcmap.$(OBJ)
patcore.dev: $(LIB_MAK) $(ECHOGS_XE) cmykcore.dev psl2core.dev $(patcore_)
	$(SETMOD) patcore -include cmykcore psl2core
	$(ADDMOD) patcore -obj $(patcore_)

gspcolor.$(OBJ): gspcolor.c $(GXERR) $(math__h) \
  $(gscspace_h) $(gsimage_h) $(gsstruct_h) $(gsutil_h) \
  $(gxarith_h) $(gxcolor2_h) $(gxcoord_h) $(gxclip2_h) \
  $(gxdcolor_h) $(gxdevice_h) $(gxdevmem_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gxpath_h) $(gxpcolor_h) $(gzstate_h)

gxclip2.$(OBJ): gxclip2.c $(GXERR) $(memory__h) \
  $(gsstruct_h) $(gxclip2_h) $(gxdevice_h) $(gxdevmem_h)

gxpcmap.$(OBJ): gxpcmap.c $(GXERR) \
  $(gsstruct_h) $(gscspace_h) $(gsutil_h) \
  $(gxcolor2_h) $(gxdcolor_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) \
  $(gxmatrix_h) $(gxpcolor_h) $(gzstate_h)

# ---------------- PostScript Type 1 (and Type 4) fonts ---------------- #

psf1core_=gstype1.$(OBJ) gxhint1.$(OBJ) gxhint2.$(OBJ) gxhint3.$(OBJ)
psf1core.dev: $(LIB_MAK) $(ECHOGS_XE) $(psf1core_)
	$(SETMOD) psf1core $(psf1core_)

gscrypt1_h=gscrypt1.h
gstype1_h=gstype1.h
gxfont1_h=gxfont1.h
gxop1_h=gxop1.h
gxtype1_h=gxtype1.h $(gscrypt1_h) $(gstype1_h)

gstype1.$(OBJ): gstype1.c $(GXERR) $(math__h) \
  $(gsstruct_h) \
  $(gxarith_h) $(gxcoord_h) $(gxfixed_h) $(gxmatrix_h) $(gxchar_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont1_h) $(gxop1_h) $(gxtype1_h) \
  $(gzstate_h) $(gzpath_h)

gxhint1.$(OBJ): gxhint1.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) \
  $(gzstate_h)

gxhint2.$(OBJ): gxhint2.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) $(gxop1_h) \
  $(gzstate_h)

gxhint3.$(OBJ): gxhint3.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) $(gxop1_h) \
  $(gxpath_h) $(gzstate_h)

# -------- Level 1 color extensions (CMYK color and colorimage) -------- #

cmykcore_=gscolor1.$(OBJ) gsht1.$(OBJ)
cmykcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(cmykcore_)
	$(SETMOD) cmykcore $(cmykcore_)

gscolor1.$(OBJ): gscolor1.c $(GXERR) \
  $(gsccolor_h) $(gscolor1_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) \
  $(gzstate_h)

gsht1.$(OBJ): gsht1.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

# ---------------- Level 2 color space support ---------------- #

psl2core_=gscolor2.$(OBJ)
psl2core.dev: $(LIB_MAK) $(ECHOGS_XE) $(psl2core_)
	$(SETMOD) psl2core $(psl2core_)

gscolor2.$(OBJ): gscolor2.c $(GXERR) \
  $(gscspace_h) \
  $(gxarith_h) $(gxcolor2_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h)

# ---------------- Display Postscript / Level 2 support ---------------- #

dps2core_=gsdps1.$(OBJ)
dps2core.dev: $(LIB_MAK) $(ECHOGS_XE) $(dps2core_)
	$(SETMOD) dps2core $(dps2core_)

gsdps1.$(OBJ): gsdps1.c $(GXERR) $(math__h) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gspath_h) $(gspath2_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gzpath_h) $(gzstate_h)

# ---------------- CIE color ---------------- #

ciecore_=gscie.$(OBJ) gxctable.$(OBJ)
ciecore.dev: $(LIB_MAK) $(ECHOGS_XE) $(ciecore_)
	$(SETMOD) ciecore $(ciecore_)

gscie.$(OBJ): gscie.c $(GXERR) $(math__h) \
  $(gscspace_h) $(gscie_h) $(gscolor2_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxarith_h) $(gxcmap_h) $(gxdevice_h) $(gzstate_h)

gxctable.$(OBJ): gxctable.c $(GX) \
  $(gxfixed_h) $(gxfrac_h) $(gxctable_h)

# ---------------- Separation colors ---------------- #

seprcore_=gscsepr.$(OBJ)
seprcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(seprcore_)
	$(SETMOD) seprcore $(seprcore_)

gscsepr.$(OBJ): gscsepr.c $(GXERR) \
  $(gscspace_h) $(gsmatrix_h) $(gsrefct_h) $(gxcolor2_h) $(gxfixed_h)

# ----------------------- Platform-specific modules ----------------------- #
# Platform-specific code doesn't really belong here: this is code that is
# shared among multiple platforms.

# Frame buffer implementations.

gp_nofb.$(OBJ): gp_nofb.c $(GX) \
  $(gp_h) $(gxdevice_h)

gp_dosfb.$(OBJ): gp_dosfb.c $(AK) $(memory__h) \
  $(gx_h) $(gp_h) $(gserrors_h) $(gxdevice_h)

# MS-DOS file system, also used by Desqview/X.
gp_dosfs.$(OBJ): gp_dosfs.c $(AK) $(dos__h) $(gp_h) $(gx_h)

# MS-DOS file enumeration, *not* used by Desqview/X.
gp_dosfe.$(OBJ): gp_dosfe.c $(AK) $(stdio__h) $(memory__h) $(string__h) \
  $(dos__h) $(gstypes_h) $(gsmemory_h) $(gsstruct_h) $(gp_h) $(gsutil_h)

# Other MS-DOS facilities.
gp_msdos.$(OBJ): gp_msdos.c $(AK) $(dos__h) \
  $(gsmemory_h) $(gstypes_h) $(gp_h)

# Unix(-like) file system, also used by Desqview/X.
gp_unifs.$(OBJ): gp_unifs.c $(AK) $(memory__h) $(string__h) $(gx_h) $(gp_h) \
  $(gsstruct_h) $(gsutil_h) $(stat__h) $(dirent__h)

# Unix(-like) file name syntax, *not* used by Desqview/X.
gp_unifn.$(OBJ): gp_unifn.c $(AK) $(gx_h) $(gp_h)

# ----------------------------- Main program ------------------------------ #

# Main program for library testing

gslib.$(OBJ): gslib.c $(AK) $(math__h) \
  $(gx_h) $(gp_h) $(gserrors_h) $(gsmatrix_h) $(gsstate_h) $(gscspace_h) \
  $(gscolor2_h) $(gscoord_h) $(gsparam_h) \
  $(gspaint_h) $(gspath_h) $(gsstruct_h) $(gsutil_h) \
  $(gxalloc_h) $(gxdevice_h)
#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# (Platform-independent) makefile for language interpreters.
# See the end of gs.mak for where this fits into the build process.

# Define the name of this makefile.
INT_MAK=int.mak

# ======================== Interpreter support ======================== #

# This is support code for all interpreters, not just PostScript and PDF.
# It knows about the PostScript data types, but isn't supposed to
# depend on anything outside itself.

errors_h=errors.h
idebug_h=idebug.h
idict_h=idict.h
igc_h=igc.h
iname_h=iname.h
inamedef_h=inamedef.h $(gconfigv_h) $(iname_h)
ipacked_h=ipacked.h
iref_h=iref.h
isave_h=isave.h
isstate_h=isstate.h
istruct_h=istruct.h $(gsstruct_h)
ivmspace_h=ivmspace.h
opdef_h=opdef.h
# Nested include files
ghost_h=ghost.h $(gx_h) $(iref_h)
imemory_h=imemory.h $(ivmspace_h)
ialloc_h=ialloc.h $(imemory_h)
iastruct_h=iastruct.h $(gxobj_h) $(ialloc_h)
iastate_h=iastate.h $(gxalloc_h) $(ialloc_h) $(istruct_h)
store_h=store.h $(ialloc_h)

GH=$(AK) $(ghost_h)

isupport1_=ialloc.$(OBJ) igc.$(OBJ) igcref.$(OBJ) igcstr.$(OBJ)
isupport2_=ilocate.$(OBJ) iname.$(OBJ) isave.$(OBJ)
isupport_=$(isupport1_) $(isupport2_)
isupport.dev: $(INT_MAK) $(ECHOGS_XE) $(isupport_)
	$(SETMOD) isupport $(isupport1_)
	$(ADDMOD) isupport -obj $(isupport2_)

ialloc.$(OBJ): ialloc.c $(AK) $(gx_h) \
  $(errors_h) $(gsstruct_h) $(gxarith_h) \
  $(iastate_h) $(iref_h) $(ivmspace_h) $(store_h)

# igc.c, igcref.c, and igcstr.c should really be in the dpsand2 list,
# but since all the GC enumeration and relocation routines refer to them,
# it's too hard to separate them out from the Level 1 base.
igc.$(OBJ): igc.c $(GH) \
  $(errors_h) $(gsexit_h) $(gsstruct_h) $(gsutil_h) \
  $(iastate_h) $(idict_h) $(igc_h) $(inamedef_h) \
  $(ipacked_h) $(isave_h) $(isstate_h) $(istruct_h) $(opdef_h) $(store_h)

igcref.$(OBJ): igcref.c $(GH) \
  $(gsexit_h) $(iastate_h) $(idebug_h) $(igc_h) $(iname_h) $(ipacked_h)

igcstr.$(OBJ): igcstr.c $(GH) \
  $(gsstruct_h) $(iastate_h) $(igc_h)

ilocate.$(OBJ): ilocate.c $(GH) $(memory__h) \
  $(errors_h) $(gsexit_h) $(gsstruct_h) \
  $(iastate_h) $(igc_h) $(iname_h) $(ipacked_h) $(isstate_h) $(ivmspace_h) \
  $(store_h)

iname.$(OBJ): iname.c $(GH) $(memory__h) $(string__h) \
  $(gsstruct_h) $(errors_h) $(imemory_h) $(inamedef_h) $(isave_h) $(store_h)

isave.$(OBJ): isave.c $(GH) \
  $(errors_h) $(gsexit_h) $(gsstruct_h) $(gsutil_h) \
  $(iastate_h) $(inamedef_h) $(isave_h) $(isstate_h) $(ivmspace_h) \
  $(ipacked_h) $(store_h)

### Include files

idparam_h=idparam.h
ilevel_h=ilevel.h
iparam_h=iparam.h $(gsparam_h)
istack_h=istack.h
iutil_h=iutil.h
opcheck_h=opcheck.h
opextern_h=opextern.h
# Nested include files
dstack_h=dstack.h $(istack_h)
estack_h=estack.h $(istack_h)
ostack_h=ostack.h $(istack_h)
oper_h=oper.h $(iutil_h) $(opcheck_h) $(opdef_h) $(opextern_h) $(ostack_h)

idebug.$(OBJ): idebug.c $(GH) \
  $(ialloc_h) $(idebug_h) $(idict_h) $(iname_h) $(istack_h) $(iutil_h) $(ivmspace_h) \
  $(ostack_h) $(opdef_h) $(ipacked_h) $(store_h)

idict.$(OBJ): idict.c $(GH) $(errors_h) \
  $(ialloc_h) $(idebug_h) $(ivmspace_h) $(inamedef_h) $(ipacked_h) \
  $(isave_h) $(store_h) $(iutil_h) $(idict_h) $(dstack_h)

idparam.$(OBJ): idparam.c $(GH) $(errors_h) \
  $(gsmatrix_h) $(gsuid_h) \
  $(idict_h) $(idparam_h) $(ilevel_h) $(imemory_h) $(iname_h) $(iutil_h) \
  $(oper_h) $(store_h)

iparam.$(OBJ): iparam.c $(GH) \
  $(ialloc_h) $(idict_h) $(iname_h) $(imemory_h) $(iparam_h) $(istack_h) $(iutil_h) $(ivmspace_h) \
  $(opcheck_h) $(store_h)

istack.$(OBJ): istack.c $(GH) $(memory__h) \
  $(errors_h) $(gsstruct_h) $(gsutil_h) \
  $(ialloc_h) $(istack_h) $(istruct_h) $(iutil_h) $(ivmspace_h) $(store_h)

iutil.$(OBJ): iutil.c $(GH) $(math__h) $(memory__h) $(string__h) \
  $(errors_h) $(idict_h) $(imemory_h) $(iutil_h) $(ivmspace_h) \
  $(iname_h) $(ipacked_h) $(store_h) \
  $(gsmatrix_h) $(gsutil_h)

# ======================== PostScript Level 1 ======================== #

###### Include files

files_h=files.h
fname_h=fname.h
imain_h=imain.h $(gsexit_h)
iminst_h=iminst.h $(imain_h)
ichar_h=ichar.h
icolor_h=icolor.h
icsmap_h=icsmap.h
ifont_h=ifont.h $(gsstruct_h)
interp_h=interp.h
iparray_h=iparray.h
iscan_h=iscan.h
iscannum_h=iscannum.h
istream_h=istream.h
main_h=main.h $(iminst_h)
overlay_h=overlay.h
sbtx_h=sbtx.h
sbwbs_h=sbwbs.h
scanchar_h=scanchar.h
sdct_h=sdct.h
sfilter_h=sfilter.h $(gstypes_h)
shcgen_h=shcgen.h
sjpeg_h=sjpeg.h
smtf_h=smtf.h
spdiffx_h=spdiffx.h
stream_h=stream.h $(scommon_h)
# Nested include files
bfont_h=bfont.h $(ifont_h)
ifilter_h=ifilter.h $(istream_h) $(ivmspace_h)
igstate_h=igstate.h $(gsstate_h) $(istruct_h)
sbhc_h=sbhc.h $(shc_h)
# Include files for optional features
ibnum_h=ibnum.h

### Initialization and scanning

iconfig=iconfig$(CONFIG)
$(iconfig).$(OBJ): iconf.c $(stdio__h) \
  $(gconfig_h) $(gscdefs_h) \
  $(files_h) $(imain_h) $(iref_h) $(ivmspace_h) $(opdef_h) $(stream_h)
	rm -f gconfig.h $(iconfig).c
	cp $(gconfig_h) gconfig.h
	cp iconf.c $(iconfig).c
	$(CCC) $(iconfig).c
	rm -f $(iconfig).c

iinit.$(OBJ): iinit.c $(GH) \
  $(gscdefs_h) $(gsexit_h) $(gsstruct_h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(errors_h) \
  $(ilevel_h) $(iname_h) $(interp_h) $(opdef_h) \
  $(ipacked_h) $(iparray_h) $(iutil_h) $(ivmspace_h) $(store_h)

iscan.$(OBJ): iscan.c $(GH) $(ctype__h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(errors_h) $(files_h) \
  $(ilevel_h) $(iutil_h) $(iscan_h) $(iscannum_h) $(istruct_h) $(ivmspace_h) \
  $(iname_h) $(ipacked_h) $(iparray_h) $(istream_h) $(ostack_h) $(store_h) \
  $(stream_h) $(strimpl_h) $(sfilter_h) $(scanchar_h)

iscannum.$(OBJ): iscannum.c $(GH) $(math__h) \
  $(errors_h) $(iscannum_h) $(scanchar_h) $(store_h) $(stream_h)

iscantab.$(OBJ): iscantab.c $(AK) \
  $(stdpre_h) $(scommon_h) $(scanchar_h)

### Streams

# Define which implementation of files we are using (sfile or sfileno).
# This can be overridden on the `make' command line.
#sfile_impl=sfileno
sfile_impl=sfile

sfile.$(OBJ): sfile.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(stream_h) $(strimpl_h)

sfileno.$(OBJ): sfileno.c $(AK) $(stdio__h) $(errno__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(stream_h) $(strimpl_h)

sfilter1.$(OBJ): sfilter1.c $(AK) $(stdio__h) $(memory__h) \
  $(sfilter_h) $(strimpl_h)

sstring.$(OBJ): sstring.c $(AK) $(stdio__h) $(memory__h) \
  $(scanchar_h) $(sfilter_h) $(strimpl_h)

stream.$(OBJ): stream.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(stream_h) $(strimpl_h)

###### Operators

OP=$(GH) $(errors_h) $(oper_h)

### Non-graphics operators

zarith.$(OBJ): zarith.c $(OP) $(math__h) $(store_h)

zarray.$(OBJ): zarray.c $(OP) $(ialloc_h) $(ipacked_h) $(store_h)

zcontrol.$(OBJ): zcontrol.c $(OP) \
  $(estack_h) $(ipacked_h) $(iutil_h) $(store_h)

zdict.$(OBJ): zdict.c $(OP) \
  $(dstack_h) $(idict_h) $(ilevel_h) $(iname_h) $(ipacked_h) $(ivmspace_h) \
  $(store_h)

zfile.$(OBJ): zfile.c $(OP) $(stat__h) $(gp_h) \
  $(gsstruct_h) $(gxiodev_h) \
  $(ialloc_h) $(estack_h) $(files_h) $(fname_h) $(ilevel_h) $(interp_h) $(iutil_h) \
  $(isave_h) $(main_h) $(sfilter_h) $(stream_h) $(strimpl_h) $(store_h)

zfname.$(OBJ): zfname.c $(OP) \
  $(fname_h) $(gxiodev_h) $(ialloc_h) $(stream_h)

zfileio.$(OBJ): zfileio.c $(OP) $(gp_h) \
  $(files_h) $(ifilter_h) $(store_h) $(stream_h) $(strimpl_h) \
  $(gsmatrix_h) $(gxdevice_h) $(gxdevmem_h)

zfilter.$(OBJ): zfilter.c $(OP) \
  $(gsstruct_h) $(files_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(sfilter_h) $(srlx_h) $(stream_h) $(strimpl_h)

zfproc.$(OBJ): zfproc.c $(GH) $(errors_h) $(oper_h) \
  $(estack_h) $(files_h) $(gsstruct_h) $(ialloc_h) $(ifilter_h) $(istruct_h) \
  $(store_h) $(stream_h) $(strimpl_h)

zgeneric.$(OBJ): zgeneric.c $(OP) \
  $(idict_h) $(estack_h) $(ivmspace_h) $(iname_h) $(ipacked_h) $(store_h)

ziodev.$(OBJ): ziodev.c $(OP) $(string__h) $(gp_h) $(gpcheck_h) \
  $(gsstruct_h) $(gxiodev_h) \
  $(files_h) $(ialloc_h) $(ivmspace_h) $(store_h) $(stream_h)

zmath.$(OBJ): zmath.c $(OP) $(math__h) $(gxfarith_h) $(store_h)

zmisc.$(OBJ): zmisc.c $(OP) $(gscdefs_h) $(gp_h) \
  $(errno__h) $(memory__h) $(string__h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(iname_h) $(ivmspace_h) $(ipacked_h) $(store_h)

zpacked.$(OBJ): zpacked.c $(OP) \
  $(ialloc_h) $(idict_h) $(ivmspace_h) $(iname_h) $(ipacked_h) $(iparray_h) \
  $(istack_h) $(store_h)

zrelbit.$(OBJ): zrelbit.c $(OP) $(gsutil_h) $(store_h) $(idict_h)

zstack.$(OBJ): zstack.c $(OP) $(ialloc_h) $(istack_h) $(store_h)

zstring.$(OBJ): zstring.c $(OP) $(gsutil_h) \
  $(ialloc_h) $(iname_h) $(ivmspace_h) $(store_h)

zsysvm.$(OBJ): zsysvm.c $(OP)

ztoken.$(OBJ): ztoken.c $(OP) \
  $(estack_h) $(files_h) $(gsstruct_h) $(iscan_h) \
  $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

ztype.$(OBJ): ztype.c $(OP) $(math__h) \
  $(dstack_h) $(idict_h) $(imemory_h) $(iname_h) \
  $(iscan_h) $(iutil_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

zvmem.$(OBJ): zvmem.c $(OP) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(estack_h) $(isave_h) $(igstate_h) $(store_h) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h)

### Graphics operators

zchar.$(OBJ): zchar.c $(OP) \
  $(gsstruct_h) $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gschar_h) $(gxdevice_h) $(gxfont_h) $(gzpath_h) $(gzstate_h) \
  $(ialloc_h) $(ichar_h) $(idict_h) $(ifont_h) $(estack_h) $(ilevel_h) $(iname_h) $(igstate_h) $(store_h)

zcolor.$(OBJ): zcolor.c $(OP) \
  $(gxfixed_h) $(gxmatrix_h) $(gzstate_h) $(gxdevice_h) $(gxcmap_h) \
  $(ialloc_h) $(icolor_h) $(estack_h) $(iutil_h) $(igstate_h) $(store_h)

zdevice.$(OBJ): zdevice.c $(OP) \
  $(ialloc_h) $(idict_h) $(igstate_h) $(iname_h) $(interp_h) $(iparam_h) $(ivmspace_h) \
  $(gsmatrix_h) $(gsstate_h) $(gxdevice_h) $(store_h)

zfont.$(OBJ): zfont.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gxfont_h) $(gxfcache_h) \
  $(ialloc_h) $(idict_h) $(igstate_h) $(iname_h) $(isave_h) $(ivmspace_h) \
  $(bfont_h) $(store_h)

zfont2.$(OBJ): zfont2.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gschar_h) $(gxfixed_h) $(gxfont_h) \
  $(ialloc_h) $(bfont_h) $(idict_h) $(idparam_h) $(ilevel_h) $(iname_h) $(istruct_h) \
  $(ipacked_h) $(store_h)

zgstate.$(OBJ): zgstate.c $(OP) \
  $(gsmatrix_h) $(ialloc_h) $(idict_h) $(igstate_h) $(istruct_h) $(store_h)

zht.$(OBJ): zht.c $(OP) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(ialloc_h) $(estack_h) $(igstate_h) $(store_h)

zmatrix.$(OBJ): zmatrix.c $(OP) $(gsmatrix_h) $(igstate_h) $(gscoord_h) $(store_h)

zpaint.$(OBJ): zpaint.c $(OP) \
  $(estack_h) $(ialloc_h) $(ifilter_h) $(igstate_h) $(ilevel_h) \
  $(gscspace_h) $(gsimage_h) $(gsmatrix_h) $(gspaint_h) $(gsstruct_h) \
  $(store_h) $(stream_h)

zpath.$(OBJ): zpath.c $(OP) $(math__h) \
  $(gsmatrix_h) $(gspath_h) $(igstate_h) $(store_h)

# Define the base PostScript language interpreter.
# This is the subset of PostScript Level 1 required by our PDF reader.

INT1=idebug.$(OBJ) idict.$(OBJ) idparam.$(OBJ) iinit.$(OBJ)
INT2=interp.$(OBJ) iparam.$(OBJ) ireclaim.$(OBJ)
INT3=iscan.$(OBJ) iscannum.$(OBJ) iscantab.$(OBJ) istack.$(OBJ) iutil.$(OBJ)
INT4=$(sfile_impl).$(OBJ) sfilter1.$(OBJ) sstring.$(OBJ) stream.$(OBJ)
Z1=zarith.$(OBJ) zarray.$(OBJ) zcontrol.$(OBJ) zdict.$(OBJ)
Z1OPS=zarith zarray zcontrol zdict
Z2=zfile.$(OBJ) zfileio.$(OBJ) zfilter.$(OBJ) zfname.$(OBJ) zfproc.$(OBJ)
Z2OPS=zfile zfileio zfilter zfproc
Z3=zgeneric.$(OBJ) ziodev.$(OBJ) zmath.$(OBJ) zmisc.$(OBJ) zpacked.$(OBJ)
Z3OPS=zgeneric ziodev zmath zmisc zpacked
Z4=zrelbit.$(OBJ) zstack.$(OBJ) zstring.$(OBJ) zsysvm.$(OBJ)
Z4OPS=zrelbit zstack zstring zsysvm
Z5=ztoken.$(OBJ) ztype.$(OBJ) zvmem.$(OBJ)
Z5OPS=ztoken ztype zvmem
Z6=zchar.$(OBJ) zcolor.$(OBJ) zdevice.$(OBJ) zfont.$(OBJ) zfont2.$(OBJ)
Z6OPS=zchar zcolor zdevice zfont zfont2
Z7=zgstate.$(OBJ) zht.$(OBJ) zmatrix.$(OBJ) zpaint.$(OBJ) zpath.$(OBJ)
Z7OPS=zgstate zht zmatrix zpaint zpath
# We have to be a little underhanded with *config.$(OBJ) so as to avoid
# circular definitions.
INT_OBJS=gsmain.$(OBJ) \
  $(INT1) $(INT2) $(INT3) $(INT4) \
  $(Z1) $(Z2) $(Z3) $(Z4) $(Z5) $(Z6) $(Z7)
INT_CONFIG=$(gconfig).$(OBJ) $(iconfig).$(OBJ) iccinit$(COMPILE_INITS).$(OBJ)
INT_ALL=$(INT_OBJS) $(INT_CONFIG)
# We omit libcore.dev, which should be included here, because problems
# with the Unix linker require libcore to appear last in the link list
# when libcore is really a library.
# We omit $(INT_CONFIG) from the dependency list because they have special
# dependency requirements and are added to the link list at the very end.
# zfilter.c shouldn't include the RLE and RLD filters, but we don't want to
# change this now.
psbase.dev: $(INT_MAK) $(ECHOGS_XE) $(INT_OBJS) isupport.dev rld.dev rle.dev
	$(SETMOD) psbase gsmain.$(OBJ)
	$(ADDMOD) psbase -obj $(INT_CONFIG)
	$(ADDMOD) psbase -obj $(INT1)
	$(ADDMOD) psbase -obj $(INT2)
	$(ADDMOD) psbase -obj $(INT3)
	$(ADDMOD) psbase -obj $(INT4)
	$(ADDMOD) psbase -obj $(Z1)
	$(ADDMOD) psbase -oper $(Z1OPS)
	$(ADDMOD) psbase -obj $(Z2)
	$(ADDMOD) psbase -oper $(Z2OPS)
	$(ADDMOD) psbase -obj $(Z3)
	$(ADDMOD) psbase -oper $(Z3OPS)
	$(ADDMOD) psbase -obj $(Z4)
	$(ADDMOD) psbase -oper $(Z4OPS)
	$(ADDMOD) psbase -obj $(Z5)
	$(ADDMOD) psbase -oper $(Z5OPS)
	$(ADDMOD) psbase -obj $(Z6)
	$(ADDMOD) psbase -oper $(Z6OPS)
	$(ADDMOD) psbase -obj $(Z7)
	$(ADDMOD) psbase -oper $(Z7OPS)
	$(ADDMOD) psbase -iodev stdin stdout stderr lineedit statementedit
	$(ADDMOD) psbase -include isupport rld rle

# -------------------------- Feature definitions -------------------------- #

# ---------------- Full Level 1 interpreter ---------------- #

level1.dev: $(INT_MAK) $(ECHOGS_XE) psbase.dev bcp.dev hsb.dev path1.dev type1.dev
	$(SETMOD) level1 -include psbase bcp hsb path1 type1
	$(ADDMOD) level1 -emulator PostScript PostScriptLevel1

# -------- Level 1 color extensions (CMYK color and colorimage) -------- #

color.dev: $(INT_MAK) $(ECHOGS_XE) cmykcore.dev cmykread.dev
	$(SETMOD) color -include cmykcore cmykread

cmykread_=zcolor1.$(OBJ) zht1.$(OBJ)
cmykread.dev: $(INT_MAK) $(ECHOGS_XE) $(cmykread_)
	$(SETMOD) cmykread $(cmykread_)
	$(ADDMOD) cmykread -oper zcolor1 zht1

zcolor1.$(OBJ): zcolor1.c $(OP) \
  $(gscolor1_h) $(gscspace_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h) $(gxdevice_h) $(gxcmap_h) \
  $(ialloc_h) $(icolor_h) $(estack_h) $(iutil_h) $(igstate_h) $(store_h)

zht1.$(OBJ): zht1.c $(OP) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(ialloc_h) $(estack_h) $(igstate_h) $(store_h)

# ---------------- HSB color ---------------- #

hsb_=gshsb.$(OBJ) zhsb.$(OBJ)
hsb.dev: $(INT_MAK) $(ECHOGS_XE) $(hsb_)
	$(SETMOD) hsb $(hsb_)
	$(ADDMOD) hsb -oper zhsb

gshsb.$(OBJ): gshsb.c $(GX) \
  $(gscolor_h) $(gshsb_h) $(gxfrac_h)

zhsb.$(OBJ): zhsb.c $(OP) \
  $(gshsb_h) $(igstate_h) $(store_h)

# ---------------- Level 1 path facilities ---------------- #

path1_=gspath1.$(OBJ) zpath1.$(OBJ)
path1.dev: $(INT_MAK) $(ECHOGS_XE) $(path1_)
	$(SETMOD) path1 $(path1_)
	$(ADDMOD) path1 -oper zpath1

gspath1.$(OBJ): gspath1.c $(GXERR) $(math__h) \
  $(gscoord_h) $(gsstruct_h) $(gxfarith_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h) $(gzpath_h)

zpath1.$(OBJ): zpath1.c $(OP) \
  $(ialloc_h) $(estack_h) $(gspath_h) $(gsstruct_h) $(igstate_h) $(store_h)

# ================ Level-independent PostScript options ================ #

# ---------------- BCP filters ---------------- #

bcp_=sbcp.$(OBJ) zfbcp.$(OBJ)
bcp.dev: $(INT_MAK) $(ECHOGS_XE) $(bcp_)
	$(SETMOD) bcp $(bcp_)
	$(ADDMOD) bcp -oper zfbcp

sbcp.$(OBJ): sbcp.c $(AK) $(stdio__h) \
  $(sfilter_h) $(strimpl_h)

zfbcp.$(OBJ): zfbcp.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(ifilter_h) \
  $(sfilter_h) $(stream_h) $(strimpl_h)

# ---------------- Double-precision floats ---------------- #

double_=zdouble.$(OBJ)
double.dev: $(INT_MAK) $(ECHOGS_XE) $(double_)
	$(SETMOD) double $(double_)
	$(ADDMOD) double -oper zdouble

zdouble.$(OBJ): zdouble.c $(OP) $(ctype__h) $(math__h) $(memory__h) $(string__h) \
  $(gxfarith_h) $(store_h)

# ---------------- RasterOp ---------------- #
# This should be a separable feature in the core also....

rasterop.dev: $(INT_MAK) $(ECHOGS_XE) ropcore.dev ropread.dev
	$(SETMOD) rasterop -include ropcore ropread

ropread_=zrop.$(OBJ)
ropread.dev: $(INT_MAK) $(ECHOGS_XE) $(ropread_)
	$(SETMOD) ropread $(ropread_)
	$(ADDMOD) ropread -oper zrop

zrop.$(OBJ): zrop.c $(OP) $(memory__h) \
  $(gsrop_h) $(gxdevice_h) $(idict_h) $(idparam_h) $(igstate_h) $(store_h)

# ---------------- PostScript Type 1 (and Type 4) fonts ---------------- #

type1.dev: $(INT_MAK) $(ECHOGS_XE) psf1core.dev psf1read.dev
	$(SETMOD) type1 -include psf1core psf1read

psf1read_=seexec.$(OBJ) zchar1.$(OBJ) zfont1.$(OBJ) zmisc1.$(OBJ)
psf1read.dev: $(INT_MAK) $(ECHOGS_XE) $(psf1read_)
	$(SETMOD) psf1read $(psf1read_)
	$(ADDMOD) psf1read -oper zchar1 zfont1 zmisc1
	$(ADDMOD) psf1read -ps gs_type1

seexec.$(OBJ): seexec.c $(AK) $(stdio__h) \
  $(gscrypt1_h) $(scanchar_h) $(sfilter_h) $(strimpl_h)

zchar1.$(OBJ): zchar1.c $(OP) \
  $(gsstruct_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gschar_h) $(gxdevice_h) $(gxfont_h) $(gxfont1_h) $(gxtype1_h) \
  $(ialloc_h) $(ichar_h) $(idict_h) $(estack_h) $(ifont_h) $(igstate_h) \
  $(store_h)

zfont1.$(OBJ): zfont1.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gschar_h) $(gxfixed_h) $(gxfont_h) $(gxfont1_h) \
  $(bfont_h) $(ialloc_h) $(idict_h) $(idparam_h) $(store_h)

zmisc1.$(OBJ): zmisc1.c $(OP) \
  $(gscrypt1_h) $(ifilter_h) $(sfilter_h) $(stream_h) $(strimpl_h)

# ---------------- Obsolete PPM writing facility ---------------- #

writeppm_=zwppm.$(OBJ)
writeppm.dev: $(INT_MAK) $(ECHOGS_XE) $(writeppm_)
	$(SETMOD) writeppm $(writeppm_)
	$(ADDMOD) writeppm -oper zwppm

zwppm.$(OBJ): zwppm.c $(OP) $(memory__h) \
  $(files_h) $(gscdefs_h) $(gsmatrix_h) $(gxdevice_h) $(gxdevmem_h) \
  $(stream_h)

# ======================== Precompilation options ======================== #

# ---------------- Precompiled fonts ---------------- #
# See fonts.doc for more information.

ccfont_h=ccfont.h $(std_h) $(gsmemory_h) $(iref_h) $(ivmspace_h) $(store_h)

CCFONT=$(OP) $(ccfont_h)

# List the fonts we are going to compile.
# Because of intrinsic limitations in `make', we have to list
# the object file names and the font names separately.
# Because of limitations in the DOS shell, we have to break the fonts up
# into lists that will fit on a single line (120 characters).
# The rules for constructing the .c files from the fonts themselves,
# and for compiling the .c files, are in cfonts.mak, not here.
# For example, to compile the Courier fonts, you should invoke
#	make -f cfonts.mak Courier_o
ccfonts_ps=gs_ccfnt
ccfonts1_=pagk.$(OBJ) pagko.$(OBJ) pagd.$(OBJ) pagdo.$(OBJ)
ccfonts1=agk agko agd agdo
ccfonts2_=pbkl.$(OBJ) pbkli.$(OBJ) pbkd.$(OBJ) pbkdi.$(OBJ)
ccfonts2=bkl bkli bkd bkdi
# The free distribution includes Bitstream Charter;
# the standard distribution has additional Helvetica Narrow variants.
ccfonts3free_=bchr.$(OBJ) bchri.$(OBJ) bchb.$(OBJ) bchbi.$(OBJ)
ccfonts3free=chr chri chb chbi
ccfonts3std_=phvrorn.$(OBJ) phvbrn.$(OBJ) phvborn.$(OBJ)
ccfonts3std=hvrorn hvbrn hvborn
ccfonts4_=ncrr.$(OBJ) ncri.$(OBJ) ncrb.$(OBJ) ncrbi.$(OBJ)
ccfonts4=crr cri crb crbi
ccfonts5_=phvr.$(OBJ) phvro.$(OBJ) phvb.$(OBJ) phvbo.$(OBJ) phvrrn.$(OBJ)
ccfonts5=hvr hvro hvb hvbo hvrrn
ccfonts6_=pncr.$(OBJ) pncri.$(OBJ) pncb.$(OBJ) pncbi.$(OBJ)
ccfonts6=ncr ncri ncb ncbi
ccfonts7_=pplr.$(OBJ) pplri.$(OBJ) pplb.$(OBJ) pplbi.$(OBJ)
ccfonts7=plr plri plb plbi
ccfonts8_=psyr.$(OBJ) ptmr.$(OBJ) ptmri.$(OBJ) ptmb.$(OBJ) ptmbi.$(OBJ)
ccfonts8=syr tmr tmri tmb tmbi
# The free distribution has Zapf Chancery plain, Oblique and Bold;
# the standard distribution has only Medium Italic.
# Both have Zapf Dingbats.
ccfonts9free_=zcr.$(OBJ) zcro.$(OBJ) zcb.$(OBJ) pzdr.$(OBJ)
ccfonts9free=zcr zcro zcb zdr
ccfonts9std_=zcmi.$(OBJ) pzdr.$(OBJ)
ccfonts9std=zcmi zdr
# Add your own fonts here if desired.
ccfonts10_=
ccfonts10=
ccfonts11_=
ccfonts11=
ccfonts12_=
ccfonts12=
ccfonts13_=
ccfonts13=
ccfonts14_=
ccfonts14=
ccfonts15_=
ccfonts15=
# Select either standard or free configuration here.
# By default, we select the standard configuration.
#ccfonts3_=$(ccfonts3free_)
#ccfonts3=$(ccfonts3free)
#ccfonts9_=$(ccfonts9free_)
#ccfonts9=$(ccfonts9free)
ccfonts3_=$(ccfonts3std_)
ccfonts3=$(ccfonts3std)
ccfonts9_=$(ccfonts9std_)
ccfonts9=$(ccfonts9std)

# It's OK for ccfonts_.dev not to be CONFIG-dependent, because it only
# exists during the execution of the following rule.
$(gconfigf_h): $(MAKEFILE) $(INT_MAK) $(GENCONF_XE)
	$(SETMOD) ccfonts_ -font $(ccfonts1)
	$(ADDMOD) ccfonts_ -font $(ccfonts2)
	$(ADDMOD) ccfonts_ -font $(ccfonts3)
	$(ADDMOD) ccfonts_ -font $(ccfonts4)
	$(ADDMOD) ccfonts_ -font $(ccfonts5)
	$(ADDMOD) ccfonts_ -font $(ccfonts6)
	$(ADDMOD) ccfonts_ -font $(ccfonts7)
	$(ADDMOD) ccfonts_ -font $(ccfonts8)
	$(ADDMOD) ccfonts_ -font $(ccfonts9)
	$(ADDMOD) ccfonts_ -font $(ccfonts10)
	$(ADDMOD) ccfonts_ -font $(ccfonts11)
	$(ADDMOD) ccfonts_ -font $(ccfonts12)
	$(ADDMOD) ccfonts_ -font $(ccfonts13)
	$(ADDMOD) ccfonts_ -font $(ccfonts14)
	$(ADDMOD) ccfonts_ -font $(ccfonts15)
	$(EXP)genconf ccfonts_.dev -f $(gconfigf_h)

# We separate ccfontab.dev from ccfonts.dev so that a customer can put
# compiled fonts into a separate shared library.

ccfontab=ccfontab$(CONFIG)

# Define ccfont_table separately, so it can be set from the command line
# to select an alternate compiled font table.
ccfont_table=$(ccfontab)

$(ccfontab).dev: $(MAKEFILE) $(INT_MAK) $(ECHOGS_XE) $(ccfontab).$(OBJ) \
  $(ccfonts1_) $(ccfonts2_) $(ccfonts3_) $(ccfonts4_) $(ccfonts5_) \
  $(ccfonts6_) $(ccfonts7_) $(ccfonts8_) $(ccfonts9_) $(ccfonts10_) \
  $(ccfonts11_) $(ccfonts12_) $(ccfonts13_) $(ccfonts14_) $(ccfonts15_)
	$(SETMOD) $(ccfontab) -obj $(ccfontab).$(OBJ)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts1_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts2_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts3_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts4_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts5_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts6_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts7_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts8_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts9_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts10_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts11_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts12_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts13_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts14_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts15_)

$(ccfontab).$(OBJ): ccfontab.c $(AK) $(ccfont_h) $(gconfigf_h)
	cp $(gconfigf_h) gconfigf.h
	$(CCCF) ccfontab.c

# Strictly speaking, ccfonts shouldn't need to include type1,
# since one could choose to precompile only Type 0 fonts,
# but getting this exactly right would be too much work.
ccfonts=ccfonts$(CONFIG)
$(ccfonts).dev: $(MAKEFILE) $(INT_MAK) type1.dev iccfont.$(OBJ) \
  $(ccfont_table).dev
	$(SETMOD) $(ccfonts) -include type1
	$(ADDMOD) $(ccfonts) -include $(ccfont_table)
	$(ADDMOD) $(ccfonts) -obj iccfont.$(OBJ)
	$(ADDMOD) $(ccfonts) -oper ccfonts
	$(ADDMOD) $(ccfonts) -ps $(ccfonts_ps)

iccfont.$(OBJ): iccfont.c $(GH) \
  $(gsstruct_h) $(ccfont_h) $(errors_h) \
  $(ialloc_h) $(idict_h) $(ifont_h) $(iname_h) $(isave_h) $(iutil_h) \
  $(oper_h) $(ostack_h) $(store_h) $(stream_h) $(strimpl_h) $(sfilter_h) $(iscan_h)
	$(CCCF) iccfont.c

# ---------------- Compiled initialization code ---------------- #

# We select either iccinit0 or iccinit1 depending on COMPILE_INITS.

iccinit0.$(OBJ): iccinit0.c $(stdpre_h)
	$(CCCF) iccinit0.c

iccinit1.$(OBJ): gs_init.$(OBJ)
	cp gs_init.$(OBJ) iccinit1.$(OBJ)

# All the gs_*.ps files should be prerequisites of gs_init.c,
# but we don't have any convenient list of them.
gs_init.c: $(GS_INIT) $(GENINIT_XE) $(gconfig_h)
	$(EXP)geninit $(GS_INIT) $(gconfig_h) -c gs_init.c

gs_init.$(OBJ): gs_init.c $(stdpre_h)
	$(CCCF) gs_init.c

# ======================== PostScript Level 2 ======================== #

###### Include files

iutil2_h=iutil2.h

### In addition to the true Level 2 configuration, we define a 'minimal'
### Level 2 that can be used with -dDEBUG in the 16-bit Windows environment.
### This also requires trimming down the sizes of the stacks in interp.c.

lev2min.dev: $(INT_MAK) $(ECHOGS_XE) \
  psbase.dev cie.dev compfont.dev dctd.dev devctrl.dev color.dev \
  dps2core.dev dps2read.dev fdecode.dev path1.dev type1.dev \
  pattern.dev psl2core.dev psl2read.dev
	$(SETMOD) lev2min -include psbase cie compfont dctd devctrl color
	$(ADDMOD) lev2min -include dps2core dps2read fdecode path1 type1
	$(ADDMOD) lev2min -include pattern psl2core psl2read
	$(ADDMOD) lev2min -emulator PostScript PostScriptLevel1 PostScriptLevel2

level2.dev: $(INT_MAK) $(ECHOGS_XE) \
  cie.dev compfont.dev dct.dev devctrl.dev dpsand2.dev filter.dev \
  level1.dev pattern.dev psl2core.dev psl2read.dev sepr.dev xfilter.dev
	$(SETMOD) level2 -include cie compfont dct devctrl dpsand2 filter
	$(ADDMOD) level2 -include level1 pattern psl2core psl2read sepr xfilter
	$(ADDMOD) level2 -emulator PostScript PostScriptLevel2

psl2read1_=iutil2.$(OBJ) zcolor2.$(OBJ) zcsindex.$(OBJ)
psl2read2_=zht2.$(OBJ) zimage2.$(OBJ) zmisc2.$(OBJ)
psl2read_=$(psl2read1_) $(psl2read2_)
# Note that zmisc2 includes both Level 1 and Level 2 operators.
psl2read.dev: $(INT_MAK) $(ECHOGS_XE) $(psl2read_)
	$(SETMOD) psl2read $(psl2read1_)
	$(ADDMOD) psl2read -obj $(psl2read2_)
	$(ADDMOD) psl2read -oper zmisc2
	$(ADDMOD) psl2read -oper zcolor2_l2 zcsindex_l2
	$(ADDMOD) psl2read -oper zht2_l2 zimage2_l2
	$(ADDMOD) psl2read -ps gs_lev2 gs_res

iutil2.$(OBJ): iutil2.c $(GXERR) $(memory__h) \
  $(gsparam_h) $(gsutil_h) \
  $(opcheck_h) $(idict_h) $(imemory_h) $(iutil_h) $(iutil2_h)

zcolor2.$(OBJ): zcolor2.c $(OP) \
  $(gscolor_h) $(gscspace_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxcolor2_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) $(gxpcolor_h) \
  $(estack_h) $(ialloc_h) $(idict_h) $(idparam_h) $(igstate_h) $(istruct_h) \
  $(store_h)

zcsindex.$(OBJ): zcsindex.c $(OP) $(memory__h) \
  $(gscolor_h) $(gsstruct_h) $(gxfixed_h) $(gxcolor2_h) $(gscspace_h) $(gsmatrix_h) \
  $(ialloc_h) $(icsmap_h) $(estack_h) $(igstate_h) $(ivmspace_h) $(store_h)

zht2.$(OBJ): zht2.c $(OP) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(estack_h) $(ialloc_h) $(icolor_h) $(idict_h) $(idparam_h) $(igstate_h) \
  $(store_h)

zimage2.$(OBJ): zimage2.c $(OP) $(math__h) \
  $(gscolor_h) $(gscolor2_h) $(gscspace_h) $(gsimage_h) $(gsmatrix_h) \
  $(idict_h) $(idparam_h) $(ilevel_h) $(igstate_h)

zmisc2.$(OBJ): zmisc2.c $(OP) \
  $(gscdefs_h) $(gsfont_h) $(gsstruct_h) $(gsutil_h) $(gxht_h) \
  $(ialloc_h) $(idict_h) $(idparam_h) $(iparam_h) $(dstack_h) $(estack_h) \
  $(ilevel_h) $(iname_h) $(iutil2_h) $(ivmspace_h) $(store_h)

# ---------------- Device control ---------------- #
# This is a catch-all for setpagedevice and IODevices.

devctrl_=zdevice2.$(OBJ) ziodev2.$(OBJ) zmedia2.$(OBJ) zdevcal.$(OBJ)
devctrl.dev: $(INT_MAK) $(ECHOGS_XE) $(devctrl_)
	$(SETMOD) devctrl $(devctrl_)
	$(ADDMOD) devctrl -oper zdevice2_l2 ziodev2_l2 zmedia2_l2
	$(ADDMOD) devctrl -iodev null ram calendar
	$(ADDMOD) devctrl -ps gs_setpd

zdevice2.$(OBJ): zdevice2.c $(OP) $(math__h) \
  $(dstack_h) $(estack_h) $(idict_h) $(idparam_h) $(igstate_h) $(iname_h) $(store_h) \
  $(gxdevice_h) $(gsstate_h)

ziodev2.$(OBJ): ziodev2.c $(OP) \
  $(gxiodev_h) $(stream_h) $(files_h) $(iparam_h) $(iutil2_h) $(store_h)

zmedia2.$(OBJ): zmedia2.c $(OP) $(math__h) $(memory__h) \
  $(gsmatrix_h) $(idict_h) $(idparam_h) $(iname_h) $(store_h)

zdevcal.$(OBJ): zdevcal.c $(GH) $(time__h) \
  $(gxiodev_h) $(iparam_h) $(istack_h)

# ---------------- Filters other than the ones in sfilter.c ---------------- #

# Standard Level 2 decoding filters only.  The PDF configuration uses this.
fdecode_=sfilter2.$(OBJ) zfdecode.$(OBJ) spdiff.$(OBJ) zfpdiff.$(OBJ)
fdecode.dev: $(INT_MAK) $(ECHOGS_XE) $(fdecode_) cfd.dev lzwd.dev rld.dev
	$(SETMOD) fdecode $(fdecode_)
	$(ADDMOD) fdecode -include cfd lzwd rld
	$(ADDMOD) fdecode -oper zfdecode zfpdiff

sfilter2.$(OBJ): sfilter2.c $(AK) $(stdio__h)\
  $(scanchar_h) $(sbtx_h) $(sfilter_h) $(strimpl_h)

spdiff.$(OBJ): spdiff.c $(AK) $(stdio__h)\
  $(spdiffx_h) $(strimpl_h)

zfdecode.$(OBJ): zfdecode.c $(OP) $(memory__h) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(scfx_h) $(sfilter_h) $(slzwx_h) $(store_h) $(strimpl_h)

zfpdiff.$(OBJ): zfpdiff.c $(OP) \
  $(gsstruct_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(sfilter_h) $(spdiffx_h) $(strimpl_h)

# Complete Level 2 filter capability.
filter_=zfilter2.$(OBJ)
filter.dev: $(INT_MAK) $(ECHOGS_XE) fdecode.dev $(filter_) cfe.dev lzwe.dev rle.dev
	$(SETMOD) filter -include fdecode
	$(ADDMOD) filter -obj $(filter_)
	$(ADDMOD) filter -include cfe lzwe rle
	$(ADDMOD) filter -oper zfilter2

zfilter2.$(OBJ): zfilter2.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) $(store_h) \
  $(sfilter_h) $(scfx_h) $(slzwx_h) $(strimpl_h)

# Extensions beyond Level 2 standard.
xfilter_=sbhc.$(OBJ) sbwbs.$(OBJ) shcgen.$(OBJ) smtf.$(OBJ) zfilterx.$(OBJ)
xfilter.dev: $(INT_MAK) $(ECHOGS_XE) $(xfilter_)
	$(SETMOD) xfilter $(xfilter_)
	$(ADDMOD) xfilter -oper zfilterx

sbhc.$(OBJ): sbhc.c $(AK) $(stdio__h) \
  $(gdebug_h) $(sbhc_h) $(shcgen_h) $(strimpl_h)

sbwbs.$(OBJ): sbwbs.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(sbwbs_h) $(sfilter_h) $(strimpl_h)

shcgen.$(OBJ): shcgen.c $(AK) $(stdio__h) \
  $(gdebug_h) $(gserror_h) $(gserrors_h) \
  $(scommon_h) $(shc_h) $(shcgen_h)

smtf.$(OBJ): smtf.c $(AK) $(stdio__h) \
  $(smtf_h) $(strimpl_h)

zfilterx.$(OBJ): zfilterx.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(store_h) $(sfilter_h) $(sbhc_h) $(sbtx_h) $(sbwbs_h) $(shcgen_h) \
  $(smtf_h) $(strimpl_h)

# ---------------- Binary tokens ---------------- #

btoken_=iscanbin.$(OBJ) zbseq.$(OBJ)
btoken.dev: $(INT_MAK) $(ECHOGS_XE) $(btoken_)
	$(SETMOD) btoken $(btoken_)
	$(ADDMOD) btoken -oper zbseq_l2
	$(ADDMOD) btoken -ps gs_btokn

bseq_h=bseq.h
btoken_h=btoken.h

iscanbin.$(OBJ): iscanbin.c $(GH) $(math__h) $(errors_h) \
  $(gsutil_h) $(ialloc_h) $(ibnum_h) $(idict_h) $(iname_h) \
  $(iscan_h) $(iutil_h) $(ivmspace_h) \
  $(bseq_h) $(btoken_h) $(dstack_h) $(ostack_h) \
  $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

zbseq.$(OBJ): zbseq.c $(OP) \
  $(ialloc_h) $(idict_h) $(isave_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h) \
  $(iname_h) $(ibnum_h) $(btoken_h) $(bseq_h)

# ---------------- User paths & insideness testing ---------------- #

upath_=zupath.$(OBJ) ibnum.$(OBJ)
upath.dev: $(INT_MAK) $(ECHOGS_XE) $(upath_)
	$(SETMOD) upath $(upath_)
	$(ADDMOD) upath -oper zupath_l2

zupath.$(OBJ): zupath.c $(OP) \
  $(idict_h) $(dstack_h) $(iutil_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gspath_h) $(gsstate_h) \
  $(gxfixed_h) $(gxdevice_h) $(gzpath_h) $(gzstate_h)

# -------- Additions common to Display PostScript and Level 2 -------- #

dpsand2.dev: $(INT_MAK) $(ECHOGS_XE) btoken.dev color.dev upath.dev dps2core.dev dps2read.dev
	$(SETMOD) dpsand2 -include btoken color upath dps2core dps2read

dps2read_=ibnum.$(OBJ) zchar2.$(OBJ) zdps1.$(OBJ) zvmem2.$(OBJ)
# Note that zvmem2 includes both Level 1 and Level 2 operators.
dps2read.dev: $(INT_MAK) $(ECHOGS_XE) $(dps2read_)
	$(SETMOD) dps2read $(dps2read_)
	$(ADDMOD) dps2read -oper zvmem2
	$(ADDMOD) dps2read -oper ireclaim_l2 zchar2_l2 zdps1_l2
	$(ADDMOD) dps2read -ps gs_dps1

ibnum.$(OBJ): ibnum.c $(GH) $(math__h) \
  $(errors_h) $(stream_h) $(ibnum_h)

zchar2.$(OBJ): zchar2.c $(OP) \
  $(gschar_h) $(gsmatrix_h) $(gsstruct_h) $(gxfixed_h) $(gxfont_h) \
  $(ialloc_h) $(ichar_h) $(estack_h) $(ifont_h) $(iname_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h)

zdps1.$(OBJ): zdps1.c $(OP) \
  $(gsmatrix_h) $(gspath_h) $(gspath2_h) $(gsstate_h) \
  $(ialloc_h) $(ivmspace_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h)

zvmem2.$(OBJ): zvmem2.c $(OP) \
  $(estack_h) $(ialloc_h) $(ivmspace_h) $(store_h)

# ---------------- Display PostScript ---------------- #

# We should include zcontext, but it isn't in good enough shape yet:
#	$(ADDMOD) dps -oper zcontext_l2
dps_=
dps.dev: $(INT_MAK) $(ECHOGS_XE) dpsand2.dev $(dps_)
	$(SETMOD) dps -include dpsand2
	$(ADDMOD) dps -obj $(dps_)

zcontext.$(OBJ): zcontext.c $(OP) \
  $(gsstruct_h) $(gsutil_h) \
  $(idict_h) $(istruct_h) $(dstack_h) $(estack_h) $(igstate_h) $(store_h)

# -------- Composite (PostScript Type 0) font support -------- #

compfont.dev: $(INT_MAK) $(ECHOGS_XE) psf0core.dev psf0read.dev
	$(SETMOD) compfont -include psf0core psf0read

psf0read_=zchar2.$(OBJ) zfont0.$(OBJ)
psf0read.dev: $(INT_MAK) $(ECHOGS_XE) $(psf0read_)
	$(SETMOD) psf0read $(psf0read_)
	$(ADDMOD) psf0read -oper zfont0 zchar2
	$(ADDMOD) psf0read -ps gs_type0

zfont0.$(OBJ): zfont0.c $(OP) \
  $(gsmatrix_h) $(gsstruct_h) $(gxdevice_h) $(gxfont_h) $(gxfont0_h) \
  $(ialloc_h) $(bfont_h) $(idict_h) $(igstate_h) $(store_h)

# ---------------- CID/CMap font support ---------------- #
#**************** NOT REAL YET.  DON'T USE. ****************#

cidfont.dev: $(INT_MAK) $(ECHOGS_XE) compfont.dev psf1read.dev
	$(SETMOD) cidfont -include compfont psf1read
	$(ADDMOD) cidfont -ps gs_cidfn

# ---------------- CIE color ---------------- #

cieread_=zcie.$(OBJ) zcrd.$(OBJ)
cie.dev: $(INT_MAK) $(ECHOGS_XE) $(cieread_) ciecore.dev
	$(SETMOD) cie $(cieread_)
	$(ADDMOD) cie -oper zcie_l2 zcrd_l2
	$(ADDMOD) cie -include ciecore

icie_h=icie.h

zcie.$(OBJ): zcie.c $(OP) $(math__h) $(memory__h) \
  $(gscspace_h) $(gscolor2_h) $(gscie_h) $(gsstruct_h) \
  $(ialloc_h) $(icie_h) $(idict_h) $(idparam_h) $(estack_h) \
  $(isave_h) $(igstate_h) $(ivmspace_h) $(store_h)

zcrd.$(OBJ): zcrd.c $(OP) $(math__h) \
  $(gscspace_h) $(gscolor2_h) $(gscie_h) $(gsstruct_h) \
  $(ialloc_h) $(icie_h) $(idict_h) $(idparam_h) $(estack_h) \
  $(isave_h) $(igstate_h) $(ivmspace_h) $(store_h)

# ---------------- Pattern color ---------------- #

pattern.dev: $(INT_MAK) $(ECHOGS_XE) patcore.dev patread.dev
	$(SETMOD) pattern -include patcore patread

patread_=zpcolor.$(OBJ)
patread.dev: $(INT_MAK) $(ECHOGS_XE) $(patread_)
	$(SETMOD) patread $(patread_)
	$(ADDMOD) patread -oper zpcolor_l2

zpcolor.$(OBJ): zpcolor.c $(OP) \
  $(gscolor_h) $(gscspace_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxcolor2_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) $(gxpcolor_h) \
  $(estack_h) $(ialloc_h) $(idict_h) $(idparam_h) $(igstate_h) $(istruct_h) \
  $(store_h)

# ---------------- Separation color ---------------- #

seprread_=zcssepr.$(OBJ)
sepr.dev: $(INT_MAK) $(ECHOGS_XE) $(seprread_) seprcore.dev
	$(SETMOD) sepr $(seprread_)
	$(ADDMOD) sepr -oper zcssepr_l2
	$(ADDMOD) sepr -include seprcore

zcssepr.$(OBJ): zcssepr.c $(OP) \
  $(gscolor_h) $(gsstruct_h) $(gxfixed_h) $(gxcolor2_h) $(gscspace_h) $(gsmatrix_h) \
  $(ialloc_h) $(icsmap_h) $(estack_h) $(igstate_h) $(ivmspace_h) $(store_h)

# ---------------- DCT filters ---------------- #
# The definitions for jpeg*.dev are in jpeg.mak.

dct.dev: $(INT_MAK) $(ECHOGS_XE) dcte.dev dctd.dev
	$(SETMOD) dct -include dcte dctd

# Common code

dctc_=sdctc.$(OBJ) sjpegc.$(OBJ) zfdctc.$(OBJ)

sdctc.$(OBJ): sdctc.c $(AK) $(stdio__h) \
  $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

sjpegc.$(OBJ): sjpegc.c $(AK) $(stdio__h) $(gx_h)\
  $(gserrors_h) $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

zfdctc.$(OBJ): zfdctc.c $(GH) $(errors_h) $(opcheck_h) \
  $(idict_h) $(idparam_h) $(imemory_h) \
  $(ipacked_h) $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jpeglib.h

# Encoding (compression)

dcte_=$(dctc_) sdcte.$(OBJ) sjpege.$(OBJ) zfdcte.$(OBJ)
dcte.dev: $(INT_MAK) $(ECHOGS_XE) jpege.dev $(dcte_)
	$(SETMOD) dcte -include jpege
	$(ADDMOD) dcte -obj $(dcte_)
	$(ADDMOD) dcte -oper zfdcte

sdcte.$(OBJ): sdcte.c $(AK) $(memory__h) $(stdio__h) $(gdebug_h)\
  $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jerror.h jpeglib.h

sjpege.$(OBJ): sjpege.c $(AK) $(stdio__h) $(gx_h)\
  $(gserrors_h) $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

zfdcte.$(OBJ): zfdcte.c $(OP) \
  $(idict_h) $(idparam_h) $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jpeglib.h

# Decoding (decompression)

dctd_=$(dctc_) sdctd.$(OBJ) sjpegd.$(OBJ) zfdctd.$(OBJ)
dctd.dev: $(INT_MAK) $(ECHOGS_XE) jpegd.dev $(dctd_)
	$(SETMOD) dctd -include jpegd
	$(ADDMOD) dctd -obj $(dctd_)
	$(ADDMOD) dctd -oper zfdctd

sdctd.$(OBJ): sdctd.c $(AK) $(memory__h) $(stdio__h) $(gdebug_h)\
  $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jerror.h jpeglib.h

sjpegd.$(OBJ): sjpegd.c $(AK) $(stdio__h) $(gx_h)\
  $(gserrors_h) $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

zfdctd.$(OBJ): zfdctd.c $(OP) \
  $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jpeglib.h

# ================================ PDF ================================ #

# We need most of the Level 2 interpreter to do PDF, but not all of it.
# In fact, we don't even need all of a Level 1 interpreter.

# Because of the way the PDF encodings are defined, they must get loaded
# before we install the Level 2 resource machinery.
# On the other hand, the PDF .ps files must get loaded after
# level2dict is defined.
pdf.dev: $(INT_MAK) $(ECHOGS_XE) \
  psbase.dev color.dev dctd.dev dps2core.dev dps2read.dev \
  fdecode.dev type1.dev pdffonts.dev psl2core.dev psl2read.dev pdfread.dev
	$(SETMOD) pdf -include psbase color dctd dps2core dps2read
	$(ADDMOD) pdf -include fdecode type1
	$(ADDMOD) pdf -include pdffonts psl2core psl2read pdfread
	$(ADDMOD) pdf -emulator PDF

# Reader only

# The .dev file should be dependent on the encoding files....
pdffonts.dev: $(INT_MAK) $(ECHOGS_XE) \
  gs_mex_e.ps gs_mro_e.ps gs_pdf_e.ps gs_wan_e.ps
	$(SETMOD) pdffonts -ps gs_mex_e gs_mro_e gs_pdf_e gs_wan_e

# pdf_2ps must be the last .ps file loaded.
pdfread.dev: $(INT_MAK) $(ECHOGS_XE)
	$(ADDMOD) pdfread -ps gs_pdf pdf_base pdf_draw pdf_font pdf_main pdf_2ps

# ============================= Main program ============================== #

gsmain.$(OBJ): gsmain.c $(GH) \
  $(gp_h) $(gslib_h) $(gsmatrix_h) $(gxdevice_h) \
  $(dstack_h) $(errors_h) $(estack_h) $(files_h) \
  $(ialloc_h) $(idebug_h) $(idict_h) $(iname_h) $(interp_h) \
  $(isave_h) $(iscan_h) $(ivmspace_h) \
  $(main_h) $(oper_h) $(ostack_h) $(sfilter_h) $(store_h) $(strimpl_h)

# Interpreter main program

gs.$(OBJ): gs.c $(GH) $(ctype__h) \
  $(gscdefs_h) $(gsdevice_h) $(gxdevice_h) $(gxdevmem_h) \
  $(errors_h) $(estack_h) $(files_h) \
  $(ialloc_h) $(interp_h) $(isave_h) $(iscan_h) $(iutil_h) $(ivmspace_h) \
  $(main_h) $(ostack_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

interp.$(OBJ): interp.c $(GH) $(memory__h) $(string__h) \
  $(dstack_h) $(errors_h) $(estack_h) $(files_h) \
  $(ialloc_h) $(iastruct_h) $(inamedef_h) $(idict_h) $(interp_h) $(ipacked_h) \
  $(iscan_h) $(isave_h) $(istack_h) $(iutil_h) $(ivmspace_h) \
  $(oper_h) $(ostack_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)
	$(CCINT) interp.c

ireclaim.$(OBJ): ireclaim.c $(GH) \
  $(errors_h) $(gsstruct_h) $(iastate_h) $(opdef_h) $(store_h) \
  $(dstack_h) $(estack_h) $(ostack_h)
#    Copyright (C) 1994, 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for Independent JPEG Group library code.

# NOTE: This makefile is only known to work with the following versions
# of the IJG library: 5a, 5b, 6.
# As of August 18, 1995, version 6 is the current version.
#
# You can get the IJG library by Internet anonymous FTP from the following
# places:
#	Standard distribution (tar + gzip format, Unix end-of-line):
#		ftp.uu.net:/graphics/jpeg/jpegsrc.v*.tar.gz
#		ftp.cs.wisc.edu:/ghost/jpegsrc.v*.tar.gz
#	MS-DOS archive (PKZIP a.k.a. zip format, MS-DOS end-of-line):
#		oak.oakland.edu:/SimTel/msdos/graphics/jpgsrc*.zip
#		ftp.cs.wisc.edu:/ghost/jpeg-*.zip
# The first site named above (ftp.uu.net and oak.oakland.edu) is supposed
# to be the master distribution site, so it may have a more up-to-date
# version; the ftp.cs.wisc.edu site is the master distribution site for
# Ghostscript, so it will always have IJG library versions known to be
# compatible with Ghostscript.
#
# If the version number, and hence the subdirectory name, changes, you
# will probably want to change the definitions of JSRCDIR and possibly
# JVERSION (in the platform-specific makefile, not here) to reflect this,
# since that way you can use the IJG archive without change.
#
# NOTE: For some obscure reason (probably a bug in djtarx), if you are
# compiling on a DesqView/X system, you should use the zip version of the
# IJG library, not the tar.gz version.

# Define the name of this makefile.
JPEG_MAK=jpeg.mak

# JSRCDIR is defined in the platform-specific makefile, not here,
# as the directory where the IJG library sources are stored.
#JSRCDIR=jpeg-6
# JVERSION is defined in the platform-specific makefile, not here,
# as the IJG library major version number (currently "5" or "6").
#JVERSION=6

JSRC=$(JSRCDIR)$(D)
RMJ=rm -f
CCCJ=$(CCC) -I. -I$(JSRCDIR)

# We keep all of the IJG code in a separate directory so as not to
# inadvertently mix it up with Aladdin Enterprises' own code.
# However, we need our own version of jconfig.h, and our own "wrapper" for
# jmorecfg.h.  We also need a substitute for jerror.c, in order to
# keep the error strings out of the automatic data segment in
# 16-bit environments.  For v5*, we also need our own version of jpeglib.h
# in order to change MAX_BLOCKS_IN_MCU for Adobe compatibility.
# (This need will go away when IJG v6 is released.)

jconfig_h=jconfig.h $(std_h)
jerror_h=jerror.h
jmorecfg_h=jmorecfg.h jmcorig.h
jpeglib_h=jpeglib.h $(jconfig_h) $(jmorecfg_h)

jconfig.h: gsjconf.h
	cp gsjconf.h jconfig.h

jmorecfg.h: gsjmorec.h
	cp gsjmorec.h jmorecfg.h

jmcorig.h: $(JSRC)jmorecfg.h
	cp $(JSRC)jmorecfg.h jmcorig.h

jpeglib.h: jlib$(JVERSION).h
	cp jlib$(JVERSION).h jpeglib.h

jlib5.h: gsjpglib.h
	cp gsjpglib.h jlib5.h

jlib6.h: $(JSRC)jpeglib.h
	cp $(JSRC)jpeglib.h jlib6.h

# To ensure that the compiler finds our versions of jconfig.h and jmorecfg.h,
# regardless of the compiler's search rule, we must copy up all .c files,
# and all .h files that include either of these files, directly or
# indirectly.  The only such .h files currently are jinclude.h and jpeglib.h.
# (Currently, we supply our own version of jpeglib.h -- see above.)
# Also, to avoid including the JSRCDIR directory name in our source files,
# we must also copy up any other .h files that our own code references.
# Currently, the only such .h files are jerror.h and jversion.h.

JHCOPY=jinclude.h jpeglib.h jerror.h jversion.h

jinclude.h: $(JSRC)jinclude.h
	cp $(JSRC)jinclude.h jinclude.h

#jpeglib.h: $(JSRC)jpeglib.h
#	cp $(JSRC)jpeglib.h jpeglib.h

jerror.h: $(JSRC)jerror.h
	cp $(JSRC)jerror.h jerror.h

jversion.h: $(JSRC)jversion.h
	cp $(JSRC)jversion.h jversion.h

# In order to avoid having to keep the dependency lists for the IJG code
# accurate, we simply make all of them depend on the only files that
# we are ever going to change, and on all the .h files that must be copied up.
# This is too conservative, but only hurts us if we are changing our own
# j*.h files, which happens only rarely during development.

JDEP=$(AK) $(jconfig_h) $(jerror_h) $(jmorecfg_h) $(JHCOPY)

# Code common to compression and decompression.

jpegc_=jcomapi.$(OBJ) jutils.$(OBJ) sjpegerr.$(OBJ) jmemmgr.$(OBJ)
jpegc.dev: $(JPEG_MAK) $(jpegc_)
	$(SETMOD) jpegc $(jpegc_)

jcomapi.$(OBJ): $(JSRC)jcomapi.c $(JDEP)
	cp $(JSRC)jcomapi.c .
	$(CCCJ) jcomapi.c
	$(RMJ) jcomapi.c

jutils.$(OBJ): $(JSRC)jutils.c $(JDEP)
	cp $(JSRC)jutils.c .
	$(CCCJ) jutils.c
	$(RMJ) jutils.c

# Note that sjpegerr replaces jerror.
sjpegerr.$(OBJ): sjpegerr.c $(JDEP)
	$(CCCF) sjpegerr.c

jmemmgr.$(OBJ): $(JSRC)jmemmgr.c $(JDEP)
	cp $(JSRC)jmemmgr.c .
	$(CCCJ) jmemmgr.c
	$(RMJ) jmemmgr.c

# Encoding (compression) code.

jpege.dev: jpege$(JVERSION).dev
	cp jpege$(JVERSION).dev jpege.dev

jpege5=jcapi.$(OBJ)
jpege6=jcapimin.$(OBJ) jcapistd.$(OBJ) jcinit.$(OBJ)

jpege_1=jccoefct.$(OBJ) jccolor.$(OBJ) jcdctmgr.$(OBJ) 
jpege_2=jchuff.$(OBJ) jcmainct.$(OBJ) jcmarker.$(OBJ) jcmaster.$(OBJ)
jpege_3=jcparam.$(OBJ) jcprepct.$(OBJ) jcsample.$(OBJ) jfdctint.$(OBJ)

jpege5.dev: $(JPEG_MAK) jpegc.dev $(jpege5) $(jpege_1) $(jpege_2) $(jpege_3)
	$(SETMOD) jpege5 $(jpege5)
	$(ADDMOD) jpege5 -include jpegc
	$(ADDMOD) jpege5 -obj $(jpege_1)
	$(ADDMOD) jpege5 -obj $(jpege_2)
	$(ADDMOD) jpege5 -obj $(jpege_3)

jpege6.dev: $(JPEG_MAK) jpegc.dev $(jpege6) $(jpege_1) $(jpege_2) $(jpege_3)
	$(SETMOD) jpege6 $(jpege6)
	$(ADDMOD) jpege6 -include jpegc
	$(ADDMOD) jpege6 -obj $(jpege_1)
	$(ADDMOD) jpege6 -obj $(jpege_2)
	$(ADDMOD) jpege6 -obj $(jpege_3)

# jcapi.c is v5* only
jcapi.$(OBJ): $(JSRC)jcapi.c $(JDEP)
	cp $(JSRC)jcapi.c .
	$(CCCJ) jcapi.c
	$(RMJ) jcapi.c
  
# jcapimin.c is new in v6
jcapimin.$(OBJ): $(JSRC)jcapimin.c $(JDEP)
	cp $(JSRC)jcapimin.c .
	$(CCCJ) jcapimin.c
	$(RMJ) jcapimin.c

# jcapistd.c is new in v6
jcapistd.$(OBJ): $(JSRC)jcapistd.c $(JDEP)
	cp $(JSRC)jcapistd.c .
	$(CCCJ) jcapistd.c
	$(RMJ) jcapistd.c

# jcinit.c is new in v6
jcinit.$(OBJ): $(JSRC)jcinit.c $(JDEP)
	cp $(JSRC)jcinit.c .
	$(CCCJ) jcinit.c
	$(RMJ) jcinit.c

jccoefct.$(OBJ): $(JSRC)jccoefct.c $(JDEP)
	cp $(JSRC)jccoefct.c .
	$(CCCJ) jccoefct.c
	$(RMJ) jccoefct.c

jccolor.$(OBJ): $(JSRC)jccolor.c $(JDEP)
	cp $(JSRC)jccolor.c .
	$(CCCJ) jccolor.c
	$(RMJ) jccolor.c

jcdctmgr.$(OBJ): $(JSRC)jcdctmgr.c $(JDEP)
	cp $(JSRC)jcdctmgr.c .
	$(CCCJ) jcdctmgr.c
	$(RMJ) jcdctmgr.c

jchuff.$(OBJ): $(JSRC)jchuff.c $(JDEP)
	cp $(JSRC)jchuff.c .
	$(CCCJ) jchuff.c
	$(RMJ) jchuff.c

jcmainct.$(OBJ): $(JSRC)jcmainct.c $(JDEP)
	cp $(JSRC)jcmainct.c .
	$(CCCJ) jcmainct.c
	$(RMJ) jcmainct.c

jcmarker.$(OBJ): $(JSRC)jcmarker.c $(JDEP)
	cp $(JSRC)jcmarker.c .
	$(CCCJ) jcmarker.c
	$(RMJ) jcmarker.c

jcmaster.$(OBJ): $(JSRC)jcmaster.c $(JDEP)
	cp $(JSRC)jcmaster.c .
	$(CCCJ) jcmaster.c
	$(RMJ) jcmaster.c

jcparam.$(OBJ): $(JSRC)jcparam.c $(JDEP)
	cp $(JSRC)jcparam.c .
	$(CCCJ) jcparam.c
	$(RMJ) jcparam.c

jcprepct.$(OBJ): $(JSRC)jcprepct.c $(JDEP)
	cp $(JSRC)jcprepct.c .
	$(CCCJ) jcprepct.c
	$(RMJ) jcprepct.c

jcsample.$(OBJ): $(JSRC)jcsample.c $(JDEP)
	cp $(JSRC)jcsample.c .
	$(CCCJ) jcsample.c
	$(RMJ) jcsample.c

jfdctint.$(OBJ): $(JSRC)jfdctint.c $(JDEP)
	cp $(JSRC)jfdctint.c .
	$(CCCJ) jfdctint.c
	$(RMJ) jfdctint.c

# Decompression code

jpegd.dev: jpegd$(JVERSION).dev
	cp jpegd$(JVERSION).dev jpegd.dev

jpegd5=jdapi.$(OBJ)
jpegd6=jdapimin.$(OBJ) jdapistd.$(OBJ) jdinput.$(OBJ) jdphuff.$(OBJ)

jpegd_1=jdcoefct.$(OBJ) jdcolor.$(OBJ)
jpegd_2=jddctmgr.$(OBJ) jdhuff.$(OBJ) jdmainct.$(OBJ) jdmarker.$(OBJ)
jpegd_3=jdmaster.$(OBJ) jdpostct.$(OBJ) jdsample.$(OBJ) jidctint.$(OBJ)

jpegd5.dev: $(JPEG_MAK) jpegc.dev $(jpegd5) $(jpegd_1) $(jpegd_2) $(jpegd_3)
	$(SETMOD) jpegd5 $(jpegd5)
	$(ADDMOD) jpegd5 -include jpegc
	$(ADDMOD) jpegd5 -obj $(jpegd_1)
	$(ADDMOD) jpegd5 -obj $(jpegd_2)
	$(ADDMOD) jpegd5 -obj $(jpegd_3)

jpegd6.dev: $(JPEG_MAK) jpegc.dev $(jpegd6) $(jpegd_1) $(jpegd_2) $(jpegd_3)
	$(SETMOD) jpegd6 $(jpegd6)
	$(ADDMOD) jpegd6 -include jpegc
	$(ADDMOD) jpegd6 -obj $(jpegd_1)
	$(ADDMOD) jpegd6 -obj $(jpegd_2)
	$(ADDMOD) jpegd6 -obj $(jpegd_3)

# jdapi.c is v5* only
jdapi.$(OBJ): $(JSRC)jdapi.c $(JDEP)
	cp $(JSRC)jdapi.c .
	$(CCCJ) jdapi.c
	$(RMJ) jdapi.c

# jdapimin.c is new in v6
jdapimin.$(OBJ): $(JSRC)jdapimin.c $(JDEP)
	cp $(JSRC)jdapimin.c .
	$(CCCJ) jdapimin.c
	$(RMJ) jdapimin.c

# jdapistd.c is new in v6
jdapistd.$(OBJ): $(JSRC)jdapistd.c $(JDEP)
	cp $(JSRC)jdapistd.c .
	$(CCCJ) jdapistd.c
	$(RMJ) jdapistd.c

jdcoefct.$(OBJ): $(JSRC)jdcoefct.c $(JDEP)
	cp $(JSRC)jdcoefct.c .
	$(CCCJ) jdcoefct.c
	$(RMJ) jdcoefct.c

jdcolor.$(OBJ): $(JSRC)jdcolor.c $(JDEP)
	cp $(JSRC)jdcolor.c .
	$(CCCJ) jdcolor.c
	$(RMJ) jdcolor.c

jddctmgr.$(OBJ): $(JSRC)jddctmgr.c $(JDEP)
	cp $(JSRC)jddctmgr.c .
	$(CCCJ) jddctmgr.c
	$(RMJ) jddctmgr.c

jdhuff.$(OBJ): $(JSRC)jdhuff.c $(JDEP)
	cp $(JSRC)jdhuff.c .
	$(CCCJ) jdhuff.c
	$(RMJ) jdhuff.c

# jdinput.c is new in v6
jdinput.$(OBJ): $(JSRC)jdinput.c $(JDEP)
	cp $(JSRC)jdinput.c .
	$(CCCJ) jdinput.c
	$(RMJ) jdinput.c

jdmainct.$(OBJ): $(JSRC)jdmainct.c $(JDEP)
	cp $(JSRC)jdmainct.c .
	$(CCCJ) jdmainct.c
	$(RMJ) jdmainct.c

jdmarker.$(OBJ): $(JSRC)jdmarker.c $(JDEP)
	cp $(JSRC)jdmarker.c .
	$(CCCJ) jdmarker.c
	$(RMJ) jdmarker.c

jdmaster.$(OBJ): $(JSRC)jdmaster.c $(JDEP)
	cp $(JSRC)jdmaster.c .
	$(CCCJ) jdmaster.c
	$(RMJ) jdmaster.c

# jdphuff.c is new in v6
jdphuff.$(OBJ): $(JSRC)jdphuff.c $(JDEP)
	cp $(JSRC)jdphuff.c .
	$(CCCJ) jdphuff.c
	$(RMJ) jdphuff.c

jdpostct.$(OBJ): $(JSRC)jdpostct.c $(JDEP)
	cp $(JSRC)jdpostct.c .
	$(CCCJ) jdpostct.c
	$(RMJ) jdpostct.c

jdsample.$(OBJ): $(JSRC)jdsample.c $(JDEP)
	cp $(JSRC)jdsample.c .
	$(CCCJ) jdsample.c
	$(RMJ) jdsample.c

jidctint.$(OBJ): $(JSRC)jidctint.c $(JDEP)
	cp $(JSRC)jidctint.c .
	$(CCCJ) jidctint.c
	$(RMJ) jidctint.c
#    Copyright (C) 1989, 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for device drivers.

# Define the name of this makefile.
DEVS_MAK=devs.mak

# -------------------------------- Catalog ------------------------------- #

# It is possible to build configurations with an arbitrary collection of
# device drivers, although some drivers are supported only on a subset
# of the target platforms.  The currently available drivers are:

# MS-DOS displays (note: not usable with Desqview/X):
#   MS-DOS EGA and VGA:
#	ega	EGA (640x350, 16-color)
#	vga	VGA (640x480, 16-color)
#   MS-DOS SuperVGA:
# +	atiw	ATI Wonder SuperVGA, 256-color modes
# +	s3vga	SuperVGA with S3 86C911 chip (e.g., Diamond Stealth board)
#	svga16	Generic SuperVGA in 800x600, 16-color mode
#		  (replaces atiw16, tseng16, and tvga16 -- see below)
#	tseng	SuperVGA using Tseng Labs ET3000/4000 chips, 256-color modes
# +	tvga	Trident SuperVGA, 256-color modes
#   ****** NOTE: The vesa device does not work with the Watcom (32-bit MS-DOS)
#   ****** compiler or executable.
#	vesa	SuperVGA with VESA standard API driver
#   MS-DOS other:
#	bgi	Borland Graphics Interface (CGA)  [MS-DOS only]
# *	herc	Hercules Graphics display   [MS-DOS only]
# *	pe	Private Eye display
# Other displays:
#   MS Windows:
#	mswin	Microsoft Windows 3.0, 3.1   [MS Windows only]
#	mswindll  Microsoft Windows 3.1 DLL  [MS Windows only]
#	mswinprn  Microsoft Windows 3.0, 3.1 DDB printer  [MS Windows only]
#	mswinpr2  Microsoft Windows 3.0, 3.1 DIB printer  [MS Windows only]
#   OS/2:
# *	os2pm	OS/2 Presentation Manager   [OS/2 only]
# *	os2dll	OS/2 DLL bitmap             [OS/2 only]
# *	os2prn	OS/2 printer                [OS/2 only]
#   Unix and VMS:
#   ****** NOTE: For direct frame buffer addressing under SCO Unix or Xenix,
#   ****** edit the definition of EGAVGA below.
# *	att3b1	AT&T 3b1/Unixpc monochrome display   [3b1 only]
# *	lvga256  Linux vgalib, 256-color VGA modes  [Linux only]
# *	sonyfb	Sony Microsystems monochrome display   [Sony only]
# *	sunview  SunView window system   [SunOS only]
# +	vgalib	Linux PC with VGALIB   [Linux only]
#	x11	X Windows version 11, release >=4   [Unix and VMS only]
#	x11alpha  X Windows masquerading as a device with alpha capability
#	x11cmyk  X Windows masquerading as a 1-bit-per-plane CMYK device
#	x11mono  X Windows masquerading as a black-and-white device
#   Platform-independent:
# *	sxlcrt	CRT sixels, e.g. for VT240-like terminals
# Printers:
# *	ap3250	Epson AP3250 printer
# *	appledmp  Apple Dot Matrix Printer (should also work with Imagewriter)
#	bj10e	Canon BubbleJet BJ10e
# *	bj200	Canon BubbleJet BJ200
# *	bjc600   Canon Color BubbleJet BJC-600 and BJC-4000
# *	bjc800   Canon Color BubbleJet BJC-800
# *	cdeskjet  H-P DeskJet 500C with 1 bit/pixel color
# *	cdjcolor  H-P DeskJet 500C with 24 bit/pixel color and
#		high-quality color (Floyd-Steinberg) dithering;
#		also good for DeskJet 540C
# *	cdjmono  H-P DeskJet 500C printing black only;
#		also good for DeskJet 510, 520, and 540C (black only)
# *	cdj500	H-P DeskJet 500C (same as cdjcolor)
# *	cdj550	H-P DeskJet 550C/560C
# *	cp50	Mitsubishi CP50 color printer
# *	declj250  alternate DEC LJ250 driver
# +	deskjet  H-P DeskJet and DeskJet Plus
#	djet500  H-P DeskJet 500
# *	djet500c  H-P DeskJet 500C alternate driver
#		(does not work on 550C or 560C)
# *	dnj650c  H-P DesignJet 650C
#	epson	Epson-compatible dot matrix printers (9- or 24-pin)
# *	eps9mid  Epson-compatible 9-pin, interleaved lines
#		(intermediate resolution)
# *	eps9high  Epson-compatible 9-pin, interleaved lines
#		(triple resolution)
# *	epsonc	Epson LQ-2550 and Fujitsu 3400/2400/1200 color printers
# *	ibmpro  IBM 9-pin Proprinter
# *	imagen	Imagen ImPress printers
# *	iwhi	Apple Imagewriter in high-resolution mode
# *	iwlo	Apple Imagewriter in low-resolution mode
# *	iwlq	Apple Imagewriter LQ in 320 x 216 dpi mode
# *	jetp3852  IBM Jetprinter ink-jet color printer (Model #3852)
# +	laserjet  H-P LaserJet
# *	la50	DEC LA50 printer
# *	la70	DEC LA70 printer
# *	la70t	DEC LA70 printer with low-resolution text enhancement
# *	la75	DEC LA75 printer
# *	la75plus DEC LA75plus printer
# *	lbp8	Canon LBP-8II laser printer
# *	lips3	Canon LIPS III laser printer in English (CaPSL) mode
# *	ln03	DEC LN03 printer
# *	lj250	DEC LJ250 Companion color printer
# +	ljet2p	H-P LaserJet IId/IIp/III* with TIFF compression
# +	ljet3	H-P LaserJet III* with Delta Row compression
# +	ljet3d	H-P LaserJet IIID with duplex capability
# +	ljet4	H-P LaserJet 4 (defaults to 600 dpi)
# +	lj4dith  H-P LaserJet 4 with Floyd-Steinberg dithering
# +	ljetplus  H-P LaserJet Plus
# *	lp2563	H-P 2563B line printer
# *	m8510	C.Itoh M8510 printer
# *	necp6	NEC P6/P6+/P60 printers at 360 x 360 DPI resolution
# *	nwp533  Sony Microsystems NWP533 laser printer   [Sony only]
# *	oce9050  OCE 9050 printer
# *	oki182	Okidata MicroLine 182
# *	okiibm	Okidata MicroLine IBM-compatible printers
# *	paintjet  alternate H-P PaintJet color printer
# *	pj	H-P PaintJet XL driver 
# *	pjetxl	alternate H-P PaintJet XL driver
# *	pjxl	H-P PaintJet XL color printer
# *	pjxl300  H-P PaintJet XL300 color printer;
#		also good for PaintJet 1200C
# *	r4081	Ricoh 4081 laser printer
# *	sj48	StarJet 48 inkjet printer
# *	sparc	SPARCprinter
# *	st800	Epson Stylus 800 printer
# *     stcolor  Epson Stylus Color
# *	t4693d2  Tektronix 4693d color printer, 2 bits per R/G/B component
# *	t4693d4  Tektronix 4693d color printer, 4 bits per R/G/B component
# *	t4693d8  Tektronix 4693d color printer, 8 bits per R/G/B component
# *	tek4696  Tektronix 4695/4696 inkjet plotter
# *	xes	Xerox XES printers (2700, 3700, 4045, etc.)
# Fax systems:
# *	dfaxhigh  DigiBoard, Inc.'s DigiFAX software format (high resolution)
# *	dfaxlow  DigiFAX low (normal) resolution
# Fax file format:
#   ****** NOTE: all of these drivers adjust the page size to match
#   ****** one of the three CCITT standard sizes (U.S. letter with A4 width,
#   ****** A4, or B4).
#	faxg3	Group 3 fax, with EOLs but no header or EOD
#	faxg32d  Group 3 2-D fax, with EOLs but no header or EOD
#	faxg4	Group 4 fax, with EOLs but no header or EOD
#	tiffcrle  TIFF "CCITT RLE 1-dim" (= Group 3 fax with no EOLs)
#	tiffg3	TIFF Group 3 fax (with EOLs)
#	tiffg32d  TIFF Group 3 2-D fax
#	tiffg4	TIFF Group 4 fax
# Other file formats and devices:
#	bit	Plain bits, monochrome
#	bitrgb	Plain bits, RGB
#	bitcmyk  Plain bits, CMYK
#	bmpmono	Monochrome MS Windows .BMP file format
#	bmp16	4-bit (EGA/VGA) .BMP file format
#	bmp256	8-bit (256-color) .BMP file format
#	bmp16m	24-bit .BMP file format
#	cgmmono  Monochrome (black-and-white) CGM -- LOW LEVEL OUTPUT ONLY
#	cgm8	8-bit (256-color) CGM -- DITTO
#	cgm24	24-bit color CGM -- DITTO
# *	cif	CIF file format for VLSI
# *	mgrmono  1-bit monochrome MGR devices
# *	mgrgray2  2-bit gray scale MGR devices
# *	mgrgray4  4-bit gray scale MGR devices
# *	mgrgray8  8-bit gray scale MGR devices
# *	mgr4	4-bit (VGA) color MGR devices
# *	mgr8	8-bit color MGR devices
#	pcxmono	PCX file format, monochrome (1-bit black and white)
#	pcxgray	PCX file format, 8-bit gray scale
#	pcx16	PCX file format, 4-bit planar (EGA/VGA) color
#	pcx256	PCX file format, 8-bit chunky color
#	pcx24b	PCX file format, 24-bit color (3 8-bit planes)
#	pbm	Portable Bitmap (plain format)
#	pbmraw	Portable Bitmap (raw format)
#	pgm	Portable Graymap (plain format)
#	pgmraw	Portable Graymap (raw format)
#	pgnm	Portable Graymap (plain format), optimizing to PBM if possible
#	pgnmraw	Portable Graymap (raw format), optimizing to PBM if possible
#	pnm	Portable Pixmap (plain format) (RGB), optimizing to PGM or PBM
#		 if possible
#	pnmraw	Portable Pixmap (raw format) (RGB), optimizing to PGM or PBM
#		 if possible
#	ppm	Portable Pixmap (plain format) (RGB)
#	ppmraw	Portable Pixmap (raw format) (RGB)
#   ****** NOTE: The PNG drivers DO NOT WORK YET.  DO NOT TRY TO USE THEM.
#	pngmono	Monochrome Portable Network Graphics (PNG)
#	pnggray	8-bit gray Portable Network Graphics (PNG)
#	png16	4-bit color Portable Network Graphics (PNG)
#	png256	8-bit color Portable Network Graphics (PNG)
#	png16m	24-bit color Portable Network Graphics (PNG)
#	psmono	PostScript (Level 1) monochrome image
#	sgirgb	SGI RGB pixmap format
#	tiff24nc  TIFF 24-bit RGB, no compression (NeXT standard format)
#	tifflzw  TIFF LZW (tag = 5) (monochrome)
#	tiffpack  TIFF PackBits (tag = 32773) (monochrome)

# User-contributed drivers marked with * require hardware or software
# that is not available to Aladdin Enterprises.  Please contact the
# original contributors, not Aladdin Enterprises, if you have questions.
# Contact information appears in the driver entry below.
#
# Drivers marked with a + are maintained by Aladdin Enterprises with
# the assistance of users, since Aladdin Enterprises doesn't have access to
# the hardware for these either.

# If you add drivers, it would be nice if you kept each list
# in alphabetical order.

# ---------------------------- End of catalog ---------------------------- #

# As noted in gs.mak, DEVICE_DEVS and DEVICE_DEVS1..15 select the devices
# that should be included in a given configuration.  By convention, these
# are used as follows.  Each of these must be limited to about 10 devices
# so as not to overflow the 120 character limit on MS-DOS command lines.
#	DEVICE_DEVS - the default device, and any display devices.
#	DEVICE_DEVS1 - additional display devices if needed.
#	DEVICE_DEVS2 - dot matrix printers.
#	DEVICE_DEVS3 - H-P monochrome printers.
#	DEVICE_DEVS4 - H-P color printers.
#	DEVICE_DEVS5 - additional H-P printers if needed.
#	DEVICE_DEVS6 - other ink-jet and laser printers.
#	DEVICE_DEVS7 - fax file formats.
#	DEVICE_DEVS8 - CGM and PCX file formats.
#	DEVICE_DEVS9 - PBM/PGM/PPM file formats.
#	DEVICE_DEVS10 - black-and-white TIFF file formats.
#	DEVICE_DEVS11 - BMP and color TIFF file formats.
#	DEVICE_DEVS12 - PostScript image and 'bit' file formats.
# Feel free to disregard this convention if it gets in your way.

# If you want to add a new device driver, the examples below should be
# enough of a guide to the correct form for the makefile rules.
# Note that all drivers other than displays must include page.dev in their
# dependencies and use $(SETPDEV) rather than $(SETDEV) in their rule bodies.

# All device drivers depend on the following:
GDEV=$(AK) $(ECHOGS_XE) $(gserrors_h) $(gx_h) $(gxdevice_h)

# "Printer" drivers depend on the following:
PDEVH=$(GDEV) $(gdevprn_h)

# Define the header files for device drivers.  Every header file used by
# more than one device driver family must be listed here.
gdev8bcm_h=gdev8bcm.h
gdevpccm_h=gdevpccm.h
gdevpcfb_h=gdevpcfb.h $(dos__h)
gdevpcl_h=gdevpcl.h
gdevsvga_h=gdevsvga.h
gdevx_h=gdevx.h

###### ----------------------- Device support ----------------------- ######

# Provide a mapping between StandardEncoding and ISOLatin1Encoding.
gdevemap.$(OBJ): gdevemap.c $(AK) $(std_h)

# Implement dynamic color management for 8-bit mapped color displays.
gdev8bcm.$(OBJ): gdev8bcm.c $(AK) \
  $(gx_h) $(gxdevice_h) $(gdev8bcm_h)

###### ------------------- MS-DOS display devices ------------------- ######

# There are really only three drivers: an EGA/VGA driver (4 bit-planes,
# plane-addressed), a SuperVGA driver (8 bit-planes, byte addressed),
# and a special driver for the S3 chip.

# PC display color mapping
gdevpccm.$(OBJ): gdevpccm.c $(AK) \
  $(gx_h) $(gsmatrix_h) $(gxdevice_h) $(gdevpccm_h)

### ----------------------- EGA and VGA displays ----------------------- ###

# The shared MS-DOS makefile defines PCFBASM as either gdevegaa.$(OBJ)
# or an empty string.

gdevegaa.$(OBJ): gdevegaa.asm

# NOTE: for direct frame buffer addressing under SCO Unix or Xenix,
# change gdevevga to gdevsco in the following line.  Also, since
# SCO's /bin/as does not support the "out" instructions, you must build
# the gnu assembler and have it on your path as "as".
EGAVGA=gdevevga.$(OBJ) gdevpcfb.$(OBJ) gdevpccm.$(OBJ) $(PCFBASM)
#EGAVGA=gdevsco.$(OBJ) gdevpcfb.$(OBJ) gdevpccm.$(OBJ) $(PCFBASM)

gdevevga.$(OBJ): gdevevga.c $(GDEV) $(gdevpcfb_h)
	$(CCD) gdevevga.c

gdevsco.$(OBJ): gdevsco.c $(GDEV) $(gdevpcfb_h)

# Common code for MS-DOS and SCO.
gdevpcfb.$(OBJ): gdevpcfb.c $(GDEV) $(gconfigv_h) \
  $(gdevpccm_h) $(gdevpcfb_h) $(gsparam_h)
	$(CCD) gdevpcfb.c

# The EGA/VGA family includes EGA and VGA.  Many SuperVGAs in 800x600,
# 16-color mode can share the same code; see the next section below.

ega.dev: $(EGAVGA)
	$(SETDEV) ega $(EGAVGA)

vga.dev: $(EGAVGA)
	$(SETDEV) vga $(EGAVGA)

### ------------------------- SuperVGA displays ------------------------ ###

# SuperVGA displays in 16-color, 800x600 mode are really just slightly
# glorified VGA's, so we can handle them all with a single driver.
# The way to select them on the command line is with
#	-sDEVICE=svga16 -dDisplayMode=NNN
# where NNN is the display mode in decimal.  See use.doc for the modes
# for some popular display chipsets.

svga16.dev: $(EGAVGA)
	$(SETDEV) svga16 $(EGAVGA)

# More capable SuperVGAs have a wide variety of slightly differing
# interfaces, so we need a separate driver for each one.

SVGA=gdevsvga.$(OBJ) gdevpccm.$(OBJ) $(PCFBASM)

gdevsvga.$(OBJ): gdevsvga.c $(GDEV) $(gconfigv_h) \
  $(gxarith_h) $(gdevpccm_h) $(gdevpcfb_h) $(gdevsvga_h)
	$(CCD) gdevsvga.c

# The SuperVGA family includes: ATI Wonder, S3, Trident, Tseng ET3000/4000,
# and VESA.

atiw.dev: $(SVGA)
	$(SETDEV) atiw $(SVGA)

tseng.dev: $(SVGA)
	$(SETDEV) tseng $(SVGA)

tvga.dev: $(SVGA)
	$(SETDEV) tvga $(SVGA)

vesa.dev: $(SVGA)
	$(SETDEV) vesa $(SVGA)

# The S3 driver doesn't share much code with the others.

s3vga_=$(SVGA) gdevs3ga.$(OBJ) gdevsvga.$(OBJ) gdevpccm.$(OBJ)
s3vga.dev: $(s3vga_)
	$(SETDEV) s3vga $(s3vga_)

gdevs3ga.$(OBJ): gdevs3ga.c $(GDEV) $(gdevpcfb_h) $(gdevsvga_h)
	$(CCD) gdevs3ga.c

### ------------ The BGI (Borland Graphics Interface) device ----------- ###

cgaf.$(OBJ): $(BGIDIR)\cga.bgi
	$(BGIDIR)\bgiobj /F $(BGIDIR)\cga

egavgaf.$(OBJ): $(BGIDIR)\egavga.bgi
	$(BGIDIR)\bgiobj /F $(BGIDIR)\egavga

# Include egavgaf.$(OBJ) for debugging only.
bgi_=gdevbgi.$(OBJ) cgaf.$(OBJ)
bgi.dev: $(bgi_)
	$(SETDEV) bgi $(bgi_)
	$(ADDMOD) bgi -lib $(LIBDIR)\graphics

gdevbgi.$(OBJ): gdevbgi.c $(GDEV) $(MAKEFILE) $(gxxfont_h)
	$(CCC) -DBGI_LIB="$(BGIDIRSTR)" gdevbgi.c

### ------------------- The Hercules Graphics display ------------------- ###

herc_=gdevherc.$(OBJ)
herc.dev: $(herc_)
	$(SETDEV) herc $(herc_)

gdevherc.$(OBJ): gdevherc.c $(GDEV)
	$(CCC) gdevherc.c

### ---------------------- The Private Eye display ---------------------- ###
### Note: this driver was contributed by a user:                          ###
###   please contact narf@media-lab.media.mit.edu if you have questions.  ###

pe_=gdevpe.$(OBJ)
pe.dev: $(pe_)
	$(SETDEV) pe $(pe_)

gdevpe.$(OBJ): gdevpe.c $(GDEV)

###### ----------------------- Other displays ------------------------ ######

### -------------------- The MS-Windows 3.n display --------------------- ###

gdevmswn_h=gdevmswn.h $(GDEV) gp_mswin.h

# Choose one of gdevwddb or gdevwdib here.
mswin_=gdevmswn.$(OBJ) gdevmsxf.$(OBJ) gdevwdib.$(OBJ) \
  gdevemap.$(OBJ) gdevpccm.$(OBJ)
mswin.dev: $(mswin_)
	$(SETDEV) mswin $(mswin_)

gdevmswn.$(OBJ): gdevmswn.c $(gdevmswn_h) $(gp_h) $(gpcheck_h) \
  $(gsparam_h) $(gdevpccm_h)

gdevmsxf.$(OBJ): gdevmsxf.c $(ctype__h) $(math__h) $(memory__h) \
  $(gdevmswn_h) $(gsstruct_h) $(gsutil_h) $(gxxfont_h)

# An implementation using a device-dependent bitmap.
gdevwddb.$(OBJ): gdevwddb.c $(gdevmswn_h)

# An implementation using a DIB filled by an image device.
gdevwdib.$(OBJ): gdevwdib.c $(dos__h) $(gdevmswn_h)

### -------------------- The MS-Windows 3.n DLL ------------------------- ###

# Must use gdevwdib.  mswin device must use the same.
mswindll_=gdevmswn.$(OBJ) gdevmsxf.$(OBJ) gdevwdib.$(OBJ) \
  gdevemap.$(OBJ) gdevpccm.$(OBJ)
mswindll.dev: $(mswindll_)
	$(SETDEV) mswindll $(mswindll_)

### -------------------- The MS-Windows DDB 3.n printer ----------------- ###

mswinprn_=gdevwprn.$(OBJ) gdevmsxf.$(OBJ)
mswinprn.dev: $(mswinprn_)
	$(SETDEV) mswinprn $(mswinprn_)

gdevwprn.$(OBJ): gdevwprn.c $(gdevmswn_h) $(gp_h)

### -------------------- The MS-Windows DIB 3.n printer ----------------- ###

mswinpr2_=gdevwpr2.$(OBJ)
mswinpr2.dev: $(mswinpr2_) page.dev
	$(SETPDEV) mswinpr2 $(mswinpr2_)

gdevwpr2.$(OBJ): gdevwpr2.c $(gdevmswn_h) $(gp_h)

### ------------------ OS/2 Presentation Manager device ----------------- ###

os2pm_=gdevpm.$(OBJ) gdevpccm.$(OBJ)
os2pm.dev: $(os2pm_)
	$(SETDEV) os2pm $(os2pm_)

os2dll_=gdevpm.$(OBJ) gdevpccm.$(OBJ)
os2dll.dev: $(os2dll_)
	$(SETDEV) os2dll $(os2dll_)

gdevpm.$(OBJ): gdevpm.c $(gp_h) $(gpcheck_h) \
  $(gsexit_h) $(gsparam_h) $(gdevpccm_h)

### --------------------------- The OS/2 printer ------------------------ ###

os2prn_=gdevos2p.$(OBJ)
os2prn.dev: $(os2prn_) page.dev
	$(SETPDEV) os2prn $(os2prn_)

os2prn.$(OBJ): os2prn.c $(gp_h)

### -------------- The AT&T 3b1 Unixpc monochrome display --------------- ###
### Note: this driver was contributed by a user: please contact           ###
###       Andy Fyfe (andy@cs.caltech.edu) if you have questions.          ###

att3b1_=gdev3b1.$(OBJ)
att3b1.dev: $(att3b1_)
	$(SETDEV) att3b1 $(att3b1_)

gdev3b1.$(OBJ): gdev3b1.c

### ---------------------- Linux PC with vgalib ------------------------- ###
### Note: these drivers were contributed by users.                        ###
### For questions about the lvga256 driver, please contact                ###
###       Ludger Kunz (ludger.kunz@fernuni-hagen.de).                     ###
### For questions about the vgalib driver, please contact                 ###
###       Erik Talvola (talvola@gnu.ai.mit.edu).                          ###

lvga256_=gdevl256.$(OBJ)
lvga256.dev: $(lvga256_)
	$(SETDEV) lvga256 $(lvga256_)
	$(ADDMOD) lvga256 -lib vga vgagl

gdevl256.$(OBJ): gdevl256.c $(GDEV) $(gxxfont_h)

vgalib_=gdevvglb.$(OBJ)
vgalib.dev: $(vgalib_)
	$(SETDEV) vgalib $(vgalib_)
	$(ADDMOD) vgalib -lib vga

gdevvglb.$(OBJ): gdevvglb.c $(GDEV)

### ------------------- Sony NeWS frame buffer device ------------------ ###
### Note: this driver was contributed by a user: please contact          ###
###       Mike Smolenski (mike@intertech.com) if you have questions.     ###

# This is implemented as a 'printer' device.
sonyfb_=gdevsnfb.$(OBJ)
sonyfb.dev: $(sonyfb_) page.dev
	$(SETPDEV) sonyfb $(sonyfb_)

gdevsnfb.$(OBJ): gdevsnfb.c $(PDEVH)

### ------------------------ The SunView device ------------------------ ###
### Note: this driver is maintained by a user: if you have questions,    ###
###       please contact Andreas Stolcke (stolcke@icsi.berkeley.edu).    ###

sunview_=gdevsun.$(OBJ)
sunview.dev: $(sunview_)
	$(SETDEV) sunview $(sunview_)
	$(ADDMOD) sunview -lib suntool sunwindow pixrect

gdevsun.$(OBJ): gdevsun.c $(GDEV) $(malloc__h) $(gscdefs_h) $(gsmatrix_h)

### -------------------------- The X11 device -------------------------- ###

# Aladdin Enterprises does not support Ghostview.  For more information
# about Ghostview, please contact Tim Theisen (ghostview@cs.wisc.edu).

# See the main makefile for the definition of XLIBS.
x11_=gdevx.$(OBJ) gdevxini.$(OBJ) gdevxxf.$(OBJ) gdevemap.$(OBJ)
x11.dev: $(x11_)
	$(SETDEV) x11 $(x11_)
	$(ADDMOD) x11 -lib $(XLIBS)

# See the main makefile for the definition of XINCLUDE.
GDEVX=$(GDEV) x_.h gdevx.h $(MAKEFILE)
gdevx.$(OBJ): gdevx.c $(GDEVX) $(gsparam_h)
	$(CCC) $(XINCLUDE) gdevx.c

gdevxini.$(OBJ): gdevxini.c $(GDEVX) $(ctype__h)
	$(CCC) $(XINCLUDE) gdevxini.c

gdevxxf.$(OBJ): gdevxxf.c $(GDEVX) $(gsstruct_h) $(gsutil_h) $(gxxfont_h)
	$(CCC) $(XINCLUDE) gdevxxf.c

# Alternate X11-based devices to help debug other drivers.
# x11alpha pretends to have 4 bits of alpha channel.
# x11cmyk pretends to be a CMYK device with 1 bit each of C,M,Y,K.
# x11mono pretends to be a black-and-white device.
x11alt_=$(x11_) gdevxalt.$(OBJ)
x11alpha.dev: $(x11alt_)
	$(SETDEV) x11alpha $(x11alt_)
	$(ADDMOD) x11alpha -lib $(XLIBS)

x11cmyk.dev: $(x11alt_)
	$(SETDEV) x11cmyk $(x11alt_)
	$(ADDMOD) x11cmyk -lib $(XLIBS)

x11mono.dev: $(x11alt_)
	$(SETDEV) x11mono $(x11alt_)
	$(ADDMOD) x11mono -lib $(XLIBS)

gdevxalt.$(OBJ): gdevxalt.c $(GDEVX) $(PDEVH)
	$(CCC) $(XINCLUDE) gdevxalt.c

### ------------------------- DEC sixel displays ------------------------ ###
### Note: this driver was contributed by a user: please contact           ###
###   Phil Keegstra (keegstra@tonga.gsfc.nasa.gov) if you have questions. ###

# This is a "printer" device, but it probably shouldn't be.
# I don't know why the implementor chose to do it this way.
sxlcrt_=gdevln03.$(OBJ)
sxlcrt.dev: $(sxlcrt_) page.dev
	$(SETPDEV) sxlcrt $(sxlcrt_)

###### --------------- Memory-buffered printer devices --------------- ######

### --------------------- The Apple printer devices --------------------- ###
### Note: these drivers were contributed by users.                        ###
###   If you have questions about the DMP driver, please contact          ###
###	Mark Wedel (master@cats.ucsc.edu).                                ###
###   If you have questions about the Imagewriter drivers, please contact ###
###	Jonathan Luckey (luckey@rtfm.mlb.fl.us).                          ###
###   If you have questions about the Imagewriter LQ driver, please       ###
###	contact Scott Barker (barkers@cuug.ab.ca).                        ###

appledmp_=gdevadmp.$(OBJ)

gdevadmp.$(OBJ): gdevadmp.c $(GDEV) $(gdevprn_h)

appledmp.dev: $(appledmp_) page.dev
	$(SETPDEV) appledmp $(appledmp_)

iwhi.dev: $(appledmp_) page.dev
	$(SETPDEV) iwhi $(appledmp_)

iwlo.dev: $(appledmp_) page.dev
	$(SETPDEV) iwlo $(appledmp_)

iwlq.dev: $(appledmp_) page.dev
	$(SETPDEV) iwlq $(appledmp_)

### ------------ The Canon BubbleJet BJ10e and BJ200 devices ------------ ###

bj10e_=gdevbj10.$(OBJ)

bj10e.dev: $(bj10e_) page.dev
	$(SETPDEV) bj10e $(bj10e_)

bj200.dev: $(bj10e_) page.dev
	$(SETPDEV) bj200 $(bj10e_)

gdevbj10.$(OBJ): gdevbj10.c $(PDEVH)

### ----------- The H-P DeskJet and LaserJet printer devices ----------- ###

### These are essentially the same device.
### NOTE: printing at full resolution (300 DPI) requires a printer
###   with at least 1.5 Mb of memory.  150 DPI only requires .5 Mb.
### Note that the lj4dith driver is included with the H-P color printer
###   drivers below.

HPPCL=gdevpcl.$(OBJ)
HPMONO=gdevdjet.$(OBJ) $(HPPCL)

gdevpcl.$(OBJ): gdevpcl.c $(PDEVH) $(gdevpcl_h)

gdevdjet.$(OBJ): gdevdjet.c $(PDEVH) $(gdevpcl_h)

deskjet.dev: $(HPMONO) page.dev
	$(SETPDEV) deskjet $(HPMONO)

djet500.dev: $(HPMONO) page.dev
	$(SETPDEV) djet500 $(HPMONO)

laserjet.dev: $(HPMONO) page.dev
	$(SETPDEV) laserjet $(HPMONO)

ljetplus.dev: $(HPMONO) page.dev
	$(SETPDEV) ljetplus $(HPMONO)

### Selecting ljet2p provides TIFF (mode 2) compression on LaserJet III,
### IIIp, IIId, IIIsi, IId, and IIp. 

ljet2p.dev: $(HPMONO) page.dev
	$(SETPDEV) ljet2p $(HPMONO)

### Selecting ljet3 provides Delta Row (mode 3) compression on LaserJet III,
### IIIp, IIId, IIIsi.

ljet3.dev: $(HPMONO) page.dev
	$(SETPDEV) ljet3 $(HPMONO)

### Selecting ljet3d also provides duplex printing capability.

ljet3d.dev: $(HPMONO) page.dev
	$(SETPDEV) ljet3d $(HPMONO)

### Selecting ljet4 also provides Delta Row compression on LaserJet IV series.

ljet4.dev: $(HPMONO) page.dev
	$(SETPDEV) ljet4 $(HPMONO)

lp2563.dev: $(HPMONO) page.dev
	$(SETPDEV) lp2563 $(HPMONO)

oce9050.dev: $(HPMONO) page.dev
	$(SETPDEV) oce9050 $(HPMONO)

### The H-P DeskJet, PaintJet, and DesignJet family color printer devices.###
### Note: there are two different 500C drivers, both contributed by users.###
###   If you have questions about the djet500c driver,                    ###
###       please contact AKayser@et.tudelft.nl.                           ###
###   If you have questions about the cdj* drivers,                       ###
###       please contact g.cameron@biomed.abdn.ac.uk.                     ###
###   If you have questions about the dnj560c driver,                     ###
###       please contact koert@zen.cais.com.                              ###
###   If you have questions about the lj4dith driver,                     ###
###       please contact Eckhard.Rueggeberg@ts.go.dlr.de.                 ###
###   If you have questions about the BJC600/BJC4000, BJC800, or ESCP     ###
###       drivers, please contact Yves.Arrouye@imag.fr.                   ###

cdeskjet_=gdevcdj.$(OBJ) $(HPPCL)

cdeskjet.dev: $(cdeskjet_) page.dev
	$(SETPDEV) cdeskjet $(cdeskjet_)

cdjcolor.dev: $(cdeskjet_) page.dev
	$(SETPDEV) cdjcolor $(cdeskjet_)

cdjmono.dev: $(cdeskjet_) page.dev
	$(SETPDEV) cdjmono $(cdeskjet_)

cdj500.dev: $(cdeskjet_) page.dev
	$(SETPDEV) cdj500 $(cdeskjet_)

cdj550.dev: $(cdeskjet_) page.dev
	$(SETPDEV) cdj550 $(cdeskjet_)

declj250.dev: $(cdeskjet_) page.dev
	$(SETPDEV) declj250 $(cdeskjet_)

dnj650c.dev: $(cdeskjet_) page.dev
	$(SETPDEV) dnj650c $(cdeskjet_)

lj4dith.dev: $(cdeskjet_) page.dev
	$(SETPDEV) lj4dith $(cdeskjet_)

pj.dev: $(cdeskjet_) page.dev
	$(SETPDEV) pj $(cdeskjet_)

pjxl.dev: $(cdeskjet_) page.dev
	$(SETPDEV) pjxl $(cdeskjet_)

pjxl300.dev: $(cdeskjet_) page.dev
	$(SETPDEV) pjxl300 $(cdeskjet_)

# Note: the BJC600 driver also works for the BJC4000.
bjc600.dev: $(cdeskjet_) page.dev
	$(SETPDEV) bjc600 $(cdeskjet_)

bjc800.dev: $(cdeskjet_) page.dev
	$(SETPDEV) bjc800 $(cdeskjet_)

escp.dev: $(cdeskjet_) page.dev
	$(SETPDEV) escp $(cdeskjet_)

# NB: you can also customise the build if required, using
# -DBitsPerPixel=<number> if you wish the default to be other than 24
# for the generic drivers (cdj500, cdj550, pjxl300, pjtest, pjxltest).
gdevcdj.$(OBJ): gdevcdj.c $(PDEVH) $(gdevpcl_h)
	$(CCC) gdevcdj.c

djet500c_=gdevdjtc.$(OBJ) $(HPPCL)
djet500c.dev: $(djet500c_) page.dev
	$(SETPDEV) djet500c $(djet500c_)

gdevdjtc.$(OBJ): gdevdjtc.c $(PDEVH) $(gdevpcl_h)

### -------------------- The Mitsubishi CP50 printer -------------------- ###
### Note: this driver was contributed by a user: please contact           ###
###       Michael Hu (michael@ximage.com) if you have questions.          ###

cp50_=gdevcp50.$(OBJ)
cp50.dev: $(cp50_) page.dev
	$(SETPDEV) cp50 $(cp50_)

gdevcp50.$(OBJ): gdevcp50.c $(PDEVH)

### ----------------- The generic Epson printer device ----------------- ###
### Note: most of this code was contributed by users.  Please contact    ###
###       the following people if you have questions:                    ###
###   eps9mid - Guenther Thomsen (thomsen@cs.tu-berlin.de)               ###
###   eps9high - David Wexelblat (dwex@mtgzfs3.att.com)                  ###
###   ibmpro - James W. Birdsall (jwbirdsa@picarefy.picarefy.com)        ###

epson_=gdevepsn.$(OBJ)

epson.dev: $(epson_) page.dev
	$(SETPDEV) epson $(epson_)

eps9mid.dev: $(epson_) page.dev
	$(SETPDEV) eps9mid $(epson_)

eps9high.dev: $(epson_) page.dev
	$(SETPDEV) eps9high $(epson_)

gdevepsn.$(OBJ): gdevepsn.c $(PDEVH)

### ----------------- The IBM Proprinter printer device ---------------- ###

ibmpro.dev: $(epson_) page.dev
	$(SETPDEV) ibmpro $(epson_)

### -------------- The Epson LQ-2550 color printer device -------------- ###
### Note: this driver was contributed by users: please contact           ###
###       Dave St. Clair (dave@exlog.com) if you have questions.         ###

epsonc_=gdevepsc.$(OBJ)
epsonc.dev: $(epsonc_) page.dev
	$(SETPDEV) epsonc $(epsonc_)

gdevepsc.$(OBJ): gdevepsc.c $(PDEVH)

### ------------- The Epson ESC/P 2 language printer devices ------------- ###
### Note: these drivers were contributed by users.                         ###
### For questions about the Stylus 800 and AP3250 drivers, please contact  ###
###        Richard Brown (rab@tauon.ph.unimelb.edu.au).                    ###
### For questions about the Stylus Color driver, please contact            ###
###        Gunther Hess (hess@ims.fhg.de until 28-feb-95; after that,      ###
###          see the other contact information in the source file).        ###

ESCP2=gdevescp.$(OBJ)

gdevescp.$(OBJ): gdevescp.c $(PDEVH)

ap3250.dev: $(ESCP2) page.dev
	$(SETPDEV) ap3250 $(ESCP2)

st800.dev: $(ESCP2) page.dev
	$(SETPDEV) st800 $(ESCP2)

stcolor_=gdevstc.$(OBJ)  \
	gdevstc1.$(OBJ) gdevstc2.$(OBJ) gdevstc3.$(OBJ) gdevstc4.$(OBJ)
stcolor.dev: $(stcolor_) page.dev
	$(SETPDEV) stcolor $(stcolor_)

gdevstc.$(OBJ): gdevstc.c gdevstc.h $(PDEVH)

gdevstc1.$(OBJ): gdevstc1.c gdevstc.h $(PDEVH)

gdevstc2.$(OBJ): gdevstc2.c gdevstc.h $(PDEVH)

gdevstc3.$(OBJ): gdevstc3.c gdevstc.h $(PDEVH)

gdevstc4.$(OBJ): gdevstc4.c gdevstc.h $(PDEVH)

escp2c_=gdevep2c.$(OBJ)
escp2cfs_=gdevep2c.$(OBJ)
escp2cdither_=gdevep2c.$(OBJ)
escp2cf2_=gdevep2c.$(OBJ)

escp2c.dev: $(escp2c_) page.dev
	$(SETPDEV) escp2c $(escp2c_)

escp2cfs.dev: $(escp2cfs_) page.dev
	$(SETPDEV) escp2cfs $(escp2cfs_)

escp2cdither.dev: $(escp2cdither_) page.dev
	$(SETPDEV) escp2cdither $(escp2cdither_)

escp2cf2.dev: $(escp2cf2_) page.dev
	$(SETPDEV) escp2cf2 $(escp2cf2_)

gdevep2c.$(OBJ): gdevep2c.c $(PDEVH)

### ------------ The H-P PaintJet color printer device ----------------- ###
### Note: this driver also supports the DEC LJ250 color printer, which   ###
###       has a PaintJet-compatible mode, and the PaintJet XL.           ###
### If you have questions about the XL, please contact Rob Reiss         ###
###       (rob@moray.berkeley.edu).                                      ###

PJET=gdevpjet.$(OBJ) $(HPPCL)

gdevpjet.$(OBJ): gdevpjet.c $(PDEVH) $(gdevpcl_h)

lj250.dev: $(PJET) page.dev
	$(SETPDEV) lj250 $(PJET)

paintjet.dev: $(PJET) page.dev
	$(SETPDEV) paintjet $(PJET)

pjetxl.dev: $(PJET) page.dev
	$(SETPDEV) pjetxl $(PJET)

### -------------- Imagen ImPress Laser Printer device ----------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Alan Millar (AMillar@bolis.sf-bay.org) if you have questions.  ###
### Set USE_BYTE_STREAM if using parallel interface;                     ###
### Don't set it if using 'ipr' spooler (default).                       ###
### You may also add -DA4 if needed for A4 paper.			 ###

imagen_=gdevimgn.$(OBJ)
imagen.dev: $(imagen_) page.dev
	$(SETPDEV) imagen $(imagen_)

gdevimgn.$(OBJ): gdevimgn.c $(PDEVH)
	$(CCC) gdevimgn.c			# for ipr spooler
#	$(CCC) -DUSE_BYTE_STREAM gdevimgn.c	# for parallel

### ------- The IBM 3852 JetPrinter color inkjet printer device -------- ###
### Note: this driver was contributed by users: please contact           ###
###       Kevin Gift (kgift@draper.com) if you have questions.           ###
### Note that the paper size that can be addressed by the graphics mode  ###
###   used in this driver is fixed at 7-1/2 inches wide (the printable   ###
###   width of the jetprinter itself.)                                   ###

jetp3852_=gdev3852.$(OBJ)
jetp3852.dev: $(jetp3852_) page.dev
	$(SETPDEV) jetp3852 $(jetp3852_)

gdev3852.$(OBJ): gdev3852.c $(PDEVH) $(gdevpcl_h)

### ---------- The Canon LBP-8II and LIPS III printer devices ---------- ###
### Note: these drivers were contributed by users.                       ###
### For questions about the LBP8 driver, please contact                  ###
###       Tom Quinn (trq@prg.oxford.ac.uk).                              ###
### For questions about the LIPS III driver, please contact              ###
###       Kenji Okamoto (okamoto@okamoto.cias.osakafu-u.ac.jp).          ###

lbp8_=gdevlbp8.$(OBJ)
lbp8.dev: $(lbp8_) page.dev
	$(SETPDEV) lbp8 $(lbp8_)

lips3.dev: $(lbp8_) page.dev
	$(SETPDEV) lips3 $(lbp8_)

gdevlbp8.$(OBJ): gdevlbp8.c $(PDEVH)

### ----------- The DEC LN03/LA50/LA70/LA75 printer devices ------------ ###
### Note: this driver was contributed by users: please contact           ###
###       Ulrich Mueller (ulm@vsnhd1.cern.ch) if you have questions.     ###
### For questions about LA50 and LA75, please contact                    ###
###       Ian MacPhedran (macphed@dvinci.USask.CA).                      ###
### For questions about the LA70, please contact                         ###
###       Bruce Lowekamp (lowekamp@csugrad.cs.vt.edu).                   ###
### For questions about the LA75plus, please contact                     ###
###       Andre' Beck (Andre_Beck@IRS.Inf.TU-Dresden.de).                ###

ln03_=gdevln03.$(OBJ)
ln03.dev: $(ln03_) page.dev
	$(SETPDEV) ln03 $(ln03_)

la50.dev: $(ln03_) page.dev
	$(SETPDEV) la50 $(ln03_)

la70.dev: $(ln03_) page.dev
	$(SETPDEV) la70 $(ln03_)

la75.dev: $(ln03_) page.dev
	$(SETPDEV) la75 $(ln03_)

la75plus.dev: $(ln03_) page.dev
	$(SETPDEV) la75plus $(ln03_)

gdevln03.$(OBJ): gdevln03.c $(PDEVH)

# LA70 driver with low-resolution text enhancement.

la70t_=gdevla7t.$(OBJ)
la70t.dev: $(la70t_) page.dev
	$(SETPDEV) la70t $(la70t_)

gdevla7t.$(OBJ): gdevla7t.c $(PDEVH)

### -------------- The C.Itoh M8510 printer device --------------------- ###
### Note: this driver was contributed by a user: please contact Bob      ###
###       Smith <bob@snuffy.penfield.ny.us> if you have questions.       ###

m8510_=gdev8510.$(OBJ)
m8510.dev: $(m8510_) page.dev
	$(SETPDEV) m8510 $(m8510_)

gdev8510.$(OBJ): gdev8510.c $(PDEVH)

### --------------------- The NEC P6 family devices -------------------- ###

necp6_=gdevnp6.$(OBJ)
necp6.dev: $(necp6_) page.dev
	$(SETPDEV) necp6 $(necp6_)

gdevnp6.$(OBJ): gdevnp6.c $(PDEVH)

### ----------------- The Okidata MicroLine 182 device ----------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Maarten Koning (smeg@bnr.ca) if you have questions.            ###

oki182_=gdevo182.$(OBJ)
oki182.dev: $(oki182_) page.dev
	$(SETPDEV) oki182 $(oki182_)

gdevo182.$(OBJ): gdevo182.c $(PDEVH)

### ------------- The Okidata IBM compatible printer device ------------ ###
### Note: this driver was contributed by a user: please contact          ###
###       Charles Mack (chasm@netcom.com) if you have questions.         ###

okiibm_=gdevokii.$(OBJ)
okiibm.dev: $(okiibm_) page.dev
	$(SETPDEV) okiibm $(okiibm_)

gdevokii.$(OBJ): gdevokii.c $(PDEVH)

### ------------- The Ricoh 4081 laser printer device ------------------ ###
### Note: this driver was contributed by users:                          ###
###       please contact kdw@oasis.icl.co.uk if you have questions.      ###

r4081_=gdev4081.$(OBJ)
r4081.dev: $(r4081_) page.dev
	$(SETPDEV) r4081 $(r4081_)


gdev4081.$(OBJ): gdev4081.c $(PDEVH)

### -------------------- Sony NWP533 printer device -------------------- ###
### Note: this driver was contributed by a user: please contact Tero     ###
###       Kivinen (kivinen@joker.cs.hut.fi) if you have questions.       ###

nwp533_=gdevn533.$(OBJ)
nwp533.dev: $(nwp533_) page.dev
	$(SETPDEV) nwp533 $(nwp533_)

gdevn533.$(OBJ): gdevn533.c $(PDEVH)

### ------------------------- The SPARCprinter ------------------------- ###
### Note: this driver was contributed by users: please contact Martin    ###
###       Schulte (schulte@thp.uni-koeln.de) if you have questions.      ###
###       He would also like to hear from anyone using the driver.       ###
### Please consult the source code for additional documentation.         ###

sparc_=gdevsppr.$(OBJ)
sparc.dev: $(sparc_) page.dev
	$(SETPDEV) sparc $(sparc_)

gdevsppr.$(OBJ): gdevsppr.c $(PDEVH)

### ----------------- The StarJet SJ48 device -------------------------- ###
### Note: this driver was contributed by a user: if you have questions,  ###
###	                      .                                          ###
###       please contact Mats Akerblom (f86ma@dd.chalmers.se).           ###

sj48_=gdevsj48.$(OBJ)
sj48.dev: $(sj48_) page.dev
	$(SETPDEV) sj48 $(sj48_)

gdevsj48.$(OBJ): gdevsj48.c $(PDEVH)

### ----------------- Tektronix 4396d color printer -------------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Karl Hakimian (hakimian@haney.eecs.wsu.edu)                    ###
###       if you have questions.                                         ###

t4693d_=gdev4693.$(OBJ)
t4693d2.dev: $(t4693d_) page.dev
	$(SETPDEV) t4693d2 $(t4693d_)

t4693d4.dev: $(t4693d_) page.dev
	$(SETPDEV) t4693d4 $(t4693d_)

t4693d8.dev: $(t4693d_) page.dev
	$(SETPDEV) t4693d8 $(t4693d_)

gdev4693.$(OBJ): gdev4693.c $(GDEV)

### -------------------- Tektronix ink-jet printers -------------------- ###
### Note: this driver was contributed by a user: please contact          ###
###       Karsten Spang (spang@nbivax.nbi.dk) if you have questions.     ###

tek4696_=gdevtknk.$(OBJ)
tek4696.dev: $(tek4696_) page.dev
	$(SETPDEV) tek4696 $(tek4696_)

gdevtknk.$(OBJ): gdevtknk.c $(PDEVH)

###### ------------------------- Fax devices ------------------------- ######

### --------------- Generic PostScript system compatible fax ------------ ###

# This code doesn't work yet.  Don't even think about using it.

PSFAX=gdevpfax.$(OBJ)

psfax_=$(PSFAX)
psfax.dev: $(psfax_) page.dev
	$(SETPDEV) psfax $(psfax_)
	$(ADDMOD) psfax -iodev Fax

gdevpfax.$(OBJ): gdevpfax.c $(PDEVH) $(gxiodev_h)

### ------------------------- The DigiFAX device ------------------------ ###
###    This driver outputs images in a format suitable for use with       ###
###    DigiBoard, Inc.'s DigiFAX software.  Use -sDEVICE=dfaxhigh for     ###
###    high resolution output, -sDEVICE=dfaxlow for normal output.        ###
### Note: this driver was contributed by a user: please contact           ###
###       Rick Richardson (rick@digibd.com) if you have questions.        ###

dfax_=gdevdfax.$(OBJ) gdevtfax.$(OBJ)

dfaxlow.dev: $(dfax_) page.dev
	$(SETPDEV) dfaxlow $(dfax_)
	$(ADDMOD) dfaxlow -include cfe

dfaxhigh.dev: $(dfax_) page.dev
	$(SETPDEV) dfaxhigh $(dfax_)
	$(ADDMOD) dfaxlow -include cfe

gdevdfax.$(OBJ): gdevdfax.c $(GDEV) $(gdevprn_h)

### ----------------- The Xerox XES printer device --------------------- ###
### Note: this driver was contributed by users: please contact           ###
###       Peter Flass (flass@lbdrscs.bitnet) if you have questions.      ###

xes_=gdevxes.$(OBJ)
xes.dev: $(xes_) page.dev
	$(SETPDEV) xes $(xes_)

gdevxes.$(OBJ): gdevxes.c $(GDEV)

### --------------------- The "plain bits" devices ---------------------- ###

bit_=gdevbit.$(OBJ)

bit.dev: $(bit_) page.dev
	$(SETPDEV) bit $(bit_)

bitrgb.dev: $(bit_) page.dev
	$(SETPDEV) bitrgb $(bit_)

bitcmyk.dev: $(bit_) page.dev
	$(SETPDEV) bitcmyk $(bit_)

gdevbit.$(OBJ): gdevbit.c $(PDEVH) $(gsparam_h) $(gxlum_h)

###### ------------------------- File formats ------------------------ ######

### ------------------------- .BMP file formats ------------------------- ###

bmp_=gdevbmp.$(OBJ) gdevpccm.$(OBJ)

gdevbmp.$(OBJ): gdevbmp.c $(PDEVH) $(gdevpccm_h)

bmpmono.dev: $(bmp_) page.dev
	$(SETPDEV) bmpmono $(bmp_)

bmp16.dev: $(bmp_) page.dev
	$(SETPDEV) bmp16 $(bmp_)

bmp256.dev: $(bmp_) page.dev
	$(SETPDEV) bmp256 $(bmp_)

bmp16m.dev: $(bmp_) page.dev
	$(SETPDEV) bmp16m $(bmp_)

### -------------------------- CGM file format ------------------------- ###
### This driver is under development.  Use at your own risk.             ###
### The output is very low-level, consisting only of rectangles and      ###
### cell arrays.                                                         ###

cgm_=gdevcgm.$(OBJ) gdevcgml.$(OBJ)

gdevcgml_h=gdevcgml.h
gdevcgmx_h=gdevcgmx.h $(gdevcgml_h)

gdevcgm.$(OBJ): gdevcgm.c $(GDEV) $(gsparam_h) $(gdevpccm_h) $(gdevcgml_h)

gdevcgml.$(OBJ): gdevcgml.c $(memory__h) $(stdio__h) \
  $(gdevcgml_h) $(gdevcgmx_h)

cgmmono.dev: $(cgm_)
	$(SETDEV) cgmmono $(cgm_)

cgm8.dev: $(cgm_)
	$(SETDEV) cgm8 $(cgm_)

cgm24.dev: $(cgm_)
	$(SETDEV) cgm24 $(cgm_)

### -------------------- The CIF file format for VLSI ------------------ ###
### Note: this driver was contributed by a user: please contact          ###
###       Frederic Petrot (petrot@masi.ibp.fr) if you have questions.    ###

cif_=gdevcif.$(OBJ)
cif.dev: $(cif_) page.dev
	$(SETPDEV) cif $(cif_)

gdevcif.$(OBJ): gdevcif.c $(PDEVH)

### --------------------------- MGR devices ---------------------------- ###
### Note: these drivers were contributed by a user: please contact       ###
###       Carsten Emde (carsten@ce.pr.net.ch) if you have questions.     ###

MGR=gdevmgr.$(OBJ) gdevpccm.$(OBJ)

gdevmgr.$(OBJ): gdevmgr.c $(PDEVH) $(gdevpccm_h) gdevmgr.h

mgrmono.dev: $(MGR) page.dev
	$(SETPDEV) mgrmono $(MGR)

mgrgray2.dev: $(MGR) page.dev
	$(SETPDEV) mgrgray2 $(MGR)

mgrgray4.dev: $(MGR) page.dev
	$(SETPDEV) mgrgray4 $(MGR)

mgrgray8.dev: $(MGR) page.dev
	$(SETPDEV) mgrgray8 $(MGR)

mgr4.dev: $(MGR) page.dev
	$(SETPDEV) mgr4 $(MGR)

mgr8.dev: $(MGR) page.dev
	$(SETPDEV) mgr8 $(MGR)

### ------------------------- PCX file formats ------------------------- ###

pcx_=gdevpcx.$(OBJ) gdevpccm.$(OBJ)

gdevpcx.$(OBJ): gdevpcx.c $(PDEVH) $(gdevpccm_h) $(gxlum_h)

pcxmono.dev: $(pcx_) page.dev
	$(SETPDEV) pcxmono $(pcx_)

pcxgray.dev: $(pcx_) page.dev
	$(SETPDEV) pcxgray $(pcx_)

pcx16.dev: $(pcx_) page.dev
	$(SETPDEV) pcx16 $(pcx_)

pcx256.dev: $(pcx_) page.dev
	$(SETPDEV) pcx256 $(pcx_)

pcx24b.dev: $(pcx_) page.dev
	$(SETPDEV) pcx24b $(pcx_)

### ------------------- Portable Bitmap file formats ------------------- ###
### For more information, see the pbm(5), pgm(5), and ppm(5) man pages.  ###

pxm_=gdevpbm.$(OBJ)

gdevpbm.$(OBJ): gdevpbm.c $(PDEVH) $(gscdefs_h) $(gxlum_h)

### Portable Bitmap (PBM, plain or raw format, magic numbers "P1" or "P4")

pbm.dev: $(pxm_) page.dev
	$(SETPDEV) pbm $(pxm_)

pbmraw.dev: $(pxm_) page.dev
	$(SETPDEV) pbmraw $(pxm_)

### Portable Graymap (PGM, plain or raw format, magic numbers "P2" or "P5")

pgm.dev: $(pxm_) page.dev
	$(SETPDEV) pgm $(pxm_)

pgmraw.dev: $(pxm_) page.dev
	$(SETPDEV) pgmraw $(pxm_)

# PGM with automatic optimization to PBM if this is possible.

pgnm.dev: $(pxm_) page.dev
	$(SETPDEV) pgnm $(pxm_)

pgnmraw.dev: $(pxm_) page.dev
	$(SETPDEV) pgnmraw $(pxm_)

### Portable Pixmap (PPM, plain or raw format, magic numbers "P3" or "P6")

ppm.dev: $(pxm_) page.dev
	$(SETPDEV) ppm $(pxm_)

ppmraw.dev: $(pxm_) page.dev
	$(SETPDEV) ppmraw $(pxm_)

# PPM with automatic optimization to PGM or PBM if possible.

pnm.dev: $(pxm_) page.dev
	$(SETPDEV) pnm $(pxm_)

pnmraw.dev: $(pxm_) page.dev
	$(SETPDEV) pnmraw $(pxm_)

### --------------- Portable Network Graphics file format --------------- ###
### Requires libpng 0.71 and zlib 0.93 (or more recent versions) from     ###
### ftp://ftp.uu.net/graphics/png.  See png.mak for more details.         ###

png_=gdevpng.$(OBJ)

pngmono.dev: pnglib.dev $(png_) page.dev
	$(SETPDEV) pngmono  $(png_)
	$(ADDMOD) pngmono  -include pnglib

pnggray.dev: pnglib.dev $(png_) page.dev
	$(SETPDEV) pnggray  $(png_)
	$(ADDMOD) pnggray  -include pnglib

png16.dev: pnglib.dev $(png_) page.dev
	$(SETPDEV) png16  $(png_)
	$(ADDMOD) png16  -include pnglib

png256.dev: pnglib.dev $(png_) page.dev
	$(SETPDEV) png256  $(png_)
	$(ADDMOD) png256  -include pnglib

png16m.dev: pnglib.dev $(png_) page.dev
	$(SETPDEV) png16m  $(png_)
	$(ADDMOD) png16m  -include pnglib

### ---------------------- PostScript image format ---------------------- ###
### These devices make it possible to print Level 2 files on a Level 1    ###
###   printer, by converting them to a bitmap in PostScript format.       ###

ps_=gdevpsim.$(OBJ)

gdevpsim.$(OBJ): gdevpsim.c $(GDEV) $(gdevprn_h)

psmono.dev: $(ps_) page.dev
	$(SETPDEV) psmono $(ps_)

# Someday there will be RGB and CMYK variants....

### -------------------------- SGI RGB pixmaps -------------------------- ###

sgirgb_=gdevsgi.$(OBJ)

gdevsgi.$(OBJ): gdevsgi.c gdevsgi.h

sgirgb.dev: $(sgirgb_) page.dev
	$(SETPDEV) sgirgb $(sgirgb_)

### -------------------- Plain or TIFF fax encoding --------------------- ###
###    Use -sDEVICE=tiffg3 or tiffg4 and				  ###
###	  -r204x98 for low resolution output, or			  ###
###	  -r204x196 for high resolution output				  ###
###    These drivers recognize 3 page sizes: letter, A4, and B4.	  ###

gdevtifs_h=gdevtifs.h

tfax_=gdevtfax.$(OBJ)
tfax.dev: $(tfax_) cfe.dev lzwe.dev rle.dev tiffs.dev
	$(SETMOD) tfax $(tfax_)
	$(ADDMOD) tfax -include cfe lzwe rle tiffs

gdevtfax.$(OBJ): gdevtfax.c $(GDEV) $(gdevprn_h) \
  $(time__h) $(gscdefs_h) $(gdevtifs_h) \
  $(scfx_h) $(slzwx_h) $(srlx_h) $(strimpl_h)

### Plain G3/G4 fax with no header

faxg3.dev: tfax.dev
	$(SETDEV) faxg3 -include tfax

faxg32d.dev: tfax.dev
	$(SETDEV) faxg32d -include tfax

faxg4.dev: tfax.dev
	$(SETDEV) faxg4 -include tfax

### ---------------------------- TIFF formats --------------------------- ###

tiffs_=gdevtifs.$(OBJ)
tiffs.dev: $(tiffs_) page.dev
	$(SETMOD) tiffs $(tiffs_)
	$(ADDMOD) tiffs -include page

gdevtifs.$(OBJ): gdevtifs.c $(stdio__h) $(time__h) \
  $(gdevprn_h) $(gdevtifs_h) $(gscdefs_h) $(gstypes_h)

# Black & white, G3/G4 fax

tiffcrle.dev: tfax.dev
	$(SETDEV) tiffcrle -include tfax

tiffg3.dev: tfax.dev
	$(SETDEV) tiffg3 -include tfax

tiffg32d.dev: tfax.dev
	$(SETDEV) tiffg32d -include tfax

tiffg4.dev: tfax.dev
	$(SETDEV) tiffg4 -include tfax

# Black & white, LZW compression

tifflzw.dev: tfax.dev
	$(SETDEV) tifflzw -include tfax

# Black & white, PackBits compression

tiffpack.dev: tfax.dev
	$(SETDEV) tiffpack -include tfax

# RGB, no compression

tiff24nc_=gdevtfnx.$(OBJ)
tiff24nc.dev: $(tiff24nc_) tiffs.dev
	$(SETPDEV) tiff24nc $(tiff24nc_)
	$(ADDMOD) tiff24nc -include tiffs

gdevtfnx.$(OBJ): gdevtfnx.c $(GDEV) $(time__h) \
  $(gdevprn_h) $(gscdefs_h) gdevtifs.h
#    Copyright (C) 1994, 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# Partial makefile, common to all Desqview/X configurations.

# This is the last part of the makefile for Desqview/X configurations.
# Since Unix make doesn't have an 'include' facility, we concatenate
# the various parts of the makefile together by brute force (in tar_cat).

# The following prevents GNU make from constructing argument lists that
# include all environment variables, which can easily be longer than
# brain-damaged system V allows.

.NOEXPORT:

# -------------------------------- Library -------------------------------- #

## The Desqview/X platform

dvx__=gp_nofb.$(OBJ) gp_dvx.$(OBJ) gp_unifs.$(OBJ) gp_dosfs.$(OBJ)
dvx_.dev: $(dvx__)
	$(SETMOD) dvx_ $(dvx__)

gp_dvx.$(OBJ): gp_dvx.c $(AK) $(string__h) $(gx_h) $(gsexit_h) $(gp_h) \
  $(time__h) $(dos__h)
	$(CCC) -D__DVX__ gp_dvx.c

# -------------------------- Auxiliary programs --------------------------- #

$(ANSI2KNR_XE): ansi2knr.c $(stdio__h) $(string__h) $(malloc__h)
	$(CC) -o ansi2knr $(CFLAGS) ansi2knr.c

$(ECHOGS_XE): echogs.c
	$(CC) -o echogs $(CFLAGS) echogs.c
	strip echogs
	coff2exe echogs
	del echogs

$(GENARCH_XE): genarch.c
	$(CC) -o genarch genarch.c
	strip genarch
	coff2exe genarch
	del genarch

$(GENCONF_XE): genconf.c
	$(CC) -o genconf genconf.c
	strip genconf
	coff2exe genconf
	del genconf

$(GENINIT_XE): geninit.c $(stdio__h) $(string__h)
	$(CC) -o geninit geninit.c
	strip geninit
	coff2exe geninit
	del geninit

# We need to query the environment to construct gconfig_.h.
INCLUDE=/djgpp/include
gconfig_.h: dvx-tail.mak $(ECHOGS_XE)
	echogs -w gconfig_.h -x 2f2a -s This file was generated automatically. -s -x 2a2f
	echogs -a gconfig_.h -x 23 define SYSTIME_H
	echogs -a gconfig_.h -x 23 define DIRENT_H

# ----------------------------- Main program ------------------------------ #

BEGINFILES=
CCBEGIN=$(CCC) *.c

# Interpreter main program

$(GS_XE): ld.tr gs.$(OBJ) $(INT_ALL) $(LIB_ALL) $(DEVS_ALL)
	cp ld.tr _temp_
	echo $(EXTRALIBS) -lm >>_temp_
	$(CC) $(LDFLAGS) $(XLIBDIRS) -o $(GS) gs.$(OBJ) @_temp_
	strip $(GS)
	coff2exe $(GS)  
	del $(GS)  
#    Copyright (C) 1994, 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# Partial makefile common to all Unix and Desqview/X configurations.

# This is the very last part of the makefile for these configurations.
# Since Unix make doesn't have an 'include' facility, we concatenate
# the various parts of the makefile together by brute force (in tar_cat).

# The rule for gconfigv.h is here because it is shared between Unix and
# DV/X environments.
gconfigv.h: unix-end.mak $(MAKEFILE) $(ECHOGS_XE)
	$(EXP)echogs -w gconfigv.h -x 23 define USE_ASM -x 2028 -q $(USE_ASM)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define USE_FPU -x 2028 -q $(FPU_TYPE)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define EXTEND_NAMES 0$(EXTEND_NAMES)

# The following rules are equivalent to what tar_cat does.
GENERIC_MAK_LIST=$(GS_MAK) $(LIB_MAK) $(INT_MAK) $(JPEG_MAK) $(DEVS_MAK)
unix.mak: dvx-gcc.mak unixansi.mak unix-cc.mak unix-gcc.mak

DVX_GCC_MAK=dgc-head.mak dvx-head.mak $(GENERIC_MAK_LIST) dvx-tail.mak unix-end.mak
dvx-gcc.mak: $(DVX_GCC_MAK)
	$(CAT) $(DVX_GCC_MAK) >dvx-gcc.mak

UNIXANSI_MAK=ansihead.mak unixhead.mak $(GENERIC_MAK_LIST) unixtail.mak unix-end.mak
unixansi.mak: $(UNIXANSI_MAK)
	$(CAT) $(UNIXANSI_MAK) >unixansi.mak

UNIX_CC_MAK=cc-head.mak unixhead.mak $(GENERIC_MAK_LIST) unixtail.mak unix-end.mak
unix-cc.mak: $(UNIX_CC_MAK)
	$(CAT) $(UNIX_CC_MAK) >unix-cc.mak

UNIX_GCC_MAK=gcc-head.mak unixhead.mak $(GENERIC_MAK_LIST) unixtail.mak unix-end.mak
unix-gcc.mak: $(UNIX_GCC_MAK)
	$(CAT) $(UNIX_GCC_MAK) >unix-gcc.mak

# Build the VMS MODULES.LIS file on a Unix system.

modules_lis=modules$(CONFIG).lis
$(modules_lis): $(MAKEFILE) $(GENCONF_XE) $(devs_tr)
	$(EXP)genconf @$(devs_tr) -pue "%s" -o $(modules_lis)

# Installation

TAGS:
	etags -t *.c *.h

install: install-exec install-data

# The sh -c in the rules below is necessary because the Ultrix `make'
# uses sh -e, which terminates execution of a command if any error occurs,
# even if the command traps the error with ||.

install-exec: $(GS)
	-mkdir $(bindir)
	$(INSTALL_PROGRAM) $(GS) $(bindir)/$(GS)
	-mkdir $(scriptdir)
	sh -c 'for f in gsbj gsdj gsdj500 gslj gslp gsnd bdftops font2c \
pdf2ps printafm ps2ascii ps2epsi wftopfa ;\
	do if ( test -f $$f ); then $(INSTALL_PROGRAM) $$f $(scriptdir)/$$f; fi;\
	done'

install-data: gs.1
	-mkdir $(mandir)
	-mkdir $(man1dir)
	for f in gs ps2epsi ;\
	do $(INSTALL_DATA) $$f.1 $(man1dir)/$$f.$(man1ext) ;\
	done
	-mkdir $(datadir)
	-mkdir $(gsdir)
	-mkdir $(gsdatadir)
	sh -c 'for f in Fontmap gs_init.ps \
gs_btokn.ps gs_ccfnt.ps gs_cidfn.ps \
gs_dps1.ps gs_fonts.ps gs_kanji.ps gs_lev2.ps gs_pfile.ps gs_res.ps \
gs_setpd.ps gs_statd.ps gs_type0.ps gs_type1.ps \
gs_dbt_e.ps gs_iso_e.ps gs_ksb_e.ps gs_std_e.ps gs_sym_e.ps \
align.ps bdftops.ps caption.ls decrypt.ps docie.ps font2c.ps gslp.ps \
impath.ps landscap.ps level1.ps markhint.ps markpath.ps \
packfile.ps pcharstr.ps pfbtogs.ps ppath.ps prfont.ps printafm.ps \
ps2ai.ps ps2ascii.ps ps2epsi.ps ps2image.ps pstoppm.ps \
quit.ps showchar.ps showpage.ps stcinfo.ps stcolor.ps \
traceimg.ps traceop.ps type1enc.ps type1ops.ps unprot.ps \
viewgif.ps viewjpeg.ps viewpbm.ps wftopfa.ps wrfont.ps \
gs_pdf.ps pdf2dsc.ps pdf_base.ps pdf_draw.ps pdf_font.ps pdf_main.ps pdf_2ps.ps \
gs_mex_e.ps gs_mro_e.ps gs_pdf_e.ps gs_wan_e.ps ;\
	do if ( test -f $$f ); then $(INSTALL_DATA) $$f $(gsdatadir)/$$f; fi;\
	done'
	-mkdir $(docdir)
	sh -c 'for f in COPYING NEWS PUBLIC README current.doc devices.doc \
drivers.doc fonts.doc gs.1 hershey.doc history1.doc history2.doc humor.doc \
language.doc lib.doc make.doc ps2epsi.1 ps2epsi.doc psfiles.doc public.doc \
use.doc xfonts.doc ;\
	do if ( test -f $$f ); then $(INSTALL_DATA) $$f $(docdir)/$$f; fi;\
	done'
	-mkdir $(exdir)
	for f in alphabet.ps chess.ps cheq.ps colorcir.ps escher.ps golfer.ps \
grayalph.ps snowflak.ps tiger.ps waterfal.ps ;\
	do $(INSTALL_DATA) $$f $(exdir)/$$f ;\
	done
