#    Copyright (C) 1991, 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for Microsoft Visual C++ 2.0, Windows NT platform.
# Thanks to Phil Conrad and Thomas Hiller for earlier versions of this file.
# Modified by Tim Derby & Hank Jacobs for use with MS Visual C++.

# NOTE: Do NOT compile iscan.c or gdevpcfb.c with optimization.

# ------------------------------- Options ------------------------------- #

###### This section is the only part of the file you should need to edit.

# ------ Generic options ------ #

# Define the directory that will hold documentation at runtime.

GS_DOCDIR=c:/gs

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with \;.
# Use / to indicate directories, not a single \.

GS_LIB_DEFAULT=.;c:/gs\;c:/gs/fonts

# Define the name of the interpreter initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# Setting DEBUG=1 includes debugging features (-Z switch) in the code.
# Code runs substantially slower even if no debugging switches are set,
# and also takes about another 25K of memory.

DEBUG=0

# Setting TDEBUG=1 includes symbol table information for the debugger,
# and also enables stack checking.  Code is substantially slower and larger.

TDEBUG=0

# Setting NOPRIVATE=1 makes private (static) procedures and variables public,
# so they are visible to the debugger and profiler.
# No execution time or space penalty, just larger .OBJ and .EXE files.

NOPRIVATE=0

# Define the name of the executable file.
# Setting GSDLL makes a Dynamic Link Library.

GSDLL=0
!if $(GSDLL)
GS=gsdll32
!else
GS=gswin32
!endif

# Define the directory where the IJG JPEG library sources are stored,
# and the major version of the library that is stored there.
# You may have to change this if the IJG library version changes.
# See jpeg.mak for more information.

JSRCDIR=jpeg-6
JVERSION=6

D=\

# Define the configuration ID.  Read gs.mak carefully before changing this.

CONFIG=

# Define any other compilation flags.  Including -DA4 makes A4 paper size
# the default for most, but not, printer drivers.

CFLAGS=-D__WIN32__

# ------ Platform-specific options ------ #

# Define the drive, directory, and compiler name for the Microsoft C files.
# COMP is the full compiler path name (normally \msc\bin\cl).
# LINK is the full linker path name (normally \msc\bin\link).
# INCDIR contains the include files (normally \msc\include).
# LIBDIR contains the library files (normally \msc\lib).
# Note that INCDIR and LIBDIR are always followed by a \,
#   so if you want to use the current directory, use an explicit '.'.

COMP=c:\msvc20\bin\cl
LINK=c:\msvc20\bin\link
INCDIR=c:\msvc20\include
LIBDIR=c:\msvc20\lib

# Windows directory

WINDIR=c:\windows

# Define the processor (CPU) type.  Currently the only acceptable value
# is 286.  (386, 486, and 586 should be supported, but MSC apparently
# doesn't provide any way to generate 16-bit code if you tell it you have
# a 32-bit processor.)

CPU_TYPE=386

# Define the math coprocessor (FPU) type.
# Options are -1 (optimize for no FPU), 0 (optimize for FPU present,
# but do not require a FPU), 87, 287, or 387.
# If you have a 486 or Pentium CPU, you should normally set FPU_TYPE to 387,
# since most of these CPUs include the equivalent of an 80387 on-chip;
# however, the 486SX and the Cyrix 486SLC do not have an on-chip FPU, so if
# you have one of these CPUs and no external FPU, set FPU_TYPE to -1 or 0.
# An xx87 option means that the executable will run only if a FPU
# of that type (or higher) is available: this is NOT currently checked
# at runtime.

FPU_TYPE=0

# ---------------------------- End of options ---------------------------- #

# Define the platform name.

PLATFORM=msc32_

# Define the name of the makefile -- used in dependencies.

#MAKEFILE=msvcwin.mak
MAKEFILE=makefile

# Define the ANSI-to-K&R dependency.  Microsoft C accepts ANSI syntax,
# but we need to preconstruct ccf.tr to get around the limit on
# the maximum length of a command line.

AK=ccf32.tr

# Define the syntax for command, object, and executable files.

CMD=.bat
O=-o
OBJ=obj
XE=.exe
XEAUX=.exe

# Define the current directory prefix and shell invocations.

D=\\

EXPP=
SH=
SHP=

# Define the arguments for genconf.

CONFILES=-p %%s -o obj.tr -l lib.tr

# Define the generic compilation flags.

PLATOPT=

INTASM=
PCFBASM=

# Define the generic compilation rules.

.asm.obj:
	$(ASM) $(ASMFLAGS) $<;

# Make sure we get the right default target for make.

all: $(GS_XE)

# Define the compilation flags.

!if $(CPU_TYPE)>400
CPFLAGS=/G4
!else if $(CPU_TYPE)>300
CPFLAGS=/G3
!else if $(CPU_TYPE)>200
CPFLAGS=/G2
!else if $(CPU_TYPE)>100
CPFLAGS=/G1
!else
CPFLAGS=/G0
!endif

!if $(FPU_TYPE)>0
FPFLAGS=/FPi87
!else
FPFLAGS=
!endif

!if $(NOPRIVATE)!=0
CP=/DNOPRIVATE
!else
CP=
!endif

!if $(DEBUG)!=0
CD=/DDEBUG /Gt128
!else
CD=
!endif

!if $(TDEBUG)!=0
CT=/f /Zi /Od
LCT=/CO /FAR /PACKC
!else
CT=
#CT=/f- /Ot /Oi /Ol /Oe /Og /Gs
LCT=/SUBSYSTEM:WINDOWS /EXETYPE:DEV386 /DEBUG
!endif

!if $(DEBUG)!=0 || $(TDEBUG)!=0
CS=/Ge
!else
CS=/Gs
!endif

GENOPT=$(CP) $(CD) $(CT) $(CS) /W2 /batch /nologo

CCFLAGS=$(PLATOPT) $(FPFLAGS) $(CPFLAGS) $(CFLAGS) $(XCFLAGS)
CC=$(COMP) /c $(CCFLAGS) @ccf32.tr
CCC=$(CC)
CCD=$(CC)
CCINT=$(CC)
CCCF=$(CCC)
CCLEAF=$(CCC)

.c.obj:
	$(CCC) $<

# Define the files to be removed by `make clean'.
# nmake expands macros when encountered, not when used,
# so this must precede the !include statements.

BEGINFILES=gs*.res gs*.ico ccf32.tr

# -------------------------- Auxiliary programs --------------------------- #

ccf32.tr: $(MAKEFILE)
	echo $(GENOPT) /I$(INCDIR) -DCHECK_INTERRUPTS > ccf32.tr

# No special gconfig_.h is needed.
# Microsoft `make' supports output redirection.
gconfig_.h: $(MAKEFILE)
	echo /* This file deliberately left blank. */ >gconfig_.h

gconfigv.h: msc.mak $(MAKEFILE) $(ECHOGS_XE)
	$(EXP)echogs -w gconfigv.h -x 23 define USE_ASM -x 2028 -q $(USE_ASM)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define USE_FPU -x 2028 -q $(FPU_TYPE)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define EXTEND_NAMES 0$(EXTEND_NAMES)

# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See gs.mak for details.

FEATURE_DEVS=level1.dev filter.dev

# Choose whether to compile the .ps initialization files into the executable.
# See gs.mak for details.

COMPILE_INITS=0

!if $(GSDLL)
DEVICE_DEVS=mswindll.dev mswin.dev mswinprn.dev
!else
DEVICE_DEVS=mswin.dev mswinprn.dev
!endif
DEVICE_DEVS3=deskjet.dev djet500.dev laserjet.dev ljetplus.dev ljet2p.dev ljet3.dev ljet4.dev
DEVICE_DEVS4=cdeskjet.dev cdjcolor.dev cdjmono.dev cdj550.dev pj.dev pjxl.dev pjxl300.dev
DEVICE_DEVS6=epson.dev eps9high.dev ibmpro.dev bj10e.dev bj200.dev bjc600.dev bjc800.dev
DEVICE_DEVS8=pcxmono.dev pcxgray.dev pcx16.dev pcx256.dev pcx24b.dev
DEVICE_DEVS10=tiffcrle.dev tiffg3.dev tiffg32d.dev tiffg4.dev tifflzw.dev tiffpack.dev
DEVICE_DEVS11=tiff24nc.dev

# Include the generic makefiles.
!include gs.mak
!include lib.mak
!include jpeg.mak
!include devs.mak
!include int.mak

# -------------------------------- Library -------------------------------- #

# The Microsoft C platform

# Eventually we need a gp_imsc.$(OBJ)....
msc32__=gp_mswin.$(OBJ) gp_mswtx.$(OBJ) gp_win32.$(OBJ) gp_nofb.$(OBJ) gp_ntfs.$(OBJ)
msc32_.dev: $(msc32__)
        $(SETMOD) msc32_ $(msc32__)
        $(ADDMOD) msc32_ -iodev wstdio

gp_mswin.$(OBJ): gp_mswin.c $(AK) gp_mswin.h gp_mswtx.h \
 $(ctype__h) $(dos__h) $(malloc__h) $(memory__h) $(stdio__h) $(string__h) $(windows__h) \
 $(gx_h) $(gp_h) $(gpcheck_h) $(gserrors_h) $(gsexit_h) $(gxdevice_h) $(gxiodev_h) $(stream_h)

gp_mswtx.$(OBJ): gp_mswtx.c $(AK) gp_mswtx.h \
 $(ctype__h) $(dos__h) $(memory__h) $(string__h) $(windows__h)

# ----------------------------- Main program ------------------------------ #

CCBEGIN=$(CCC) *.c

LIBCTR=libc32.tr

$(LIBCTR): $(MAKEFILE) $(ECHOGS_XE)
        echogs -w $(LIBCTR) $(LIBDIR)\shell32.lib
        echogs -a $(LIBCTR) $(LIBDIR)\comdlg32.lib
        echogs -a $(LIBCTR) $(LIBDIR)\gdi32.lib
        echogs -a $(LIBCTR) $(LIBDIR)\user32.lib
        echogs -a $(LIBCTR) $(LIBDIR)\winspool.lib

ICONS=gsgraph.ico gstext.ico

GS_ALL=gs.$(OBJ) $(INT_ALL) $(INTASM)\
  $(LIB_ALL) $(LIBCTR) lib.tr obj.tr $(GS).res $(GS).def $(ICONS)

# Make the icons from their text form.

gsgraph.ico: gsgraph.icx echogs$(XE)
        echogs -wb gsgraph.ico -n -X -r gsgraph.icx

gstext.ico: gstext.icx echogs$(XE)
        echogs -wb gstext.ico -n -X -r gstext.icx

$(GS).res: $(GS).rc gp_mswin.h $(ICONS)
        rc -i$(INCDIR) -r $(GS)

!if $(GSDLL)
$(GS)$(XE): $(GS).dll

gsdll.$(OBJ): gsdll.c gsdll.h $(ghost_h)

$(GS).dll: $(GS_ALL) $(DEVS_ALL) gsdll.$(OBJ)
        $(LINK) $(LCT) gsdll @obj.tr $(INTASM) @lib.tr $(GS).def $(GS).res
!else
$(GS)$(XE): $(GS_ALL) $(DEVS_ALL)
        $(LINK) $(LCT) gs @obj.tr @$(LIBCTR) $(INTASM) @lib.tr /DEF:$(GS).def $(GS).res
!endif
