/* Copyright (C) 1992, 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* gsimage.h */
/* Client interface to image painting */
/* Requires gscspace.h, gsstate.h, and gsmatrix.h */

/*
 * Define the structure for specifying image data.
 * Note that ColorSpace and ImageMask are imports from PDF.
 */
typedef struct gs_image_common_s {
	int Width;
	int Height;
	gs_matrix ImageMatrix;
	bool MultipleDataSources;	/* ignored for imagemask */
	int BitsPerComponent;		/* must be 1 for imagemask */
	const gs_color_space *ColorSpace;	/* ignored for imagemask; */
					/* NULL = DeviceGray */
	float Decode[8];		/* must be {0,1} or {1,0} for mask */
	bool Interpolate;
	bool ImageMask;
		/* The following are not PostScript standard. */
	bool adjust;			/* only for imagemask */
	bool CombineWithColor;
} gs_image_t;

#define image_default(mask, zero)\
	0, 0, { identity_matrix_body },\
	false, 1, NULL,\
	{ zero, 1-(zero), zero, 1-(zero), zero, 1-(zero), zero, 1-(zero) },\
	false, mask, mask, false
/* Define prototypes for initializing the structures. */
extern const gs_image_t far_data gs_image_default;
extern const gs_image_t far_data gs_image_mask_default;
extern const gs_image_t far_data gs_image_mask_inverted_default;

/* The image painting interface uses an enumeration style: */
/* the client initializes an enumerator, then supplies data incrementally. */
typedef struct gs_image_enum_s gs_image_enum;
gs_image_enum *
	gs_image_enum_alloc(P2(gs_memory_t *, client_name_t));
/* image_init returns 1 for an empty image, 0 normally, <0 on error. */
/* Note that image_init serves for both image and imagemask, */
/* depending on the value of ImageMask in the image structure. */
int	gs_image_init(P3(gs_image_enum *penum, const gs_image_t *,
			 gs_state *pgs));
int	gs_image_next(P4(gs_image_enum *penum, const byte *dbytes,
			 uint dsize, uint *pused));
/* Clean up after processing an image. */
void	gs_image_cleanup(P1(gs_image_enum *penum));
