/* Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* siscale.h */
/* Image scaling filter state definition */
/* Requires strimpl.h */

/* Input values */
/*typedef byte PixelIn;*/		/* see sizeofPixelIn below */
/*#define MaxValueIn 255*/		/* see MaxValueIn below */

/* Temporary intermediate values */
typedef byte PixelTmp;
#define minPixelTmp 0
#define maxPixelTmp 255
#define unitPixelTmp 255

/* Output values */
/*typedef byte PixelOut;*/		/* see sizeofPixelOut below */
/*#define MaxValueOut 255*/		/* see MaxValueOut below */

/* Auxiliary structures. */

typedef struct {
	int	pixel;		/* offset of pixel in source data */
	float	weight;
} CONTRIB;

typedef struct {
	int	n;		/* number of contributors */
	int	max_index;	/* max value of pixel in contributors list, */
				/* not multiplied by stride */
	CONTRIB	*p;		/* pointer to list of contributors */
} CLIST;

/* ImageScaleEncode / ImageScaleDecode */
typedef struct stream_IScale_state_s {
	stream_state_common;
		/* The client sets the following before initialization. */
	int Colors;			/* any number >= 1 */
	int BitsPerComponentIn;		/* bits per input value, 8 or 16 */
	uint MaxValueIn;		/* max value of input component */
	int WidthIn, HeightIn;
	int BitsPerComponentOut;	/* bits per output value, 8 or 16 */
	uint MaxValueOut;		/* max value of output component */
	int WidthOut, HeightOut;
		/* The init procedure sets the following. */
	int sizeofPixelIn;	/* bytes per input value, 1 or 2 */
	int sizeofPixelOut;	/* bytes per output value, 1 or 2 */
	double xscale, yscale;
	void /*PixelIn*/ *src;
	void /*PixelOut*/ *dst;
	PixelTmp *tmp;
	CLIST *contrib;
	CONTRIB *items;
		/* The following are updated dynamically. */
	int src_y;
	uint src_offset, src_size;
	int dst_y;
	uint dst_offset, dst_size;
} stream_IScale_state;
extern_st(st_IScale_state);	/* so clients can allocate */
#define public_st_IScale_state()	/* in siscale.c */\
  gs_public_st_ptrs5(st_IScale_state, stream_IScale_state,\
    "ImageScaleEncode/Decode state",\
    iscale_state_enum_ptrs, iscale_state_reloc_ptrs,\
    dst, src, tmp, contrib, items)
extern const stream_template s_IScale_template;
