#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for PNG (Portable Network Graphics) and ZLIB code.

# This partial makefile compiles the PNG and ZLIB libraries for use in
# the PNG drivers.  You can get the source code for these libraries from:
#  ftp://ftp.uu.net/graphics/png/lbpng071.zip   (libpng 0.71)
#		or libpng-0.71.tar.gz
#  ftp://ftp.uu.net/graphics/png/zlib093.zip    (zlib 0.93)
#		or zlib-0.93.tar.gz
# Unpack them into subdirectories gsxxx/png and gsxxx/zlib, where gsxxx
# is the main source library.

# PSRCDIR and ZSRCDIR should really be defined in the platform
# makefile to deal with the VMS directory structure.
PSRCDIR=png
ZSRCDIR=zlib

PSRC=$(PSRCDIR)$(D)
ZSRC=$(ZSRCDIR)$(D)
RMP=rm -f

# We keep all of the PNG and ZLIB code in a separate directory so as not to
# inadvertently mix it up with Aladdin Enterprises' own code.

PHCOPY=png.h zlib.h zutil.h zconf.h deflate.h

PDEP=$(AK) $(PHCOPY)

png_1=png.$(OBJ) pngstub.$(OBJ) pngtrans.$(OBJ)
png_2=pngwrite.$(OBJ) pngwtran.$(OBJ) pngwutil.$(OBJ)
zlib_1=adler32.$(OBJ) deflate.$(OBJ) trees.$(OBJ) zutil.$(OBJ)

# copy the header files to the current directory
png.h: $(PSRC)png.h
	cp $(PSRC)png.h png.h

zlib.h: $(ZSRC)zlib.h
	cp $(ZSRC)zlib.h zlib.h

zutil.h: $(ZSRC)zutil.h
	cp $(ZSRC)zutil.h zutil.h

zconf.h: $(ZSRC)zconf.h
	cp $(ZSRC)zconf.h zconf.h

deflate.h: $(ZSRC)deflate.h
	cp $(ZSRC)deflate.h deflate.h

# LIBPNG modules
png.$(OBJ): $(PSRC)png.c $(PDEP)
	cp $(PSRC)png.c .
	$(CCC) png.c
	$(RMP) png.c

pngstub.$(OBJ): $(PSRC)pngstub.c $(PDEP)
	cp $(PSRC)pngstub.c .
	$(CCC) pngstub.c
	$(RMP) pngstub.c

pngtrans.$(OBJ): $(PSRC)pngtrans.c $(PDEP)
	cp $(PSRC)pngtrans.c .
	$(CCC) pngtrans.c
	$(RMP) pngtrans.c

pngwrite.$(OBJ): $(PSRC)pngwrite.c $(PDEP)
	cp $(PSRC)pngwrite.c .
	$(CCC) pngwrite.c
	$(RMP) pngwrite.c

pngwtran.$(OBJ): $(PSRC)pngwtran.c $(PDEP)
	cp $(PSRC)pngwtran.c .
	$(CCC) pngwtran.c
	$(RMP) pngwtran.c

pngwutil.$(OBJ): $(PSRC)pngwutil.c $(PDEP)
	cp $(PSRC)pngwutil.c .
	$(CCC) pngwutil.c
	$(RMP) pngwutil.c

# ZLIB modules
adler32.$(OBJ): $(ZSRC)adler32.c $(PDEP)
	cp $(ZSRC)adler32.c .
	$(CCC) adler32.c
	$(RMP) adler32.c

deflate.$(OBJ): $(ZSRC)deflate.c $(PDEP)
	cp $(ZSRC)deflate.c .
	$(CCC) deflate.c
	$(RMP) deflate.c

trees.$(OBJ): $(ZSRC)trees.c $(PDEP)
	cp $(ZSRC)trees.c .
	$(CCC) trees.c
	$(RMP) trees.c

zutil.$(OBJ): $(ZSRC)zutil.c $(PDEP)
	cp $(ZSRC)zutil.c .
	$(CCC) zutil.c
	$(RMP) zutil.c

pngclean:
	rm png.h
	rm zlib.h
	rm zutil.h
	rm zconf.h
	rm deflate.h
	rm png.c
	rm pngstub.c
	rm pngtrans.c
	rm pngwrite.c
	rm pngwtran.c
	rm pngwutil.c
	rm adler32.c
	rm deflate.c
	rm trees.c
	rm zutil.c

pnglib.dev: png.mak $(png_1) $(png_2) $(zlib_1)
	$(SETMOD) pnglib  $(png_1)
	$(ADDMOD) pnglib  -obj $(png_2)
	$(ADDMOD) pnglib  -obj $(zlib_1)
