#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# (Platform-independent) makefile for graphics library and other support code.
# See the end of gs.mak for where this fits into the build process.

# Define the name of this makefile.
LIB_MAK=lib.mak

# Define the inter-dependencies of the .h files.
# Since not all versions of `make' defer expansion of macros,
# we must list these in bottom-to-top order.

# Generic files

arch_h=arch.h
stdpre_h=stdpre.h
std_h=std.h $(arch_h) $(stdpre_h)

# Platform interfaces

gp_h=gp.h
gpcheck_h=gpcheck.h

# Configuration definitions

# gconfig*.h are generated dynamically.
gconfig__h=gconfig_.h
gconfigv_h=gconfigv.h
gscdefs_h=gscdefs.h

# C library interfaces

# Because of variations in the "standard" header files between systems, and
# because we must include std.h before any file that includes sys/types.h,
# we define local include files named *_.h to substitute for <*.h>.

vmsmath_h=vmsmath.h

dos__h=dos_.h
ctype__h=ctype_.h $(std_h)
dirent__h=dirent_.h $(std_h) $(gconfig__h)
errno__h=errno_.h
malloc__h=malloc_.h $(std_h)
math__h=math_.h $(std_h) $(vmsmath_h)
memory__h=memory_.h $(std_h)
stat__h=stat_.h $(std_h)
stdio__h=stdio_.h $(std_h)
string__h=string_.h $(std_h)
time__h=time_.h $(std_h) $(gconfig__h)
windows__h=windows_.h

# Miscellaneous

gdebug_h=gdebug.h
gsalloc_h=gsalloc.h
gserror_h=gserror.h
gserrors_h=gserrors.h
gsexit_h=gsexit.h
gsio_h=gsio.h
gsmemory_h=gsmemory.h
gsrefct_h=gsrefct.h
gsstruct_h=gsstruct.h
gstypes_h=gstypes.h
gx_h=gx.h $(stdio__h) $(gdebug_h) $(gserror_h) $(gsio_h) $(gsmemory_h) $(gstypes_h)

GX=$(AK) $(gx_h)
GXERR=$(GX) $(gserrors_h)

###### Support

### Include files

gsbitops_h=gsbitops.h
gsbittab_h=gsbittab.h
gsuid_h=gsuid.h
gsutil_h=gsutil.h
gxarith_h=gxarith.h
gxbitmap_h=gxbitmap.h
gxfarith_h=gxfarith.h $(gconfigv_h) $(gxarith_h)
gxfixed_h=gxfixed.h
gxobj_h=gxobj.h $(gxbitmap_h)
# Out of order
gxalloc_h=gxalloc.h $(gsalloc_h) $(gxobj_h)

### Executable code

gsalloc.$(OBJ): gsalloc.c $(GX) $(memory__h) \
  $(gsstruct_h) $(gxalloc_h)

gsbitops.$(OBJ): gsbitops.c $(AK) $(std_h) $(memory__h) $(gsbitops_h)

gsbittab.$(OBJ): gsbittab.c $(AK) $(stdpre_h) $(gsbittab_h)

gsmemory.$(OBJ): gsmemory.c $(GX) \
  $(gsrefct_h) $(gsstruct_h)

gsmisc.$(OBJ): gsmisc.c $(GXERR) $(gconfigv_h) \
  $(math__h) $(memory__h) $(gxfarith_h) $(gxfixed_h)

gsutil.$(OBJ): gsutil.c $(AK) $(gconfigv_h) \
  $(std_h) $(gsuid_h) $(gsutil_h)

###### Low-level facilities and utilities

### Include files

gdevmrop_h=gdevmrop.h

gsccode_h=gsccode.h
gsccolor_h=gsccolor.h $(gsstruct_h)
gscie_h=gscie.h $(gsrefct_h)
gscolor1_h=gscolor.h
gscoord_h=gscoord.h
gscpm_h=gscpm.h
gsdevice_h=gsdevice.h
gsfont_h=gsfont.h
gshsb_h=gshsb.h
gsht_h=gsht.h
gsht1_h=gsht1.h $(gsht_h)
gsimage_h=gsimage.h
gsjconf_h=gsjconf.h $(std_h)
gslib_h=gslib.h $(stdio__h)
gsline_h=gsline.h
gsmatrix_h=gsmatrix.h
gspaint_h=gspaint.h
gsparam_h=gsparam.h
gspath_h=gspath.h
gspath2_h=gspath2.h
gsropt_h=gsropt.h
gsxfont_h=gsxfont.h
# Out of order
gschar_h=gschar.h $(gsccode_h) $(gscpm_h)
gscolor2_h=gscolor2.h $(gsccolor_h) $(gsuid_h) $(gxbitmap_h)

gxchar_h=gxchar.h $(gschar_h)
gxcindex_h=gxcindex.h
gxclio_h=gxclio.h
gxclist_h=gxclist.h $(gxclio_h)
gxclip2_h=gxclip2.h
gxcolor2_h=gxcolor2.h $(gscolor2_h) $(gsrefct_h) $(gxbitmap_h)
gxcoord_h=gxcoord.h $(gscoord_h)
gxcpath_h=gxcpath.h
gxctable_h=gxctable.h
gxdcolor_h=gxdcolor.h $(gsrefct_h) $(gsropt_h) $(gsstruct_h) $(gxbitmap_h) $(gxcindex_h)
gxdda_h=gxdda.h
gxdevice_h=gxdevice.h $(gsmatrix_h) $(gsropt_h) $(gsstruct_h) $(gsxfont_h) $(gxbitmap_h) $(gxcindex_h)
gxdevmem_h=gxdevmem.h
gxdht_h=gxdht.h
gxdither_h=gxdither.h
gxdraw_h=gxdraw.h
gxfcache_h=gxfcache.h $(gsuid_h) $(gsxfont_h)
gxfont_h=gxfont.h $(gsfont_h) $(gsuid_h) $(gsstruct_h)
gxfont0_h=gxfont0.h
gxfrac_h=gxfrac.h
gxiodev_h=gxiodev.h $(stat__h)
gxlum_h=gxlum.h
gxmatrix_h=gxmatrix.h $(gsmatrix_h)
gxpaint_h=gxpaint.h
gxpath_h=gxpath.h $(gscpm_h) $(gspath_h)
gxpcolor_h=gxpcolor.h
gxtmap_h=gxtmap.h
gxxfont_h=gxxfont.h $(gsccode_h) $(gsmatrix_h) $(gsuid_h) $(gsxfont_h)
# The following are out of order because they include other files.
gscspace_h=gscspace.h $(gsccolor_h) $(gsstruct_h) $(gxfrac_h)
gxdcconv_h=gxdcconv.h $(gxfrac_h) $(gsccolor_h)
gxfmap_h=gxfmap.h $(gsrefct_h) $(gxfrac_h) $(gxtmap_h)
gxcmap_h=gxcmap.h $(gxfmap_h)
gxht_h=gxht.h $(gsht1_h) $(gxtmap_h)
gscolor_h=gscolor.h $(gxtmap_h)
gsstate_h=gsstate.h $(gscolor_h) $(gsdevice_h) $(gsht_h) $(gsline_h)

gzcpath_h=gzcpath.h $(gxcpath_h)
gzht_h=gzht.h $(gxdht_h) $(gxfmap_h) $(gxht_h)
gzline_h=gzline.h $(gsline_h)
gzpath_h=gzpath.h $(gsstruct_h) $(gxpath_h)
gzstate_h=gzstate.h $(gsropt_h) $(gsstate_h) $(gxdcolor_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevice_h) $(gxtmap_h)

gdevprn_h=gdevprn.h $(memory__h) $(string__h) $(gx_h) \
  $(gserrors_h) $(gsmatrix_h) $(gsutil_h) \
  $(gxdevice_h) $(gxdevmem_h) $(gxclist_h)

scommon_h=scommon.h $(gsmemory_h) $(gstypes_h) $(gsstruct_h)
shc_h=shc.h $(gsbittab_h)
siscale_h=siscale.h
slzwx_h=slzwx.h
srlx_h=srlx.h
strimpl_h=strimpl.h $(scommon_h) $(gstypes_h) $(gsstruct_h)
# Out of order
gximage_h=gximage.h $(gscspace_h) $(gsimage_h) $(gxdda_h) \
  $(siscale_h) $(strimpl_h)
gxcldev_h=gxcldev.h $(gxclist_h) $(gsropt_h) $(gxfixed_h) $(gzline_h) $(gzpath_h) \
  $(strimpl_h) $(srlx_h)
scf_h=scf.h $(shc_h)
scfx_h=scfx.h $(shc_h)

### Executable code

# gconfig is handled specially.  Currently it goes in psbase rather than
# libcore, which is clearly wrong.
gconfig=gconfig$(CONFIG)
$(gconfig).$(OBJ): gconf.c $(GX) \
  $(gscdefs_h) $(gconfig_h) $(gxdevice_h) $(gxiodev_h) $(MAKEFILE)
	rm -f gconfig.h $(gconfig).c
	cp $(gconfig_h) gconfig.h
	cp gconf.c $(gconfig).c
	$(CCC) $(gconfig).c
	rm -f $(gconfig).c

gxacpath.$(OBJ): gxacpath.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxcpath_h) $(gxdcolor_h) $(gxfixed_h) \
  $(gxpaint_h) $(gzcpath_h) $(gzpath_h)

gxccache.$(OBJ): gxccache.c $(GXERR) $(gpcheck_h) \
  $(gscspace_h) $(gsimage_h) $(gsstruct_h) \
  $(gxchar_h) $(gxdevmem_h) $(gxfcache_h) \
  $(gxfixed_h) $(gxfont_h) $(gxmatrix_h) $(gxxfont_h) \
  $(gzstate_h) $(gzpath_h) $(gzcpath_h) 

gxccman.$(OBJ): gxccman.c $(GXERR) $(gpcheck_h) \
  $(gsbitops_h) $(gsstruct_h) $(gsutil_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gxdevmem_h) $(gxfont_h) $(gxfcache_h) $(gxchar_h) \
  $(gxxfont_h) $(gzstate_h) $(gzpath_h)

gxcht.$(OBJ): gxcht.c $(GXERR) \
  $(gsutil_h) \
  $(gxcmap_h) $(gxdcolor_h) $(gxdevice_h) $(gxfixed_h) $(gxmatrix_h) $(gzht_h) $(gzstate_h)

gxcmap.$(OBJ): gxcmap.c $(GXERR) \
  $(gsccolor_h) $(gscspace_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) $(gxdither_h) \
  $(gxfarith_h) $(gxfrac_h) $(gxlum_h) $(gzstate_h)

gxcpath.$(OBJ): gxcpath.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxfixed_h) $(gzpath_h) $(gzcpath_h)

gxdcconv.$(OBJ): gxdcconv.c $(GX) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdcolor_h) $(gxdevice_h) \
  $(gxfarith_h) $(gxlum_h) $(gzstate_h)

gxdither.$(OBJ): gxdither.c $(GX) \
  $(gsstruct_h) $(gxcmap_h) $(gxdcolor_h) $(gxdevice_h) $(gxdither_h) $(gxlum_h) $(gzht_h)

gxdraw.$(OBJ): gxdraw.c $(GXERR) $(math__h) $(gpcheck_h) \
  $(gxbitmap_h) $(gxdraw_h) $(gxfixed_h) $(gxmatrix_h) $(gzht_h) $(gzstate_h)

gxfill.$(OBJ): gxfill.c $(GXERR) \
  $(gsstruct_h) \
  $(gxdevice_h) $(gxdraw_h) $(gxfixed_h) $(gxmatrix_h) $(gxpaint_h) \
  $(gzcpath_h) $(gzpath_h) $(gzstate_h)

gxht.$(OBJ): gxht.c $(GXERR) \
  $(gsbitops_h) $(gsstruct_h) $(gsutil_h) \
  $(gxfixed_h) $(gxdevice_h) $(gzstate_h) $(gzht_h)

gxpath.$(OBJ): gxpath.c $(GXERR) \
  $(gsstruct_h) $(gxfixed_h) $(gzpath_h)

gxpath2.$(OBJ): gxpath2.c $(GXERR) $(math__h) \
  $(gxfixed_h) $(gxarith_h) $(gzpath_h)

gxpcopy.$(OBJ): gxpcopy.c $(GXERR) $(math__h) \
  $(gsmatrix_h) $(gscoord_h) $(gxfixed_h) $(gxarith_h) $(gzline_h) $(gzpath_h)

gxstroke.$(OBJ): gxstroke.c $(GXERR) $(math__h) $(gpcheck_h) \
  $(gscoord_h) \
  $(gxdraw_h) $(gxfixed_h) $(gxarith_h) $(gxmatrix_h) $(gxpaint_h) \
  $(gzline_h) $(gzpath_h) $(gzstate_h)

###### High-level facilities

gschar.$(OBJ): gschar.c $(GXERR) \
  $(gsstruct_h) \
  $(gxfixed_h) $(gxarith_h) $(gxmatrix_h) $(gxcoord_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h) $(gxfcache_h) $(gzpath_h) $(gzstate_h)

gscolor.$(OBJ): gscolor.c $(GXERR) \
  $(gsccolor_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) $(gzstate_h)

gscoord.$(OBJ): gscoord.c $(GXERR) $(math__h) \
  $(gsccode_h) $(gxcoord_h) $(gxfarith_h) $(gxfixed_h) $(gxfont_h) \
  $(gxmatrix_h) $(gxpath_h) $(gzstate_h)

gsdevice.$(OBJ): gsdevice.c $(GXERR) $(memory__h) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gsparam_h) $(gspath_h) $(gsstruct_h) \
  $(gxarith_h) $(gxbitmap_h) $(gxcmap_h) $(gxdevmem_h) $(gzstate_h)

gsdevmem.$(OBJ): gsdevmem.c $(GXERR) $(math__h) $(memory__h) \
  $(gxarith_h) $(gxdevice_h) $(gxdevmem_h)

gsdparam.$(OBJ): gsdparam.c $(GXERR) $(memory__h) $(string__h) \
  $(gsparam_h) $(gxdevice_h) $(gxfixed_h)

gsfont.$(OBJ): gsfont.c $(GXERR) \
  $(gsstruct_h) \
  $(gxdevice_h) $(gxfixed_h) $(gxmatrix_h) $(gxfont_h) $(gxfcache_h) \
  $(gzstate_h)

gsht.$(OBJ): gsht.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

gshtscr.$(OBJ): gshtscr.c $(GXERR) $(math__h) \
  $(gsstruct_h) $(gxarith_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

gsimage.$(OBJ): gsimage.c $(GXERR) $(math__h) $(gpcheck_h) \
  $(gsccolor_h) $(gspaint_h) $(gsstruct_h) \
  $(gxfixed_h) $(gxfrac_h) $(gxarith_h) $(gxmatrix_h) \
  $(gxdevice_h) $(gzpath_h) $(gzstate_h) \
  $(gzcpath_h) $(gxdevmem_h) $(gximage_h) $(gdevmrop_h)

gsimage0.$(OBJ): gsimage0.c $(GXERR) \
  $(gxcpath_h) $(gxdevice_h) $(gxfixed_h) $(gximage_h) \
  $(gzpath_h) $(gzstate_h)

gsimage1.$(OBJ): gsimage1.c $(GXERR) $(gpcheck_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) $(gsutil_h) \
  $(gxarith_h) $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) \
  $(gxdraw_h) $(gxfixed_h) $(gximage_h) $(gxmatrix_h) \
  $(gzht_h) $(gzpath_h) $(gzstate_h)

gsimage2.$(OBJ): gsimage2.c $(GXERR) $(gpcheck_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) \
  $(gxarith_h) $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) \
  $(gxdraw_h) $(gxfixed_h) $(gximage_h) $(gxmatrix_h) \
  $(gzht_h) $(gzpath_h) $(gzstate_h)

gsimage3.$(OBJ): gsimage3.c $(GXERR) $(gpcheck_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) \
  $(gxarith_h) $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) \
  $(gxdraw_h) $(gxfixed_h) $(gximage_h) $(gxmatrix_h) \
  $(gzht_h) $(gzpath_h) $(gzstate_h)

gsimpath.$(OBJ): gsimpath.c $(GXERR) \
  $(gsmatrix_h) $(gsstate_h) $(gspath_h)

gsinit.$(OBJ): gsinit.c $(memory__h) $(stdio__h) \
  $(gdebug_h) $(gp_h) $(gslib_h) $(gsmemory_h)

gsiodev.$(OBJ): gsiodev.c $(GXERR) $(errno__h) $(string__h) \
  $(gp_h) $(gsparam_h) $(gxiodev_h)

gsline.$(OBJ): gsline.c $(GXERR) $(math__h) \
  $(gxfixed_h) $(gxmatrix_h) $(gzstate_h) $(gzline_h)

gsmatrix.$(OBJ): gsmatrix.c $(GXERR) $(math__h) \
  $(gxfarith_h) $(gxfixed_h) $(gxmatrix_h)

gspaint.$(OBJ): gspaint.c $(GXERR) $(gpcheck_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gspaint_h) $(gxpaint_h) \
  $(gzpath_h) $(gzstate_h) $(gxcpath_h) $(gxdevmem_h) $(gximage_h)

gsparam.$(OBJ): gspaint.c $(GXERR) $(memory__h) $(string__h) \
  $(gsparam_h) $(gsstruct_h)

gspath.$(OBJ): gspath.c $(GXERR) \
  $(gscoord_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzcpath_h) $(gzpath_h) $(gzstate_h)

gsstate.$(OBJ): gsstate.c $(GXERR) \
  $(gscie_h) $(gscolor2_h) $(gscoord_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) \
  $(gzstate_h) $(gzht_h) $(gzline_h) $(gzpath_h) $(gzcpath_h)

###### The internal devices

gdevmem_h=gdevmem.h $(gsbitops_h)

gdevabuf.$(OBJ): gdevabuf.c $(GXERR) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevmem.$(OBJ): gdevmem.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm1.$(OBJ): gdevm1.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm2.$(OBJ): gdevm2.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm4.$(OBJ): gdevm4.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm8.$(OBJ): gdevm8.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm16.$(OBJ): gdevm16.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm24.$(OBJ): gdevm24.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevm32.$(OBJ): gdevm32.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevmpla.$(OBJ): gdevmpla.c $(GX) \
  $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

# Create a pseudo-"feature" for the entire graphics core library.

LIB1=gsalloc.$(OBJ) gsbitops.$(OBJ) gsbittab.$(OBJ)
LIB2=gschar.$(OBJ) gscolor.$(OBJ) gscoord.$(OBJ) gsdevice.$(OBJ) gsdevmem.$(OBJ)
LIB3=gsdparam.$(OBJ) gsfont.$(OBJ) gsht.$(OBJ) gshtscr.$(OBJ)
LIB4=gsimage.$(OBJ) gsimage0.$(OBJ) gsimage1.$(OBJ) gsimage2.$(OBJ) gsimage3.$(OBJ)
LIB5=gsimpath.$(OBJ) gsinit.$(OBJ) gsiodev.$(OBJ)
LIB6=gsline.$(OBJ) gsmatrix.$(OBJ) gsmemory.$(OBJ) gsmisc.$(OBJ)
LIB7=gspaint.$(OBJ) gsparam.$(OBJ) gspath.$(OBJ) gsstate.$(OBJ) gsutil.$(OBJ)
LIB8=gxacpath.$(OBJ) gxccache.$(OBJ) gxccman.$(OBJ)
LIB9=gxcht.$(OBJ) gxcmap.$(OBJ) gxcpath.$(OBJ)
LIB10=gxdcconv.$(OBJ) gxdither.$(OBJ) gxdraw.$(OBJ) gxfill.$(OBJ)
LIB11=gxht.$(OBJ) gxpath.$(OBJ) gxpath2.$(OBJ) gxpcopy.$(OBJ) gxstroke.$(OBJ)
LIB12=gdevabuf.$(OBJ) gdevmem.$(OBJ) gdevm1.$(OBJ) gdevm2.$(OBJ) gdevm4.$(OBJ)
LIB13=gdevm8.$(OBJ) gdevm16.$(OBJ) gdevm24.$(OBJ) gdevm32.$(OBJ)
LIB14=gdevmpla.$(OBJ)
LIB_ALL=$(LIB1) $(LIB2) $(LIB3) $(LIB4) $(LIB5) $(LIB6) $(LIB7) $(LIB8) \
  $(LIB9) $(LIB10) $(LIB11) $(LIB12) $(LIB13) $(LIB14)
libcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(LIB_ALL) iscale.dev ropcore.dev
	$(EXP)echogs -w libcore.dev $(LIB1)
	$(EXP)echogs -a libcore.dev $(LIB2)
	$(EXP)echogs -a libcore.dev $(LIB3)
	$(EXP)echogs -a libcore.dev $(LIB4)
	$(EXP)echogs -a libcore.dev $(LIB5)
	$(EXP)echogs -a libcore.dev $(LIB6)
	$(EXP)echogs -a libcore.dev $(LIB7)
	$(EXP)echogs -a libcore.dev $(LIB8)
	$(EXP)echogs -a libcore.dev $(LIB9)
	$(EXP)echogs -a libcore.dev $(LIB10)
	$(EXP)echogs -a libcore.dev $(LIB11)
	$(EXP)echogs -a libcore.dev $(LIB12)
	$(EXP)echogs -a libcore.dev $(LIB13)
	$(EXP)echogs -a libcore.dev $(LIB14)
	$(ADDMOD) libcore -dev nullpage
	$(ADDMOD) libcore -include iscale ropcore

# ---------------- CCITTFax filters ---------------- #
# These are used by some drivers, as well as by Level 2 in general.
# Someday we may use them for compressing characters in the cache.

cfe_=scfe.$(OBJ) scfetab.$(OBJ) shc.$(OBJ)
cfe.dev: $(LIB_MAK) $(ECHOGS_XE) $(cfe_)
	$(SETMOD) cfe $(cfe_)

scfe.$(OBJ): scfe.c $(AK) $(stdio__h) $(gdebug_h)\
  $(scf_h) $(strimpl_h) $(scfx_h)

scfetab.$(OBJ): scfetab.c $(AK) $(std_h) $(scommon_h) $(scf_h)

shc.$(OBJ): shc.c $(AK) $(std_h) $(shc_h)

cfd_=scfd.$(OBJ) scfdtab.$(OBJ)
cfd.dev: $(LIB_MAK) $(ECHOGS_XE) $(cfd_)
	$(SETMOD) cfd $(cfd_)

scfd.$(OBJ): scfd.c $(AK) $(stdio__h) $(gdebug_h)\
  $(scf_h) $(strimpl_h) $(scfx_h)

scfdtab.$(OBJ): scfdtab.c $(AK) $(std_h) $(scommon_h) $(scf_h)

# ---------------- RunLength filters ---------------- #
# These are used by clists and also by Level 2 in general.

rle_=srle.$(OBJ)
rle.dev: $(LIB_MAK) $(ECHOGS_XE) $(rle_)
	$(SETMOD) rle $(rle_)

srle.$(OBJ): srld.c $(AK) $(stdio__h) $(memory__h) \
  $(srlx_h) $(strimpl_h)

rld_=srld.$(OBJ)
rld.dev: $(LIB_MAK) $(ECHOGS_XE) $(rld_)
	$(SETMOD) rld $(rld_)

srld.$(OBJ): srld.c $(AK) $(stdio__h) $(memory__h) \
  $(srlx_h) $(strimpl_h)

# ---------------- LZW filters ---------------- #
# These are used by clists and also by Level 2 in general.

#lzwe_=slzwce.$(OBJ)
lzwe_=slzwe.$(OBJ) slzwc.$(OBJ)
lzwe.dev: $(LIB_MAK) $(ECHOGS_XE) $(lzwe_)
	$(SETMOD) lzwe $(lzwe_)

slzwce.$(OBJ): slzwce.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

slzwe.$(OBJ): slzwe.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

slzwc.$(OBJ): slzwc.c $(AK) $(std_h)\
  $(slzwx_h) $(strimpl_h)

lzwd_=slzwd.$(OBJ) slzwc.$(OBJ)
lzwd.dev: $(LIB_MAK) $(ECHOGS_XE) $(lzwd_)
	$(SETMOD) lzwd $(lzwd_)

slzwd.$(OBJ): slzwd.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

# ---------------- Command lists ---------------- #

# Choose between clfile and clmem.  Someday this might be dynamic....
cl_impl=clfile
clist_=gxclist.$(OBJ) gxclread.$(OBJ)
clist.dev: $(LIB_MAK) $(ECHOGS_XE) $(clist_) $(cl_impl).dev rle.dev rld.dev
	$(SETMOD) clist $(clist_)
	$(ADDMOD) clist -include $(cl_impl) rle rld

gxclist.$(OBJ): gxclist.c $(GXERR) $(gpcheck_h) \
  $(gsbitops_h) $(gsmatrix_h) $(gsutil_h) \
  $(gxbitmap_h) $(gxcldev_h) $(gxdevice_h) $(gxdevmem_h)

gxclread.$(OBJ): gxclread.c $(GXERR) $(gpcheck_h) \
  $(gsbitops_h) $(gsdevice_h) $(gsmatrix_h) \
  $(gxbitmap_h) $(gxcldev_h) $(gxdevice_h) $(gxdevmem_h)

# Implement band lists on files.

clfile_=gxclfile.$(OBJ)
clfile.dev: $(LIB_MAK) $(ECHOGS_XE) $(clfile_)
	$(SETMOD) clfile $(clfile_)

gxclfile.$(OBJ): gxclfile.c $(stdio__h) $(string__h) \
  $(gp_h) $(gsmemory_h) $(gserror_h) $(gserrors_h) $(gxclio_h)

# Implement band lists in memory (RAM).

clmem_=gxclmem.$(OBJ)
clmem.dev: $(LIB_MAK) $(ECHOGS_XE) $(clmem_) lzwe.dev lzwd.dev
	$(SETMOD) clmem $(clmem_)
	$(ADDMOD) clmem -include lzwe lzwd

gxclmem_h=gxclmem.h $(gxclio_h)

gxclmem.$(OBJ): gxclmem.c $(GXERR) \
  $(gxclmem_h)

# ---------------- Page devices ---------------- #
# We include this here, rather than in devs.mak, because it is more like
# a feature than a simple device.

page_=gdevprn.$(OBJ)
page.dev: $(LIB_MAK) $(ECHOGS_XE) $(page_) clist.dev
	$(SETMOD) page $(page_)
	$(ADDMOD) page -include clist

gdevprn.$(OBJ): gdevprn.c $(ctype__h) \
  $(gdevprn_h) $(gp_h) $(gsparam_h) $(gxclio_h)

# ---------------- Image scaling filter ---------------- #
# Currently this module is required even in Level 1 systems,
# but it should be optional in Level 1 and required only in Level 2.

iscale_=siscale.$(OBJ)
iscale.dev: $(LIB_MAK) $(ECHOGS_XE) $(iscale_)
	$(SETMOD) iscale $(iscale_)

siscale.$(OBJ): siscale.c $(AK) $(math__h) $(memory__h) $(stdio__h) \
  $(siscale_h) $(strimpl_h)

# ---------------- RasterOp et al ---------------- #
# Currently this module is required, but it should be optional.

gsrop_h=gsrop.h $(gsropt_h)

ropcore_=gdevmrop.$(OBJ) gsrop.$(OBJ) gsroptab.$(OBJ)
ropcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(ropcore_)
	$(SETMOD) ropcore $(ropcore_)

gdevmrop.$(OBJ): gdevmrop.c $(GXERR) $(memory__h) \
  $(gsbittab_h) $(gsropt_h) \
  $(gxdcolor_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h) $(gdevmrop_h)

gsrop.$(OBJ): gsrop.c $(GXERR) \
  $(gsrop_h) $(gzstate_h)

gsroptab.$(OBJ): gsroptab.c $(stdpre_h) $(gsropt_h)
	$(CCLEAF) gsroptab.c

# -------- Composite (PostScript Type 0) font support -------- #

psf0core_=gschar0.$(OBJ) gsfont0.$(OBJ)
psf0core.dev: $(LIB_MAK) $(ECHOGS_XE) $(psf0core_)
	$(SETMOD) psf0core $(psf0core_)

gschar0.$(OBJ): gschar0.c $(GXERR) \
  $(gsstruct_h) $(gxfixed_h) $(gxdevice_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h)

gsfont0.$(OBJ): gsfont0.c $(GXERR) \
  $(gsmatrix_h) $(gsstruct_h) $(gxfixed_h) $(gxdevmem_h) $(gxfcache_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h) $(gxdevice_h)

# ---------------- Pattern color ---------------- #

patcore_=gspcolor.$(OBJ) gxclip2.$(OBJ) gxpcmap.$(OBJ)
patcore.dev: $(LIB_MAK) $(ECHOGS_XE) cmykcore.dev psl2core.dev $(patcore_)
	$(SETMOD) patcore -include cmykcore psl2core
	$(ADDMOD) patcore -obj $(patcore_)

gspcolor.$(OBJ): gspcolor.c $(GXERR) $(math__h) \
  $(gscspace_h) $(gsimage_h) $(gsstruct_h) $(gsutil_h) \
  $(gxarith_h) $(gxcolor2_h) $(gxcoord_h) $(gxclip2_h) \
  $(gxdcolor_h) $(gxdevice_h) $(gxdevmem_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gxpath_h) $(gxpcolor_h) $(gzstate_h)

gxclip2.$(OBJ): gxclip2.c $(GXERR) $(memory__h) \
  $(gsstruct_h) $(gxclip2_h) $(gxdevice_h) $(gxdevmem_h)

gxpcmap.$(OBJ): gxpcmap.c $(GXERR) \
  $(gsstruct_h) $(gscspace_h) $(gsutil_h) \
  $(gxcolor2_h) $(gxdcolor_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) \
  $(gxmatrix_h) $(gxpcolor_h) $(gzstate_h)

# ---------------- PostScript Type 1 (and Type 4) fonts ---------------- #

psf1core_=gstype1.$(OBJ) gxhint1.$(OBJ) gxhint2.$(OBJ) gxhint3.$(OBJ)
psf1core.dev: $(LIB_MAK) $(ECHOGS_XE) $(psf1core_)
	$(SETMOD) psf1core $(psf1core_)

gscrypt1_h=gscrypt1.h
gstype1_h=gstype1.h
gxfont1_h=gxfont1.h
gxop1_h=gxop1.h
gxtype1_h=gxtype1.h $(gscrypt1_h) $(gstype1_h)

gstype1.$(OBJ): gstype1.c $(GXERR) $(math__h) \
  $(gsstruct_h) \
  $(gxarith_h) $(gxcoord_h) $(gxfixed_h) $(gxmatrix_h) $(gxchar_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont1_h) $(gxop1_h) $(gxtype1_h) \
  $(gzstate_h) $(gzpath_h)

gxhint1.$(OBJ): gxhint1.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) \
  $(gzstate_h)

gxhint2.$(OBJ): gxhint2.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) $(gxop1_h) \
  $(gzstate_h)

gxhint3.$(OBJ): gxhint3.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) $(gxop1_h) \
  $(gxpath_h) $(gzstate_h)

# -------- Level 1 color extensions (CMYK color and colorimage) -------- #

cmykcore_=gscolor1.$(OBJ) gsht1.$(OBJ)
cmykcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(cmykcore_)
	$(SETMOD) cmykcore $(cmykcore_)

gscolor1.$(OBJ): gscolor1.c $(GXERR) \
  $(gsccolor_h) $(gscolor1_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) \
  $(gzstate_h)

gsht1.$(OBJ): gsht1.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

# ---------------- Level 2 color space support ---------------- #

psl2core_=gscolor2.$(OBJ)
psl2core.dev: $(LIB_MAK) $(ECHOGS_XE) $(psl2core_)
	$(SETMOD) psl2core $(psl2core_)

gscolor2.$(OBJ): gscolor2.c $(GXERR) \
  $(gscspace_h) \
  $(gxarith_h) $(gxcolor2_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h)

# ---------------- Display Postscript / Level 2 support ---------------- #

dps2core_=gsdps1.$(OBJ)
dps2core.dev: $(LIB_MAK) $(ECHOGS_XE) $(dps2core_)
	$(SETMOD) dps2core $(dps2core_)

gsdps1.$(OBJ): gsdps1.c $(GXERR) $(math__h) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gspath_h) $(gspath2_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gzpath_h) $(gzstate_h)

# ---------------- CIE color ---------------- #

ciecore_=gscie.$(OBJ) gxctable.$(OBJ)
ciecore.dev: $(LIB_MAK) $(ECHOGS_XE) $(ciecore_)
	$(SETMOD) ciecore $(ciecore_)

gscie.$(OBJ): gscie.c $(GXERR) $(math__h) \
  $(gscspace_h) $(gscie_h) $(gscolor2_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxarith_h) $(gxcmap_h) $(gxdevice_h) $(gzstate_h)

gxctable.$(OBJ): gxctable.c $(GX) \
  $(gxfixed_h) $(gxfrac_h) $(gxctable_h)

# ---------------- Separation colors ---------------- #

seprcore_=gscsepr.$(OBJ)
seprcore.dev: $(LIB_MAK) $(ECHOGS_XE) $(seprcore_)
	$(SETMOD) seprcore $(seprcore_)

gscsepr.$(OBJ): gscsepr.c $(GXERR) \
  $(gscspace_h) $(gsmatrix_h) $(gsrefct_h) $(gxcolor2_h) $(gxfixed_h)

# ----------------------- Platform-specific modules ----------------------- #
# Platform-specific code doesn't really belong here: this is code that is
# shared among multiple platforms.

# Frame buffer implementations.

gp_nofb.$(OBJ): gp_nofb.c $(GX) \
  $(gp_h) $(gxdevice_h)

gp_dosfb.$(OBJ): gp_dosfb.c $(AK) $(memory__h) \
  $(gx_h) $(gp_h) $(gserrors_h) $(gxdevice_h)

# MS-DOS file system, also used by Desqview/X.
gp_dosfs.$(OBJ): gp_dosfs.c $(AK) $(dos__h) $(gp_h) $(gx_h)

# MS-DOS file enumeration, *not* used by Desqview/X.
gp_dosfe.$(OBJ): gp_dosfe.c $(AK) $(stdio__h) $(memory__h) $(string__h) \
  $(dos__h) $(gstypes_h) $(gsmemory_h) $(gsstruct_h) $(gp_h) $(gsutil_h)

# Other MS-DOS facilities.
gp_msdos.$(OBJ): gp_msdos.c $(AK) $(dos__h) \
  $(gsmemory_h) $(gstypes_h) $(gp_h)

# Unix(-like) file system, also used by Desqview/X.
gp_unifs.$(OBJ): gp_unifs.c $(AK) $(memory__h) $(string__h) $(gx_h) $(gp_h) \
  $(gsstruct_h) $(gsutil_h) $(stat__h) $(dirent__h)

# Unix(-like) file name syntax, *not* used by Desqview/X.
gp_unifn.$(OBJ): gp_unifn.c $(AK) $(gx_h) $(gp_h)

# ----------------------------- Main program ------------------------------ #

# Main program for library testing

gslib.$(OBJ): gslib.c $(AK) $(math__h) \
  $(gx_h) $(gp_h) $(gserrors_h) $(gsmatrix_h) $(gsstate_h) $(gscspace_h) \
  $(gscolor2_h) $(gscoord_h) $(gsparam_h) \
  $(gspaint_h) $(gspath_h) $(gsstruct_h) $(gsutil_h) \
  $(gxalloc_h) $(gxdevice_h)
