#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# (Platform-independent) makefile for language interpreters.
# See the end of gs.mak for where this fits into the build process.

# Define the name of this makefile.
INT_MAK=int.mak

# ======================== Interpreter support ======================== #

# This is support code for all interpreters, not just PostScript and PDF.
# It knows about the PostScript data types, but isn't supposed to
# depend on anything outside itself.

errors_h=errors.h
idebug_h=idebug.h
idict_h=idict.h
igc_h=igc.h
iname_h=iname.h
inamedef_h=inamedef.h $(gconfigv_h) $(iname_h)
ipacked_h=ipacked.h
iref_h=iref.h
isave_h=isave.h
isstate_h=isstate.h
istruct_h=istruct.h $(gsstruct_h)
ivmspace_h=ivmspace.h
opdef_h=opdef.h
# Nested include files
ghost_h=ghost.h $(gx_h) $(iref_h)
imemory_h=imemory.h $(ivmspace_h)
ialloc_h=ialloc.h $(imemory_h)
iastruct_h=iastruct.h $(gxobj_h) $(ialloc_h)
iastate_h=iastate.h $(gxalloc_h) $(ialloc_h) $(istruct_h)
store_h=store.h $(ialloc_h)

GH=$(AK) $(ghost_h)

isupport1_=ialloc.$(OBJ) igc.$(OBJ) igcref.$(OBJ) igcstr.$(OBJ)
isupport2_=ilocate.$(OBJ) iname.$(OBJ) isave.$(OBJ)
isupport_=$(isupport1_) $(isupport2_)
isupport.dev: $(INT_MAK) $(ECHOGS_XE) $(isupport_)
	$(SETMOD) isupport $(isupport1_)
	$(ADDMOD) isupport -obj $(isupport2_)

ialloc.$(OBJ): ialloc.c $(AK) $(gx_h) \
  $(errors_h) $(gsstruct_h) $(gxarith_h) \
  $(iastate_h) $(iref_h) $(ivmspace_h) $(store_h)

# igc.c, igcref.c, and igcstr.c should really be in the dpsand2 list,
# but since all the GC enumeration and relocation routines refer to them,
# it's too hard to separate them out from the Level 1 base.
igc.$(OBJ): igc.c $(GH) \
  $(errors_h) $(gsexit_h) $(gsstruct_h) $(gsutil_h) \
  $(iastate_h) $(idict_h) $(igc_h) $(inamedef_h) \
  $(ipacked_h) $(isave_h) $(isstate_h) $(istruct_h) $(opdef_h) $(store_h)

igcref.$(OBJ): igcref.c $(GH) \
  $(gsexit_h) $(iastate_h) $(idebug_h) $(igc_h) $(iname_h) $(ipacked_h)

igcstr.$(OBJ): igcstr.c $(GH) \
  $(gsstruct_h) $(iastate_h) $(igc_h)

ilocate.$(OBJ): ilocate.c $(GH) $(memory__h) \
  $(errors_h) $(gsexit_h) $(gsstruct_h) \
  $(iastate_h) $(igc_h) $(iname_h) $(ipacked_h) $(isstate_h) $(ivmspace_h) \
  $(store_h)

iname.$(OBJ): iname.c $(GH) $(memory__h) $(string__h) \
  $(gsstruct_h) $(errors_h) $(imemory_h) $(inamedef_h) $(isave_h) $(store_h)

isave.$(OBJ): isave.c $(GH) \
  $(errors_h) $(gsexit_h) $(gsstruct_h) $(gsutil_h) \
  $(iastate_h) $(inamedef_h) $(isave_h) $(isstate_h) $(ivmspace_h) \
  $(ipacked_h) $(store_h)

### Include files

idparam_h=idparam.h
ilevel_h=ilevel.h
iparam_h=iparam.h $(gsparam_h)
istack_h=istack.h
iutil_h=iutil.h
opcheck_h=opcheck.h
opextern_h=opextern.h
# Nested include files
dstack_h=dstack.h $(istack_h)
estack_h=estack.h $(istack_h)
ostack_h=ostack.h $(istack_h)
oper_h=oper.h $(iutil_h) $(opcheck_h) $(opdef_h) $(opextern_h) $(ostack_h)

idebug.$(OBJ): idebug.c $(GH) \
  $(ialloc_h) $(idebug_h) $(idict_h) $(iname_h) $(istack_h) $(iutil_h) $(ivmspace_h) \
  $(ostack_h) $(opdef_h) $(ipacked_h) $(store_h)

idict.$(OBJ): idict.c $(GH) $(errors_h) \
  $(ialloc_h) $(idebug_h) $(ivmspace_h) $(inamedef_h) $(ipacked_h) \
  $(isave_h) $(store_h) $(iutil_h) $(idict_h) $(dstack_h)

idparam.$(OBJ): idparam.c $(GH) $(errors_h) \
  $(gsmatrix_h) $(gsuid_h) \
  $(idict_h) $(idparam_h) $(ilevel_h) $(imemory_h) $(iname_h) $(iutil_h) \
  $(oper_h) $(store_h)

iparam.$(OBJ): iparam.c $(GH) \
  $(ialloc_h) $(idict_h) $(iname_h) $(imemory_h) $(iparam_h) $(istack_h) $(iutil_h) $(ivmspace_h) \
  $(opcheck_h) $(store_h)

istack.$(OBJ): istack.c $(GH) $(memory__h) \
  $(errors_h) $(gsstruct_h) $(gsutil_h) \
  $(ialloc_h) $(istack_h) $(istruct_h) $(iutil_h) $(ivmspace_h) $(store_h)

iutil.$(OBJ): iutil.c $(GH) $(math__h) $(memory__h) $(string__h) \
  $(errors_h) $(idict_h) $(imemory_h) $(iutil_h) $(ivmspace_h) \
  $(iname_h) $(ipacked_h) $(store_h) \
  $(gsmatrix_h) $(gsutil_h)

# ======================== PostScript Level 1 ======================== #

###### Include files

files_h=files.h
fname_h=fname.h
imain_h=imain.h $(gsexit_h)
iminst_h=iminst.h $(imain_h)
ichar_h=ichar.h
icolor_h=icolor.h
icsmap_h=icsmap.h
ifont_h=ifont.h $(gsstruct_h)
interp_h=interp.h
iparray_h=iparray.h
iscan_h=iscan.h
iscannum_h=iscannum.h
istream_h=istream.h
main_h=main.h $(iminst_h)
overlay_h=overlay.h
sbtx_h=sbtx.h
sbwbs_h=sbwbs.h
scanchar_h=scanchar.h
sdct_h=sdct.h
sfilter_h=sfilter.h $(gstypes_h)
shcgen_h=shcgen.h
sjpeg_h=sjpeg.h
smtf_h=smtf.h
spdiffx_h=spdiffx.h
stream_h=stream.h $(scommon_h)
# Nested include files
bfont_h=bfont.h $(ifont_h)
ifilter_h=ifilter.h $(istream_h) $(ivmspace_h)
igstate_h=igstate.h $(gsstate_h) $(istruct_h)
sbhc_h=sbhc.h $(shc_h)
# Include files for optional features
ibnum_h=ibnum.h

### Initialization and scanning

iconfig=iconfig$(CONFIG)
$(iconfig).$(OBJ): iconf.c $(stdio__h) \
  $(gconfig_h) $(gscdefs_h) \
  $(files_h) $(imain_h) $(iref_h) $(ivmspace_h) $(opdef_h) $(stream_h)
	rm -f gconfig.h $(iconfig).c
	cp $(gconfig_h) gconfig.h
	cp iconf.c $(iconfig).c
	$(CCC) $(iconfig).c
	rm -f $(iconfig).c

iinit.$(OBJ): iinit.c $(GH) \
  $(gscdefs_h) $(gsexit_h) $(gsstruct_h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(errors_h) \
  $(ilevel_h) $(iname_h) $(interp_h) $(opdef_h) \
  $(ipacked_h) $(iparray_h) $(iutil_h) $(ivmspace_h) $(store_h)

iscan.$(OBJ): iscan.c $(GH) $(ctype__h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(errors_h) $(files_h) \
  $(ilevel_h) $(iutil_h) $(iscan_h) $(iscannum_h) $(istruct_h) $(ivmspace_h) \
  $(iname_h) $(ipacked_h) $(iparray_h) $(istream_h) $(ostack_h) $(store_h) \
  $(stream_h) $(strimpl_h) $(sfilter_h) $(scanchar_h)

iscannum.$(OBJ): iscannum.c $(GH) $(math__h) \
  $(errors_h) $(iscannum_h) $(scanchar_h) $(store_h) $(stream_h)

iscantab.$(OBJ): iscantab.c $(AK) \
  $(stdpre_h) $(scommon_h) $(scanchar_h)

### Streams

# Define which implementation of files we are using (sfile or sfileno).
# This can be overridden on the `make' command line.
#sfile_impl=sfileno
sfile_impl=sfile

sfile.$(OBJ): sfile.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(stream_h) $(strimpl_h)

sfileno.$(OBJ): sfileno.c $(AK) $(stdio__h) $(errno__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(stream_h) $(strimpl_h)

sfilter1.$(OBJ): sfilter1.c $(AK) $(stdio__h) $(memory__h) \
  $(sfilter_h) $(strimpl_h)

sstring.$(OBJ): sstring.c $(AK) $(stdio__h) $(memory__h) \
  $(scanchar_h) $(sfilter_h) $(strimpl_h)

stream.$(OBJ): stream.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(stream_h) $(strimpl_h)

###### Operators

OP=$(GH) $(errors_h) $(oper_h)

### Non-graphics operators

zarith.$(OBJ): zarith.c $(OP) $(math__h) $(store_h)

zarray.$(OBJ): zarray.c $(OP) $(ialloc_h) $(ipacked_h) $(store_h)

zcontrol.$(OBJ): zcontrol.c $(OP) \
  $(estack_h) $(ipacked_h) $(iutil_h) $(store_h)

zdict.$(OBJ): zdict.c $(OP) \
  $(dstack_h) $(idict_h) $(ilevel_h) $(iname_h) $(ipacked_h) $(ivmspace_h) \
  $(store_h)

zfile.$(OBJ): zfile.c $(OP) $(stat__h) $(gp_h) \
  $(gsstruct_h) $(gxiodev_h) \
  $(ialloc_h) $(estack_h) $(files_h) $(fname_h) $(ilevel_h) $(interp_h) $(iutil_h) \
  $(isave_h) $(main_h) $(sfilter_h) $(stream_h) $(strimpl_h) $(store_h)

zfname.$(OBJ): zfname.c $(OP) \
  $(fname_h) $(gxiodev_h) $(ialloc_h) $(stream_h)

zfileio.$(OBJ): zfileio.c $(OP) $(gp_h) \
  $(files_h) $(ifilter_h) $(store_h) $(stream_h) $(strimpl_h) \
  $(gsmatrix_h) $(gxdevice_h) $(gxdevmem_h)

zfilter.$(OBJ): zfilter.c $(OP) \
  $(gsstruct_h) $(files_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(sfilter_h) $(srlx_h) $(stream_h) $(strimpl_h)

zfproc.$(OBJ): zfproc.c $(GH) $(errors_h) $(oper_h) \
  $(estack_h) $(files_h) $(gsstruct_h) $(ialloc_h) $(ifilter_h) $(istruct_h) \
  $(store_h) $(stream_h) $(strimpl_h)

zgeneric.$(OBJ): zgeneric.c $(OP) \
  $(idict_h) $(estack_h) $(ivmspace_h) $(iname_h) $(ipacked_h) $(store_h)

ziodev.$(OBJ): ziodev.c $(OP) $(string__h) $(gp_h) $(gpcheck_h) \
  $(gsstruct_h) $(gxiodev_h) \
  $(files_h) $(ialloc_h) $(ivmspace_h) $(store_h) $(stream_h)

zmath.$(OBJ): zmath.c $(OP) $(math__h) $(gxfarith_h) $(store_h)

zmisc.$(OBJ): zmisc.c $(OP) $(gscdefs_h) $(gp_h) \
  $(errno__h) $(memory__h) $(string__h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(iname_h) $(ivmspace_h) $(ipacked_h) $(store_h)

zpacked.$(OBJ): zpacked.c $(OP) \
  $(ialloc_h) $(idict_h) $(ivmspace_h) $(iname_h) $(ipacked_h) $(iparray_h) \
  $(istack_h) $(store_h)

zrelbit.$(OBJ): zrelbit.c $(OP) $(gsutil_h) $(store_h) $(idict_h)

zstack.$(OBJ): zstack.c $(OP) $(ialloc_h) $(istack_h) $(store_h)

zstring.$(OBJ): zstring.c $(OP) $(gsutil_h) \
  $(ialloc_h) $(iname_h) $(ivmspace_h) $(store_h)

zsysvm.$(OBJ): zsysvm.c $(OP)

ztoken.$(OBJ): ztoken.c $(OP) \
  $(estack_h) $(files_h) $(gsstruct_h) $(iscan_h) \
  $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

ztype.$(OBJ): ztype.c $(OP) $(math__h) \
  $(dstack_h) $(idict_h) $(imemory_h) $(iname_h) \
  $(iscan_h) $(iutil_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

zvmem.$(OBJ): zvmem.c $(OP) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(estack_h) $(isave_h) $(igstate_h) $(store_h) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h)

### Graphics operators

zchar.$(OBJ): zchar.c $(OP) \
  $(gsstruct_h) $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gschar_h) $(gxdevice_h) $(gxfont_h) $(gzpath_h) $(gzstate_h) \
  $(ialloc_h) $(ichar_h) $(idict_h) $(ifont_h) $(estack_h) $(ilevel_h) $(iname_h) $(igstate_h) $(store_h)

zcolor.$(OBJ): zcolor.c $(OP) \
  $(gxfixed_h) $(gxmatrix_h) $(gzstate_h) $(gxdevice_h) $(gxcmap_h) \
  $(ialloc_h) $(icolor_h) $(estack_h) $(iutil_h) $(igstate_h) $(store_h)

zdevice.$(OBJ): zdevice.c $(OP) \
  $(ialloc_h) $(idict_h) $(igstate_h) $(iname_h) $(interp_h) $(iparam_h) $(ivmspace_h) \
  $(gsmatrix_h) $(gsstate_h) $(gxdevice_h) $(store_h)

zfont.$(OBJ): zfont.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gxfont_h) $(gxfcache_h) \
  $(ialloc_h) $(idict_h) $(igstate_h) $(iname_h) $(isave_h) $(ivmspace_h) \
  $(bfont_h) $(store_h)

zfont2.$(OBJ): zfont2.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gschar_h) $(gxfixed_h) $(gxfont_h) \
  $(ialloc_h) $(bfont_h) $(idict_h) $(idparam_h) $(ilevel_h) $(iname_h) $(istruct_h) \
  $(ipacked_h) $(store_h)

zgstate.$(OBJ): zgstate.c $(OP) \
  $(gsmatrix_h) $(ialloc_h) $(idict_h) $(igstate_h) $(istruct_h) $(store_h)

zht.$(OBJ): zht.c $(OP) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(ialloc_h) $(estack_h) $(igstate_h) $(store_h)

zmatrix.$(OBJ): zmatrix.c $(OP) $(gsmatrix_h) $(igstate_h) $(gscoord_h) $(store_h)

zpaint.$(OBJ): zpaint.c $(OP) \
  $(estack_h) $(ialloc_h) $(ifilter_h) $(igstate_h) $(ilevel_h) \
  $(gscspace_h) $(gsimage_h) $(gsmatrix_h) $(gspaint_h) $(gsstruct_h) \
  $(store_h) $(stream_h)

zpath.$(OBJ): zpath.c $(OP) $(math__h) \
  $(gsmatrix_h) $(gspath_h) $(igstate_h) $(store_h)

# Define the base PostScript language interpreter.
# This is the subset of PostScript Level 1 required by our PDF reader.

INT1=idebug.$(OBJ) idict.$(OBJ) idparam.$(OBJ) iinit.$(OBJ)
INT2=interp.$(OBJ) iparam.$(OBJ) ireclaim.$(OBJ)
INT3=iscan.$(OBJ) iscannum.$(OBJ) iscantab.$(OBJ) istack.$(OBJ) iutil.$(OBJ)
INT4=$(sfile_impl).$(OBJ) sfilter1.$(OBJ) sstring.$(OBJ) stream.$(OBJ)
Z1=zarith.$(OBJ) zarray.$(OBJ) zcontrol.$(OBJ) zdict.$(OBJ)
Z1OPS=zarith zarray zcontrol zdict
Z2=zfile.$(OBJ) zfileio.$(OBJ) zfilter.$(OBJ) zfname.$(OBJ) zfproc.$(OBJ)
Z2OPS=zfile zfileio zfilter zfproc
Z3=zgeneric.$(OBJ) ziodev.$(OBJ) zmath.$(OBJ) zmisc.$(OBJ) zpacked.$(OBJ)
Z3OPS=zgeneric ziodev zmath zmisc zpacked
Z4=zrelbit.$(OBJ) zstack.$(OBJ) zstring.$(OBJ) zsysvm.$(OBJ)
Z4OPS=zrelbit zstack zstring zsysvm
Z5=ztoken.$(OBJ) ztype.$(OBJ) zvmem.$(OBJ)
Z5OPS=ztoken ztype zvmem
Z6=zchar.$(OBJ) zcolor.$(OBJ) zdevice.$(OBJ) zfont.$(OBJ) zfont2.$(OBJ)
Z6OPS=zchar zcolor zdevice zfont zfont2
Z7=zgstate.$(OBJ) zht.$(OBJ) zmatrix.$(OBJ) zpaint.$(OBJ) zpath.$(OBJ)
Z7OPS=zgstate zht zmatrix zpaint zpath
# We have to be a little underhanded with *config.$(OBJ) so as to avoid
# circular definitions.
INT_OBJS=gsmain.$(OBJ) \
  $(INT1) $(INT2) $(INT3) $(INT4) \
  $(Z1) $(Z2) $(Z3) $(Z4) $(Z5) $(Z6) $(Z7)
INT_CONFIG=$(gconfig).$(OBJ) $(iconfig).$(OBJ) iccinit$(COMPILE_INITS).$(OBJ)
INT_ALL=$(INT_OBJS) $(INT_CONFIG)
# We omit libcore.dev, which should be included here, because problems
# with the Unix linker require libcore to appear last in the link list
# when libcore is really a library.
# We omit $(INT_CONFIG) from the dependency list because they have special
# dependency requirements and are added to the link list at the very end.
# zfilter.c shouldn't include the RLE and RLD filters, but we don't want to
# change this now.
psbase.dev: $(INT_MAK) $(ECHOGS_XE) $(INT_OBJS) isupport.dev rld.dev rle.dev
	$(SETMOD) psbase gsmain.$(OBJ)
	$(ADDMOD) psbase -obj $(INT_CONFIG)
	$(ADDMOD) psbase -obj $(INT1)
	$(ADDMOD) psbase -obj $(INT2)
	$(ADDMOD) psbase -obj $(INT3)
	$(ADDMOD) psbase -obj $(INT4)
	$(ADDMOD) psbase -obj $(Z1)
	$(ADDMOD) psbase -oper $(Z1OPS)
	$(ADDMOD) psbase -obj $(Z2)
	$(ADDMOD) psbase -oper $(Z2OPS)
	$(ADDMOD) psbase -obj $(Z3)
	$(ADDMOD) psbase -oper $(Z3OPS)
	$(ADDMOD) psbase -obj $(Z4)
	$(ADDMOD) psbase -oper $(Z4OPS)
	$(ADDMOD) psbase -obj $(Z5)
	$(ADDMOD) psbase -oper $(Z5OPS)
	$(ADDMOD) psbase -obj $(Z6)
	$(ADDMOD) psbase -oper $(Z6OPS)
	$(ADDMOD) psbase -obj $(Z7)
	$(ADDMOD) psbase -oper $(Z7OPS)
	$(ADDMOD) psbase -iodev stdin stdout stderr lineedit statementedit
	$(ADDMOD) psbase -include isupport rld rle

# -------------------------- Feature definitions -------------------------- #

# ---------------- Full Level 1 interpreter ---------------- #

level1.dev: $(INT_MAK) $(ECHOGS_XE) psbase.dev bcp.dev hsb.dev path1.dev type1.dev
	$(SETMOD) level1 -include psbase bcp hsb path1 type1
	$(ADDMOD) level1 -emulator PostScript PostScriptLevel1

# -------- Level 1 color extensions (CMYK color and colorimage) -------- #

color.dev: $(INT_MAK) $(ECHOGS_XE) cmykcore.dev cmykread.dev
	$(SETMOD) color -include cmykcore cmykread

cmykread_=zcolor1.$(OBJ) zht1.$(OBJ)
cmykread.dev: $(INT_MAK) $(ECHOGS_XE) $(cmykread_)
	$(SETMOD) cmykread $(cmykread_)
	$(ADDMOD) cmykread -oper zcolor1 zht1

zcolor1.$(OBJ): zcolor1.c $(OP) \
  $(gscolor1_h) $(gscspace_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h) $(gxdevice_h) $(gxcmap_h) \
  $(ialloc_h) $(icolor_h) $(estack_h) $(iutil_h) $(igstate_h) $(store_h)

zht1.$(OBJ): zht1.c $(OP) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(ialloc_h) $(estack_h) $(igstate_h) $(store_h)

# ---------------- HSB color ---------------- #

hsb_=gshsb.$(OBJ) zhsb.$(OBJ)
hsb.dev: $(INT_MAK) $(ECHOGS_XE) $(hsb_)
	$(SETMOD) hsb $(hsb_)
	$(ADDMOD) hsb -oper zhsb

gshsb.$(OBJ): gshsb.c $(GX) \
  $(gscolor_h) $(gshsb_h) $(gxfrac_h)

zhsb.$(OBJ): zhsb.c $(OP) \
  $(gshsb_h) $(igstate_h) $(store_h)

# ---------------- Level 1 path facilities ---------------- #

path1_=gspath1.$(OBJ) zpath1.$(OBJ)
path1.dev: $(INT_MAK) $(ECHOGS_XE) $(path1_)
	$(SETMOD) path1 $(path1_)
	$(ADDMOD) path1 -oper zpath1

gspath1.$(OBJ): gspath1.c $(GXERR) $(math__h) \
  $(gscoord_h) $(gsstruct_h) $(gxfarith_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h) $(gzpath_h)

zpath1.$(OBJ): zpath1.c $(OP) \
  $(ialloc_h) $(estack_h) $(gspath_h) $(gsstruct_h) $(igstate_h) $(store_h)

# ================ Level-independent PostScript options ================ #

# ---------------- BCP filters ---------------- #

bcp_=sbcp.$(OBJ) zfbcp.$(OBJ)
bcp.dev: $(INT_MAK) $(ECHOGS_XE) $(bcp_)
	$(SETMOD) bcp $(bcp_)
	$(ADDMOD) bcp -oper zfbcp

sbcp.$(OBJ): sbcp.c $(AK) $(stdio__h) \
  $(sfilter_h) $(strimpl_h)

zfbcp.$(OBJ): zfbcp.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(ifilter_h) \
  $(sfilter_h) $(stream_h) $(strimpl_h)

# ---------------- Double-precision floats ---------------- #

double_=zdouble.$(OBJ)
double.dev: $(INT_MAK) $(ECHOGS_XE) $(double_)
	$(SETMOD) double $(double_)
	$(ADDMOD) double -oper zdouble

zdouble.$(OBJ): zdouble.c $(OP) $(ctype__h) $(math__h) $(memory__h) $(string__h) \
  $(gxfarith_h) $(store_h)

# ---------------- RasterOp ---------------- #
# This should be a separable feature in the core also....

rasterop.dev: $(INT_MAK) $(ECHOGS_XE) ropcore.dev ropread.dev
	$(SETMOD) rasterop -include ropcore ropread

ropread_=zrop.$(OBJ)
ropread.dev: $(INT_MAK) $(ECHOGS_XE) $(ropread_)
	$(SETMOD) ropread $(ropread_)
	$(ADDMOD) ropread -oper zrop

zrop.$(OBJ): zrop.c $(OP) $(memory__h) \
  $(gsrop_h) $(gxdevice_h) $(idict_h) $(idparam_h) $(igstate_h) $(store_h)

# ---------------- PostScript Type 1 (and Type 4) fonts ---------------- #

type1.dev: $(INT_MAK) $(ECHOGS_XE) psf1core.dev psf1read.dev
	$(SETMOD) type1 -include psf1core psf1read

psf1read_=seexec.$(OBJ) zchar1.$(OBJ) zfont1.$(OBJ) zmisc1.$(OBJ)
psf1read.dev: $(INT_MAK) $(ECHOGS_XE) $(psf1read_)
	$(SETMOD) psf1read $(psf1read_)
	$(ADDMOD) psf1read -oper zchar1 zfont1 zmisc1
	$(ADDMOD) psf1read -ps gs_type1

seexec.$(OBJ): seexec.c $(AK) $(stdio__h) \
  $(gscrypt1_h) $(scanchar_h) $(sfilter_h) $(strimpl_h)

zchar1.$(OBJ): zchar1.c $(OP) \
  $(gsstruct_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gschar_h) $(gxdevice_h) $(gxfont_h) $(gxfont1_h) $(gxtype1_h) \
  $(ialloc_h) $(ichar_h) $(idict_h) $(estack_h) $(ifont_h) $(igstate_h) \
  $(store_h)

zfont1.$(OBJ): zfont1.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gschar_h) $(gxfixed_h) $(gxfont_h) $(gxfont1_h) \
  $(bfont_h) $(ialloc_h) $(idict_h) $(idparam_h) $(store_h)

zmisc1.$(OBJ): zmisc1.c $(OP) \
  $(gscrypt1_h) $(ifilter_h) $(sfilter_h) $(stream_h) $(strimpl_h)

# ---------------- Obsolete PPM writing facility ---------------- #

writeppm_=zwppm.$(OBJ)
writeppm.dev: $(INT_MAK) $(ECHOGS_XE) $(writeppm_)
	$(SETMOD) writeppm $(writeppm_)
	$(ADDMOD) writeppm -oper zwppm

zwppm.$(OBJ): zwppm.c $(OP) $(memory__h) \
  $(files_h) $(gscdefs_h) $(gsmatrix_h) $(gxdevice_h) $(gxdevmem_h) \
  $(stream_h)

# ======================== Precompilation options ======================== #

# ---------------- Precompiled fonts ---------------- #
# See fonts.doc for more information.

ccfont_h=ccfont.h $(std_h) $(gsmemory_h) $(iref_h) $(ivmspace_h) $(store_h)

CCFONT=$(OP) $(ccfont_h)

# List the fonts we are going to compile.
# Because of intrinsic limitations in `make', we have to list
# the object file names and the font names separately.
# Because of limitations in the DOS shell, we have to break the fonts up
# into lists that will fit on a single line (120 characters).
# The rules for constructing the .c files from the fonts themselves,
# and for compiling the .c files, are in cfonts.mak, not here.
# For example, to compile the Courier fonts, you should invoke
#	make -f cfonts.mak Courier_o
ccfonts_ps=gs_ccfnt
ccfonts1_=pagk.$(OBJ) pagko.$(OBJ) pagd.$(OBJ) pagdo.$(OBJ)
ccfonts1=agk agko agd agdo
ccfonts2_=pbkl.$(OBJ) pbkli.$(OBJ) pbkd.$(OBJ) pbkdi.$(OBJ)
ccfonts2=bkl bkli bkd bkdi
# The free distribution includes Bitstream Charter;
# the standard distribution has additional Helvetica Narrow variants.
ccfonts3free_=bchr.$(OBJ) bchri.$(OBJ) bchb.$(OBJ) bchbi.$(OBJ)
ccfonts3free=chr chri chb chbi
ccfonts3std_=phvrorn.$(OBJ) phvbrn.$(OBJ) phvborn.$(OBJ)
ccfonts3std=hvrorn hvbrn hvborn
ccfonts4_=ncrr.$(OBJ) ncri.$(OBJ) ncrb.$(OBJ) ncrbi.$(OBJ)
ccfonts4=crr cri crb crbi
ccfonts5_=phvr.$(OBJ) phvro.$(OBJ) phvb.$(OBJ) phvbo.$(OBJ) phvrrn.$(OBJ)
ccfonts5=hvr hvro hvb hvbo hvrrn
ccfonts6_=pncr.$(OBJ) pncri.$(OBJ) pncb.$(OBJ) pncbi.$(OBJ)
ccfonts6=ncr ncri ncb ncbi
ccfonts7_=pplr.$(OBJ) pplri.$(OBJ) pplb.$(OBJ) pplbi.$(OBJ)
ccfonts7=plr plri plb plbi
ccfonts8_=psyr.$(OBJ) ptmr.$(OBJ) ptmri.$(OBJ) ptmb.$(OBJ) ptmbi.$(OBJ)
ccfonts8=syr tmr tmri tmb tmbi
# The free distribution has Zapf Chancery plain, Oblique and Bold;
# the standard distribution has only Medium Italic.
# Both have Zapf Dingbats.
ccfonts9free_=zcr.$(OBJ) zcro.$(OBJ) zcb.$(OBJ) pzdr.$(OBJ)
ccfonts9free=zcr zcro zcb zdr
ccfonts9std_=zcmi.$(OBJ) pzdr.$(OBJ)
ccfonts9std=zcmi zdr
# Add your own fonts here if desired.
ccfonts10_=
ccfonts10=
ccfonts11_=
ccfonts11=
ccfonts12_=
ccfonts12=
ccfonts13_=
ccfonts13=
ccfonts14_=
ccfonts14=
ccfonts15_=
ccfonts15=
# Select either standard or free configuration here.
# By default, we select the standard configuration.
#ccfonts3_=$(ccfonts3free_)
#ccfonts3=$(ccfonts3free)
#ccfonts9_=$(ccfonts9free_)
#ccfonts9=$(ccfonts9free)
ccfonts3_=$(ccfonts3std_)
ccfonts3=$(ccfonts3std)
ccfonts9_=$(ccfonts9std_)
ccfonts9=$(ccfonts9std)

# It's OK for ccfonts_.dev not to be CONFIG-dependent, because it only
# exists during the execution of the following rule.
$(gconfigf_h): $(MAKEFILE) $(INT_MAK) $(GENCONF_XE)
	$(SETMOD) ccfonts_ -font $(ccfonts1)
	$(ADDMOD) ccfonts_ -font $(ccfonts2)
	$(ADDMOD) ccfonts_ -font $(ccfonts3)
	$(ADDMOD) ccfonts_ -font $(ccfonts4)
	$(ADDMOD) ccfonts_ -font $(ccfonts5)
	$(ADDMOD) ccfonts_ -font $(ccfonts6)
	$(ADDMOD) ccfonts_ -font $(ccfonts7)
	$(ADDMOD) ccfonts_ -font $(ccfonts8)
	$(ADDMOD) ccfonts_ -font $(ccfonts9)
	$(ADDMOD) ccfonts_ -font $(ccfonts10)
	$(ADDMOD) ccfonts_ -font $(ccfonts11)
	$(ADDMOD) ccfonts_ -font $(ccfonts12)
	$(ADDMOD) ccfonts_ -font $(ccfonts13)
	$(ADDMOD) ccfonts_ -font $(ccfonts14)
	$(ADDMOD) ccfonts_ -font $(ccfonts15)
	$(EXP)genconf ccfonts_.dev -f $(gconfigf_h)

# We separate ccfontab.dev from ccfonts.dev so that a customer can put
# compiled fonts into a separate shared library.

ccfontab=ccfontab$(CONFIG)

# Define ccfont_table separately, so it can be set from the command line
# to select an alternate compiled font table.
ccfont_table=$(ccfontab)

$(ccfontab).dev: $(MAKEFILE) $(INT_MAK) $(ECHOGS_XE) $(ccfontab).$(OBJ) \
  $(ccfonts1_) $(ccfonts2_) $(ccfonts3_) $(ccfonts4_) $(ccfonts5_) \
  $(ccfonts6_) $(ccfonts7_) $(ccfonts8_) $(ccfonts9_) $(ccfonts10_) \
  $(ccfonts11_) $(ccfonts12_) $(ccfonts13_) $(ccfonts14_) $(ccfonts15_)
	$(SETMOD) $(ccfontab) -obj $(ccfontab).$(OBJ)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts1_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts2_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts3_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts4_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts5_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts6_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts7_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts8_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts9_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts10_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts11_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts12_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts13_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts14_)
	$(ADDMOD) $(ccfontab) -obj $(ccfonts15_)

$(ccfontab).$(OBJ): ccfontab.c $(AK) $(ccfont_h) $(gconfigf_h)
	cp $(gconfigf_h) gconfigf.h
	$(CCCF) ccfontab.c

# Strictly speaking, ccfonts shouldn't need to include type1,
# since one could choose to precompile only Type 0 fonts,
# but getting this exactly right would be too much work.
ccfonts=ccfonts$(CONFIG)
$(ccfonts).dev: $(MAKEFILE) $(INT_MAK) type1.dev iccfont.$(OBJ) \
  $(ccfont_table).dev
	$(SETMOD) $(ccfonts) -include type1
	$(ADDMOD) $(ccfonts) -include $(ccfont_table)
	$(ADDMOD) $(ccfonts) -obj iccfont.$(OBJ)
	$(ADDMOD) $(ccfonts) -oper ccfonts
	$(ADDMOD) $(ccfonts) -ps $(ccfonts_ps)

iccfont.$(OBJ): iccfont.c $(GH) \
  $(gsstruct_h) $(ccfont_h) $(errors_h) \
  $(ialloc_h) $(idict_h) $(ifont_h) $(iname_h) $(isave_h) $(iutil_h) \
  $(oper_h) $(ostack_h) $(store_h) $(stream_h) $(strimpl_h) $(sfilter_h) $(iscan_h)
	$(CCCF) iccfont.c

# ---------------- Compiled initialization code ---------------- #

# We select either iccinit0 or iccinit1 depending on COMPILE_INITS.

iccinit0.$(OBJ): iccinit0.c $(stdpre_h)
	$(CCCF) iccinit0.c

iccinit1.$(OBJ): gs_init.$(OBJ)
	cp gs_init.$(OBJ) iccinit1.$(OBJ)

# All the gs_*.ps files should be prerequisites of gs_init.c,
# but we don't have any convenient list of them.
gs_init.c: $(GS_INIT) $(GENINIT_XE) $(gconfig_h)
	$(EXP)geninit $(GS_INIT) $(gconfig_h) -c gs_init.c

gs_init.$(OBJ): gs_init.c $(stdpre_h)
	$(CCCF) gs_init.c

# ======================== PostScript Level 2 ======================== #

###### Include files

iutil2_h=iutil2.h

### In addition to the true Level 2 configuration, we define a 'minimal'
### Level 2 that can be used with -dDEBUG in the 16-bit Windows environment.
### This also requires trimming down the sizes of the stacks in interp.c.

lev2min.dev: $(INT_MAK) $(ECHOGS_XE) \
  psbase.dev cie.dev compfont.dev dctd.dev devctrl.dev color.dev \
  dps2core.dev dps2read.dev fdecode.dev path1.dev type1.dev \
  pattern.dev psl2core.dev psl2read.dev
	$(SETMOD) lev2min -include psbase cie compfont dctd devctrl color
	$(ADDMOD) lev2min -include dps2core dps2read fdecode path1 type1
	$(ADDMOD) lev2min -include pattern psl2core psl2read
	$(ADDMOD) lev2min -emulator PostScript PostScriptLevel1 PostScriptLevel2

level2.dev: $(INT_MAK) $(ECHOGS_XE) \
  cie.dev compfont.dev dct.dev devctrl.dev dpsand2.dev filter.dev \
  level1.dev pattern.dev psl2core.dev psl2read.dev sepr.dev xfilter.dev
	$(SETMOD) level2 -include cie compfont dct devctrl dpsand2 filter
	$(ADDMOD) level2 -include level1 pattern psl2core psl2read sepr xfilter
	$(ADDMOD) level2 -emulator PostScript PostScriptLevel2

psl2read1_=iutil2.$(OBJ) zcolor2.$(OBJ) zcsindex.$(OBJ)
psl2read2_=zht2.$(OBJ) zimage2.$(OBJ) zmisc2.$(OBJ)
psl2read_=$(psl2read1_) $(psl2read2_)
# Note that zmisc2 includes both Level 1 and Level 2 operators.
psl2read.dev: $(INT_MAK) $(ECHOGS_XE) $(psl2read_)
	$(SETMOD) psl2read $(psl2read1_)
	$(ADDMOD) psl2read -obj $(psl2read2_)
	$(ADDMOD) psl2read -oper zmisc2
	$(ADDMOD) psl2read -oper zcolor2_l2 zcsindex_l2
	$(ADDMOD) psl2read -oper zht2_l2 zimage2_l2
	$(ADDMOD) psl2read -ps gs_lev2 gs_res

iutil2.$(OBJ): iutil2.c $(GXERR) $(memory__h) \
  $(gsparam_h) $(gsutil_h) \
  $(opcheck_h) $(idict_h) $(imemory_h) $(iutil_h) $(iutil2_h)

zcolor2.$(OBJ): zcolor2.c $(OP) \
  $(gscolor_h) $(gscspace_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxcolor2_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) $(gxpcolor_h) \
  $(estack_h) $(ialloc_h) $(idict_h) $(idparam_h) $(igstate_h) $(istruct_h) \
  $(store_h)

zcsindex.$(OBJ): zcsindex.c $(OP) $(memory__h) \
  $(gscolor_h) $(gsstruct_h) $(gxfixed_h) $(gxcolor2_h) $(gscspace_h) $(gsmatrix_h) \
  $(ialloc_h) $(icsmap_h) $(estack_h) $(igstate_h) $(ivmspace_h) $(store_h)

zht2.$(OBJ): zht2.c $(OP) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(estack_h) $(ialloc_h) $(icolor_h) $(idict_h) $(idparam_h) $(igstate_h) \
  $(store_h)

zimage2.$(OBJ): zimage2.c $(OP) $(math__h) \
  $(gscolor_h) $(gscolor2_h) $(gscspace_h) $(gsimage_h) $(gsmatrix_h) \
  $(idict_h) $(idparam_h) $(ilevel_h) $(igstate_h)

zmisc2.$(OBJ): zmisc2.c $(OP) \
  $(gscdefs_h) $(gsfont_h) $(gsstruct_h) $(gsutil_h) $(gxht_h) \
  $(ialloc_h) $(idict_h) $(idparam_h) $(iparam_h) $(dstack_h) $(estack_h) \
  $(ilevel_h) $(iname_h) $(iutil2_h) $(ivmspace_h) $(store_h)

# ---------------- Device control ---------------- #
# This is a catch-all for setpagedevice and IODevices.

devctrl_=zdevice2.$(OBJ) ziodev2.$(OBJ) zmedia2.$(OBJ) zdevcal.$(OBJ)
devctrl.dev: $(INT_MAK) $(ECHOGS_XE) $(devctrl_)
	$(SETMOD) devctrl $(devctrl_)
	$(ADDMOD) devctrl -oper zdevice2_l2 ziodev2_l2 zmedia2_l2
	$(ADDMOD) devctrl -iodev null ram calendar
	$(ADDMOD) devctrl -ps gs_setpd

zdevice2.$(OBJ): zdevice2.c $(OP) $(math__h) \
  $(dstack_h) $(estack_h) $(idict_h) $(idparam_h) $(igstate_h) $(iname_h) $(store_h) \
  $(gxdevice_h) $(gsstate_h)

ziodev2.$(OBJ): ziodev2.c $(OP) \
  $(gxiodev_h) $(stream_h) $(files_h) $(iparam_h) $(iutil2_h) $(store_h)

zmedia2.$(OBJ): zmedia2.c $(OP) $(math__h) $(memory__h) \
  $(gsmatrix_h) $(idict_h) $(idparam_h) $(iname_h) $(store_h)

zdevcal.$(OBJ): zdevcal.c $(GH) $(time__h) \
  $(gxiodev_h) $(iparam_h) $(istack_h)

# ---------------- Filters other than the ones in sfilter.c ---------------- #

# Standard Level 2 decoding filters only.  The PDF configuration uses this.
fdecode_=sfilter2.$(OBJ) zfdecode.$(OBJ) spdiff.$(OBJ) zfpdiff.$(OBJ)
fdecode.dev: $(INT_MAK) $(ECHOGS_XE) $(fdecode_) cfd.dev lzwd.dev rld.dev
	$(SETMOD) fdecode $(fdecode_)
	$(ADDMOD) fdecode -include cfd lzwd rld
	$(ADDMOD) fdecode -oper zfdecode zfpdiff

sfilter2.$(OBJ): sfilter2.c $(AK) $(stdio__h)\
  $(scanchar_h) $(sbtx_h) $(sfilter_h) $(strimpl_h)

spdiff.$(OBJ): spdiff.c $(AK) $(stdio__h)\
  $(spdiffx_h) $(strimpl_h)

zfdecode.$(OBJ): zfdecode.c $(OP) $(memory__h) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(scfx_h) $(sfilter_h) $(slzwx_h) $(store_h) $(strimpl_h)

zfpdiff.$(OBJ): zfpdiff.c $(OP) \
  $(gsstruct_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(sfilter_h) $(spdiffx_h) $(strimpl_h)

# Complete Level 2 filter capability.
filter_=zfilter2.$(OBJ)
filter.dev: $(INT_MAK) $(ECHOGS_XE) fdecode.dev $(filter_) cfe.dev lzwe.dev rle.dev
	$(SETMOD) filter -include fdecode
	$(ADDMOD) filter -obj $(filter_)
	$(ADDMOD) filter -include cfe lzwe rle
	$(ADDMOD) filter -oper zfilter2

zfilter2.$(OBJ): zfilter2.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) $(store_h) \
  $(sfilter_h) $(scfx_h) $(slzwx_h) $(strimpl_h)

# Extensions beyond Level 2 standard.
xfilter_=sbhc.$(OBJ) sbwbs.$(OBJ) shcgen.$(OBJ) smtf.$(OBJ) zfilterx.$(OBJ)
xfilter.dev: $(INT_MAK) $(ECHOGS_XE) $(xfilter_)
	$(SETMOD) xfilter $(xfilter_)
	$(ADDMOD) xfilter -oper zfilterx

sbhc.$(OBJ): sbhc.c $(AK) $(stdio__h) \
  $(gdebug_h) $(sbhc_h) $(shcgen_h) $(strimpl_h)

sbwbs.$(OBJ): sbwbs.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(sbwbs_h) $(sfilter_h) $(strimpl_h)

shcgen.$(OBJ): shcgen.c $(AK) $(stdio__h) \
  $(gdebug_h) $(gserror_h) $(gserrors_h) \
  $(scommon_h) $(shc_h) $(shcgen_h)

smtf.$(OBJ): smtf.c $(AK) $(stdio__h) \
  $(smtf_h) $(strimpl_h)

zfilterx.$(OBJ): zfilterx.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(store_h) $(sfilter_h) $(sbhc_h) $(sbtx_h) $(sbwbs_h) $(shcgen_h) \
  $(smtf_h) $(strimpl_h)

# ---------------- Binary tokens ---------------- #

btoken_=iscanbin.$(OBJ) zbseq.$(OBJ)
btoken.dev: $(INT_MAK) $(ECHOGS_XE) $(btoken_)
	$(SETMOD) btoken $(btoken_)
	$(ADDMOD) btoken -oper zbseq_l2
	$(ADDMOD) btoken -ps gs_btokn

bseq_h=bseq.h
btoken_h=btoken.h

iscanbin.$(OBJ): iscanbin.c $(GH) $(math__h) $(errors_h) \
  $(gsutil_h) $(ialloc_h) $(ibnum_h) $(idict_h) $(iname_h) \
  $(iscan_h) $(iutil_h) $(ivmspace_h) \
  $(bseq_h) $(btoken_h) $(dstack_h) $(ostack_h) \
  $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

zbseq.$(OBJ): zbseq.c $(OP) \
  $(ialloc_h) $(idict_h) $(isave_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h) \
  $(iname_h) $(ibnum_h) $(btoken_h) $(bseq_h)

# ---------------- User paths & insideness testing ---------------- #

upath_=zupath.$(OBJ) ibnum.$(OBJ)
upath.dev: $(INT_MAK) $(ECHOGS_XE) $(upath_)
	$(SETMOD) upath $(upath_)
	$(ADDMOD) upath -oper zupath_l2

zupath.$(OBJ): zupath.c $(OP) \
  $(idict_h) $(dstack_h) $(iutil_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gspath_h) $(gsstate_h) \
  $(gxfixed_h) $(gxdevice_h) $(gzpath_h) $(gzstate_h)

# -------- Additions common to Display PostScript and Level 2 -------- #

dpsand2.dev: $(INT_MAK) $(ECHOGS_XE) btoken.dev color.dev upath.dev dps2core.dev dps2read.dev
	$(SETMOD) dpsand2 -include btoken color upath dps2core dps2read

dps2read_=ibnum.$(OBJ) zchar2.$(OBJ) zdps1.$(OBJ) zvmem2.$(OBJ)
# Note that zvmem2 includes both Level 1 and Level 2 operators.
dps2read.dev: $(INT_MAK) $(ECHOGS_XE) $(dps2read_)
	$(SETMOD) dps2read $(dps2read_)
	$(ADDMOD) dps2read -oper zvmem2
	$(ADDMOD) dps2read -oper ireclaim_l2 zchar2_l2 zdps1_l2
	$(ADDMOD) dps2read -ps gs_dps1

ibnum.$(OBJ): ibnum.c $(GH) $(math__h) \
  $(errors_h) $(stream_h) $(ibnum_h)

zchar2.$(OBJ): zchar2.c $(OP) \
  $(gschar_h) $(gsmatrix_h) $(gsstruct_h) $(gxfixed_h) $(gxfont_h) \
  $(ialloc_h) $(ichar_h) $(estack_h) $(ifont_h) $(iname_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h)

zdps1.$(OBJ): zdps1.c $(OP) \
  $(gsmatrix_h) $(gspath_h) $(gspath2_h) $(gsstate_h) \
  $(ialloc_h) $(ivmspace_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h)

zvmem2.$(OBJ): zvmem2.c $(OP) \
  $(estack_h) $(ialloc_h) $(ivmspace_h) $(store_h)

# ---------------- Display PostScript ---------------- #

# We should include zcontext, but it isn't in good enough shape yet:
#	$(ADDMOD) dps -oper zcontext_l2
dps_=
dps.dev: $(INT_MAK) $(ECHOGS_XE) dpsand2.dev $(dps_)
	$(SETMOD) dps -include dpsand2
	$(ADDMOD) dps -obj $(dps_)

zcontext.$(OBJ): zcontext.c $(OP) \
  $(gsstruct_h) $(gsutil_h) \
  $(idict_h) $(istruct_h) $(dstack_h) $(estack_h) $(igstate_h) $(store_h)

# -------- Composite (PostScript Type 0) font support -------- #

compfont.dev: $(INT_MAK) $(ECHOGS_XE) psf0core.dev psf0read.dev
	$(SETMOD) compfont -include psf0core psf0read

psf0read_=zchar2.$(OBJ) zfont0.$(OBJ)
psf0read.dev: $(INT_MAK) $(ECHOGS_XE) $(psf0read_)
	$(SETMOD) psf0read $(psf0read_)
	$(ADDMOD) psf0read -oper zfont0 zchar2
	$(ADDMOD) psf0read -ps gs_type0

zfont0.$(OBJ): zfont0.c $(OP) \
  $(gsmatrix_h) $(gsstruct_h) $(gxdevice_h) $(gxfont_h) $(gxfont0_h) \
  $(ialloc_h) $(bfont_h) $(idict_h) $(igstate_h) $(store_h)

# ---------------- CID/CMap font support ---------------- #
#**************** NOT REAL YET.  DON'T USE. ****************#

cidfont.dev: $(INT_MAK) $(ECHOGS_XE) compfont.dev psf1read.dev
	$(SETMOD) cidfont -include compfont psf1read
	$(ADDMOD) cidfont -ps gs_cidfn

# ---------------- CIE color ---------------- #

cieread_=zcie.$(OBJ) zcrd.$(OBJ)
cie.dev: $(INT_MAK) $(ECHOGS_XE) $(cieread_) ciecore.dev
	$(SETMOD) cie $(cieread_)
	$(ADDMOD) cie -oper zcie_l2 zcrd_l2
	$(ADDMOD) cie -include ciecore

icie_h=icie.h

zcie.$(OBJ): zcie.c $(OP) $(math__h) $(memory__h) \
  $(gscspace_h) $(gscolor2_h) $(gscie_h) $(gsstruct_h) \
  $(ialloc_h) $(icie_h) $(idict_h) $(idparam_h) $(estack_h) \
  $(isave_h) $(igstate_h) $(ivmspace_h) $(store_h)

zcrd.$(OBJ): zcrd.c $(OP) $(math__h) \
  $(gscspace_h) $(gscolor2_h) $(gscie_h) $(gsstruct_h) \
  $(ialloc_h) $(icie_h) $(idict_h) $(idparam_h) $(estack_h) \
  $(isave_h) $(igstate_h) $(ivmspace_h) $(store_h)

# ---------------- Pattern color ---------------- #

pattern.dev: $(INT_MAK) $(ECHOGS_XE) patcore.dev patread.dev
	$(SETMOD) pattern -include patcore patread

patread_=zpcolor.$(OBJ)
patread.dev: $(INT_MAK) $(ECHOGS_XE) $(patread_)
	$(SETMOD) patread $(patread_)
	$(ADDMOD) patread -oper zpcolor_l2

zpcolor.$(OBJ): zpcolor.c $(OP) \
  $(gscolor_h) $(gscspace_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxcolor2_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) $(gxpcolor_h) \
  $(estack_h) $(ialloc_h) $(idict_h) $(idparam_h) $(igstate_h) $(istruct_h) \
  $(store_h)

# ---------------- Separation color ---------------- #

seprread_=zcssepr.$(OBJ)
sepr.dev: $(INT_MAK) $(ECHOGS_XE) $(seprread_) seprcore.dev
	$(SETMOD) sepr $(seprread_)
	$(ADDMOD) sepr -oper zcssepr_l2
	$(ADDMOD) sepr -include seprcore

zcssepr.$(OBJ): zcssepr.c $(OP) \
  $(gscolor_h) $(gsstruct_h) $(gxfixed_h) $(gxcolor2_h) $(gscspace_h) $(gsmatrix_h) \
  $(ialloc_h) $(icsmap_h) $(estack_h) $(igstate_h) $(ivmspace_h) $(store_h)

# ---------------- DCT filters ---------------- #
# The definitions for jpeg*.dev are in jpeg.mak.

dct.dev: $(INT_MAK) $(ECHOGS_XE) dcte.dev dctd.dev
	$(SETMOD) dct -include dcte dctd

# Common code

dctc_=sdctc.$(OBJ) sjpegc.$(OBJ) zfdctc.$(OBJ)

sdctc.$(OBJ): sdctc.c $(AK) $(stdio__h) \
  $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

sjpegc.$(OBJ): sjpegc.c $(AK) $(stdio__h) $(gx_h)\
  $(gserrors_h) $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

zfdctc.$(OBJ): zfdctc.c $(GH) $(errors_h) $(opcheck_h) \
  $(idict_h) $(idparam_h) $(imemory_h) \
  $(ipacked_h) $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jpeglib.h

# Encoding (compression)

dcte_=$(dctc_) sdcte.$(OBJ) sjpege.$(OBJ) zfdcte.$(OBJ)
dcte.dev: $(INT_MAK) $(ECHOGS_XE) jpege.dev $(dcte_)
	$(SETMOD) dcte -include jpege
	$(ADDMOD) dcte -obj $(dcte_)
	$(ADDMOD) dcte -oper zfdcte

sdcte.$(OBJ): sdcte.c $(AK) $(memory__h) $(stdio__h) $(gdebug_h)\
  $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jerror.h jpeglib.h

sjpege.$(OBJ): sjpege.c $(AK) $(stdio__h) $(gx_h)\
  $(gserrors_h) $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

zfdcte.$(OBJ): zfdcte.c $(OP) \
  $(idict_h) $(idparam_h) $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jpeglib.h

# Decoding (decompression)

dctd_=$(dctc_) sdctd.$(OBJ) sjpegd.$(OBJ) zfdctd.$(OBJ)
dctd.dev: $(INT_MAK) $(ECHOGS_XE) jpegd.dev $(dctd_)
	$(SETMOD) dctd -include jpegd
	$(ADDMOD) dctd -obj $(dctd_)
	$(ADDMOD) dctd -oper zfdctd

sdctd.$(OBJ): sdctd.c $(AK) $(memory__h) $(stdio__h) $(gdebug_h)\
  $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jerror.h jpeglib.h

sjpegd.$(OBJ): sjpegd.c $(AK) $(stdio__h) $(gx_h)\
  $(gserrors_h) $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h

zfdctd.$(OBJ): zfdctd.c $(OP) \
  $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jpeglib.h

# ================================ PDF ================================ #

# We need most of the Level 2 interpreter to do PDF, but not all of it.
# In fact, we don't even need all of a Level 1 interpreter.

# Because of the way the PDF encodings are defined, they must get loaded
# before we install the Level 2 resource machinery.
# On the other hand, the PDF .ps files must get loaded after
# level2dict is defined.
pdf.dev: $(INT_MAK) $(ECHOGS_XE) \
  psbase.dev color.dev dctd.dev dps2core.dev dps2read.dev \
  fdecode.dev type1.dev pdffonts.dev psl2core.dev psl2read.dev pdfread.dev
	$(SETMOD) pdf -include psbase color dctd dps2core dps2read
	$(ADDMOD) pdf -include fdecode type1
	$(ADDMOD) pdf -include pdffonts psl2core psl2read pdfread
	$(ADDMOD) pdf -emulator PDF

# Reader only

# The .dev file should be dependent on the encoding files....
pdffonts.dev: $(INT_MAK) $(ECHOGS_XE) \
  gs_mex_e.ps gs_mro_e.ps gs_pdf_e.ps gs_wan_e.ps
	$(SETMOD) pdffonts -ps gs_mex_e gs_mro_e gs_pdf_e gs_wan_e

# pdf_2ps must be the last .ps file loaded.
pdfread.dev: $(INT_MAK) $(ECHOGS_XE)
	$(ADDMOD) pdfread -ps gs_pdf pdf_base pdf_draw pdf_font pdf_main pdf_2ps

# ============================= Main program ============================== #

gsmain.$(OBJ): gsmain.c $(GH) \
  $(gp_h) $(gslib_h) $(gsmatrix_h) $(gxdevice_h) \
  $(dstack_h) $(errors_h) $(estack_h) $(files_h) \
  $(ialloc_h) $(idebug_h) $(idict_h) $(iname_h) $(interp_h) \
  $(isave_h) $(iscan_h) $(ivmspace_h) \
  $(main_h) $(oper_h) $(ostack_h) $(sfilter_h) $(store_h) $(strimpl_h)

# Interpreter main program

gs.$(OBJ): gs.c $(GH) $(ctype__h) \
  $(gscdefs_h) $(gsdevice_h) $(gxdevice_h) $(gxdevmem_h) \
  $(errors_h) $(estack_h) $(files_h) \
  $(ialloc_h) $(interp_h) $(isave_h) $(iscan_h) $(iutil_h) $(ivmspace_h) \
  $(main_h) $(ostack_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

interp.$(OBJ): interp.c $(GH) $(memory__h) $(string__h) \
  $(dstack_h) $(errors_h) $(estack_h) $(files_h) \
  $(ialloc_h) $(iastruct_h) $(inamedef_h) $(idict_h) $(interp_h) $(ipacked_h) \
  $(iscan_h) $(isave_h) $(istack_h) $(iutil_h) $(ivmspace_h) \
  $(oper_h) $(ostack_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)
	$(CCINT) interp.c

ireclaim.$(OBJ): ireclaim.c $(GH) \
  $(errors_h) $(gsstruct_h) $(iastate_h) $(opdef_h) $(store_h) \
  $(dstack_h) $(estack_h) $(ostack_h)
