#define NO_PTRACE_H

#include <i386/nm-i386v.h>

#define TARGET_HAS_HARDWARE_WATCHPOINTS

#define TARGET_CAN_USE_HARDWARE_WATCHPOINT(type, cnt, ot) 1

/* After a watchpoint trap, the PC points to the instruction after
   the one that caused the trap.  Therefore we don't need to step over it.
   But we do need to reset the status register to avoid another trap.  */
#define HAVE_CONTINUABLE_WATCHPOINT

#define STOPPED_BY_WATCHPOINT(W)  \
  go32_stopped_by_watchpoint (inferior_pid)

/* Use these macros for watchpoint insertion/removal.  */

#define target_insert_watchpoint(addr, len, type)  \
  go32_insert_watchpoint (inferior_pid, addr, len, 2)

#define target_remove_watchpoint(addr, len, type)  \
  go32_remove_watchpoint (inferior_pid, addr, len)


#define target_insert_hw_breakpoint(addr, shadow)  \
  go32_insert_hw_breakpoint(addr, shadow)
  
#define target_remove_hw_breakpoint(addr, shadow)  \
  go32_remove_hw_breakpoint(addr, shadow)

#define DECR_PC_AFTER_HW_BREAK 0
