{ -------------------------------------------------------------------------------------}
{ A "Fileicon Extension to TImage" unit for Delphi32.                                  }
{ Copyright 1996, Patrick Brisacier.  All Rights Reserved.                             }
{ This component can be freely used and distributed in commercial and private          }
{ environments, provided this notice is not modified in any way.                       }
{ -------------------------------------------------------------------------------------}
{ Feel free to contact me if you have any questions, comments or suggestions at        }
{ PBrisacier@mail.dotcom.fr (Patrick Brisacier)                                        }
{ -------------------------------------------------------------------------------------}
{ Date last modified:  08/07/96                                                        }
{ -------------------------------------------------------------------------------------}

{ -------------------------------------------------------------------------------------}
{ TFileIndexIcon v1.00                                                                 }
{ -------------------------------------------------------------------------------------}
{ Description:                                                                         }
{   A unit that extends the capacity of the TImage component to show icons             }
{   extracted from a file.                                                             }
{                                                                                      }
{ See example contained in example.zip file for more details.                          }
{ -------------------------------------------------------------------------------------}
{ Revision History:                                                                    }
{ 1.00:  + Initial release                                                             }
{ -------------------------------------------------------------------------------------}

unit FIdxIcon;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TFileIndexIcon = class(TIcon)
  private
    { Dclarations prives }
    fFileName:String;
    fIconIndex:Integer;
    fNumberOfIcons:Integer;
    procedure SetFileName(value:String);
    procedure SetIconIndex(value:Integer);
    procedure LoadIcon;
    procedure FreeIcon;
    procedure ReadIcon;
  protected
    { Dclarations protges }
  public
    { Dclarations publiques }
  constructor create;override;
  published
    { Dclarations publies }
    property FileName:String read fFileName write SetFileName;
    property IconIndex:Integer read fIconIndex write SetIconIndex default -1;
    property NumberOfIcons:Integer read fNumberOfIcons default -1;
  end;


implementation

uses ShellAPI;

procedure TFileIndexIcon.SetFileName(value:String);
begin
  if FFileName <> Value then begin
    FFileName := Value;
    LoadIcon;
  end;
end;

procedure TFileIndexIcon.SetIconIndex(value:Integer);
begin
  if (FIconIndex <> Value) and (FNumberOfIcons <> -1) then begin
    if Value < 0 then Value := 0;
    if Value >= FNumberOfIcons then Value := FNumberOfIcons - 1;
    FIconIndex := Value;
    ReleaseHandle;
    ReadIcon;
  end;
end;

procedure TFileIndexIcon.LoadIcon;
var
  Buff: array[0..255] of char;
begin
  FreeIcon;
  if FileExists(FFileName) then begin
    FNumberOfIcons := ExtractIcon(hInstance, StrPCopy(Buff, FFileName), -1);
    if FNumberOfIcons = 0 then begin
      FNumberOfIcons := -1;
      IconIndex := -1;
    end
    else begin
      IconIndex := 0;
      ReadIcon;
    end;
  end;
end;

procedure TFileIndexIcon.FreeIcon;
begin
  ReleaseHandle;
  FNumberOfIcons := -1;
end;

procedure TFileIndexIcon.ReadIcon;
var
  Buff: array[0..255] of char;
begin
    Handle := ExtractIcon(hInstance, StrPCopy(Buff, FFileName), FIconIndex);
end;

constructor TFileIndexIcon.create;
begin
  inherited create;
  FIconIndex := -1;
  FNumberOfIcons := -1;
end;

end.
