/*---------------------------------------------------------------------------*/
/* EWDLL.H - Borland C++ 4.0 - Embedded Window API Header File               */
/* Copyright (C) 1994 by R&R Engineering - All Rights Reserved               */
/*                                                                           */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*                                                                           */
/*  This library is free software; you can redistribute it and/or modify it  */
/*  under the terms of the GNU Library General Public License as published   */
/*  by the Free Software Foundation; either version 2 of the License, or     */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This library is distributed in the hope that it will be useful, but      */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of               */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        */
/*  Library General Public License for more details.                         */
/*                                                                           */
/*  You should have received a copy of the GNU Library General Public        */
/*  License along with this library; if not, write to the Free Software      */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#ifndef __EWM_H
#define __EWM_H

// Define messages specific to embedded window DLLs
#define EWM_RENDER     0x706A
#define EWM_QUERYSIZE  0x706B
#define EWM_ASKPALETTE 0x706C

// Define the CREATEINFO structure passed in CREATESTRUCT
typedef struct {
   short  idMajVersion;
   short  idMinVersion;
   LPSTR  lpstrFileName;
   LPSTR  lpstrAuthorData;
   HANDLE hfs;
   DWORD  coForeground;
   DWORD  coBackground;
} CREATEINFO;

// Define the RENDERINFO structure passed in the EWM_RENDER message
typedef struct {
   RECT rc;
   HDC  hdc;
} RENDERINFO;

// Message crackers for the EWM messages (16-bit versions)
#define HANDLE_EWM_RENDER( hWnd, wParam, lParam, fn ) \
        ((LRESULT)(fn)( (hWnd), (wParam), (RENDERINFO*)(lParam) ))
#define HANDLE_EWM_QUERYSIZE( hWnd, wParam, lParam, fn ) \
        ((fn)( (hWnd), (HDC)(wParam), (POINT*)(lParam) ))
#define HANDLE_EWM_ASKPALETTE( hWnd, wParam, lParam, fn ) \
        ((LRESULT)(fn)( (hWnd) ))

#endif
