/***************************************************************************
*   TESTUTIL.H                                                             *
*   HEADER FOR TESTUTIL                                                    *
*   OS:      DOS                                                           *
*   VERSION: 1.0                                                           *
*   DATE:    11/18/91                                                      *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
*   Compiles under Borland C++ 2.0, Turbo C 2.0, and MSC 6.00A.            *
*                                                                          *
*   Header file for TESTUTIL module.                                       *
*                                                                          *
***************************************************************************/

#ifndef TESTUTIL_H

#define TESTUTIL_H

/*
** system includes <>
*/

/*
** custom includes ""
*/

/*
** local #defines
*/

/* MSC does not have a MK_FP() macro. Define it if it doesn't exist. */
#ifndef MK_FP
#define MK_FP(seg,off)   (void far *)((((long)(seg)) << 16) | ((long)(off)))
#endif

/*
** define ASM to be the appropriate keyword for in-line assembly according
** to the compiler.
*/
#ifdef __TURBOC__
#define ASM              asm
#else
#define ASM              _asm
#endif

/*
** Define FMEMCMP and FMEMSET according to whether library functions
** are present or not.
*/
#ifndef NO_FFUNC

#define FMEMCMP          _fmemcmp
#define FMEMSET          _fmemset

#else

#define FMEMCMP          Fmemcmp
#define FMEMSET          Fmemset

#endif


/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

/*
** global variables
*/

/*
** function prototypes
*/

extern int farmemcheck(unsigned char far *buffer, unsigned int len,
                                                      unsigned char checkchar);
extern int lfarmemcheck(unsigned char far *buffer, unsigned long len,
                                                      unsigned char checkchar);
extern int LFMEMCMP(void far *buf1, void far *buf2, unsigned long n);
extern void LFMEMSET(void far *s, int c, unsigned long n);
extern void farincwordfill(unsigned char far *buffer, unsigned int len,
                                                           unsigned int start);
extern void lfarincwordfill(unsigned char far *buffer, unsigned long len,
                                                           unsigned int start);
extern int farincwordcheck(unsigned char far *buffer, unsigned int len,
                                                           unsigned int start);
extern int lfarincwordcheck(unsigned char far *buffer, unsigned long len,
                                                           unsigned int start);

extern unsigned long get_tick(void);
unsigned char huge *normptr(unsigned char far *norm);

extern int Fmemcmp(void far *buf1, void far *buf2, unsigned int n);
extern void Fmemset(void far *s, int c, unsigned int n);

#endif

