#include <stdio.h>
#include <xlib.h>
#define som _emit 0x66               /*Switch operand mode*/
#define sam _emit 0x67               /*Switch address mode*/
long __far getextmem(long address);

int goterr = 0;                      /*Error flag*/

void main(void)
{
  long l, xaddress;

  l = INITXLIB();                    /*Initialize XLIB*/
  if(l != 0)                         /*See if an error occurred*/
  {
    printf("Library initialization error:  %lX\n",l);
    return;
  }

  xaddress = 0x100000;               /*Read first dword in 2ond meg*/
  l = getextmem(xaddress);           /*See if an error occurred*/
  if(goterr != 0)
  {
    printf("Inline mode-switch error:  %lX\n",l);
    return;
  }
  printf("[%lX] = %lX\n",xaddress,l);
}

long __far getextmem(long address)
{
  __asm
  {
    som                             ;mov  eax,[bp+6]
    mov       ax,[bp+6]             ;  ""
    call      INLINEPM              ;Switch to 16-bit protected mode
    jc        error                 ;Error code in ax
    mov       ds,es:FLATDSEL        ;Switch to flat data model
    sam                             ;push dword ptr [eax]
    som                             ;  ""
    _emit     0ffh                  ;  ""
    _emit     030h                  ;  ""
    pop       ax                    ;Return address contents in dx:ax
    pop       dx
    call      es:INLINERMPTR        ;Switch back to real mode by calling
    jmp       done                  ;INLINERM indirect.  A direct call would
                                    ;load cs with an invalid value.
error:
    xor       dx,dx                 ;Return error code in dx:ax
    inc       goterr                ;Set error flag
done:
  }
}
