'  This is the first example program in EASYX.DOC translated to Microsoft
'Basic version 7.0.  The program should be linked with EASYX.LIB.  When
'developing code in the Microsoft BASIC development environment (QBX), a 
'quick library will also be needed.  See README.DOC for information about
'constructing quick libraries.  Initialize the environment with the quick
'library.

'Declarations of all functions in EASYX.LIB which are usable by BASIC. 
'XLIB.LIB is contained within EASYX.LIB; hence, certain of the following
'functions are actually XLIB procedures.  These are explained in XLIB.DOC.
DECLARE FUNCTION XLIBMEMREQ& ()    'XLIB procedure
DECLARE FUNCTION VCPIMEMREQ& ()    'XLIB procedure
DECLARE FUNCTION DPMIMEMREQ& ()    'XLIB procedure
DECLARE FUNCTION INITXLIB& ()      'XLIB procedure
DECLARE FUNCTION XLIBCONFIG% ()    'XLIB procedure
DECLARE FUNCTION XMALLOC& (BYVAL NOBYTES AS LONG, SEG ADDRESS AS LONG, SEG SIZE AS LONG, SEG HANDLE AS LONG)
DECLARE FUNCTION XFREE& (BYVAL HANDLE AS LONG)
DECLARE FUNCTION MAPIOMEM& (BYVAL PHYSADDRESS AS LONG, BYVAL SIZE AS LONG, SEG LOGADDRESS AS LONG)
DECLARE FUNCTION LINADR& (SEG VARIABLE AS ANY)
DECLARE SUB MOVMEM (BYVAL DESTADR AS LONG, BYVAL SOURCEADR AS LONG, BYVAL NOBYTES AS LONG)
DECLARE SUB XFCREATE (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFOPEN (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFCLOSE (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFLOAD (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFSAVE (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFREAD (SEG CONTROLBLOCK AS ANY)
DECLARE SUB XFWRITE (SEG CONTROLBLOCK AS ANY)

'  EASYX procedures should not be called until XLIB has been initialized
'by calling the XLIB function INITXLIB.  This is done in code that follows.
'BASIC complicates this process because it allocates all available DOS memory
'leaving none for the library.  This situation is corrected by forcing BASIC
'to release some memory with its SETMEM function.  The memory should be
'released before calling INITXLIB.  It should also be released before
'declaring any far data in BASIC.  The XLIB function XLIBMEMREQ tells BASIC
'how many bytes to release.
'  XLIBMEMREQ can possibly fail.  If so, then it will return a negative
'number.  Mask the sign bit of this number to obtain an XLIB error code which
'explains the failure.  See XLIB.DOC for explanation of error codes.
'  If working in the Microsoft BASIC program development environment (QBX),
'then XLIB needs to be initialized only once.  Hence the foregoing code first
'calls XLIBCONFIG to determine if XLIB has already been initialized.  This
'function will return a nonzero value if initialization is complete.
IF XLIBCONFIG = 0 THEN               'See if XLIB already initialized
  TEMP& = XLIBMEMREQ                 'See how much memory to release for XLIB
  IF TEMP& >= 0& THEN                'TEMP& will be negative if error
    IF TEMP& > 0 THEN TEMP& = SETMEM(-TEMP& - 16&)   'Release extra paragraph
    TEMP& = INITXLIB                 'XLIB error code returned in TEMP&
  ELSE
    TEMP& = TEMP& AND &H7FFFFFFF     'Mask sign bit to leave error code only
  END IF
  IF TEMP& <> 0 THEN
    PRINT "Library initialization error:  "; HEX$(TEMP&)
    END
  END IF
END IF

DIM ERRCODE AS LONG, NOBYTES AS LONG, XADDRESS AS LONG, XSIZE AS LONG
DIM XHANDLE AS LONG, BUFFERADDRESS AS LONG
DIM BUFFER(1023) AS LONG        '4k buffer

NOBYTES = &H10000               'Allocate 64k of extended memory
ERRCODE = XMALLOC(NOBYTES, XADDRESS, XSIZE, XHANDLE)
IF ERRCODE <> 0 THEN
  PRINT "Memory allocation error:  "; HEX$(ERRCODE)
  END
END IF

BUFFERADDRESS = LINADR(BUFFER)                'Get linear address of buffer
CALL MOVMEM(XADDRESS, BUFFERADDRESS, 4096)    'Transfer buffer to extended
CALL MOVMEM(BUFFERADDRESS, XADDRESS, 4096)    'Transfer extended to buffer

ERRCODE = XFREE(XHANDLE)                      'Release the extended memory
IF ERRCODE <> 0 THEN PRINT "Memory release error:  "; HEX$(ERRCODE)

END

