unit Toolbox;
interface
uses WinTypes;

const
  GHND       = (GMEM_MOVEABLE or GMEM_ZEROINIT or GMEM_DDESHARE);

  DLL_TBPRO2 = $01;
  DLL_TBPRO3 = $02;
  DLL_TBPRO4 = $04;
  DLL_TBPRO5 = $08;
  DLL_TBPRO6 = $10;

  DRIVELEN =   3;                 (* max length of drive in file name *)
  DIRLEN   = 130;                 (* max length of directory *)
  NAMELEN  =  10;                 (* max length of name in file name *)
  EXTLEN   =   5;                 (* max length of extn in file name *)
  FILELEN  = (NAMELEN+EXTLEN);    (* max length of file name *)
  PATHLEN  = (DRIVELEN+DIRLEN+FILELEN);(* max full file name path *)

  ERRLEN     = 100;               (* ERROR length *)
  INTLEN     =   7;               (* max integer string length *)
  LONGLEN    =  11;               (* max long string length *)
  DATELEN    =  12;               (* Length of date string: dd-mmm-[yy]yy *)
  LIBVERSION =  10;               (* LIBRARY VERSION *)

type
  PWinDevice = ^TWinDevice;
  TWinDevice = record
    DeviceName : array[0..50] of Char;
    DriverName : array[0..9]  of Char;
    Port       : array[0..40] of Char;
  end;

{ Passed to date functions to set date parameters                        }
{ Structures for holding the actual values for the Date and Time values: }

  PDate = ^TDate;
  TDate = record
    nDay, nMonth, nYear: Integer
  end;

  PTime = ^TTime;
  TTime = record
    nHour, nMinute, nSecond: Integer
  end;

  PDateFormat = ^TDateFormat;
  TDateFormat = record
    bCentury   : Boolean;
    cSeparator : Char;
    nFormat    : Integer;
    bSpin      : Boolean
  end;

  PTimeFormat = ^TTimeFormat;
  TTimeFormat = record
    b24Hour, bSeconds : Boolean;
    cSeparator        : Char;
    bSpin             : Boolean
  end;

  PFloatFormat = ^TFloatFormat;
  TFloatFormat = record
    cCurrencySign,
    cDecimalSign,
    cSeparator     : Char
  end;


{ DATE FORMAT IDENTIFIERS }
const
  IDF_DDMONYY =   100;
  IDF_DDMMYY  =   101;
  IDF_MMDDYY  =   102;
  IDF_YYMMDD  =   103;


function DateAddDays      (var ADate: TDate; APeriode: Longint): PDate;
function DateDMYToJulian  (var ADate: TDate)                     : Longint;
function DateDMYToString  (var ADate: TDate; ADateStr: PChar; var aFormat: TDateFormat) : PChar;
function DateGetFormat    (AWnd: hWnd; var aFormat: TDateFormat) : Boolean;
function DateGetWeekday   (var aDate: TDate; AWeekDay: PChar)    : PChar;
function DateIntIsValid   (var aDate: TDate) : Boolean;
function DateJulianToDMY  (aPeriode: Longint; var aDate: TDate)  : PDate;
function DateSetFormat    (aWnd: hWnd; var aFormat: TDateFormat) : Boolean;
function DateSetRange     (AWnd: hWnd; var aMin, aMax: TDate)      : Boolean;
function DateStringIsValid(aStr: PChar; var aFormat: TDateFormat): Boolean;
function DateStringToDMY  (aStr: PChar; var aDate: TDate; var aFormat: TDateFormat): PDate;
function DateSubtractDates(var FromDate, ToDate: TDate)          : Longint;
{
function DateGetDlgItemFormat(aDlg: hWnd; anID: Integer; var aDateFmt: TDateFormat): Boolean;
function DateSetDlgItemFormat(aDlg: hWnd; anID: Integer; var aDateFmt: TDateFormat): Boolean;
function DateSetDlgItemRange (aDlg: hWnd; anID: Integer; var Min: TDate; var Max: TDate): Boolean;
}

function PopupCalender      (aTBDateWnd: hWnd): Boolean;

function TimeGetFormat      (aWnd: hWnd; var aTimeFormat: TTimeFormat): Boolean;
function TimeHMSToSeconds   (var Time: TTime): Longint;
function TimeHMSToString    (var aTime: TTime; aTimeStr: PChar; var aTimeFormat: TTimeFormat): PChar;
function TimeSecondsToHMS   (Seconds: Longint; var aTime: TTime): PTime;
function TimeSetFormat      (aWnd: hWnd; var aTimeFormat: TTimeFormat): Boolean;
function TimeSetRange       (aWnd: hWnd; var aMin: TTime; var aMax: TTime): Boolean;
function TimeStringIsValid  (aTimeStr: PChar; var aTimeFormat: TTimeFormat): Boolean;
function TimeStringToHMS    (aTimeStr: PChar; var aTime: TTime; var aTimeFormat: TTimeFormat): PTime;
procedure TimeGetCurrentTime(aTimeStr: PChar; var aTimeFormat: TTimeFormat);
{ TimeGetDlgItemFormat - TimeSetDlgItemRange }

function IntSetRange   (aWnd: hWnd; lMin, lMax: Longint): Boolean;
function IntGetRange   (aWnd: hWnd; var lMin, lMax: Longint): Boolean;
function IntSetValue   (aWnd: hWnd; l: Longint): Boolean;
function IntGetValue   (aWnd: hWnd; var l: Longint): Boolean;
function IntSetMask    (aWnd: hWnd; aMask: PChar): Boolean;
function IntSetSpin    (aWnd: hWnd; aSpin, aSpinWrap: Boolean; aSpinInc: Longint): Boolean;
function IntGetSpin    (aWnd: hWnd; var SpinWrap: Boolean; var SpinInc: Longint): Boolean;

{ IntSetDlgItemRange - IntGetDlgItemValue }

function FloatGetValue (aWnd: hWnd; var aDouble: Double): Boolean;
function FloatSetValue (aWnd: hWnd; aDouble: Double): Boolean;
function FloatSetRange (aWnd: hWnd; aMin, aMax: Double): Boolean;
function FloatGetRange (aWnd: hWnd; var aMin, aMax: Double): Boolean;
function FloatSetFormat(aWnd: hWnd; var ff: TFloatFormat): Boolean;
function FloatGetFormat(aWnd: hWnd; var ff: TFloatFormat): Boolean;
function FloatSetStyle(aWnd: hWnd; aStyle: Longint): Boolean;
function FloatFormatString(aVal: Double; szBuffer: PChar; fSeparator, fMoney: Boolean;
		           iDecimalPlaces: Integer): PChar;
function FloatFormatString2(aVal: Double; szBuffer: PChar; var lpFromat: TFloatFormat;
                            iDecimalPlaces: Integer): PChar;
function FloatSetMask (aWnd: hWnd; szMaske: PChar): Boolean;
{ FloatSetDlgItemRange - FloatSetDlgItemValue }

function GetToolBoxGlobal (nID: Integer; var lValue: Longint): Boolean;
function SetToolBoxGlobal (nID: Integer;     lValue: Longint): Boolean;
{
function DlgCoordToPixelX(x: Integer): Integer;
function DlgCoordToPixelY(y: Integer): Integer;
}

const
  TBG_CURRENTDATETIME = 1;
  TBG_POPUPCALENDAR   = 2;
  TBG_CLEARFIELD      = 3;

  ERR_AUTO            = 100;

{$IFNDEF DRV_NOPATTERN}
{ function prototypes for Pattern }
{$ENDIF}

{$IFNDEF DRV_NOSYS}
const
  FI_NORMAL      = $00;    (* Normal file - No read/write restrictions *)
  FI_RDONLY      = $01;    (* Read only file *)
  FI_HIDDEN      = $02;    (* Hidden file *)
  FI_SYSTEM      = $04;    (* System file *)
  FI_VOLID       = $08;    (* Volume ID file *)
  FI_SUBDIR      = $10;    (* Subdirectory *)
  FI_ARCH        = $20;    (* Archive file *)
  FI_EXCLUSIVE   = $80;    (* only those selected by above attributes *)

type
  PFileInfo = ^TFileInfo;
  TFileInfo = record
    reserved : array[0..20] of Char;
    attrib   : Char;
    time,
    date     : Integer;
    fileSize : Longint;
    fileName : array[0..12] of Char
  end;

  PDiskInfo = ^TDiskInfo;
  TDiskInfo = record
    bytesPerSector,                { Bytes in a Sector (normally 512) }
    clustersPerDrive,              { Clusters per Device              }
    sectorsPerCluster,             { Sectors in a Cluster             }
    avaliableClusters: Word        { Number of free Clusters          }
  end;

  PParamBlk = ^TParamBlk;
  TParamBlk = record
    wSegmentEnvBlock,              { segment pointer to environment block }
    wOffSetCmdLine,                { offset of command line               }
    wSegmentCmdLine,               { segment of command line              }
    wOffSetFCB1,                   { etc.                                 }
    wSegmentFCB1,
    wOffSetFCB2,
    wSegmentFCB2     : Word
  end;

{**********************************************
* System and File-Related Function Prototypes
**********************************************}

function GetFileString     (lpszKey, lpszDefault, lpReturn: PChar; nSize: Integer;
                            lpszFile: PChar): Integer;
function SysCreateSubDir   (szNewSubDir: PChar): Integer;
function SysDeleteFile     (szExistingFile: PChar): Integer;
function SysDeleteSubDir   (szExistingDir : PChar): Integer;
function SysDiskBytesFree  (iDrive: Integer): Longint;
function SysDiskBytesTotal (iDrive: Integer): Longint;
function SysDiskInfo       (iDrive: Integer; var di: TDiskInfo): Boolean;
function SysExecPgm        (szPath: PChar; var aParam: TParamBlk): Integer;
function SysFileSpec       (lpszPattern, lpszFileName: PChar): Boolean;
{ SysFindFirst - SysGetFileAttr }

{$ENDIF}

(* auto messagebox functions *)
const
  DRVMSG_BEEP = $01;
  DRVMSG_LOG  = $10;

function InitToolbox     (hInst: THandle): Boolean;
function ToolboxLoadDlls (dDlls: Integer): Boolean;
procedure ToolboxFreeDlls(dDlls: Integer);
procedure ToolboxFreeAllDlls;
function GetToolboxVersion: Word;

(* HOUR GLASS FUNCTIONS *)
function HourGlassCount: Word;
procedure HourGlassOff;
procedure HourGlassOn;

(* STRING FUNCTIONS *)
{StrCat - LongToString}
function StrRTrim(aString: PChar) : PChar;

(* CONVERSION FUNCTIONS *)
{ FloatToEString - StringToLong }

(* FILE FUNCTIONS *)
{ ErrorNo - FileGetDateTime }

(* LIST BOX FUNCTIONS *)
{ ListAddStr - ListSelectStr }

(* FAR POINTER MEMORY FUNCTIONS (+ ALLOCATION ) *)
{ MemCmp - MemiCmd }

(* huge POINTER MEMORY FUNCTIONS *)
{ MemHugeCmp - MemHugecCpy }

(* MESSAGE DISPLAY *)
{ Debug }
{ function _MsgDisp        (aWnd: hWnd; iId: Integer; var args: PChar): Integer; }
function MsgDoDisp       (lpMsg, lpTitle: PChar; iStyle: Integer; iFlags: Integer): Integer;
function MsgLoad         (aHnd: THandle; iId: Integer; lpMsg, lpTitle: PChar;
								  lpMFlags, lpIFlags: PInteger ): PChar;

(* misc.c *)
function DlgFileOpenOne  (aWnd: hWnd; lpszFileSpec, spszFile: PChar; iLength: Integer): Boolean;
function DlgFileOpenTwo  (aWnd: hWnd; lpszFileSpec, spszFile: PChar; iLength: Integer): Boolean;
function DlgFontSelect   (aWnd: hWnd; var LogFont: TLogFont; var FontType: Integer): Boolean;
function DlgPrinterSetup (aWnd: hWnd) : Boolean;
{ EnumFiles }
procedure ExitNow;
function FullMkDir       (lpPath: PChar): Integer;

function GaugeGetPos     (aWnd: hWnd; var aPos: Integer): Boolean;
function GaugeGetRange   (aWnd: hWnd; var aMin, aMax: Integer): Boolean;
function GaugeSetColors  (aWnd: hWnd; RGBBack, RGBPlate, RGBText, RGBFill: TColorRef): Boolean;
function GaugeSetPos     (aWnd: hWnd; iPos: Integer): Boolean;
function GaugeSetRange   (aWnd: hWnd; iMin, iMax: Integer): Boolean;
function GaugeSetTitle   (aWnd: hWnd; szTitle: PChar): PChar;
procedure GetChildSize   (aWnd: hWnd; var Rect: TRect);
{ MsgBox }
procedure MsgLineMenuHelp(aWnd: hWnd; iID: Word);
procedure MsgLinePaint   (aWnd: hWnd; aDC: hDC);
procedure MsgLineTextOut (aWnd: hWnd; lpText: PChar);
procedure OLRect         (aDC: hDC; lpRect: PRect);
procedure OLLine         (aDC: hDC; ia, ib, ic, id, ie: Integer);
function PrinterGetDC    : hDC;
function PrinterGetIC    : hDC;
function PrinterGetDetails(var WinDevice: TWinDevice): Boolean;
function RmTmp           : Integer;
function WinExecProg     (szPath, CmdLine: PChar; nCmdShow: Integer): Integer;

const

(* SORT *)
{ QuickSort - LinearFindHuge }

(* Listbox Notification Codes *)
  LBN_ESCAPE        = 30;       { the user pressed the escape key }
  LBN_RETURN        = 31;       { the user pressed the return key }

  LBN_TOPITEM       = 1000;
  LBN_RBUTTONDBLCLK = 1001;     { our own notification            }
  LBN_MBUTTONDBLCLK = 1002;     { our own notification            }
  LBN_LBUTTONDBLCLK = 1003;     { our own notification            }

(* LB_DIR attributes *)
  LBDA_NORMAL       = $0000;
  LBDA_READONLY     = $0001;
  LBDA_HIDDEN       = $0002;
  LBDA_SYSTEM       = $0004;
  LBDA_SUBDIR       = $0010;
  LBDA_ARCHIVE      = $0020;

{ Windows places the messages generated by DlgDirList in the application queue;
  otherwise sent directly to the dialog function                                 }
  LBDA_DIRFLAG      = $2000;
  LBDA_DRIVE        = $4000;
  LBDA_EXCLUSIVE    = $8000;

  EM_VALIDATE       = (EM_MSGMAX + 1);
  EM_GETCARETPOS    = (EM_MSGMAX + 2);
  EM_SETCARETPOS    = (EM_MSGMAX + 3);
  EM_CARETPOS       = (EM_MSGMAX + 4);
  EM_SETRANGE       = (EM_MSGMAX + 5);
  EM_SETFORMAT      = (EM_MSGMAX + 6);
  EM_GETFORMAT      = (EM_MSGMAX + 7);
  EPM_GETMASK       = (EM_MSGMAX + 8);
  EPM_SETMASK       = (EM_MSGMAX + 9);
  EPM_SETCALLBACK   = (EM_MSGMAX + 10);
  EM_TOOLBOXUSERMAX = (EPM_SETCALLBACK);

  EN_INVALIDDATA    = $1000;
  EN_FIELDNONEMPTY  = $1001;
  EN_FIELDEMPTY     = $1002;
  EN_INVALIDSETTEXT = $1003;
  EN_INVALIDCHAR    = $2003;

  LB_SETSELECTIONMODE = (LB_MSGMAX+0);
  LB_GETTEXTEXTENT    = (LB_MSGMAX+1);
  LB_GETDBLCLKHPOS    = (LB_MSGMAX+2);
  LB_GETDBLCLKITEM    = (LB_MSGMAX+3);

{****************
* Gauge control
****************}

  GS_TITLE        = $00000001;
  GS_VALUE        = $00000010;

{*****************
* General styles
*****************}

  ES_STATIC      = $0200;
  ES_OVERSTRIKE  = $0800;

{**************
* Time fields
**************}

  TS_12HOUR      = $1000;
  TS_24HOUR      = $2000;
  TS_SECONDS     = $4000;
  TS_SPIN        = $8000;

{**************
* Date fields
**************}

  DS_SPIN        = $0040;
  DS_DEFCENTURY  = $0004;
  DS_CENTURY     = $1000;
  DS_DDMONYY     = $2000;
  DS_DDMMYY      = $4000;
  DS_MMDDYY      = $6000;
  DS_YYMMDD      = $8000;

{****************
* Integer Style
****************}

  IS_SPIN        = $1000;
  IS_SPINWRAP    = $2000;

{**************
* Float Style
**************}

  FS_MONEY       = $1000;
  FS_SEPARATOR   = $2000;

{********************************
* Define WM_CTLCOLOR parameters
********************************}

  CTLCOLOR_TBEDIT     = (101);
  CTLCOLOR_TBPROGRESS = (102);
  CTLCOLOR_TBSPINNUM  = (103);
  CTLCOLOR_TBTIMESPIN = (104);
  CTLCOLOR_TBDATESPIN = (105);
  CTLCOLOR_TBVIEWPICT = (106);

{**********
* DirFile
**********}

  DFM_GETSIZE          = (WM_USER + 30);
  DFM_SETSIZE          = (WM_USER + 31);

  DFN_SETFOCUS         = 30;
  DFN_KILLFOCUS        = 31;
  DFN_SIZECHANGE       = 32;

  DFS_DIRRIGHT            = $0001;
  DFS_NOUPDATEFILELIST    = $0002;
  DFS_CLOSEALLCHILDREN    = $0004;
  DFS_OPENROOTCHILDREN    = $0008;
  DFS_FOLDEROPENDIR       = $0010;
  DFS_FILELIST_NOSHOWICON = $0020;
  DFS_FILELIST_VERT       = $0040;
  DFS_FILELIST_HORZ       = $0080;
  DFS_FILELIST_SHOW_SIZE  = $0100;
  DFS_FILELIST_SHOW_DATE  = $0200;
  DFS_FILELIST_SHOW_TIME  = $0400;

{**********
* DirList
**********}

  DLM_SETDRIVE              = (WM_USER + 0);
  DLM_READDRIVE             = (WM_USER + 1);
  DLM_GETSELDIRENTRY        = (WM_USER + 2);
  DLM_GETSELDIR             = (WM_USER + 3);
  DLM_GETDIRCNT             = (WM_USER + 4);
  DLM_SETSELDIR             = (WM_USER + 5);
  DLM_SETCOLOR              = (WM_USER + 6);
  DLM_OPENCHILDREN          = (WM_USER + 7);
  DLM_GETCOLOR              = (WM_USER + 8);

  DLN_SETFOCUS              = 10;
  DLN_KILLFOCUS             = 11;
  DLN_SELCHANGE             = 12;
  DLN_DBLCLK                = 13;

  DLS_CLOSEALLCHILDREN      = $01;
  DLS_OPENROOTCHILDREN      = $02;
  DLS_FOLDEROPENDIR         = $04;

  DIRLIST_CHILDREN_OPENALL  = 0;
  DIRLIST_CHILDREN_OPENROOT = 1;
  DIRLIST_CHILDREN_CLOSEALL = 2;
  DIRLIST_CHILDREN_OPENCUR  = 3;
  DIRLIST_CHILDREN_CLOSECUR = 4;
  DIRLIST_CHILDREN_FLIPCUR  = 5;

type
  PDirListColor = ^TDirListColor;
  TDirListColor = record
     ColorBack,
     ColorText,
     ColorLines,
     ColorIconShadow,
     ColorIconBack,
     ColorIconFore : TColorRef
  end;



{************
* DriveList
************}

const
  DVLM_GETDRIVECOUNT        = (WM_USER + 0);
  DVLM_GETSELDRIVE          = (WM_USER + 1);
  DVLM_SETSELDRIVE          = (WM_USER + 2);
  DVLM_SETCOLOR             = (WM_USER + 3);
  DVLM_GETCOLOR             = (WM_USER + 4);

  DVLN_SETFOCUS             = 10;     { Used Internally }
  DVLN_KILLFOCUS            = 11;
  DVLN_SELCHANGE            = 12;     { Used Internally }
  DVLN_DBLCLK               = 13;
  DVLN_DRIVECHANGE          = 14;

  DVLS_DRIVELIST_FIXED      = $01;
  DVLS_DRIVELIST_REMOTE     = $02;
  DVLS_DRIVELIST_REMOVABLE  = $04;
  DVLS_DRIVELIST_ALL        = $07;
  DVLS_DRIVELIST_LISTBOX    = $08;
  DVLS_DRIVELIST_COMBOBOX   = $10;
  DVLS_DRIVELIST_NOSHOWICON = $20;

type
  PDriveListColor = ^TDriveListColor;
  TDriveListColor = record
    ColorBack,
    ColorText,
    ColorIconShadowBright,
    ColorIconShadowDark,
    ColorIconBack,
    ColorIconFore,
    ColorIconLight  : TColorRef;
  end;


{***********
* FileList
***********}

const
  FLM_SETDIRECTORY        = (WM_USER + 10);   { Used Internally }
  FLM_READDIRECTORY       = (WM_USER + 11);
  FLM_SETVIEWTYPE         = (WM_USER + 12);
  FLM_SETSORTMETHOD       = (WM_USER + 13);
  FLM_SETSORTORDER        = (WM_USER + 14);
  FLM_SETCOLOR            = (WM_USER + 15);
  FLM_GETFILECOUNT        = (WM_USER + 16);
  FLM_GETSELFILE          = (WM_USER + 17);
  FLM_SETSELFILE          = (WM_USER + 18);
  FLM_SETFILESPEC         = (WM_USER + 19);
  FLM_GETCOLOR            = (WM_USER + 20);

  FLN_SETFOCUS            = 20;
  FLN_KILLFOCUS           = 21;
  FLN_SELCHANGE           = 22;
  FLN_DBLCLK              = 23;

  FLS_FILELIST_SORT_NONE  = $0001;
  FLS_FILELIST_SORT_NAME  = $0002;
  FLS_FILELIST_SORT_DATE  = $0004;
  FLS_FILELIST_SORT_SIZE  = $0008;
  FLS_FILELIST_SORT_EXT   = $0010;
  FLS_FILELIST_SORT_DESC  = $0020;
  FLS_FILELIST_NOSHOWICON = $0040;
  FLS_FILELIST_VERT       = $0080;
  FLS_FILELIST_HORZ       = $0100;
  FLS_FILELIST_SHOW_SIZE  = $0200;
  FLS_FILELIST_SHOW_DATE  = $0400;
  FLS_FILELIST_SHOW_TIME  = $0800;

  FILELIST_SORTORDER_ASC  = 0;
  FILELIST_SORTORDER_DESC = 1;

type
  PFileListColor = ^TFileListColor;
  TFileListColor = record
    ColorBack,
    ColorText,
    ColorIconShadow,
    ColorIconExeBack,
    ColorIconExeFore,
    ColorIconExeUpper,
    ColorIconDocBack,
    ColorIconDocFore,
    ColorIconDocUpper : TColorRef
  end;

{**********
* Imprint
**********}
const
  IS_IMPRINT_OUT            = $0001;
  IS_IMPRINT_IN             = $0002;
  IS_FRAME_OUT              = $0004;
  IS_FRAME_IN               = $0008;
  IS_INSIDEBORDER           = $0010;
  IS_OUTSIDEBORDER          = $0020;
  IS_GROUPBOX               = $0040;
  IS_CLEAR                  = $0080;
  IS_TEXTBOTTOM             = $0100;
  IS_TEXTCENTER             = $0200;
  IS_TEXTLEFT               = $0400;
  IS_TEXTRIGHT              = $0800;
  IS_TEXTTOP                = $1000;
  IS_TEXTVCENTER            = $2000;
  IS_TEXTBORDER             = $4000;

  IM_GETFRAMESIZE           = (WM_USER + 0);
  IM_GETLINECNT             = (WM_USER + 1);
  IM_GETLINESIZE            = (WM_USER + 2);
  IM_GETSHADOWSIZE          = (WM_USER + 3);
  IM_SETCOLOR               = (WM_USER + 4);
  IM_SETFRAMESIZE           = (WM_USER + 5);
  IM_SETLINECNT             = (WM_USER + 6);
  IM_SETLINESIZE            = (WM_USER + 7);
  IM_SETSHADOWSIZE          = (WM_USER + 8);
  IM_GETCOLOR               = (WM_USER + 9);

type
  PImprintColor = ^TImprintColor;
  TImprintColor = record
    Color,
    ColorFrame,
    ColorShadow,
    ColorHighlight,
    ColorInsideBorder,
    ColorOutsideBorder,
    ColorText,
    ColorLines          : TColorRef
  end;


{***********
* Progress
***********}

const
  PS_VERTICAL       = $01;
  PS_HORIZONTAL     = $02;
  PS_HIDEPERCENTAGE = $04;


  PM_GETRANGE       = (WM_USER + 0);
  PM_GETPOS         = (WM_USER + 1);
  PM_SETRANGE       = (WM_USER + 2);
  PM_SETPOS         = (WM_USER + 3);

{**********
* SpinBtn
**********}

  SBNS_UPARROW     = $01;
  SBNS_DOWNARROW   = $02;
  SBNS_UPDOWNARROW = $03;
  SBNS_HORIZONTAL  = $04;
  SBNS_VERTICAL    = $08;

{***********
* SuperBtn
***********}

  SBS_DEFPUSHBUTTON        = $0001;
  SBS_TEXTTOP_PICTBOT      = $0002;
  SBS_TEXTBOT_PICTTOP      = $0004;
  SBS_TEXTLEFT_PICTRIGHT   = $0008;
  SBS_TEXTRIGHT_PICTLEFT   = $0010;
  SBS_BTNFRAMEIN           = $0020;
  SBS_BTNFRAMEOUT          = $0040;
  SBS_PICTFRAMEIN          = $0080;
  SBS_PICTFRAMEOUT         = $0100;
  SBS_TEXTFRAMEIN          = $0200;
  SBS_TEXTFRAMEOUT         = $0400;
  SBS_NOINVERTFRAME        = $0800;
  SBS_TEXTICON             = $1000;
  SBS_TEXTBITMAP           = $2000;
  SBS_TEXTTEXT             = $4000;
  SBS_NOPOINTERFOCUS       = $8000;

  SBM_SETSTYLE             = BM_SETSTYLE;
  SBM_SETCOLOR             = (WM_USER + 50);
  SBM_SETPICT              = (WM_USER + 51);
  SBM_SETPICT_DISABLED     = (WM_USER + 52);
  SBM_SETPICT_BTNDOWN      = (WM_USER + 53);
  SBM_GETCOLOR             = (WM_USER + 54);
  SBM_SETBUTTONTYPE        = (WM_USER + 55); { Internal Use }
  SBM_GETBUTTONSTATE       = (WM_USER + 56); { Internal Use }
  SBM_SETBUTTONSTATE       = (WM_USER + 57); { Internal Use }
  SBM_SETSHADOWSIZE        = (WM_USER + 58); { Internal Use }
  SBM_GETSHADOWSIZE        = (WM_USER + 59); { Internal Use }

  SBN_CLICKED              = BN_CLICKED;

  SUPERBTN_UP              = 0;
  SUPERBTN_DOWN            = 1;

  SUPERBTN_TYPE_NORMAL     = 0;
  SUPERBTN_TYPE_2STATE     = 1;

  SUPERBTN_PICT_NONE       = $00;
  SUPERBTN_PICT_ICON       = $01;
  SUPERBTN_PICT_BITMAP     = $02;
  SUPERBTN_PICT_HANDLE     = $04;

type
  PSuperBtnColor = ^TSuperBtnColor;
  TSuperBtnColor = record
    Color,
    ColorBorder,
    ColorShadow,
    ColorHighlight,
    ColorText  : TColorRef
  end;


{***********
* ViewText
***********}

const
  VTS_OWNERSUPPLYTEXT       = $01;
  VTS_NOHSCROLLBAR          = $02;
  VTS_NOVSCROLLBAR          = $04;

  VTM_ADDSTRING             = (WM_USER + 0);
  VTM_CLEAR                 = (WM_USER + 1);
  VTM_DELETESTRING          = (WM_USER + 2);
  VTM_GETLINECOUNT          = (WM_USER + 3);
  VTM_GETSTRING             = (WM_USER + 4);
  VTM_GETSTRINGLEN          = (WM_USER + 5);
  VTM_GETTOPINDEX           = (WM_USER + 6);
  VTM_HIGHLIGHTTEXT         = (WM_USER + 7);
  VTM_INSERTSTRING          = (WM_USER + 8);
  VTM_REDRAW                = (WM_USER + 9);
  VTM_SEARCH                = (WM_USER + 10);
  VTM_SEARCHREPEAT          = (WM_USER + 11);
  VTM_SETCOLHEADERS         = (WM_USER + 12);
  VTM_SETCOLOR              = (WM_USER + 13);
  VTM_GETCOLOR              = (WM_USER + 14);
  VTM_SETHEADER             = (WM_USER + 15);
  VTM_SETROWHEADERS         = (WM_USER + 16);
  VTM_SETTOPINDEX           = (WM_USER + 17);

  VTM_VIEWSIZE              = $0510;
  VTM_RETRIEVETEXT          = $0511;

  VTN_KILLFOCUS             = 1;
  VTN_SETFOCUS              = 2;

  VIEWTEXT_SEARCH_CASE      = $0001;
  VIEWTEXT_SEARCH_NOCASE    = $0002;

  VIEWTEXT_SEARCH_CURRENT   = $0004;
  VIEWTEXT_SEARCH_BEGIN     = $0008;
  VIEWTEXT_SEARCH_END       = $0010;

  VIEWTEXT_SEARCH_FORWARD   = $0020;
  VIEWTEXT_SEARCH_BACKWARD  = $0040;

  VIEWTEXT_SEARCH_SUBSTRING = $0080;
  VIEWTEXT_SEARCH_WHOLEWORD = $0100;

type
  PViewTextColor = ^TViewTextColor;
  TViewTextColor = record
    BackGround,
    MainText,
    Header,
    ColTitles,
    RowTitles,
    HighLightText,
    HighLightBk    : TColorRef
  end;


  PViewSize = ^TViewSize;
  TViewSize = record
    WidthMax, ItemCnt: Integer
  end;

  PViewRetrieveText = ^TViewRetrieveText;
  TViewRetrieveText = record
    ItemNum  : Integer;
    ItemText : PChar
  end;


{***********
* ViewPict
***********}

const
  VPS_NORMAL            = $0000;
  VPS_CENTER            = $0001;
  VPS_STRETCH           = $0002;
  VPS_MAINTAINSCALE     = $0004;
  VPS_SCROLL            = $0008;
  VPS_RESOURCE          = $0010;
  VPS_BMP               = $0020;
  VPS_PCX               = $0040;
  VPS_GIF               = $0080;
  VPS_FREEZE            = $0100;
  VPS_SHOWFRAMEONCE     = $0200;
  VPS_STATIC            = $0400;

{********************
* ViewPict Messages
********************}

  VPN_KILLFOCUS         = 1;
  VPN_SETFOCUS          = 2;
  VPN_BUTTONDOWN        = 3;
  VPN_DBLCLK            = 4;

  VPM_SETPICTURE        = (WM_USER + 0);
  VPM_CLEAR             = (WM_USER + 1);
  VPM_SETSTYLE          = (WM_USER + 2);
  VPM_GETPOINTERPOS     = (WM_USER + 3);


{*************************
* Messages for animation
*************************}

  VPM_SETFRAMES         = (WM_USER + 4);
  VPM_FREEZEANIMATION   = (WM_USER + 5);
  VPM_STARTANIMATION    = (WM_USER + 6);
  VPM_SHOWNEXTFRAME     = (WM_USER + 7);
  VPM_SHOWPREVFRAME     = (WM_USER + 8);

{**************************
* ViewPict Error Messages
**************************}

  VIEWPICT_ERR_OK       = 0;
  VIEWPICT_ERR_NOTFOUND = 1;
  VIEWPICT_ERR_MEMORY   = 2;
  VIEWPICT_ERR_FILEERR  = 3;
  VIEWPICT_ERR_BADPICT  = 4;

  VIEWPICT_END          = -1;
  VIEWPICT_DEFDELAY     = -1;

type
  PViewPict_AnimateHdr = ^TViewPict_AnimateHdr;
  TViewPict_AnimateHdr = record
    PictureCnt, TimeDelay : Integer
  end;

  PViewPict_AnimatePict = ^TViewPict_AnimatePict;
  TViewPict_AnimatePict = record
    PictName: PChar;
    PictStyle,
    x, y, TimeDelay : Integer
  end;

  PViewpict_Animate = ^TViewpict_Animate;
  TViewpict_Animate = record
    AnimateHdr : TViewPict_AnimateHdr;
    AnimatePict: PViewPict_AnimatePict
  end;

{**************
* SpreadSheet *
**************}

{******************
* Notify Messages
******************}
const
  SSM_DBLCLK            = $0501;
  SSM_EDITMODEON        = $0502;
  SSM_EDITMODEOFF       = $0503;
  SSM_CELLLOCKED        = $0504;
  SSM_ROWRESTRICTED     = $0505;
  SSM_COLRESTRICTED     = $0506;
  SSM_COLROWRESTRICTED  = $0507;
  SSM_DATACHANGE        = $0508;
  SSM_LEAVECELL         = $0509;

  SSN_SETFOCUS          = 51;
  SSN_KILLFOCUS         = 52;
  SSN_INVALIDDATA       = 53;
  SSN_BLOCKSELECTED     = 54;
  SSN_BLOCKCHANGED      = 55;
  SSN_USERFORMULA       = 56;
  SSN_EXITNEXT          = 57;    { Internal Use }
  SSN_EXITPREV          = 58;    { Internal Use }
  SSN_BUTTONDOWN        = 59;    { Internal Use }
  SSN_BUTTONUP          = 60;    { Internal Use }


  SSS_RESTRICTROWS      = $0001;
  SSS_RESTRICTCOLS      = $0002;
  SSS_PROTECTDOC        = $0004;
  SSS_LOCKDOC           = $0008;
  SSS_NORESIZE          = $0010;
  SSS_NOSELECTBLOCK     = $0020;
  SSS_NOGRIDLINES       = $0040;
  SSS_ALLOWUSERFORMULAS = $0080;

type
  TSS_Coord   = Integer;  PSS_Coord  = ^TSS_Coord;
  TSS_FontID  = Integer;  PSS_FontID = ^TSS_FontID;
  TSS_ColorID = Integer;  PSS_ColorID= ^TSS_ColorID;



{*********************************
* Define Calculation definitions
*********************************}

const
  SS_CALC_MAXPARAMS      = 20;
  SS_CALC_VARPARAMS      = -1;


{*******************
* Calculation List
*******************}

type
  PSS_CalcList = ^TSS_CalcList;
  TSS_CalcList = record
    hItems                : THandle;
    ItemCnt, ItemAllocCnt : Integer;
    ListBuilt             : Boolean
  end;

{******************************
* Calculation Value Structure *
******************************}

PSS_Value = ^TSS_Value;
TSS_Value = record
  Status   : Char;
  Typ      : Char;
  case Integer of
  0:   (hValStr  : TGlobalHandle);
  1:   (ValLong  : Longint);
  2:   (ValDouble: Double);
end;

TSS_CalcFunc = TFarProc;


{*********************************
* Define Calculation definitions
*********************************}

const
  SS_VALUE_STATUS_OK    = 0;
  SS_VALUE_STATUS_ERROR = 1;
  SS_VALUE_STATUS_EMPTY = 2;
  SS_VALUE_STATUS_CLEAR = 3;
  SS_VALUE_STATUS_NONE  = 4;

  SS_VALUE_TYPE_LONG    = 0;
  SS_VALUE_TYPE_DOUBLE  = 1;
  SS_VALUE_TYPE_STR     = 2;

{*****************************
* Define font for font table
*****************************}

type
  PSS_Font = ^TSS_Font;
  TSS_Font = record
    FontId         : Integer;
    Font           : hFont;
    DeleteFont     : Boolean;
    FontHeight     : Integer;
    FontCellHeight : Double
  end;


{********************
* SpreadSheet Color
********************}

  PSS_ColorItem = ^TSS_ColorItem;
  TSS_ColorItem = record
    BackgroundID,
    ForegroundID : TSS_ColorID
  end;


{********************
* SpreadSheet Color
********************}

  PSS_Color = ^TSS_Color;
  TSS_Color = record
    BackgroundId,
    ForegroundId,
    ShadowColorId,
    ShadowTextId,
    ShadowDarkId,
    ShadowLightId  : TSS_ColorID
  end;


{******************
* Cell Coordinate
******************}

  PSS_CellCoord = ^TSS_CellCoord;
  TSS_CellCoord = record
     Row, Col : TSS_Coord
  end;


{*************
* Leave Cell
*************}

  PSS_LeaveCell = ^TSS_LeaveCell;
  TSS_LeaveCell = record
    RowCurrent, ColCurrent,
    RowNew    , ColNew     : TSS_Coord
  end;


{***********************
* Cell Type definition
***********************}

  TSSEdit = record
    ChrSet, Len   : Integer;
    ChrCase       : Char
  end;

  TSSInteger = record
    Min, Max : LongInt
  end;

  TSSFloat = record
    Left, Right : Integer;
    Min, Max    : Double
  end;

  TSSComboBox = record
    ItemCnt,
    ItemDefault : Integer;
    Items       : THandle
  end;

  TSSTime = record
    SetFormat, SetRange : Boolean;
    Format              : TTimeFormat;
    Min, Max            : TTime
  end;

  TSSDate = record
    SetFormat, SetRange : Boolean;
    Format              : TDateFormat;
    Min, Max            : TDate
  end;

  TSSPic = record
    hClassName          : THandle
  end;

  TSSCustom = record
    hClassName          : THandle
  end;

  TSSViewPict = record
    hPictName           : THandle
  end;

  TSSButton = record
    hText,
    hPicName,
    hPictDownName       : THandle;
    nPictureType,
    nPictoreDownType    : Integer;
    ButtonType,
    ShadowSize          : Char;
    fSetColor           : Boolean;
    Color               : TSuperBtnColor
  end;



  PSS_CellType = ^TSS_CellType;
  TSS_CellType = record
     Typ        : Char;
     ControlID  : Integer;
     Style      : Longint;
     case Integer of
     0 : ( Edit    : TSSEdit);
     1 : ( Int     : TSSInteger);
     2 : ( Float   : TSSFloat);
     3 : ( Combo   : TSSComboBox);
     4 : ( Time    : TSSTime);
     5 : ( Date    : TSSDate);
     6 : ( Pic     : TSSPic);
     7 : ( Custom  : TSSCustom);
     8 : ( ViewPict: TSSViewPict);
     9 : ( Button  : TSSButton)
  end;


{******************
* Cell Definition
******************}

  PSS_Cell = ^TSS_Cell;
  TSS_Cell = record
    CellLocked   : Boolean;
    FontId       : TSS_FontID;
    Color        : TSS_ColorItem;
    hData,
    hCellType,
    hCalc        : TGlobalHandle;
    Dependents   : TSS_CalcList
  end;

{*************************************************
* Define character sets for the string data type
*************************************************}

const
  SS_CHRSET_CHR         = 0;
  SS_CHRSET_ALPHA       = 1;
  SS_CHRSET_ALPHANUM    = 2;
  SS_CHRSET_NUM         = 3;

{***************************************
* Define case for the string data type
***************************************}

  SS_CASE_LCASE         = 0;
  SS_CASE_NOCASE        = 1;
  SS_CASE_UCASE         = 2;

{**************************************************
* Define Plus and Minus for the numeric data type
**************************************************}

  SS_NUM_PLUSMINUS      = 0;
  SS_NUM_PLUS           = 1;

{*************
* Cell Types
*************}

  SS_TYPE_DATE          = 1;
  SS_TYPE_EDIT          = 2;
  SS_TYPE_PIC           = 3;
  SS_TYPE_FLOAT         = 4;
  SS_TYPE_INTEGER       = 5;
  SS_TYPE_STATICTEXT    = 6;
  SS_TYPE_TIME          = 7;
  SS_TYPE_PICTURE       = 8;
  SS_TYPE_BUTTON        = 10;      { Not Used }

{**************
* Text Styles
**************}

  SS_TEXT_LEFT          = $001;
  SS_TEXT_RIGHT         = $002;
  SS_TEXT_CENTER        = $004;
  SS_TEXT_VCENTER       = $008;
  SS_TEXT_TOP           = $010;
  SS_TEXT_BOTTOM        = $020;
  SS_TEXT_WORDWRAP      = $040;
  SS_TEXT_SHADOW        = $080;
  SS_TEXT_VERTICAL      = $100;

  SS_FONT_NONE          = -1;

  SS_ROWHEIGHT_DEFAULT  = 0;
  SS_COLWIDTH_DEFAULT   = 0;

  SS_MAXCOORD           = 32767;

  SS_FIRST              = -1;
  SS_LAST               = -2;
  SS_HEADER             = -SS_MAXCOORD;

  SS_VISIBLE_PARTIAL    = 0;
  SS_VISIBLE_ALL        = 1;

  SS_SCROLLAREA_ALL     = 0;
  SS_SCROLLAREA_COLS    = 1;
  SS_SCROLLAREA_ROWS    = 2;
  SS_SCROLLAREA_CELLS   = 3;

  SS_ALLCOLS            = -1;
  SS_ALLROWS            = -1;

  SSB_PROTECT           = 0;
  SSB_RESTRICTROWS      = 1;
  SSB_RESTRICTCOLS      = 2;
  SSB_SHOWCOLHEADERS    = 3;
  SSB_SHOWROWHEADERS    = 4;
  SSB_ALLOWUSERRESIZE   = 5;
  SSB_ALLOWUSERSELBLOCK = 6;
  SSB_AUTOCALC          = 7;
  SSB_REDRAW            = 8;
  SSB_GRIDLINES         = 9;
  SSB_HORZSCROLLBAR     = 10;
  SSB_VERTSCROLLBAR     = 11;
  SSB_ALLOWUSERFORMULAS = 12;
  SSB_EDITMODEPERMANENT = 13;    { Internal Use }
  SSB_AUTOSIZE          = 14;    { Internal Use }
  SSB_SCROLLBAREXTMODE  = 15;    { Internal Use }

  SS_SHOW_TOPLEFT       = 0;
  SS_SHOW_TOPCENTER     = 1;
  SS_SHOW_TOPRIGHT      = 2;
  SS_SHOW_CENTERLEFT    = 3;
  SS_SHOW_CENTER        = 4;
  SS_SHOW_CENTERRIGHT   = 5;
  SS_SHOW_BOTTOMLEFT    = 6;
  SS_SHOW_BOTTOMCENTER  = 7;
  SS_SHOW_BOTTOMRIGHT   = 8;
  SS_SHOW_NEAREST       = 9;

{**********************
* Function Prototypes
**********************}

function  SSSetRowHeight  (aWnd: hWnd; Row: TSS_Coord; Height: Double): Boolean;
function  SSGetRowHeight  (aWnd: hWnd; Row: TSS_Coord): Double;
function  SSInsRow        (aWnd: hWnd; Row: TSS_Coord): Boolean;
function  SSDelRow        (aWnd: hWnd; Row: TSS_Coord): Boolean;
function  SSSetColWidth   (aWnd: hWnd; Col: TSS_Coord; Width: Double): Boolean;
function  SSGetColWidth   (aWnd: hWnd; Col: TSS_Coord): Double;
function  SSInsCol        (aWnd: hWnd; Col: TSS_Coord): Boolean;
function  SSDelCol        (aWnd: hWnd; Col: TSS_Coord): Boolean;
function  SSSetData       (aWnd: hWnd; Col, Row: TSS_Coord; lpData: PChar): Boolean;
function  SSSetDataRange  (aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord; lpData: PChar): Boolean;
function  SSGetData       (aWnd: hWnd; Col, Row: TSS_Coord; lpData: PChar): Integer;
function  SSGetDataLen    (aWnd: hWnd; Col, Row: TSS_Coord): Integer;
function  SSGetVisible    (aWnd: hWnd; Col, Row: TSS_Coord; iVisible: Integer): Boolean;
function  SSGetEditMode   (aWnd: hWnd): Boolean;
function  SSSetEditMode   (aWnd: hWnd; fEditModeOn: Boolean): Boolean;
function  SSGetActiveCell (aWnd: hWnd; var Col, Row: TSS_Coord): Boolean;
function  SSSetActiveCell (aWnd: hWnd; Col, Row: TSS_Coord): Boolean;
procedure SSSetMaxRows    (aWnd: hWnd; MaxRows: TSS_Coord);
function  SSGetMaxRows    (aWnd: hWnd): TSS_Coord;
procedure SSSetMaxCols    (aWnd: hWnd; MaxCols: TSS_Coord);
function  SSGetMaxCols    (aWnd: hWnd): TSS_Coord;
function  SSGetSelectBlock(aWnd: hWnd; var CellUL, CellLR: TSS_CellCoord): Boolean;
function  SSSetSelectBlock(aWnd: hWnd; var CellUL, CellLR: TSS_CellCoord): Boolean;
procedure SSGetShadowColor(aWnd: hWnd; var ShColor, ShText, ShDark, ShLight: TColorRef);
procedure SSSetShadowColor(aWnd: hWnd;     ShColor, ShText, ShDark, ShLight: TColorRef);
function  SSSetTypeEdit   (aWnd: hWnd; var CType: TSS_CellType; Style: Longint;
                           Len, ChrSet: Integer; ChrCase: Byte): PSS_CellType;
function  SSSetTypePic    (aWnd: hWnd; var CType: TSS_CellType; Style: Longint;
                           Mask: PChar): PSS_CellType;
function  SSSetTypeStaticText(aWnd: hWnd; var CType: TSS_CellType; TextStyle: Integer): PSS_CellType;
function  SSSetTypeDate   (aWnd: hWnd; var CType: TSS_CellType; Style: Longint;
                           var Format: TDateFormat; var Min, Max: TDate): PSS_CellType;
function  SSSetTypeTime   (aWnd: hWnd; var CType: TSS_CellType; Style: Longint;
                           var Format: TTimeFormat; var Min, Max: TTime): PSS_CellType;
function  SSSetTypeInteger(aWnd: hWnd; var CType: TSS_CellType; Min, Max: Longint): PSS_CellType;
function  SSSetTypeFloat  (aWnd: hWnd; var CType: TSS_CellType; Style: Longint; Left, Right: Integer;
                           Min, Max: Double): PSS_CellType;
function  SSSetTypePicture(aWnd: hWnd; var CType: TSS_CellType; Style: Longint;
                           PictName: PChar): PSS_CellType;
function  SSSaveToFile    (aWnd: hWnd; FileName: PChar; DataOnly: Boolean): Boolean;
function  SSSavetoBuffer  (aWnd: hWnd; var BufferLen: Longint; DataOnly: Boolean): TGlobalHandle;
function  SSLoadFromFile  (aWnd: hWnd; FileName: PChar): Boolean;
function  SSLoadFromBuffer(aWnd: hWnd; Buffer: TGlobalHandle; BufferLen: Longint): Boolean;
function  SSBuildDependencies(aWnd: hWnd): Boolean;
function  SSAddCustomFunction(aWnd: hWnd; FunctionName: PChar; ParamCnt: Integer;
                              FunctionProg: TFarProc): Boolean;
function  SSShowCell      (aWnd: hWnd; Col, Row: TSS_Coord; Position: Integer): Boolean;
function  SSShowActiveCell(aWnd: hWnd; Position: Integer): Boolean;
function  SSSetFormula    (aWnd: hWnd; Col, Row: TSS_Coord; Formula: PChar;
                           BuildDependencies: Boolean): Boolean;
function  SSSetFormulaRange(aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord; Formula: PChar;
                           BuildDependencies: Boolean): Boolean;
function  SSGetFormula    (aWnd: hWnd; Col, Row: TSS_Coord; Furmula: PChar): Integer;
function  SSGetFormulaLen (aWnd: hWnd; Col, Row: TSS_Coord): Integer;
function  SSClear         (aWnd: hWnd; Col, Row: TSS_Coord): Boolean;
function  SSClearRange    (aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord): Boolean;
function  SSSetLock       (aWnd: hWnd; Col, Row: TSS_Coord; Lock: Boolean): Boolean;
function  SSSetLockRange  (aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord; Lock: Boolean): Boolean;
function  SSSetFont       (aWnd: hWnd; Col, Row: TSS_Coord; Font: hFont; DelFont: Boolean): Boolean;
function  SSSetFontRange  (aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord; Font: hFont;
                           DelFont: Boolean): Boolean;
function  SSGetFont       (aWnd: hWnd; Col, Row: TSS_Coord): THandle;
function  SSSetCellType   (aWnd: hWnd; Col, Row: TSS_Coord; var CType: TSS_CellType): Boolean;
function  SSSetCellTypeRange(aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord;
                             var CType: TSS_CellType): Boolean;
function  SSGetCellType   (aWnd: hWnd; Col, Row: TSS_Coord; var CType: TSS_CellType): Boolean;
function  SSSetColor      (aWnd: hWnd; Col, Row: TSS_Coord; Background, Foreground: TColorRef): Boolean;
function  SSSetColorRange (aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord;
                           Background, Foreground: TColorRef): Boolean;
function  SSGetColor      (aWnd: hWnd; Col, Row: TSS_Coord;
                           var Background, Foreground: TColorRef): Boolean;
function  SSGetTopLeftCell(aWnd: hWnd): Longint;
function  SSGetBottomRightCell(aWnd: hWnd): Longint;
function  SSSetBool       (aWnd: hWnd; Index: Integer; NewVal: Boolean): Boolean;
function  SSGetBool       (aWnd: hWnd; Index: Integer): Boolean;
function  SSClipOut       (aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord): THandle;
function  SSClipIn        (aWnd: hWnd; Col, Row, Col2, Row2: TSS_Coord; lpBuffer: PChar; BufLen: Longint): Boolean;
function  SSSetSel        (aWnd: hWnd; SelStart, SelEnd: Integer): Boolean;
function  SSGetSel        (aWnd: hWnd; var SelStart, SelEnd: Integer): Boolean;
function  SSReplaceSel    (aWnd: hWnd; Txt: PChar): Boolean;
function  SSGetSelText    (aWnd: hWnd): TGlobalHandle;
function  SSValidateFormula(aWnd: hWnd; Formula: PChar): Boolean;
function  SSLogUnitstoColWidth(aWnd: hWnd; Units: Integer): Double;
function  SSLogUnitsToRowHeight(aWnd: hWnd; Row: TSS_Coord; Units: Integer): Double;
function  SSColWidthToLogUnits(aWnd: hWnd; ColWidth: Double): Integer;
function  SSRowHeightToLogUnits(aWnd: hWnd; Row: TSS_Coord; RowHeight: Double): Integer;
function  SSRecalc(aWnd: hWnd): Boolean;
function  SSDeSelectBlock (aWnd: hWnd): Boolean;


{*********
* Colors
*********}

{
#define RGBCOLOR_DEFAULT   -1L
#define RGBCOLOR_WHITE     RGB(255, 255, 255)
#define RGBCOLOR_BLUE      RGB(0, 0, 255)
#define RGBCOLOR_RED       RGB(255, 0, 0)
#define RGBCOLOR_PINK      RGB(255, 0, 255)
#define RGBCOLOR_GREEN     RGB(0, 255, 0)
#define RGBCOLOR_CYAN      RGB(0, 255, 255)
#define RGBCOLOR_YELLOW    RGB(255, 255, 0)
#define RGBCOLOR_BLACK     RGB(0, 0, 0)
#define RGBCOLOR_DARKGRAY  RGB(128, 128, 128)
#define RGBCOLOR_DARKBLUE  RGB(0, 0, 128)
#define RGBCOLOR_DARKRED   RGB(128, 0, 0)
#define RGBCOLOR_DARKPINK  RGB(255, 0, 128)
#define RGBCOLOR_DARKGREEN RGB(0, 128, 0)
#define RGBCOLOR_DARKCYAN  RGB(0, 128, 128)
#define RGBCOLOR_BROWN     RGB(128, 128, 64)
#define RGBCOLOR_PALEGRAY  RGB(192, 192, 192)
}


{******************
 * Play functions
 *****************}

function  Play            (aWnd: hWnd; PlayString: PChar; Speed: Byte): THandle;
function  PlayChangeSpeed (PlayInst: THandle; Speed: Byte): Boolean;
function  PlayStop        (PlayInst: THandle): Boolean;
function  PlayFreeze      (PlayInst: THandle): Boolean;
function  PlayResume      (PlayInst: THandle): Boolean;
function  WhiteNoise      (FreqLow, FreqHigh, Duration: Word): Boolean;
procedure ToneInit;
procedure ToneOn          (Freq: Word);
procedure ToneOff;
function  TickCount: Longint;

{*****************
* Bios functions
*****************}


const
  ERR_TIME_OUT       = $80;        { prob. No disk            }
  ERR_BAD_SEEK       = $40;        { illegal track or sector? }
  ERR_BAD_NEC        = $20;        { controller card failed   }
  ERR_BAD_CRC        = $10;        { sector damaged           }
  ERR_DMA_BOUNDARY   = $09;        { software error           }
  ERR_BAD_DMA        = $08;        { software error           }
  ERR_RECORD_NOT_FND = $04;        { bad sector or track?     }
  ERR_WRITE_PROTECT  = $02;        { could also be invalid format }
  ERR_BAD_ADDR_MARK  = $01;        { probably unformatted      }

{ BIOSReadSector - BIOSDriveType }



{--------------------------------------------------------------------}
implementation
{--------------------------------------------------------------------}

function DateAddDays         ;external 'TBPRO2' index 2003;
function DateDMYToJulian     ;external 'TBPRO2' index 2006;
function DateDMYToString     ;external 'TBPRO2' index 2002;
function DateGetFormat       ;external 'TBPRO2' index 2010;
function DateGetWeekday      ;external 'TBPRO2' index 2005;
function DateIntIsValid      ;external 'TBPRO2' index 2001;
function DateJulianToDMY     ;external 'TBPRO2' index 2007;
function DateSetFormat       ;external 'TBPRO2' index 2009;
function DateSetRange        ;external 'TBPRO2' index 2008;
function DateStringIsValid   ;external 'TBPRO2' index 2000;
function DateStringToDMY     ;external 'TBPRO2' index 2011;
function DateSubtractDates   ;external 'TBPRO2' index 2004;

function PopupCalender       ;external 'TBPRO2' index 1915;
function TimeGetFormat       ;external 'TBPRO2' index 2057;
function TimeHMSToSeconds    ;external 'TBPRO2' index 2052;
function TimeHMSToString     ;external 'TBPRO2' index 2054;
function TimeSecondsToHMS    ;external 'TBPRO2' index 2053;
function TimeSetFormat       ;external 'TBPRO2' index 2056;
function TimeSetRange        ;external 'TBPRO2' index 2055;
function TimeStringIsValid   ;external 'TBPRO2' index 2050;
function TimeStringToHMS     ;external 'TBPRO2' index 2051;
procedure TimeGetCurrentTime ;external 'TBPRO2' index 2058;


function IntGetRange         ;external 'TBPRO2' index 2100;
function IntSetRange         ;external 'TBPRO2' index 2101;
function IntGetValue         ;external 'TBPRO2' index 2102;
function IntSetValue         ;external 'TBPRO2' index 2103;
function IntSetMask          ;external 'TBPRO2' index 2104;
function IntSetSpin          ;external 'TBPRO2' index 2105;
function IntGetSpin          ;external 'TBPRO2' index 2106;
{ IntSetDlgItemRange - IntGetDlgItemValue }

function FloatGetValue       ;external 'TBPRO2' index 2151;
function FloatSetValue       ;external 'TBPRO2' index 2156;
function FloatSetRange       ;external 'TBPRO2' index 2150;
function FloatGetRange       ;external 'TBPRO2' index 2155;
function FloatSetFormat      ;external 'TBPRO2' index 2157;
function FloatGetFormat      ;external 'TBPRO2' index 2158;
function FloatSetStyle       ;external 'TBPRO2' index 2152;
function FloatFormatString   ;external 'TBPRO2' index 2153;
function FloatFormatString2  ;external 'TBPRO2' index 2159;
function FloatSetMask        ;external 'TBPRO2' index 2154;
{ FloatSetDlgItemRange - FloatSetDlgItemValue }

function GetToolBoxGlobal    ;external 'TBPRO1' index 2501;
function SetToolBoxGlobal    ;external 'TBPRO1' index 2500;

function GetFileString       ;external 'TBPRO1' index 1736;
function SysCreateSubDir     ;external 'TBPRO1' index 1713;
function SysDeleteFile       ;external 'TBPRO1' index 1718;
function SysDeleteSubDir     ;external 'TBPRO1' index 1715;
function SysDiskBytesFree    ;external 'TBPRO1' index 1732;
function SysDiskBytesTotal   ;external 'TBPRO1' index 1733;
function SysDiskInfo         ;external 'TBPRO1' index 1701;
function SysExecPgm          ;external 'TBPRO1' index 1725;
function SysFileSpec         ;external 'TBPRO1' index 1726;
{ SysFindFirst - SysGetFileAttr }

function  InitToolbox        ;external 'TBPRO1' index 50;
function  ToolboxLoadDlls    ;external 'TBPRO1' index 51;
procedure ToolboxFreeDlls    ;external 'TBPRO1' index 52;
procedure ToolboxFreeAllDlls ;external 'TBPRO1' index 53;
function  GetToolboxVersion  ;external 'TBPRO1' index 54;

function  HourGlassCount     ;external 'TBPRO1' index 1403;
procedure HourGlassOff       ;external 'TBPRO1' index 1402;
procedure HourGlassOn        ;external 'TBPRO1' index 1401;

{StrCat - LongToString}
function StrRTrim            ;external 'TBPRO1' index 726;

{ FloatToEString - StringToLong }

{ ErrorNo - FileGetDateTime }

{ ListAddStr - ListSelectStr }

{ MemCmp - MemiCmd }

{ MemHugeCmp - MemHugecCpy }

{ Debug }
{ function _MsgDisp            ;external 'TBPRO1' index 1303; }
function MsgDoDisp           ;external 'TBPRO1' index 1302;
function MsgLoad             ;external 'TBPRO1' index 1301;

function DlgFileOpenOne      ;external 'TBPRO1' index 2301;
function DlgFileOpenTwo      ;external 'TBPRO1' index 2302;
function DlgFontSelect       ;external 'TBPRO1' index 2303;
function DlgPrinterSetup     ;external 'TBPRO1' index 2300;
{ EnumFiles }
procedure ExitNow            ;external 'TBPRO1' index 1603;
function FullMkDir           ;external 'TBPRO1' index 1735;

function GaugeGetPos         ;external 'TBPRO1' index 1203;
function GaugeGetRange       ;external 'TBPRO1' index 1201;
function GaugeSetColors      ;external 'TBPRO1' index 1205;
function GaugeSetPos         ;external 'TBPRO1' index 1204;
function GaugeSetRange       ;external 'TBPRO1' index 1202;
function GaugeSetTitle       ;external 'TBPRO1' index 1206;
procedure GetChildSize       ;external 'TBPRO1' index 500;
{ MsgBox }
procedure  MsgLineMenuHelp   ;external 'TBPRO1' index 1602;
procedure  MsgLinePaint      ;external 'TBPRO1' index 1600;
procedure  MsgLineTextOut    ;external 'TBPRO1' index 1601;
procedure  OLRect            ;external 'TBPRO1' index  505;
procedure  OLLine            ;external 'TBPRO1' index  504;
function  PrinterGetDC       ;external 'TBPRO1' index 2308;
function  PrinterGetIC       ;external 'TBPRO1' index 2309;
function  PrinterGetDetails  ;external 'TBPRO1' index 2310;
function  RmTmp              ;external 'TBPRO1' index 2404;
function  WinExecProg        ;external 'TBPRO1' index 1727;

function  SSSetRowHeight     ;external 'TBPRO3' index 2800;
procedure SSGetRowHeightC (aWnd: hWnd; Row: TSS_Coord; NearPtr: Word);far;
                              external 'TBPRO3' index 2801;
function  SSGetRowHeight;
  var D : Double;
  begin SSGetRowHeightC(aWnd, Row, ofs(D)); SSGetRowHeight := D end;
function  SSInsRow           ;external 'TBPRO3' index 2804;
function  SSDelRow           ;external 'TBPRO3' index 2805;
function  SSSetColWidth      ;external 'TBPRO3' index 2900;
procedure SSGetColWidthC (aWnd: hWnd; Col: TSS_Coord; NearPtr: Word);far;
                              external 'TBPRO3' index 2901;
function SSGetColWidth;
  var D : Double;
  begin SSGetColWidthC(aWnd, Col, ofs(D)); SSGetColWidth := D end;
function  SSInsCol           ;external 'TBPRO3' index 2905;
function  SSDelCol           ;external 'TBPRO3' index 2904;
function  SSSetData          ;external 'TBPRO3' index 3001;
function  SSSetDataRange     ;external 'TBPRO3' index 3002;
function  SSGetData          ;external 'TBPRO3' index 3003;
function  SSGetDataLen       ;external 'TBPRO3' index 3004;
function  SSGetVisible       ;external 'TBPRO3' index 2714;
function  SSGetEditMode      ;external 'TBPRO3' index 3115;
function  SSSetEditMode      ;external 'TBPRO3' index 3114;
function  SSGetActiveCell    ;external 'TBPRO3' index 3116;
function  SSSetActiveCell    ;external 'TBPRO3' index 3117;
procedure SSSetMaxCols       ;external 'TBPRO3' index 3118;
function  SSGetMaxCols       ;external 'TBPRO3' index 3119;
procedure SSSetMaxRows       ;external 'TBPRO3' index 3120;
function  SSGetMaxRows       ;external 'TBPRO3' index 3121;
function  SSGetSelectBlock   ;external 'TBPRO3' index 3126;
function  SSSetSelectBlock   ;external 'TBPRO3' index 3127;
procedure SSGetShadowColor   ;external 'TBPRO3' index 3130;
procedure SSSetShadowColor   ;external 'TBPRO3' index 3131;
function  SSSetTypeEdit      ;external 'TBPRO3' index 3200;
function  SSSetTypePic       ;external 'TBPRO3' index 3201;
function  SSSetTypeStaticText;external 'TBPRO3' index 3203;
function  SSSetTypeDate      ;external 'TBPRO3' index 3204;
function  SSSetTypeTime      ;external 'TBPRO3' index 3205;
function  SSSetTypeInteger   ;external 'TBPRO3' index 3206;
function  SSSetTypeFloat     ;external 'TBPRO3' index 3207;
function  SSSetTypePicture   ;external 'TBPRO3' index 3209;
function  SSSaveToFile       ;external 'TBPRO3' index 3300;
function  SSSavetoBuffer     ;external 'TBPRO3' index 3301;
function  SSLoadFromFile     ;external 'TBPRO3' index 3302;
function  SSLoadFromBuffer   ;external 'TBPRO3' index 3303;
function  SSBuildDependencies;external 'TBPRO3' index 3402;
function  SSAddCustomFunction;external 'TBPRO3' index 3403;
function  SSShowCell         ;external 'TBPRO3' index 2710;
function  SSShowActiveCell   ;external 'TBPRO3' index 2711;
function  SSSetFormula       ;external 'TBPRO3' index 3505;
function  SSSetFormulaRange  ;external 'TBPRO3' index 3506;
function  SSGetFormula       ;external 'TBPRO3' index 3507;
function  SSGetFormulaLen    ;external 'TBPRO3' index 3508;
function  SSClear            ;external 'TBPRO3' index 2712;
function  SSClearRange       ;external 'TBPRO3' index 2713;
function  SSSetLock          ;external 'TBPRO3' index 2724;
function  SSSetLockRange     ;external 'TBPRO3' index 2725;
function  SSSetFont          ;external 'TBPRO3' index 2715;
function  SSSetFontRange     ;external 'TBPRO3' index 2716;
function  SSGetFont          ;external 'TBPRO3' index 2717;
function  SSSetCellType      ;external 'TBPRO3' index 2718;
function  SSSetCellTypeRange ;external 'TBPRO3' index 2719;
function  SSGetCellType      ;external 'TBPRO3' index 2720;
function  SSSetColor         ;external 'TBPRO3' index 2721;
function  SSSetColorRange    ;external 'TBPRO3' index 2722;
function  SSGetColor         ;external 'TBPRO3' index 2723;
function  SSGetTopLeftCell   ;external 'TBPRO3' index 3509;
function  SSGetBottomRightCell;external 'TBPRO3' index 3510;
function  SSSetBool          ;external 'TBPRO3' index 3511;
function  SSGetBool          ;external 'TBPRO3' index 3512;
function  SSClipOut          ;external 'TBPRO3' index 3513;
function  SSClipIn           ;external 'TBPRO3' index 3514;
function  SSSetSel           ;external 'TBPRO3' index 3600;
function  SSGetSel           ;external 'TBPRO3' index 3601;
function  SSReplaceSel       ;external 'TBPRO3' index 3602;
function  SSGetSelText       ;external 'TBPRO3' index 3603;
function  SSValidateFormula  ;external 'TBPRO3' index 3700;
procedure SSLogUnitstoColWidthC(aWnd: hWnd; Units: Integer; NearPtr: Word);far
                             ;external 'TBPRO3' index 3701;
function SSLogUnitstoColWidth;
  var D: Double;
  begin SSLogUnitstoColWidthC(aWnd, Units, ofs(D)); SSLogUnitstoColWidth:=D end;
procedure SSLogUnitsToRowHeightC(aWnd: hWnd; Row: TSS_Coord; Units: Integer; NearPtr: Word);far;
                              external 'TBPRO3' index 3702;
function SSLogUnitsToRowHeight;
  var D: Double;
  begin SSLogUnitsToRowHeightC(aWnd, Row, Units, ofs(D)); SSLogUnitsToRowHeight:=D end;
function  SSColWidthToLogUnits  ;external 'TBPRO3' index 3703;
function  SSRowHeightToLogUnits ;external 'TBPRO3' index 3704;
function  SSRecalc              ;external 'TBPRO3' index 3705;
function  SSDeSelectBlock       ;external 'TBPRO3' index 3706;

function  Play                  ;external 'TBPRO1' index 2551;
function  PlayChangeSpeed       ;external 'TBPRO1' index 2552;
function  PlayStop              ;external 'TBPRO1' index 2553;
function  PlayFreeze            ;external 'TBPRO1' index 2554;
function  PlayResume            ;external 'TBPRO1' index 2555;
function  WhiteNoise            ;external 'TBPRO1' index 2556;
procedure ToneInit              ;external 'TBPRO1' index 2557;
procedure ToneOn                ;external 'TBPRO1' index 2558;
procedure ToneOff               ;external 'TBPRO1' index 2559;
function  TickCount             ;external 'TBPRO1' index 2560;




begin
end.
