/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                  Major definitions used in BinkleyTerm                   */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* LEGIBLE SECTION.  Definitions to make "C" look like a real language.     */
/*--------------------------------------------------------------------------*/

#ifndef BINK_DEFINED
#define BINK_DEFINED

#ifndef max
#define max(a,b)     ((a)>(b)?(a):(b))
#endif

#ifndef min
#define min(a,b)     ((a)<=(b)?(a):(b))
#endif

/*
 * updcrc macro derived from article Copyright (C) 1986 Stephen Satchell.
 *  NOTE: First argument must be in range 0 to 255.
 *        Second argument is referenced twice.
 *
 * Programmers may incorporate any or all code into their programs,
 * giving proper credit within the source. Publication of the
 * source routines is permitted so long as proper credit is given
 * to Stephen Satchell, Satchell Evaluations and Chuck Forsberg,
 * Omen Technology.
 */

#define updcrc(cp, crc) ( crctab[((crc >> 8) & 255) ^ cp] ^ (crc << 8))

/* We need it the other way around for BinkleyTerm */
#define xcrc(crc,cp) ( crctab[((crc >> 8) & 255) ^ cp] ^ (crc << 8))

typedef unsigned bit;
typedef unsigned short word;
typedef unsigned char byte;

#define fallthrough

#define LOCAL        static
#define empty_str    ""

/* The following changes by Greylock Software, to facilitate the MEWEL
 * version of Bink.
 */

#define PRDCT_NM(m)     PrdctTbl[m]
#define WELCOME_LEN     1024

#define POLL_POPUP
#define EventSub()

struct _lang_hdr
{
	short ElemCnt;
	short PoolSize;
};

struct _key_fnc
{
	short FncIdx;
	short ScanCode;
};

struct _key_fnc_hdr
{
	short KeyFncCnt;
	short *KeyFncAry;
	struct _key_fnc *KeyFncTbl;
};

#define FA_RDONLY   0x01		/* File is readonly */
#define FA_HIDDEN   0x02		/* File is hidden   */
#define FA_SYSTEM   0x04		/* System file      */
#define FA_VOLID    0x08		/* Volume ID        */
#define FA_SUBDIR   0x10		/* Subdirectory     */
#define FA_ARCH     0x20		/* Archive file     */

struct FILEINFO
{
	char rsvd[21];
	char attr;
	long time;
	long size;
	char name[13];
	char nill;
};

#define DENY_ALL   0
#define DENY_NONE  1
#define DENY_READ  2
#define DENY_RDWR  3
#define DENY_WRITE 4

typedef struct pnums
{
	char num[20];
	char pre[20];
	char suf[20];
	short len;
	struct pnums *next;
} PN_TRNS;

typedef struct anums
{
	char *num;
	char *alt;
	struct anums *next;
} ANUMS, *P_ANUMS;

typedef struct mnums
{
	byte mdm;
	char pre[50];
	char suf[50];
	struct mnums *next;
} MDM_TRNS;

/* Used to parse result codes. Filled in by user in BTCONFIG or
   by default in B_INITVA. */

struct resp_str
{
	char *resp;
	unsigned disp;
};

/* Values for resp_str.disp. */

#define FAILURE   0
#define IGNORE    1
#define CONNECTED 2
#define RINGING   3
#define INCOMING  4
#define	DIALRETRY 5
#define FAX       16			/* Fax starts at 16 */
#define ZYXFAX    17			/* Fax or'ed with 1. Next fax type = 18, then 20 */

struct prototable
{
	char first_char;
	short entry;
};

typedef struct j_types
{
	char j_match[30];
	struct j_types *next;
} J_TYPES, *J_TYPESP;

/* mailtypes bit field definitions */
#define MAIL_CRASH   0x0001
#define MAIL_HOLD    0x0002
#define MAIL_DIRECT  0x0004
#define MAIL_NORMAL  0x0008
#define MAIL_REQUEST 0x0010
#define MAIL_WILLGO  0x0020
#define MAIL_TRIED   0x0040
#define MAIL_TOOBAD  0x0080
#define MAIL_UNKNOWN 0x0100
#define MAIL_RES0200 0x0200
#define MAIL_QSMALL  0x0400
#define MAIL_RES0800 0x0800
#define MAIL_RES1000 0x1000
#define MAIL_RES2000 0x2000
#define MAIL_RES4000 0x4000
#define MAIL_RES8000 0x8000

typedef struct finfo
{
	int info_size;
	char curr_fossil;
	char curr_rev;
	char far *id_string;
	int ibufr;
	int ifree;
	int obufr;
	int ofree;
	byte swidth;
	byte sheight;
	char baud;
} FOSINFO;

typedef short (*PFI3) (short, short, short, short);

typedef struct
{
	unsigned short background;
	unsigned short settings;
	unsigned short history;
	unsigned short hold;
	unsigned short call;
	unsigned short file;
	unsigned short calling;
	unsigned short popup;
} SB_COLORS;

/*--------------------------------------------------------------------------*/
/* Sealink and Telink header structure                                      */
/*--------------------------------------------------------------------------*/

#define HEADER_NAMESIZE  17

struct zero_block
{
	long size;					/* file length                    */
	long time;					/* file date/time stamp           */
	char name[HEADER_NAMESIZE];	/* original file name             */
	char moi[15];				/* sending program name           */
	char noacks;				/* for SLO                        */
};

/*--------------------------------------------------------------------------*/
/* NodeList.Sys                                                             */
/*                                                                          */
/*    NET > 0 and NODE > 0    Normal node                                   */
/*                                                                          */
/*    NET > 0 and NODE <= 0   Host node                                     */
/*                               Net host........node== 0                   */
/*                               Regional host...node==-1                   */
/*                               Country host....node==-2                   */
/*                                                                          */
/*    NET == -1      Nodelist.Sys revision                                  */
/*                                                                          */
/*    NET == -2      Nodelist statement                                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* NODE                                                                     */
/* Please note the NewStyle structure (below).  Time is running out for the */
/* existing `_node' structure!  Opus currently uses the old style node      */
/* structure, but not for long.                                             */
/*--------------------------------------------------------------------------*/

struct _node
{
	short number;				/* node number                              */
	short net;					/* net number                               */
	short cost;					/* cost of a message to this node           */
	short rate;					/* baud rate                                */
	char name[20];				/* node name                                */
	char phone[40];				/* phone number                             */
	char city[40];				/* city and state                           */
};

/*--------------------------------------------------------------------------*/
/* THE NEWSTYLE NODE LIST IS NOW BEING USED BY OPUS 1.10                    */
/*--------------------------------------------------------------------------*/

struct _newnode
{
	word NetNumber;
	word NodeNumber;
	word Cost;					/* cost to user for a message */
	char SystemName[34];		/* node name */
	char PhoneNumber[40];		/* phone number */
	char MiscInfo[30];			/* city and state */
	char Password[8];			/* WARNING: not necessarily null-terminated */
	word RealCost;				/* phone company's charge */
	word HubNode;				/* this node's hub, or point number if a point */
	byte BaudRate;				/* baud rate divided by 300 */
	byte ModemType;				/* RESERVED for modem type */
	word NodeFlags;				/* set of flags (see below) */
	word NodeFiller;
};

/*--------------------------------------------------------------------------*/
/* nodex.ndx                                                                */
/*                                                                          */
/* Version 7 Nodelist Index structure.  This is a 512-byte record, which    */
/* is defined by three structures:  Record 0 is the Control Record, then    */
/* some number of Leaf Node (LNode) Records, then the Index Node (INode)    */
/* Records.  This defines an unbalanced binary tree.                        */
/*                                                                          */
/* This description is based on Scott Samet's CBTREE.PAS program.           */
/*                                                                          */
/*--------------------------------------------------------------------------*/

struct _ndx
{
	union
	{
		struct _CtlBlk
		{
			word CtlBlkSize;	/* Blocksize of Index Blocks   */
			long CtlRoot;		/* Block number of Root        */
			long CtlHiBlk;		/* Block number of last block  */
			long CtlLoLeaf;		/* Block number of first leaf  */
			long CtlHiLeaf;		/* Block number of last leaf   */
			long CtlFree;		/* Head of freelist            */
			word CtlLvls;		/* Number of index levels      */
			word CtlParity;		/* XOR of above fields         */
		} CtlBlk;

		struct _INodeBlk
		{
			long IndxFirst;		/* Pointer to next lower level */
			long IndxBLink;		/* Pointer to previous link    */
			long IndxFLink;		/* Pointer to next link        */
			short IndxCnt;		/* Count of Items in block     */
			word IndxStr;		/* Offset in block of 1st str  */

			/* If IndxFirst is NOT -1, this is INode:          */

			struct _IndxRef
			{
				word IndxOfs;	/* Offset of string into block */
				word IndxLen;	/* Length of string            */
				long IndxData;	/* Record number of string     */
				long IndxPtr;	/* Block number of lower index */
			} IndxRef[20];
		} INodeBlk;

		struct _LNodeBlk
		{
			/* IndxFirst is -1 in LNodes   */

			long IndxFirst;		/* Pointer to next lower level */
			long IndxBLink;		/* Pointer to previous link    */
			long IndxFLink;		/* Pointer to next link        */
			short IndxCnt;		/* Count of Items in block     */
			word IndxStr;		/* Offset in block of 1st str  */
			struct _LeafRef
			{
				word KeyOfs;	/* Offset of string into block */
				word KeyLen;	/* Length of string            */
				long KeyVal;	/* Pointer to data block       */
			} LeafRef[30];
		} LNodeBlk;

		char RawNdx[512];

	} ndx;
};

/*--------------------------------------------------------------------------*/
/*                                                                          */
/* OPUS 1.20 Version 7 Nodelist structure. Copyright 1991 Wynn Wagner III   */
/* and Doug Boone. Used by permission.                                      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

struct _vers7
{
	short Zone;
	short Net;
	short Node;
	short HubNode;				/* If a point, this is point number. */
	word CallCost;				/* phone company's charge */
	word MsgFee;				/* Amount charged to user for a message */
	word NodeFlags;				/* set of flags (see below) */
	byte ModemType;				/* RESERVED for modem type */
	byte Phone_len;
	byte Password_len;
	byte Bname_len;
	byte Sname_len;
	byte Cname_len;
	byte pack_len;
	byte BaudRate;				/* baud rate divided by 300 */
};

/*--------------------------------------------------------------------------*/
/* Values for the `NodeFlags' field                                         */
/*--------------------------------------------------------------------------*/

#define B_hub    0x0001		/* node is a net hub        0000 0000 0000 0001 */
#define B_host   0x0002		/* node is a net host       0000 0000 0000 0010 */
#define B_region 0x0004		/* node is region coord     0000 0000 0000 0100 */
#define B_zone   0x0008		/* is a zone gateway        0000 0000 0000 1000 */
#define B_CM     0x0010		/* runs continuous mail     0000 0000 0001 0000 */
#define B_res1   0x0020		/* reserved by Opus         0000 0000 0010 0000 */
#define B_res2   0x0040		/* reserved by Opus         0000 0000 0100 0000 */
#define B_res3   0x0080		/* reserved by Opus         0000 0000 1000 0000 */
#define B_res4   0x0100		/* reserved by Opus         0000 0001 0000 0000 */
#define B_res5   0x0200		/* reserved for non-Opus    0000 0010 0000 0000 */
#define B_res6   0x0400		/* reserved for non-Opus    0000 0100 0000 0000 */
#define B_res7   0x0800		/* reserved for non-Opus    0000 1000 0000 0000 */
#define B_point  0x1000		/* node is a point          0001 0000 0000 0000 */
#define B_res9   0x2000		/* reserved for non-Opus    0010 0000 0000 0000 */
#define B_resa   0x4000		/* reserved for non-Opus    0100 0000 0000 0000 */
#define B_resb   0x8000		/* reserved for non-Opus    1000 0000 0000 0000 */

/*--------------------------------------------------------------------------*/
/* Nodelist.Idx                                                             */
/* (File is terminated by EOF)                                              */
/*--------------------------------------------------------------------------*/

struct _ndi
{
	short node;				/* node number  */
	short net;				/* net number   */
};

/*--------------------------------------------------------------------------*/
/* QuickBBS 2.00 QNL_IDX.BBS                                                */
/* (File is terminated by EOF)                                              */
/*--------------------------------------------------------------------------*/

struct QuickNodeIdxRecord
{
	unsigned short QI_Zone;
	unsigned short QI_Net;
	unsigned short QI_Node;
	byte QI_NodeType;
};

/*--------------------------------------------------------------------------*/
/* QuickBBS 2.00 QNL_DAT.BBS                                                */
/* (File is terminated by EOF)                                              */
/*--------------------------------------------------------------------------*/

struct QuickNodeListRecord
{
	byte QL_NodeType;
	unsigned short QL_Zone;
	unsigned short QL_Net;
	unsigned short QL_Node;
	char QL_Name[21];			/* Pascal! 1 byte count, up to 20 chars */
	char QL_City[41];			/* 1 + 40 */
	char QL_Phone[41];			/* 1 + 40 */
	char QL_Password[9];		/* 1 + 8 */
	word QL_Flags;				/* Same as flags in new nodelist structure */
	word QL_BaudRate;
	word QL_Cost;
};

/* SEAdog NETLIST.DOG format */

struct netls
{
	short netnum;
	char netname[14];
	char netcity[40];
	short havehost;
	short nethost;
	short havegate;
	short netgate;
	long nodeptr;
	short numnodes;
};

/* SEAdog NODELIST.DOG format */

struct nodels
{
	short nodenum;
	char nodename[14];
	char nodecity[40];
	char nodephone[40];
	short havehub;
	short nodehub;
	short nodecost;
	short nodebaud;
};

/* Things most nodelists don't contain, but Binkley likes to have */

struct extrastuff
{
	char password[8];
	unsigned short flags1;
	byte modem;
	char extra[5];				/* for future expansion */
};

/* Format of a XMODEM block */

typedef struct
{
	unsigned char header;
	unsigned char block_num;
	unsigned char block_num_comp;
	unsigned char data_bytes[128];
	unsigned char data_check[2];
} XMDATA, *XMDATAP;

/* Format of Telink block 0 */

typedef struct
{
	unsigned char header;
	unsigned char block_num;
	unsigned char block_num_comp;
	long filelength;
	union
	{
		struct
		{
			unsigned short time;
			unsigned short date;
		} twowords;

		struct
		{
			unsigned long timedate;
		} oneword;
	} filetime;
	char filename[16];
	char nullbyte;
	char sendingprog[15];
	char noacks;
	unsigned char crcmode;
	char fill[86];
	unsigned char data_check[2];
} TLDATA, *TLDATAP;

/* Format of SEAlink block 0 */

typedef struct
{
	unsigned char header;
	unsigned char block_num;
	unsigned char block_num_comp;
	long filelength;
	unsigned long timedate;
	char filename[17];
	char sendingprog[15];
	char SLO;
	char Resync;
	char MACFLOW;
	char fill[85];
	unsigned char data_check[2];
} SEADATA, *SEADATAP;

typedef struct
{
	unsigned int SEAlink:1;		/* Can do SEAlink */
	unsigned int SLO:1;			/* Can do SEAlink with Overdrive */
	unsigned int Resync:1;		/* Can do SEAlink with Resync */
	unsigned int MacFlow:1;		/* Can do SEAlink with Macintosh flow control */
	unsigned int do_CRC:1;		/* Should do CRC instead of checksum */
	unsigned int TeLink:1;		/* We saw a TeLink header */
} TRANS, *TRANSP;

typedef struct
{
	char *state_name;
	short (*state_func) (void *);
} STATES, *STATEP;

typedef struct
{
	long control;				/* We will always have a long on top */
	long filler;				/* Just to be sure. Min size, 8 bytes*/
} STATEBASE, *STATEBASEP;

typedef struct
{
	long control;				/* These must always start with a long! */
	TRANS options;				/* Transfer options */
	short result;				/* Result from last operation */
	short sub_results;			/* Extra result codes */
	long T1;					/* General purpose timer */
	long T2;					/* General purpose timer */
	short Window;				/* SEAlink window size */
	long SendBLK;				/* Current block to be sent */
	long NextBLK;				/* Next block we will try to send */
	long ACKBLK;				/* Block that was last ACK'd */
	long LastBlk;				/* Last block in file */
	long ARBLK;					/* Used in ACK Check calculations */
	long WriteBLK;				/* Block number to write to file */
	long filelen;				/* Length of file being sent */
	long curr_byte;				/* Current byte offset of sending or receiving */
	long prev_bytes;			/* Bytes that we are resyncing over */
	long total_blocks;			/* Total number of blocks in file to be received */
	long resync_block;			/* Block number we received to resync to */
	short NumNAK;				/* Number of NAK's received this block */
	short ACKsRcvd;				/* Number of ACK's received since file start */
	short ACKST;				/* Current state of the ack/nak state variable */
	short tries;				/* Number of tries thus far */
	short goodfile;				/* 0 if file was bad, 1 if file was good */
	short datalen;				/* Length of data in this block */
	short recblock;				/* Block number received */
	short sent_ACK;				/* Whether or not we sent an ACK already */
	short tot_errs;				/* Total number of errors */
	unsigned char ARBLK8;		/* 8 bit value of ARBLK */
	unsigned char blocknum;		/* 8 bit value of SendBLK */
	unsigned char check;		/* checksum value */
	unsigned char save_header;	/* Received header from first block */
	short CHR;					/* General purpose receive character */
	union						/* File date and time in Telink or SEAlink format */
	{
		struct
		{
			unsigned short time;
			unsigned short date;
		} twowords;

		struct
		{
			unsigned long timedate;
		} oneword;
	}
	save_filetime;
	char received_name[20];		/* Received filename from Telink or SEAlink */
	char m7name[12];			/* Filename in Modem7 format */
	char sending_program[16];	/* Sending program name                    */
	char *filename;				/* The filename to be sent or received */
	char *path;					/* Just the path to the file to be sent/received */
	char *fptr;					/* Pointer into character fields */
	char *temp_name;			/* Temporary name for receiving */
	FILE *file_pointer;			/* The pointer for read/write/seek operations */

	unsigned char header;
	unsigned char block_num;
	unsigned char block_num_comp;
	unsigned char data[128];
	unsigned char data_check[2];
} XMARGS, *XMARGSP;

#define DID_RESYNC 1

typedef struct
{
	long control;				/* These must always start with a long! */
	short tries;
	short barklen;
	short barkok;
	long T1;
	short nfiles;
	char *inbound;
	char *filename;
	char barkpacket[128];
	char *barkpw;
	char *barktime;
} BARKARGS, *BARKARGSP;

/*--------------------------------------------------------------------------*/
/* FIDONET ADDRESS STRUCTURE                                                */
/*--------------------------------------------------------------------------*/

typedef struct _ADDRESS
{
	word Zone;
	word Net;
	word Node;
	word Point;
	char *Domain;
} ADDR, *ADDRP;

typedef struct _DOMAINKLUDGE
{
	word zone;
	word domain;
} DOMAINKLUDGE;

typedef struct mail
{
	ADDR mail_addr;				/* Addressee */
	unsigned short numfiles;	/* Total number of packets and files      */
	unsigned short mailtypes;	/* Bitmask of types we have for addressee */
	unsigned long mailsize;		/* Total amount of mail for addressee     */
	unsigned long callsize;		/* Amount of mail that isn't on hold      */
	unsigned long oldest;		/* time_t of oldest mail                  */
	struct mail *next;
	struct mail *prev;
} MAIL, *MAILP;

typedef int (*nfunc) (ADDR *, int);
typedef void (*ufunc) (char *, ADDR *);

#define	MAX_EXTERN	8
#define	ALIAS_CNT	25

/*--------------------------------------------------------------------------*/
/* Matrix mask                                                              */
/* Undefined bits are reserved by Opus                                      */
/*--------------------------------------------------------------------------*/

#define NO_TRAFFIC	0x0001
#define LOCAL_ONLY	0x0002
#define OPUS_ONLY	0x0004

#define NO_EXITS	0x2000
#define MAIL_ONLY	0x4000
#define TAKE_REQ	0x8000

/*--------------------------------------------------------------------------*/
/* Message packet header                                                    */
/*--------------------------------------------------------------------------*/

#define PKTVER	2

/*--------------------------------------------*/
/* POSSIBLE VALUES FOR `product' (below)      */
/*                                            */
/* NOTE: These product codes are assigned by  */
/* the FidoNet<tm> Technical Stardards Com-   */
/* mittee.  If you are writing a program that */
/* builds packets, you will need a product    */
/* code.  Please use ZERO until you get your  */
/* own.  For more information on codes, write */
/* to FTSC at 115/333.                        */
/*                                            */
/*--------------------------------------------*/

#define isFIDO		0
#define isANXCLO	4
#define isOPUS		5
#define isIGOR		65
#define isTIMS		66
#define isBITBRAIN	0x1b
#define isDBRIDGE	0x1d
#define isMILQUE	0xac

#ifndef PRDCT_CODE
#define PRDCT_CODE		isBITBRAIN
#endif

#ifndef PRDCT_MAJOR
#define PRDCT_MAJOR		2
#endif

#ifndef PRDCT_MINOR
#define PRDCT_MINOR		60
#endif

#ifndef PRDCT_PRFX
#define PRDCT_PRFX		"BINKLEY"
#endif

#ifndef PRDCT_PRTY
#define PRDCT_PRTY		"BinkleyTerm"
#endif

#ifndef PRD_SH_PRTY
#define PRD_SH_PRTY		"Binkley"
#endif

#ifndef PRDCT_SHRT
#define PRDCT_SHRT		"Bink"
#endif

#ifndef PRDCT_VRSN
#define PRDCT_VRSN		"2.60"
#endif

struct _pkthdr
{
	short orig_node;		/* originating node               */
	short dest_node;		/* destination node               */
	short year;				/* 0..99  when packet was created */
	short month;			/* 0..11  when packet was created */
	short day;				/* 1..31  when packet was created */
	short hour;				/* 0..23  when packet was created */
	short minute;			/* 0..59  when packet was created */
	short second;			/* 0..59  when packet was created */
	short rate;				/* destination's baud rate        */
	short ver;				/* packet version, must be 2      */
	short orig_net;			/* originating network number     */
	short dest_net;			/* destination network number     */
	char product;			/* product type                   */
	char serial;			/* serial number (some systems)   */

	byte password[8];		/* session/pickup password        */
	short orig_zone;		/* originating zone               */
	short dest_zone;		/* Destination zone               */
	byte B_fill2[16];
	long B_fill3;
};

struct _pkthdr45			/* FSC-0045 (2.2) packet type     */
{
	short orig_node;		/* originating node               */
	short dest_node;		/* destination node               */
	short orig_point;		/* originating point              */
	short dest_point;		/* destination point              */
	byte b_fill1[8];		/* Unused, must be zero           */
	short subver;			/* packet subversion, must be 2   */
	short ver;				/* packet version, must be 2      */
	short orig_net;			/* originating network number     */
	short dest_net;			/* destination network number     */
	char product;			/* product type                   */
	char serial;			/* serial number (some systems)   */

	byte password[8];		/* session/pickup password        */
	short orig_zone;		/* originating zone               */
	short dest_zone;		/* Destination zone               */
	byte orig_domain[8];	/* originating domain             */
	byte dest_domain[8];	/* destination domain             */
	long B_fill3;
};

struct _pkthdr39			/* FSC-0039 packet type           */
{
	short orig_node;		/* originating node               */
	short dest_node;		/* destination node               */
	short year;				/* 0..99  when packet was created */
	short month;			/* 0..11  when packet was created */
	short day;				/* 1..31  when packet was created */
	short hour;				/* 0..23  when packet was created */
	short minute;			/* 0..59  when packet was created */
	short second;			/* 0..59  when packet was created */
	short rate;				/* destination's baud rate        */
	short ver;				/* packet version, must be 2      */
	short orig_net;			/* originating network number     */
	short dest_net;			/* destination network number     */
	byte product_low;		/* FTSC product type (low byte)   */
	byte prod_rev_low;		/* product rev (low byte)         */

	byte password[8];		/* session/pickup password        */
	short zone_ignore[2];	/* Zone info from other software  */
	byte B_fill1[2];
	short CapValid;			/* CapWord with bytes swapped.    */
	byte product_hi;		/* FTSC product type (high byte)  */
	byte prod_rev_hi;		/* product rev (hi byte)          */
	short CapWord;			/* Capability word                */
	short orig_zone;		/* originating zone               */
	short dest_zone;		/* Destination zone               */
	short orig_point;		/* originating point              */
	short dest_point;		/* destination point              */
	long ProdData;			/* Product-specific data          */
};

/*--------------------------------------------------------------------------*/
/* WaZOO                                                                    */
/*--------------------------------------------------------------------------*/

#ifndef ACK
#define ACK    0x06
#endif

#ifndef NAK
#define NAK    0x15
#endif

#ifndef ENQ
#define ENQ    0x05
#endif

#ifndef YOOHOO
#define YOOHOO 0x00f1
#endif

#ifndef  TSYNC
#define  TSYNC 0x00ae
#endif

struct _Hello
{
	word signal;			/* always 'o'     (0x6f)                   */
	word hello_version;		/* currently 1    (0x01)                   */
	word product;			/* product code                            */
	word product_maj;		/* major revision of the product           */
	word product_min;		/* minor revision of the product           */
	char my_name[60];		/* Other end's name                        */
	char sysop[20];			/* sysop's name                            */
	word my_zone;			/* 0== not supported                       */
	word my_net;			/* out primary net number                  */
	word my_node;			/* our primary node number                 */
	word my_point;			/* 0== not supported                       */
	byte my_password[8];	/* ALL 8 CHARACTERS ARE SIGNIFICANT !!!!!  */
	byte reserved2[8];		/* reserved by Opus                        */
	word capabilities;		/* see below                               */
	byte reserved3[12];		/* available to non-Opus                   */
							/* systems by prior "approval" of 124/108. */
};							/* size 128 bytes */

/*--------------------------------------------------------------------------*/
/* YOOHOO<tm> CAPABILITY VALUES                                             */
/*--------------------------------------------------------------------------*/

#define Y_DIETIFNA	0x0001
#define FTB_USER	0x0002
#define ZED_ZIPPER	0x0004
#define ZED_ZAPPER	0x0008
#define DOES_IANUS	0x0010
#define DOES_HYDRA	0x0020
#define Bit_6		0x0040
#define Bit_7		0x0080
#define Bit_8		0x0100
#define Bit_9		0x0200
#define Bit_a		0x0400
#define Bit_b		0x0800
#define Bit_c		0x1000
#define Bit_d		0x2000
#define DO_DOMAIN	0x4000
#define WZ_FREQ		0x8000

/*--------------------------------------------------------------------------*/
/* EMSI                                                                     */
/*--------------------------------------------------------------------------*/

/* Indexes into the emsistr array for use by EMSI parsing */

#define EMSI_REQ   0
#define EMSI_DAT   1
#define EMSI_HBT   2
#define EMSI_NAK   3
#define EMSI_ACK   4
#define EMSI_INQ   5
#define EMSI_CLI   6

#define EMSI_LEN   14     /* longest emsi string */
#define EMSI_MAX   6      /* highest emsi string */

#endif				/* BINK_DEFINED */

/* END OF FILE: bink.h */

