; 386POWER example program #0.
; Install a mouse driver, compile, and run.
; When run, use the left mouse button to draw. Any key exits.
        .386p

code32  segment para public use32
        assume cs:code32, ds:code32

include 386power.inc
include 386video.inc
include 386file.inc

public  _Main

CR equ 0dh
LF equ 0ah

; DATA
eraw_text       db      ' Voc2RAW result ( 0 == OK)',0
raw_text       db      ' RAW data size',0
ex_text         db      'TEST ONE for 386POWER',CR,LF
                db      'Testing PWM sound system',CR,LF
                db      'PRESS & RELEASE ESC TO EXIT',0
                
lo_mem          db      'AVAILABLE DOS MEMORY',0
hi_mem          db      'AVAILABLE EXTENDED MEMORY',0

fl_mem          db      'SIZE OF TIGER.VOC FILE',0
man_text        db      'RUNNING UNDER ',0
systypestr      db      'VCPI','DPMI'
hextuff         db      '0123456789ABCDEF'
d_text          db      8 dup(0)
fname           db      'tiger.voc',0

; CODE

PutText:  ; put ECX chars to screen with attr AH
        push edx
        mov  edx,edi
XPutText:        
        lodsb
        cmp al,0
        je CHend
        cmp al,CR
        jne noCR
        mov edi,edx
        jmp nxCH
noCR:   cmp al,LF
        jne noLF
        add edx,160
        add edi,160
        jmp nxCH
noLF:                
        stosw
nxCH:        
        loop XPutText
CHend:        
        pop edx
        ret

;----------------------
d2text: ; edx = dword to convert to hex
        push ebx
        push ecx
        push edi
        
        xor ebx,ebx
        mov edi, offset d_text
        mov ecx, 8
        add edi, 7
        std
txpit:        
        mov ebx,edx
        and ebx,0Fh
        mov al,[ebx+hextuff]
        stosb
        shr edx,4
        loop txpit
        
        pop edi
        pop ecx
        pop ebx
        cld
        ret
        
LargestFree DD 48 dup(0FFFFFFFFh)

;
_Main:  mov al,10h
        mov V86ax,0003 ; text mode 80 columns, 16 colors
        int 33h
        
        sti ; enable interrupts
        
        @rlp edi,0b8000h     ; get relative pointer to text screen
        mov ecx,(80*25)/2    ; and clear it
        mov eax,0            ;
        rep stosd            ;

        @rlp edi,0b8000h+(50*2)    ; put type of system
        mov esi,offset man_text    ;
        mov ecx,-1                 ;
        mov ah,14                  ;
        call PutText               ;
        movzx esi,_386Man          ;
        and esi,1                  ; all the other bits will be 0, but
        lea esi,[esi*4+systypestr] ; what the heck!
        mov ecx,4                  ;
        mov ah,15                  ;
        call PutText               ;
        
        
        mov edx,_HiMemTop          ; write allocated ext. mem. size
        sub edx,_HiMemBase         ;
        call d2text                ;
                                   ;
        @rlp edi,0b8000h           ;
        mov esi,offset d_text      ;
        mov ecx,8                  ;
        mov ah,13                  ;
        call PutText               ;
                                   ;
        @rlp edi,(0b8000h+18)      ;
        mov esi,offset hi_mem      ;
        mov ecx,-1                 ;
        mov ah,13                  ;
        call PutText               ;
        
        mov edx,_LoMemTop          ; write available low mem size
        sub edx,_LoMemBase         ;
        call d2text                ;
                                   ;
        @rlp edi,(0b8000h+160)     ;
        mov esi,offset d_text      ;
        mov ecx,8                  ;
        mov ah,12                  ;
        call PutText               ;
                                   ;
        @rlp edi,(0b8000h+160+18)  ;
        mov esi,offset lo_mem      ;
        mov ecx,-1                 ;
        mov ah,12                  ;
        call PutText               ;


        mov esi, offset fname    ; load at _HiMemBase file called fname
        call _FLoad              ; BUT do not update _HiMemBase
        ; eax == file size
        
        pushad                         ; write size of file loaded
        mov edx,eax                    ;
        call d2text                    ;
                                       ;
        @rlp edi,(0b8000h+(160*2))     ;
        mov esi,offset d_text          ;
        mov ecx,8                      ;
        mov ah,11                      ;
        call PutText                   ;
                                       ;
        @rlp edi,(0b8000h+(160*2)+18)  ;
        mov esi,offset fl_mem          ;
        mov ecx,-1                     ;
        mov ah,11                      ;
        call PutText                   ;
        popad                          ;
        
        cmp eax,-1       ; does we had problems?
        je skipsound     ;
        
        pushad  ; save 
        
        call _InstallPWM      ; install PWM sound system and initialize
                              ; the voc converter table
        
        mov edi,_LoMemBase
        mov esi,_HiMemBase
        call _Voc2RAW    ; convert into PWM count format
        
        and eax,0FFh                ; display Voc2RAW result
        mov edx,eax                 ;
        call d2text                 ;
                                    ;
        @rlp edi,(0b8000h+(160*8))  ;
        mov esi,offset d_text       ;
        mov ecx,8                   ;
        mov ah,11                   ;
        call PutText                ;
        
        @rlp edi,(0b8000h+(160*8)+20) ; explanatory text
        mov esi,offset eraw_text      ;
        mov ecx,0                     ;
        mov ah,11                     ;
        call PutText                  ;
        
        popad
        
        mov edi,_LoMemBase ; point to "pwm" data
        
        mov edx,[edi]                 ; write lenght of "raw" data
        call d2text                   ;
                                      ;
        @rlp edi,(0b8000h+(160*9))    ;
        mov esi,offset d_text         ;
        mov ecx,8                     ;
        mov ah,11                     ;
        call PutText                  ;
                                      ;
        @rlp edi,(0b8000h+(160*9)+20) ;
        mov esi,offset raw_text      ;
        mov ecx,0                     ;
        mov ah,11                     ;
        call PutText                  ;
        mov edi,_LoMemBase
        mov eax,[edi]
        mov _DSoundLen,eax  ;  set lenght of digitized samples
        mov _SoundLen,eax   ;
        add edi,4
        mov _DSoundPtr,edi ; set pointers
        mov _SoundPtr,edi  ;
        
        mov _DSoundOn,1  ; turn on repetition of default sound
        
        mov _SoundOn,1   ; turn on sound
        
        
        
skipsound:       
        @rlp edi,(0b8000h+(160*22)+(40*2)) ; explain this test
        mov esi,offset ex_text             ;
        mov ecx,-1                         ;
        mov ah,10                          ;
        call PutText                       ;
        
        call _InstallRKB ; install raw keyboard
        
kkey:        
        call _WaitKey     ; wait fo a key press

        mov edi,offset _RKB
        cmp byte ptr [edi+_ESC],KPRESSED
        jne kkey
thend:        
        @rlp edi,0b8000h      ; restore default screen attributes
        mov ecx,2000          ;
        mov al,07             ;
defcolor:                     ;
        inc edi               ;
        stosb                 ;
        loop defcolor         ;
        
        jmp _Exit


code32  ends
        end

