include 386video.inc

; _VPix
; _VBlock
; _Scr2Scr

code32 segment para public use32
       assume cs:code32,ds:code32



        public _Pix
_Pix:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; cl= color
        
        push edi 
        add edi,[edx*4+_RowStart]
        add edi,eax
        mov [edi],cl
        pop edi
	ret

; ==========================================================================
;
; BLOCK BLITTING FUNCTIONS
;
; ==========================================================================

        public _Block

_Block:
        ; blit a single color block on screen
        ;edi = screen base offset
        ;eax = x position in pixels
        ;edx = y position in pixels
        
        ;ecx = block width in nudgets
        ;ebx = block height in pixels
        ;esi = color pattern  (all 4 bytes are used)

        pushad
        
        add edi,eax                   ;
        add edi,[edx*4 + _RowStart]   ; edi = upper-left block corner
        
        mov edx,ecx       ;edx = x width in nudgets
        neg ecx
        mov eax,esi
        lea esi,[ecx*4+PXWIDTH]
@zblock:
        mov ecx,edx
        rep stosd ; ZOOM! Thundering speed!
        add edi,esi ; next line
        dec ebx
        jne @zblock
        
        popad
	ret


        public _Scr2Scr

_Scr2Scr:
        ; copy a screen rectangle fron a display page to another
        ; eax = x position in pixels
        ; edx = y position in pixels
        ; ecx = x width  in nudgets
        ; ebx = y height in pixels
        ; esi = scr_source base offset
        ; edi = scr_dest base offset
        
        pushad
        
        add eax,[edx*4+_RowStart]
        add esi,eax
        add edi,eax
        
        mov edx,PXWIDTH
        mov eax,ecx  ; eax = width counter
        shl ecx,2 ;nudgets to pixels
        sub edx,ecx
@zipscr:
        mov ecx,eax
        rep movsd
        add edi,edx
        add esi,edx
        dec ebx
        jne @zipscr
        popad
        ret

code32 ends

 END

