; experimental code, do not use it, it is badly commented
; (partially in italian and partially in english) and may change a lot.

; _RawStick
; _Stick

code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc

; What is needed to read the joystick port:
;1.  Trigger the joystick oneshots with an 'out' to 0x201.
;    This will set all of the joystick bits on.

;2.  Read (in) 0x201, finding:

;	 Bit		 Contents
;	 0		 Joystick A X coordinate
;	 1		 Joystick A Y coordinate
;	 2		 Joystick B X coordinate
;	 3		 Joystick B Y coordinate
;	 4		 Button A 1
;	 5		 Button A 2
;	 6		 Button B 1
;	 7		 Button B 2
;
;3.  Continue reading 0x201 until ALL oneshots return to zero
;    (i've seen lots of joystic routines that seems to miss this)
;    recording the loop during which each bit falls to zero.
;    The duration of the pulse from each oneshot may be used to
;    determine the resistive load (from 0 to 100K) from each
;    Joystick, as: Time = 24.2msec. + .011 (r) msec.
;
;4.  To do this correctly, I recommend calibrating the joystick;
;    have the user move the stick to each corner, then center it,
;    while recording the resulting values.

       public _JX_A, _JY_A, _JX_B, _JY_B, _B1_A, _B2_A, _B1_B, _B2_B

      align dword
; le seguenti DWORDS contengono il valore del downcounter
; quando il corrispondente bit della porta joystick e' sceso
; sotto la tensione di soglia
; ( N.B questi sono valori "grezzi" con un errore medio del 10% !!!!)
_JX_A DD 0
_JY_A DD 0
_JX_B DD 0
_JY_B DD 0
_B1_A DD 0
_B2_A DD 0
_B1_B DD 0
_B2_B DD 0

; parametri per lettura joystick A calibrato
JUP_A dd 0 ; up   threshold
JDN_A dd 0 ; down threshold
JLF_A dd 0 ; left threshold
JRG_A dd 0 ; right threshold

; parametri per lettura joystick B calibrato
JUP_B dd 0
JDN_B dd 0
JLF_B dd 0
JRG_B dd 0


		public _POLL_TIME,_BUTTON_MID

_POLL_TIME      dd 0FFFFFFFFh
		; MAX. NUMBER OF LOOPS WE HAVE TO PERFORM
		; TO COMPLETELY DECODE THE JOYSTICK PORT
                ; (dopo il test di calibrazione del joystick
                ;  inizializzarlo con il valore di downcount piu grande
                ;  che sia stato rilevato)

_BUTTON_MID     dd 0FFFFFFFFh
                ; "default" threshold for joystick button pressed
                ; you must calibrate this too!


JPORT	equ 0201h

        align byte
        
        Public _RawStick

_RawStick proc
           mov ecx,_POLL_TIME
           mov al,0FFh

	   mov dx,JPORT

           xor ebx,ebx ; questo serve per eseguire somme veloci

	   ; azzera
           mov _JX_A,ebx
           mov _JY_A,ebx
           mov _JX_B,ebx
           mov _JY_B,ebx
           mov _B1_A,ebx
           mov _B2_A,ebx
           mov _B1_B,ebx
           mov _B2_B,ebx

	   cli
	   out dx,al ; trigger RCs

girastick:
	   in al,dx ; leggi lo stato delle linee del joystick

	   ; aggiorna i contatori
	   shr al,1
           adc _JX_A,ebx
	   shr al,1
           adc _JY_A,ebx
	   shr al,1
           adc _JX_B,ebx
	   shr al,1
           adc _JY_B,ebx
	   shr al,1
           adc _B1_A,ebx
	   shr al,1
           adc _B2_A,ebx
	   shr al,1
           adc _B1_B,ebx
	   shr al,1
           adc _B2_B,ebx

	   loop girastick
	   sti
	   ret

        public _Stick
_Stick:
        call _RawStick        
        ; x axis translation raw->logical
        ; -1 = left
        ;  0 = center
        ;  1 = right
        mov eax,_JX_A
        mov ebx,-1
        cmp eax,JLF_A
        ja done_xa
        inc ebx
        cmp eax,JRG_A
        ja done_xa
        inc ebx
done_xa: mov _JX_A,ebx
        mov eax,_JX_B
        mov ebx,-1
        cmp eax,JLF_B
        ja done_xb
        inc ebx
        cmp eax,JRG_B
        ja done_xb
        inc ebx
done_xb: mov _JX_B,ebx
        ; y axis translation raw->logical
        ;  -1 = up
        ;   0 = center
        ;   1 = down
        mov eax,_JY_A
        mov ebx,-1
        cmp eax,JUP_A
        ja done_ya
        inc ebx
        cmp eax,JDN_A
        ja done_ya
        inc ebx
done_ya: mov _JY_A,ebx
        mov eax,_JY_B
        mov ebx,-1
        cmp eax,JUP_B
        ja done_yb
        inc ebx
        cmp eax,JDN_B
        ja done_yb
        inc ebx
done_yb: mov _JY_B,ebx

        ; traduzione pulsanti  1= pressed 0 = not pressed
        xor ebx,ebx
        mov edx,_BUTTON_MID
        cmp _B1_A,edx
        ja nob1a
        inc ebx
nob1a:  mov _B1_A,ebx
        xor ebx,ebx
        mov edx,_BUTTON_MID
        cmp _B2_A,edx
        ja nob2a
        inc ebx
nob2a:  mov _B2_A,ebx        
        xor ebx,ebx
        mov edx,_BUTTON_MID
        cmp _B1_B,edx
        ja nob1b
        inc ebx
nob1b:  mov _B1_B,ebx
        xor ebx,ebx
        mov edx,_BUTTON_MID
        cmp _B2_B,edx
        ja nob2b
        inc ebx
nob2b:  mov _B2_B,ebx
        ret
        
code32 ends        
	   END
