.386P

;-----------------------------------------------------------------------------
; VGA I/O ports

STATUS          = 03DAh ; status register port

IS_HVSYNC       = 01
IS_VSYNC        = 08

CRTC            = 03D4h ; CRT Controller port
VGAIRQ          =     011h    ; CRTC porta contenente i bit di gestione IRQ9
VSTART_HI       =     0ch     ; CRTC bitmap start address high byte
VSTART_LO       =     0dh     ; CRTC bitmap start address low byte
VSTART_HILO     =     0c0dh   ; indici combinati
LINE_OFS        =     13h     ; CRTC physical bitmap width
UNDERLINE       =     14h     ; CRTC
MODE_CONTROL    =     17h     ; CRTC
OVERFLOW        =     07h     ; CRTC overflow register index
MAX_SCAN_LINE   =     09h     ; CRTC maximum scan line register index
LINE_COMPARE    =     18h     ; CRTC line comp reg. index (bits 0-7 of
                              ; split screen scan line )
                              
GRAPHICS        = 03CEh
FUN_SELECT      =     03h     ;index in GC of Rotate/Function Select
READ_MAP        =     04h     ;index in GC of Read Map register
BIT_MASK        =     08h     ;index in GC of Bit Mask register
ALL_BIT         =     0FF08h  ; bit mask + all bits ON

MISCELLANEOUS   =     06h  ; GC
GRAPHICS_MODE   =     05h  ; GC read/write access mode

DACREAD         = 03C7h
DACWRITE        = 03C8h
DACDATA         = 03C9h

SEQUENCER       = 03C4h
MAP_MASK        =     02h     ;index in SC of Map Mask register
MEMORY_MODE     =     04h     ; SC text/graphics/chain4

ATTRIBUTE       = 03C0h
PEL_PANNING     =     33h    ;indice PEL panning  + display enable (20h)
ATTR_CONTROL    =     30h    ;indice ATTR control + display enable (20h)

NOSPLITPAN      =     20h
PRESET_SCAN     =     08h    ; offset iniziale di visualizzazione

; write plane selectors ( hi = mask, lo= register index)
WP0 = 0102h
WP1 = 0202h
WP2 = 0402h
WP3 = 0802h
WPA = 0F02h

; values to ROL bit masks while blitting sprite
WWP0 = 8802h
WWP3 = 4402h

WRITEPLANE macro wplane
	   mov dx,SEQUENCER
           mov ax,wplane
	   out dx,ax
 endm

RP0 = 0004h
RP1 = 0104h
RP2 = 0204h
RP3 = 0304h

READPLANE macro rplane
	   mov dx,GRAPHICS
           mov ax,rplane
	   out dx,ax
 endm

WPUT   = 0003h
WAND   = 0803h
WOR    = 1003h
WXOR   = 1803h

WRITEMODE macro wmode
	  mov dx,GRAPHICS
          mov ax,wmode
	  out dx,ax
 endm

; modi validi a 256 colori !!!!!
BLITPLANE = 4005h
BLITBLOCK = 4105h

BLITMODE  macro bmode
	  mov dx,GRAPHICS
          mov ax,bmode
	  out dx,ax
 endm
 
;-----------------------------------------------------------------------------
; definizioni per il Programmable Interrupt Timer  (PIT) chip 8253
PIT0 = 40h ; porta dati del canale 0 (collegato ad IRQ0)
PIT1 = 41h ; canale 1, usato per il refresh della RAM
PIT2 = 42h ; canale 2, collegato allo speaker

PIT_CTRL = 43h ; porta di controllo dell' 8253

T_SET0 = 036h ; canale 0, modo ad onde quadre, leggi/scrivi LSB&MSB
              ; comando standard per programmare interrupt temporizzato
              
T_SET2 = 0B6h ; canale 2, modo ad onde quadre, leggi/scrivi LSB&MSB
              ; comando standard per emettere suono periodico
              ; (se si attiva l' uscita tramite il keyboard controller)
              
P_SET2L = 0B6h ; canale 2, modo quadra, leggi/scrivi LSB&MSB
P_SET2S = 096h ; canale 2, modo quadra, leggi/scrivi solo LSB

F8008 = 149       ; valore downcounter per avere una frequenza di 8008Hz
                  ; 149 == 8008 Hz
F18_2 = 0000      ; valore downcounter per avere una frequenza di 18,2 Hz
                  ; (in realta si deve scrivere 0000h nel contatore del chip)
                  

;------------------------------------------------------------------------------
; definizioni dei Programmable Interrupt Controllers                  

; Master PIC: IRQ0..IRQ7 ( IRQ2 chains slave PIC)
PIC0_CTRL = 020h
PIC0_DATA = 021h
; Slave PIC: IRQ8..IRQF ( IRQ9 is the "alias" for the original unchained IRQ2
; found on pc-xt , so if you set a board on IRQ2 it will use IRQ9)

PIC1_CRTL = 0A0h
PIC1_DATA = 0A1h

EOI  = 020h ; End Of Interrupt (riabilita tutti gli interrupt sul PIC)
SEOI = 060h ; Specific End Of Interrupt (da usare nel caso di overruns)
            ; Se mentre si e' in un ISR arriva UN NUOVO IRQ corrispondente
            ; a quello su cui si sta lavorando, "lo si mette a tacere"
            ; usando SEOI.
            
;------------------------------------------------------------------------------
; DISPLAY DESCRIPTORS & PARAMETERS
; PARAMETRI DI DESCRIZIONE IMMAGINE VIDEO

; size of the display buffer mapped into RAM
SCRSIZE = 64000
; real size (in pixels) of a display page
RXWIDTH    = 320
DXWIDTH    = 320
RYHEIGHT   = 182
INTERSPACE = 12

; virtual size of a display page (halved)
VXWIDTH    = (320*10)
VYHEIGHT   = 338

; tiles (bitmaps 32x26) on a virtual page
XTILES = 10*10
YTILES = 14
; tiles on screen
SXTILES =10
SYTILES =7

; tile width & height
TWIDTH  = 32
THEIGHT = 26
; tile size
TILESIZE = (TWIDTH*THEIGHT)

; Logical size of visible display window (pixels)
LXWIDTH    = RXWIDTH
LYHEIGHT   = RYHEIGHT

; X width in addressing unit (nudget)
PXWIDTH    = (RXWIDTH)

; X width in scanline units (double nudgets)
SXWIDTH    = (RXWIDTH)

; Now follows the parameters for what i call "the scoreboard"
; A window on the lower part of the screen with fixed mapping at
; linear address 0A0000h ( 0A000:0000 in seg:ofs mapping)
; SCOHEIGHT = altezza della "scoreboard"  = 200 - inizio_scoreboard
;                                           + 1 interlinea di sicurezza

SCOHEIGHT = (200-LYHEIGHT+1)

; Logical size of a character bitmap
LCHARX = 8
LCHARY = 8

; spazio occupato da un char in unita di indirizzamento 
CHARSIZE  = (LCHARX*LCHARY)

; shift equivalente a CHARSIZE
CHARSHIFT = 6

; indirizzo lineare della base della "finestra di memoria" della scheda vga
; equivale all' indirizzo base della finestra "segnapunti" (scoreboard)
SCOBASE   = 000A0000h

; base address for first page
BASE0   = (SCOBASE+(SCOHEIGHT*PXWIDTH))
; base address for second page (with an interline space between)
BASE1   = (BASE0+((RYHEIGHT+INTERSPACE)*PXWIDTH))
; base address for third page
BASE2   = (BASE1+((RYHEIGHT+INTERSPACE)*PXWIDTH))

NUMCHAR    = 128

; Value currently not supported
UPDOWN    = 2

; Supported value for blit 
LEFTRIGHT = 1

PIXSHIFT  = 2
PIXMUP    = 3

; base offset of next page displayed by _PageFlip
Global _ActiveBase :dword
; base offset of page currently displayed
Global _ViewBase   :dword
; base of "scoreboard" window in the lower part of the screen
Global _ScoBase    :dword
; array of dwords containing line start displacements from page base offset
Global _RowStart   :dword

Global _SetGameMode: near
       ; Initialize game mode
       ; 320x200 planar (mode-x) screen
       ; with a main 320x182 "game" window
       ; selectable between 3 overlapping display pages
       ; and a 320x18 "scoreboard" window
       ; turn on "timer limited" triple page flipping

Global _RestoreTextMode: near
       ; Restores 80x25 color text mode
       
Global _WaitVR: near
       ; Waits a full Vertical Retrace Interval
       ; (it disables interrupts while waiting, use it with care)

Global _DisplayStart: near
       ; EAX= x_position (bits 0..1 ignored) 
       ; EBX = y_position 
       ; It set the new x,y position inside the display page
       ; it will be effective at the next _PageFlip
       
Global _PageFlip: near
       ; Set the old active page (the one referenced thru _ActiveBase)
       ; as the new viewable page (the one referenced thru _ViewBase)
       ; and swaps pointers
       ; N.B. Is uses TRIPLE buffering (there are 3 display pages)
       ;      and limits the "flipping" rate to 60Hz
       ;      by way of timer channel 0.
       
Global _WipeVRAM:near
        ; EAX= four color patter to set display memory to
        ; (every pixel in the color pattern will be repeated four times)
        
       


Global _SoundOn:byte,_SoundLen:dword,_SoundPtr:dword
Global _DSoundOn:byte,_DSoundLen:dword,_DSoundPtr:dword

Global _RKB:byte
        ; _RKB is a table of 128 bytes, where the n-th byte
        ; contains the status of the n-th keyboard key
        ; bit 0 = 1 == key IS pressed
        ;         0 == key IS NOT pressed
        ; bit 1 = 1 == key HAS BEEN pressed since last time you reset
        ;              this bit
        ; bit 2..7 = always set to zero.
        ; An irq handler sets/resets bit0 for every key pressed/released
        ; but ONLY set bit 1 if a key has been pressed
        ; (you must reset bit1 on your own).
        ; thus....
        ;   0 == not pressed
        ;   3 == currently pressed
        ;   2 == has been pressed AT LEAST one time, currently is released
KPRESS   = 3
KPRESSED = 2      
        ;   I don't provide routines or macros to read the keyboard table
        ;   but i provide keyboard scancodes for a US keyboards.
        ;   In some countries some alphabetic keys gets placed differently
        ;   but you can trust on the position of cursor,keypad & fn-keys 
        ;   and on the various ESC,ALT,CTRL,SHIFT,BACKSPACE & RETURN keys
        ;   plus "the first row" on the alphanumeric portion
        ;   (that is: the 1,2,...9,0 keys above the alphabetic keys)
        ;   
        ;   HOW TO "READ" A KEY: 
        ;   if for example you want to read status of the ESC key
        ;   and the edi register contains the offset of _RKB...
        ;
        ;   instruction:                     if Zero flag is set after
        ;                                    executing the istruction then ...
        ;
        ;   test edi,[edi + _ESC],KPRESSED   This key has been pressed
        ;                                  
        ;   cmp  edi,[edi + _ESC],KPRESSED   This key has been pressed
        ;                                    AND NOW is NOT pressed
        ;
        ;   cmp  edi,[edi + _ESC],KPRESS     This key is CURRENTLY pressed
        
Global _RKBPressed:byte
        ; set to 1 every time a key is pressed
        
Global _InstallRKB: near
        ; installs the bimodal raw keyboard handlers
        ; ( use _InstallRKB before using the "raw keyboard" 
        ; data structures and functions)
        ; Remember that this meas that all dos keyboard input
        ; and int 16h functions ARE DISABLED!!
        
Global _InstallDKB: near
        ; installs the standard MS-DOS keyboard handler
        ; so you can use the standard dos keyboard functions
        ; It detects if _InstallRKB was called and if this happened
        ; it sets handlers back to DOS
        
Global _InstallOKB: near
        ; AFTER you called _InstallRKB or _InstallDKB
        ; it restores the previous keyboard handler
        
Global _WaitKey: near
        ; resets the _RKBPressed flag & waits a key press

Global _InstallPWM: near
        ; installs the PWM pc-speaker drive & timer driven page flipper
        ; and installs the voc->PWM translation table
        ; WARNING! The PWM system is still in an early experimental beta stage
        ; (tried lots of different methods, this one still has some bugs)
        
Global _Voc2RAW: near                
        ; converts an 8 bit not-compressed mono .VOC file
        ; to "RAW" encoded data
        ; You must install a sound driver (i.e. _InstallPWM for the pc-speaker
        ; driver) to set up the voc->raw translation table
        
Global _TimerTicks:dword,_SysTicks:dword,_Seconds:dword
        ; _TimerTicks counts how many 1193180Hz "ticks" have occured
        ; _SysTicks counte how many 18.2Hz "ticks" have occoured
        ; _Seconds ... self explanatory, uh?
        ; To read meaningful values you must activate game mode
        ; ( call _SetgameMode) or the pwm sound driver.
       
; RAW KEYBOARD (_RKB) INDEXES
_ESC = 1
_1 = 2
_2 = 3
_3 = 4
_4 = 5
_5 = 6
_6 = 7
_7 = 8
_8 = 9
_9 = 0Ah
_0 = 0Bh

_F1  = 3Bh
_F2  = 3Ch
_F3  = 3Dh
_F4  = 3Eh
_F5  = 3Fh
_F6  = 40h
_F7  = 41h
_F8  = 42h
_F9  = 43h
_F10 = 44h
_F11 = 57h
_F12 = 58h

_ALT       = 38h
_CTRL      = 1Dh
_LSHIFT    = 2Ah
_RSHIFT    = 36h
_CAPSLOCK  = 3Ah
_TAB       = 0Fh
_BACKSPACE = 0Eh
_ENTER     = 1Ch

_HOME   = 47h
_UP     = 48h
_PGUP   = 49h
_LEFT   = 4Bh
_CENTER = 4Ch
_RIGHT  = 4Dh
_END    = 4Fh
_DOWN   = 50h
_PGDN   = 51h

_INS    = 52h
_DEL    = 53h

_KMINUS = 4Ah
_KPLUS  = 4Eh

_SPACEBAR = 39h

