//	vga.cpp		03/21/97	v0.93
//
//	This file contains the BASE CLASS for all sub-derived SVGA chipsets.
//	class vga does NOT offer any user-alterable settings, by itself.
//
//	The version# of VGA.CPP always reflects the MOST RECENT DATE of any
//	of the constituent svga source codes (S3, CIRRUS, etc.)
//

#define __vgachipset__
#include "vga.h"

//	Required for proper chips.h operation

#include <dos.h>
#include<stdio.h>
#include<string.h>
#include<stdlib.h>

/*
 *	VGA class function definitions
 */


vga::vga( vga_info info )	// Constructor, Initializes "vga.id" with info
{
	id= info;
	num_param=0;	//	Set number of parameters to 0
	param=NULL;	//	Set param pointer to NULL
	status = EXIT_SUCCESS;
}

uchar
vga::shift( uchar in )
{    //	Shift will "remap" data according to S3-801/805's parameters
	switch ( in )	{
		case 0x02:	in = 3;	// 0010 -> 0011
			break;
		case 0x03:	in = 2;	// 0011 -> 0010
			break;
		default:	;		//All other values unaffected
	}
	return in;
}


char *
vga::bitstat( uchar bit )	//	Returns "ENABLE or DISABLE"
{
	return ( bit ? "enable" : "disable" );
//	if ( bit )
//		return "enable";
//	else
//		return "disable";
}


uchar vga::read_SR ( uchar index )	// Read VGA_SR register 'index'
{
	outportb( _SRindex, index );
	return inportb( _SRIO );
}

void vga::write_SR( uchar index, uchar data )	// Write VGA_SR register
{
	outportb( _SRindex, index );
	outportb( _SRIO, data );
}

uchar vga::read_CR ( uchar index )	// Read VGA_CR register 'index'
{
	outportb( _CRindex, index );
	return inportb( _CRIO );
}

void vga::write_CR( uchar index, uchar data )	// Write VGA_CR register
{
	outportb( _CRindex, index );
	outportb( _CRIO, data );
}


uchar	//	Read a single BIT(bit) from VGA IO port index
vga::read_bit ( int port, uchar index, uchar bit )
{
	uchar data;
	outportb( port, index );
	data = inportb( port + 1 );
	return ( data >> bit ) & 0x01;	// Returns 1 or 0
}


uchar
vga::read_bit ( int port, uchar bit )
{
	return ( inportb( port ) >> bit ) & 0x01;
}


void	// Write a single BIT(bit) to VGA IO port, while preserving other bits!
vga::write_bit( int port, uchar index, uchar bit, uchar data )
{
	uchar old_byte, mask = 0x01;

	mask = ~( mask << bit );
	data = data << bit;

	outportb( port, index );
	old_byte = inportb( port + 1 ) & mask;
	outportb( port, index );
	outportb( port + 1, old_byte | data );
}

void
vga::write_bit( int port, uchar bit, uchar data )
{
	uchar old_byte, mask = 0x01;

	mask = ~( mask << bit ); // negate bitfield 0010 0000 -> 1101 1111
	data = data << bit;

	old_byte = inportb( port ) & mask;
	outportb( port, old_byte | data );
}


// returns # of parameters scanned, 0 if unsuccessful
int
vga::parse_param( int index, uchar *parsed ) // Acquire 1 parameter
{
	int temp = 0;
	if ( param[ index ] )
		temp = sscanf( param[ index ], " %u", parsed );

	return temp;	//	0 = unsucessful
}


// Quick function for printing (to string deststr) HEX values XX

void
vga::hexout( ostrstream &deststr, int value )
{
	deststr.setf( ios::hex | ios::uppercase );
	deststr.fill('0');
	deststr.width( 2 );	// Want left-edge blank digits to be '0'
	deststr << value ;
	deststr.unsetf( ios::hex | ios::uppercase );
}


message
vga::get_vgahelp( void )
{
	INITMSG( msg.text );

	msgout<<"**** If you're running MCLK from Windows 3.x or Windows95, "<<
		"\n**** you must do so from a FULL-SCREEN DOS box!" <<
		"\n\nFor a list of supported chipsets\n\t" << _argv[ 0 ] <<
		" /F\n\nUsage : MCLK.EXE /0 aa /1 bb /2 cc " <<
		".. \n\n\t...where 0, 1 & 2 represent menu option(s) " <<
		"0 - 5\n\t...and aa, bb, cc, etc. are parameters." <<
		"\n\t   (some functions require several parameters)" ;
	msgout << ends ;	// Terminate string!
	return msg;
}


//	This next function is the "command-center."  The main program, MCLK.CPP,
//	access all SVGA functions (settings) through this go() function.
void
vga::go( int fxn, int cmd )	// cmd = _SET, _GET, _QUERY
{
	status= EXIT_SUCCESS;
	msg.text[ 0 ] = NULL; // 0.90 to fix text-redundancy during execution
	msg.temp[ 0 ] = NULL; // 0.90 of multiple commands
	INITMSG( msg.text );
		// Initialize msgout to first char in text-buffer

	if ( num_param == 0 )	// If there are no parameters, default to HELP
		cmd = _HELP;

	switch ( cmd )	{
		case _HELP:	case _SET:	case _GET:	case _QUERY:
			switch( fxn )	{
				case 0:	_mclk( cmd );
					break;
				case 1:	_fxn1( cmd );
					break;
				case 2:	_fxn2( cmd );
					break;
				case 3:	_fxn3( cmd );
					break;
				case 4:	_fxn4( cmd );
					break;
				case 5:	_fxn5( cmd );
					break;
				default:
					msgout << "_fxn" << fxn << " not defined" << ends;
					status= EXIT_FAILURE;
			}
			break;
		default:
			msgout << "vga::go( " << cmd << " ) unrecognized cmd" <<
				ends;
			status= EXIT_FAILURE;
	}
}


message	//	Returns a struct message, with what available SVGA settings
vga::get_settings( void )
{
	message settings;
	ostrstream stgout( settings.text, sizeof( settings.text ) );

	_mclk( _QUERY );
	stgout << msg.text ;
	_fxn1( _QUERY );
	stgout << msg.text ;
	_fxn2( _QUERY );
	stgout << msg.text ;
	_fxn3( _QUERY );
	stgout << msg.text ;
	_fxn4( _QUERY );
	stgout << msg.text ;
	_fxn5( _QUERY );
	stgout << msg.text << ends;
	return settings;
}


void
vga::_fxn1( int cmd )
{
	INITMSG( msg.text );
	msgout << "1  function NOT available.\n" << ends;
	status = EXIT_FAILURE;
}


void
vga::_fxn2( int cmd )
{
	INITMSG( msg.text );
	msgout << "2  function NOT available.\n" << ends ;
	status = EXIT_FAILURE;
}


void
vga::_fxn3( int cmd )
{
	INITMSG( msg.text );
	msgout << "3  function NOT available.\n" << ends;
	status = EXIT_FAILURE;
}


void
vga::_fxn4( int cmd )
{
	INITMSG( msg.text );
	msgout << "4  function NOT available.\n" << ends;
	status = EXIT_FAILURE;
}


void
vga::_fxn5( int cmd )
{
	INITMSG( msg.text );
	msgout << "5  function NOT available.\n" << ends;
	status = EXIT_FAILURE;
}


void
vga::_mclk( int cmd )
{
	INITMSG( msg.text );
	msgout << "0  MCLK function NOT available.\n" << ends;
	status = EXIT_FAILURE;
}


message
vga::_info( void )
{
	INITMSG( msg.text );
	msgout << "(No chipset specific information available.)" << ends;
	status = EXIT_FAILURE;
	return msg;
}