:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                              INSTALL.BAT                                ::
::               Copyright 1995, 1996 McAfee Associates, Inc.              ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  @IF NOT "%3" == "DEBUG2" ECHO OFF
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Check for troubleshooting mode switches.                                ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  IF "%3" == "GOTO"   GOTO JumpCheck
  IF "%3" == "DEBUG"  GOTO JumpCheck
  IF "%3" == "DEBUG2" GOTO JumpCheck
  GOTO SourceCheck
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: If specified, go directly to label (case-sensitive), except JumpCheck.  ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :JumpCheck
    IF "%4" == "JumpCheck" GOTO SourceCheck
    IF "%4" == ""          GOTO SourceCheck
    GOTO %4
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Display help if user fails to specify installation source directory.    ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :SourceCheck
    IF "%1" == ""          GOTO WhereAmI
    IF "%1" == "GOTO"      GOTO WhereAmI
    GOTO TargetCheck
  :WhereAmI
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                    BootShield Installation Error!                    I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I The BootShield installation requires that you specify which          I
    ECHO I directory the source files are located in.                           I
    ECHO I                                                                      I
    ECHO I Examples:                                                            I
    ECHO I   A:\INSTALL A:                                                      I
    ECHO I   B:\INSTALL B:                                                      I
    ECHO I   C:\TEMP\INSTALL C:\TEMP                                            I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    GOTO Aborted
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Rerun with default if target directory is not specified.                ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :TargetCheck
    IF "%2" == ""          GOTO DefaultTarget
    IF "%2" == "GOTO"      GOTO DefaultTarget
    GOTO PackingCheck
  :DefaultTarget
    %1\INSTALL.BAT %1 C:\McAfee\BShield %2 %3
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Verify all files in the packing list are in the source directory.       ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :PackingCheck
    %1\SELFCHEK.EXE %1\PACKING.LST Directory of /were validated
    IF NOT ERRORLEVEL 1 GOTO OSInstalledCheck
    GOTO PackingError
  :PackingError
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                    BootShield Installation Error!                    I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I One or more of the installation files are missing from the source    I
    ECHO I directory specified.                                                 I
    ECHO I                                                                      I
    ECHO I Please check the file PACKING.LST for required files.                I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    GOTO Aborted
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Check to see what operating systems are installed and warn if 32-bit.   ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :OSInstalledCheck
    IF EXIST C:\SYSTEM.1ST   GOTO InstalledOS
    IF EXIST C:\NTLDR        GOTO InstalledOS
    IF EXIST C:\NTDETECT.COM GOTO InstalledOS
    IF EXIST C:\OS2LDR       GOTO InstalledOS
    IF EXIST C:\OS2KRNL      GOTO InstalledOS
    GOTO OSRunningCheck
  :InstalledOS
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                    BootShield Installation Error!                    I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I WARNING:  BootShield installation has detected that one or more of   I
    ECHO I the following operating systems are installed on this computer:      I
    ECHO I   Windows 95, Windows NT, OS/2.                                      I
    ECHO I                                                                      I
    ECHO I Due to the nature of the BootLock feature of BootShield, it is not   I
    ECHO I recommended that you install BootShield on this computer.  If you    I
    ECHO I continue, you may experience serious problems with your computer.    I
    ECHO I                                                                      I
    ECHO I For more information, please refer to the BootShield manual.         I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %1\GETREPLY.EXE Do you wish to continue the installation (Y/N)? ;yn
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO OSRunningCheck
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Check to see what operating system is running and abort if needed.      ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :OSRunningCheck
    IF NOT "%windir%"     == "" GOTO RunningOS
    IF NOT "%winbootdir%" == "" GOTO RunningOS
    IF NOT "%systemroot%" == "" GOTO RunningOS
    IF NOT "%os2_shell%"  == "" GOTO RunningOS
    GOTO ReadManualWarning
  :RunningOS
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                    BootShield Installation Error!                    I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I BootShield installation detected that you are attempting to install  I
    ECHO I while running Windows or OS/2.  Due to the nature of these           I
    ECHO I environments, installation cannot continue.                          I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    GOTO Aborted
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Remind user to review manual before installing.                         ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :ReadManualWarning
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I WARNING:  BootShield replaces critical system startup areas, such as I
    ECHO I the Master Boot Record, which may affect your computer's normal      I
    ECHO I operation.  While BootShield is an effective boot virus deterent, if I
    ECHO I installed and operated improperly, BootShield may significantly      I
    ECHO I corrupt system data.                                                 I
    ECHO I                                                                      I
    ECHO I YOU MUST READ AND UNDERSTAND THE USER MANUAL BEFORE INSTALLING!      I
    ECHO I                                                                      I
    ECHO I Failure to do so may result in serious loss of data.  If you         I
    ECHO I frequently modify your system boot area, such as changing operating  I
    ECHO I systems, adding or removing partitions, or using sector editors to   I
    ECHO I directly access the drive, you will have to uninstall BootShield     I
    ECHO I often.  It is also suggested to frequently utilize ImageStor or your I
    ECHO I favorite backup utility as a disaster recovery method.  Once again,  I
    ECHO I if you are unsure about any of the above requirements, we suggest    I
    ECHO I that you delay your installation.                                    I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %1\GETREPLY.EXE Do you wish to install BootShield now (Y/N)? ;yn
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO UpgradeWarning
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Warn user to uninstall a previous version before upgrading.             ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :UpgradeWarning
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I If this installation of BootLock is an upgrade (eg., from evaluation I
    ECHO I to license version or, from license to evaluation version), you must I
    ECHO I use the PREVIOUS version to uninstall BootLock before installing the I
    ECHO I upgrade.                                                             I
    ECHO I                                                                      I
    ECHO I If you are upgrading BootLock and have not uninstalled with your     I
    ECHO I previous version, you need to abort this installation and uninstall  I
    ECHO I before continuing.                                                   I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %1\GETREPLY.EXE Do you wish to continue installing BootShield (Y/N)? ;yn
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO ScanHD
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Verify memory and system area of C: drive are virus-free.               ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :ScanHD
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I BootShield installation will now check your memory and the system    I
    ECHO I area of your C: drive for viruses.                                   I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %1\SCAN C: /BOOT /NOBREAK /PAUSE
    IF NOT ERRORLEVEL 1 GOTO DirSetup
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I An error has occured while scanning your system for viruses!         I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    GOTO Aborted
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Create target directory.  If directory cannot be created, offer using   ::
:: default instead.                                                        ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :DirSetup
    IF NOT "%2" == "C:\McAfee\BShield" GOTO CreateDir
    IF NOT EXIST C:\MCAFEE\CON MD C:\McAfee
  :CreateDir
    IF NOT EXIST %2\CON MD %2
    IF NOT EXIST %2\CON GOTO TryDefaultDir
    GOTO CopyFiles
  :TryDefaultDir
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                    BootShield Installation Error!                    I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I Unable to create the specified target directory.  Either you have    I
    ECHO I insufficient rights or disk space, the target's parent directory     I
    ECHO I does not exist, or the target directory name is invalid.             I
    ECHO I                                                                      I
    ECHO I It is recommended that you attempt to install BootShield to the      I
    ECHO I default directory of C:\McAfee\BShield.                              I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %1\GETREPLY.EXE Do you want to use default directory (Y/N) ;yn
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO UseDefaultDir
    GOTO Abend
  :UseDefaultDir
    if "%3" == "DEBUG"  %1\INSTALL.BAT %1 C:\McAfee\BShield DEBUG  DirSetup
    if "%3" == "DEBUG2" %1\INSTALL.BAT %1 C:\McAfee\BShield DEBUG2 DirSetup
                        %1\INSTALL.BAT %1 C:\McAfee\BShield GOTO   DirSetup
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copy files from source to target directory                              ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :CopyFiles
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I BootShield installation will now copy all of the files from the      I
    ECHO I source to the target directory.                                      I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO. 
    COPY /V %1\*.* %2
    ECHO ;BootShield files... >> %2\DRIVER.LST
    ECHO COPY %2\BSSETUP.EXE %%c: >> %2\DRIVER.LST
    ECHO COPY %2\BSSETUP.INI %%c: >> %2\DRIVER.LST
    ECHO COPY %2\BSSHELP.HLP %%c: >> %2\DRIVER.LST
    COPY /V %2\BSSETUP.IN1 %2\BSSETUP.INI
    ECHO %2 >> %2\BSSETUP.INI
    COPY /V %2\BSSETUP.INI + BSSETUP.IN2 %2\BSSETUP.INI
    GOTO DestPackingCheck
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Make sure all files in the packing list were copied to the hard drive.  ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :DestPackingCheck
    %1\SELFCHEK.EXE %2\PACKING.LST Directory of /were validated
    IF ERRORLEVEL 1 GOTO CopyError
    if "%3" == "DEBUG"  %2\INSTALL.BAT %2 %2 DEBUG  RunFromHD
    if "%3" == "DEBUG2" %2\INSTALL.BAT %2 %2 DEBUG2 RunFromHD
                        %2\INSTALL.BAT %2 %2 GOTO   RunFromHD
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Display message about error while copying files.                        ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :CopyError
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I An error has occured while copying files!  One or more files are     I
    ECHO I missing.                                                             I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    GOTO Aborted
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Ensure C: is current drive and change to target directory.              ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :RUNFROMHD
  :RunFromHD
    C:
    CD %2
    GOTO InsertDisk
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Instruct user to insert a pre-formatted, empty diskette into A: drive.  ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :InsertDisk
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I BootShield installation will now setup a clean boot disk.  Please    I
    ECHO I place a pre-formatted, empty diskette into the A: drive.             I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %2\GETREPLY.EXE Press 'C' to continue when ready or 'A' to abort installation. ;ca
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO AskImage
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Ask user if ImageStor should make a backup.                             ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :AskImage
    ECHO.
    %2\GETREPLY.EXE Would you like ImageStor to backup your hard drive before proceeding (Y/N)? ;yn
    ECHO.
    IF ERRORLEVEL 2 GOTO SysDrive
    IF ERRORLEVEL 1 GOTO ImageBoot
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Create an ImageStor boot disk.                                          ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :ImageBoot
    %2\ISBOOT.EXE
    IF NOT ERRORLEVEL 1 GOTO RunIsEng
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I An error occurred while ImageStor was creating a bootable diskette.  I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %2\GETREPLY.EXE Please press 'R' to retry or 'A' to abort installation. ;ra
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO ISRetry
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Retry creating boot disk on failure.                                    ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :ISRetry
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I BootShield installation will now attempt to retry making a clean     I
    ECHO I boot disk.  Please place another pre-formatted, empty diskette into  I
    ECHO I the A: drive.                                                        I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %2\GETREPLY.EXE Press 'C' to continue when ready or 'A' to abort installation. ;ca
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO ImageBoot
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Run the ImageStor backup engine.                                        ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :RunIsEng
    ECHO.
    %2\SETUPENG.EXE %2\ISENG.EXE
    ECHO.
    IF ERRORLEVEL 1 GOTO IsEngError
    CALL %2\SETUPENG.BAT
    IF EXIST %2\SETUPENG.BAT DEL %2\SETUPENG.BAT
    IF EXIST %2\ZERO.BYT     DEL %2\ZERO.BYT
    IF NOT EXIST %2\SETUPENG.FLG GOTO SetUpBS
    GOTO IsEngError
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Inform user of error while ImageStor was running and offer to retry.    ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :IsEngError
    DEL %2\SETUPENG.FLG
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I An error occurred while IMAGESTOR was backing up your hard drive or, I
    ECHO I you terminated IMAGESTOR by pressing 'Ctrl-C'.                       I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %2\GETREPLY.EXE Please press 'R' to retry, 'S' to skip backup, or 'A' to abort installation. ;rsa
    ECHO.
    IF ERRORLEVEL 3 GOTO Aborted
    IF ERRORLEVEL 2 GOTO SetUpBS
    IF ERRORLEVEL 1 GOTO RunISEng
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Backup not performed so create a bootable floppy for BSSETUP to access. ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :SysDrive
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I Transferring system files to the A: drive.                           I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    SYS A:
    IF NOT ERRORLEVEL 1 GOTO CopyBootLock
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I An error occurred while SYS was creating a bootable diskette.        I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %2\GETREPLY.EXE Please press 'R' to retry or 'A' to abort installation. ;ra
    ECHO.
    IF ERRORLEVEL 2 GOTO SysDriveErr
    IF ERRORLEVEL 1 GOTO SysRetry
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Prompt user to insert another floppy diskette is SYS fails.             ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :SysRetry
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I Place another pre-formatted, empty diskette into the A: drive.       I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %2\GETREPLY.EXE Press 'C' to continue when ready or 'A' to abort installation. ;ca
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO SysDrive
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Detail possible causes of errors during system transfer.                ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :SysDriveErr
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I An error occurred while transferring system files to the A: drive.   I
    ECHO I Either SYS.COM could not be found or the SYS command was             I
    ECHO I unsuccessful.  Consult your DOS manual for assistance.               I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    GOTO Aborted
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Backup not performed so transfer BootLock files to system floppy.       ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :CopyBootLock
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I Transferring BootLock setup files to the A: drive.                   I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    COPY %2\BSSETUP.EXE /V A:
    COPY %2\BSSETUP.INI /V A:
    COPY %2\BSSHELP.HLP /V A:
    IF NOT EXIST A:\BSSETUP.EXE GOTO CopyBootLockError
    IF NOT EXIST A:\BSSETUP.INI GOTO CopyBootLockError
    IF NOT EXIST A:\BSSHELP.HLP GOTO CopyBootLockError
    GOTO SetUpBS
  :CopyBootLockError
    ECHO.
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I An error occurred while copying BootLock files to the A: drive.  One I
    ECHO I or more files failed to transfer properly.  Please verify the media  I
    ECHO I in the A: drive and try again.                                       I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    %2\GETREPLY.EXE Please press 'R' to retry or 'A' to abort installation. ;ra
    ECHO.
    IF ERRORLEVEL 2 GOTO Aborted
    IF ERRORLEVEL 1 GOTO SysRetry
    GOTO Abend
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Run the BSSETUP utility to install BootLock to the hard drive.          ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :SetUpBS
    IF "%3" == "DEBUG"  PAUSE
    IF "%3" == "DEBUG2" PAUSE
    CLS
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I BootShield installation is about to run the BootLock setup program.  I
    ECHO I                                                                      I
    ECHO I Please leave the diskette in the A: drive until you are instructed   I
    ECHO I to remove it.  This disk is needed to store important recovery       I
    ECHO I information.  Once the installation is complete, be sure to label    I
    ECHO I this disk "BootLock Recovery Diskette" and place it in a safe place. I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    PAUSE
    %2\BSSETUP.EXE
    ECHO +======================================================================+
    ECHO I                        BootShield Installation                       I
    ECHO +----------------------------------------------------------------------+
    ECHO I                                                                      I
    ECHO I BootLock implantation bypassed.  BootShield will be unable to        I
    ECHO I protect this computer from virus attacks.                            I
    ECHO I                                                                      I
    ECHO +----------------------------------------------------------------------+
    ECHO.
    GOTO Aborted
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Display error message if install terminates inappropriately.            ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :Abend
    ECHO Abnormal Installation failure.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Display error message if install is terminated.                         ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :Aborted
    ECHO Installation Aborted!
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: End INSTALL.BAT file.                                                   ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  :Finished
    ECHO.

