//      This program plots
// z=2.0*cos(7.0*sqrt(x*x+y*y))*cos(7.0*sqrt(x*x+y*y))/(1.0+30.0*(x*x+y*y))
// in three dimensions on a VGA display.

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#include "titillat.h"
#include "plot3d.h"
#include "vga3d.h"

#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif

static int    external_to_plot(double,double);
static double f(double,double);
       int    main(void);
static int    red(double,double);

extern unsigned _stklen=0x8000;

int main()
    {
      static   int    fatal_error;
      static   double light_x;
      static   double light_y;
      static   double light_z;
      static   int    response;
      static   double rotation;
      static   double tilt;
      static   vga3d  *vga3d_ptr;

      fatal_error=FALSE;
      vga3d_ptr=new vga3d();
      rotation=(double) 0.0;
      tilt=(double) 30.0;
      light_x=(double) 1.0;
      light_y=(double) -1.0;
      light_z=(double) 1.0;
      if (vga3d_ptr->prepare_plot(f, // function f(x,y) to be plotted
       -1.0,                         // minimum x
       1.0,                          // maximum x
       -1.0,                         // minimum y
       1.0,                          // maximum y
       external_to_plot,             // don't plot -- always FALSE
       red,                          // highlight -- always FALSE
       120,                          // number of x divisions
       120,                          // number of y divisions
       rotation,                     // rotation in degrees
       tilt,                         // tilt in degrees
       light_x,light_y,light_z))     // vector to light source
        {
          if (vga3d_ptr->plot("",     // output file name
                              FALSE,  // highlight flagged areas
                              FALSE,  // amuse user while plotting
                              1.0))   // contrast adjustment
            {
              fflush(stdin);
              response=getch();
              fflush(stdin);
            }
        }
      delete vga3d_ptr;
      return(fatal_error);
    }

static int external_to_plot(
  double x,
  double y)
    {
       return FALSE;
    }

static int red(
  double x,
  double y)
    {
       return FALSE;
    }

static double f(
  double x,
  double y)
    {
       double t1=x*x+y*y;
       double t2=cos(7.0*sqrt(t1));
       return 2.0*t2*t2/(1.0+30.0*t1);
    }

