#ifndef ORACLE_H
#define ORACLE_H

//      Each object derived from this class is a random number generator.
// random_number() returns integers uniformly distributed between 0 and
// max_r_n_plus_1-1.

class oracle
  {
    protected:
      int  modulus;
//       max_r_n_plus_1-1

      long r_n [8];
//       The previous 8 proposed random numbers (some of which may be out
// of range).

      long equal_or_larger_prime(int);
//       Returns the first prime number no less than a given number.

      int  is_prime(long);
//       Returns TRUE if a number is prime, FALSE otherwise.

      long prime;
//      A prime number no less than max_r_n_plus_1.

    public:
           oracle(char *seed,int max_r_n_plus_1);
//      A string of up to 8 characters "seeds" the random number generator.
// Random numbers distributed uniformly between 0 and max_r_n_plus_1-1
// will be returned.

      int  random_number(void);
//     Return a random number.
  };

#endif
