#include "cell.h"

void cell::knock_down_wall(char wall_num)
//      Changes the bit for the appropriate wall to zero.
//      For square rooms,
//           0 represents the north wall,
//           1 represents the west wall,
//           2 represents the south wall, and
//           3 represents the east wall.
//      For hexagonal rooms,
//           0 represents the north wall,
//           1 represents the northwest wall,
//           2 represents the southwest wall, 
//           3 represents the south wall.
//           4 represents the southeast wall, and
//           5 represents the northeast wall.
  {
    switch (wall_num)
      {
        case '\0':
          wall_present&=62;
          break;
        case '\1':
          wall_present&=61;
          break;
        case '\2':
          wall_present&=59;
          break;
        case '\3':
          wall_present&=55;
          break;
        case '\4':
          wall_present&=47;
          break;
        default:
          wall_present&=31;
          break;
      }
  }

int cell::wall_up(char wall_num)
//     Returns whether or not a wall is present.
//      For square rooms,
//           0 represents the north wall,
//           1 represents the west wall,
//           2 represents the south wall, and
//           3 represents the east wall.
//      For hexagonal rooms,
//           0 represents the north wall,
//           1 represents the northwest wall,
//           2 represents the southwest wall, 
//           3 represents the south wall.
//           4 represents the southeast wall, and
//           5 represents the northeast wall.
  {
    int result=int(wall_present);
    switch (wall_num)
      {
        case '\0':
          result&=1;
          break;
        case '\1':
          result&=2;
          break;
        case '\2':
          result&=4;
          break;
        case '\3':
          result&=8;
          break;
        case '\4':
          result&=16;
          break;
        default:
          result&=32;
          break;
      }
    return result;
  }
