From eliz@is.elta.co.ilThu Dec  7 18:28:01 1995
Date: Thu, 7 Dec 1995 19:01:12 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Morten Welinder <terra@diku.dk>,
    Richard Stallman <rms@gnu.ai.mit.edu>
Subject: Menu pane name in DOS Emacs 19.30

The original code on msdos.c which displays a menu ignores the pane name
(title).  To see why this is sometimes a problem, try to kill Emacs from
the menu bar ``Files'' menu with the mouse, while some of the files have
unsaved changes: you'll see the pop-up menu with ``No'', ``Yes'', ``Quit''
etc., but without any clue as to what the heck is the question!  I checked
on a workstation under X (with and without toolkit)--the title *is*
displayed there. 

Here is the patch:

Thu Dec  7 18:39:50 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* msdos.c (XMenuActivate): Display the menu pane title.
	(XMenuLocate): Do not ignore pane title length when deciding on
	menu location.

*** src/msdos.c~2	Thu Dec  7 14:58:36 1995
--- src/msdos.c	Thu Dec  7 18:39:50 1995
***************
*** 1679,1689 ****
  XMenuLocate (Display *foo0, XMenu *menu, int foo1, int foo2, int x, int y,
  	     int *ulx, int *uly, int *width, int *height)
  {
!   if (menu->count == 1 && menu->submenu[0])
!       /* Special case: the menu consists of only one pane.  */
!     IT_menu_calc_size (menu->submenu[0], width, height);
!   else
!     IT_menu_calc_size (menu, width, height);
    *ulx = x + 1;
    *uly = y;
    *width += 2;
--- 1679,1685 ----
  XMenuLocate (Display *foo0, XMenu *menu, int foo1, int foo2, int x, int y,
  	     int *ulx, int *uly, int *width, int *height)
  {
!   IT_menu_calc_size (menu, width, height);
    *ulx = x + 1;
    *uly = y;
    *width += 2;
***************
*** 1738,1743 ****
--- 1734,1741 ----
    state[0].menu = menu;
    mouse_off ();
    ScreenRetrieve (state[0].screen_behind = xmalloc (screensize));
+ 
+   IT_menu_display (menu, y0 - 1, x0 - 1, faces); /* display the menu title */
    if ((onepane = menu->count == 1 && menu->submenu[0]))
      {
        menu->width = menu->submenu[0]->width;

