From eliz@is.elta.co.ilThu Dec 21 17:34:25 1995
Date: Thu, 21 Dec 1995 17:23:08 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Mickey Ferguson <mickeyf@stac.com>,
    Morten Welinder <terra@diku.dk>, Richard Stallman <rms@gnu.ai.mit.edu>,
    Karl Heuer <kwzh@gnu.ai.mit.edu>
Subject: DOS-compatible filenames in Emacs

The patches below fix all the places I've found that use filenames which
are illegal or incorrect under MS-DOS.  I didn't bother fixing code which
is irrelevant under DOS (such as various mail packages, GNUS, etc.).  I
also didn't fix startup filenames in the edt emulation package, since I
think Kevin will do it better (or is it done already?) The most important
effect of these patches is that `recover-session' now works under DOS
(provided that you also install the fileio.c patch I send separately).  
Note that some of the files are laded at startup, so you'll need to do a 
`make install' to see the difference.

Thu Dec 21 16:07:49 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* cpp.el (cpp-config-file): New variable; under MS-DOS set to a
	filename without a leading dot.
	(cpp-edit-load): Use `cpp-config-file' for the configuration
	filename.
	(cpp-edit-save): Use `cpp-config-file' for the configuration
	filename.

	* completion.el (save-completions-file-name): Under MS-DOS set to
	a filename without a leading dot.

	* custom.el (custom-file):  Under MS-DOS set to a filename without
	a leading dot.

	* paths.el (abbrev-file-name):  Under MS-DOS set to a filename
	without a leading dot.

	* saveplace.el (save-place-file):  Under MS-DOS set to a filename
	without a leading dot.

	* vip.el (vip-startup-file): New variable; under MS-DOS set to a
	filename without a leading dot.
	(vip-mode): Use `vip-startup-file' for the startup file name.

	* viper.el (vip-custom-file-name): Under MS-DOS set to a filename
	without a leading dot.

	* ffap.el (ffap-list-env): Use `path-separator' rather than ":".

	* dired-x.el (dired-local-variables-file): Under MS-DOS set to a
	filename without a leading dot.
	(dired-filename-at-point): Under MS-DOS, use DOS-specific filename
	characters.

	* hippie-exp.el (he-file-name-chars): Under MS-DOS, use
	DOS-specific filename characters.

	* thingatpt.el (file-name-chars): Under MS-DOS, use DOS-specific
	filename characters.

	* startup.el (auto-save-list-file-prefix):  Under MS-DOS set to
	a shorter string without a leading dot.  This is needed to make
	`recover-session' work under MS-DOS.
	(normal-top-level): Under MS-DOS, use `make-temp-name' to produce
	a unique `auto-save-list-file-name' (PID is not unique enough).
	(command-line-1): Delete explicit test for msdos and windowsnt:
	they aren't needed anymore (both systems define `window-system').

	* files.el (abbrev-file-name): Drive letter can go beyond `Z'
	under MS-DOS/Novell.
	(auto-mode-alist): Make some extensions be appropriate for MS-DOS,
	too.
	(backup-buffer): Make the name of the last resort backup file be
	legal under MS-DOS, and still end with a `~'.
	(basic-save-buffer-1): Make the name of the temporary file (where
	precious files are saved) conform to MS-DOS 8+3 constraints.

*** lisp/cpp.e~0	Wed Apr 19 06:36:02 1995
--- lisp/cpp.el	Sun Dec 17 11:02:16 1995
***************
*** 47,52 ****
--- 47,58 ----
  
  ;;; Customization:
  
+ (defvar cpp-config-file
+   (if (eq system-type 'ms-dos)
+       "_cpp.el"	; Cannot have initial dot [Yuck!]
+     ".cpp.el")
+   "*File name to save cpp configuration.")
+ 
  (defvar cpp-known-face 'invisible
    "*Face used for known cpp symbols.")
  
***************
*** 506,515 ****
  (defun cpp-edit-load ()
    "Load cpp configuration."
    (interactive)
!   (cond ((file-readable-p ".cpp.el")
! 	 (load-file ".cpp.el"))
! 	((file-readable-p "~/.cpp.el")
! 	 (load-file ".cpp.el")))
    (if (eq major-mode 'cpp-edit-mode)
        (cpp-edit-reset)))
  
--- 512,521 ----
  (defun cpp-edit-load ()
    "Load cpp configuration."
    (interactive)
!   (cond ((file-readable-p cpp-config-file)
! 	 (load-file cpp-config-file))
! 	((file-readable-p (concat "~/" cpp-config-file))
! 	 (load-file cpp-config-file)))
    (if (eq major-mode 'cpp-edit-mode)
        (cpp-edit-reset)))
  
***************
*** 519,525 ****
    (require 'pp)
    (save-excursion
      (set-buffer cpp-edit-buffer)
!     (let ((buffer (find-file-noselect ".cpp.el")))
        (set-buffer buffer)
        (erase-buffer)
        (pp (list 'setq 'cpp-known-face
--- 525,531 ----
    (require 'pp)
    (save-excursion
      (set-buffer cpp-edit-buffer)
!     (let ((buffer (find-file-noselect cpp-config-file)))
        (set-buffer buffer)
        (erase-buffer)
        (pp (list 'setq 'cpp-known-face
***************
*** 534,540 ****
  		(list 'quote cpp-unknown-writable)) buffer)
        (pp (list 'setq 'cpp-edit-list
  		(list 'quote cpp-edit-list)) buffer)
!       (write-file ".cpp.el"))))
  
  (defun cpp-edit-home ()
    "Switch back to original buffer."
--- 540,546 ----
  		(list 'quote cpp-unknown-writable)) buffer)
        (pp (list 'setq 'cpp-edit-list
  		(list 'quote cpp-edit-list)) buffer)
!       (write-file cpp-config-file))))
  
  (defun cpp-edit-home ()
    "Switch back to original buffer."
*** lisp/completi.e~0	Thu Nov 23 05:58:22 1995
--- lisp/completi.el	Sun Dec 17 11:02:42 1995
***************
*** 285,291 ****
    "*Non-nil means save most-used completions when exiting Emacs.
  See also `saved-completions-retention-time'.")
  
! (defvar save-completions-file-name "~/.completions"
    "*The filename to save completions to.")
  
  (defvar save-completions-retention-time 336
--- 285,294 ----
    "*Non-nil means save most-used completions when exiting Emacs.
  See also `saved-completions-retention-time'.")
  
! (defvar save-completions-file-name
!   (if (eq system-type 'ms-dos)
!       "~/_complet.ion" ; Cannot have initial dot [Yuck!]
!     "~/.completions")
    "*The filename to save completions to.")
  
  (defvar save-completions-retention-time 336
*** lisp/custom.e~0	Sat Nov  4 03:48:46 1995
--- lisp/custom.el	Sun Dec 17 11:22:36 1995
***************
*** 401,407 ****
  ;; where each CUSTOM is a leaf in the hierarchy defined by the `type'
  ;; property and `custom-type-properties'.
  
! (defvar custom-file "~/.custom.el"
    "Name of file with customization information.")
  
  (defconst custom-data
--- 401,410 ----
  ;; where each CUSTOM is a leaf in the hierarchy defined by the `type'
  ;; property and `custom-type-properties'.
  
! (defvar custom-file
!   (if (eq system-type 'ms-dos)
!       "~/_custom.el" ; Cannot have initial dot [Yuck!]
!     "~/.custom.el")
    "Name of file with customization information.")
  
  (defconst custom-data
***************
*** 426,432 ****
  		  (type . button)
  		  (query . custom-save))
  		 ((name . custom-file)
! 		  (default . "~/.custom.el")
  		  (doc . "Name of file with customization information.\n")
  		  (tag . "File")
  		  (type . file))))))
--- 429,438 ----
  		  (type . button)
  		  (query . custom-save))
  		 ((name . custom-file)
! 		  (default .
! 		    (if (eq system-type 'ms-dos)
! 			"~/_custom.el"
! 		      "~/.custom.el"))
  		  (doc . "Name of file with customization information.\n")
  		  (tag . "File")
  		  (type . file))))))
*** lisp/paths.e~0	Mon Jul 17 22:54:20 1995
--- lisp/paths.el	Sun Dec 17 11:31:32 1995
***************
*** 140,148 ****
  the terminal-initialization file to be loaded.")
  
  (defconst abbrev-file-name 
!   (if (eq system-type 'vax-vms)
!       "~/abbrev.def"
!     "~/.abbrev_defs")
    "*Default name of file to read abbrevs from.")
  
  ;;; paths.el ends here
--- 140,148 ----
  the terminal-initialization file to be loaded.")
  
  (defconst abbrev-file-name 
!   (cond ((eq system-type 'vax-vms) "~/abbrev.def")
! 	((eq system-type 'ms-dos)  "~/_abbrev.def")
! 	(t "~/.abbrev_defs"))
    "*Default name of file to read abbrevs from.")
  
  ;;; paths.el ends here
*** lisp/saveplac.e~0	Mon Nov 20 05:37:46 1995
--- lisp/saveplac.el	Sun Dec 17 11:35:10 1995
***************
*** 56,62 ****
  
  (make-variable-buffer-local 'save-place)
  
! (defvar save-place-file "~/.emacs-places"
    "*Name of the file that records `save-place-alist' value.")
  
  (defvar save-place-version-control 'nospecial
--- 56,65 ----
  
  (make-variable-buffer-local 'save-place)
  
! (defvar save-place-file
!   (if (eq system-type 'ms-dos)
!       "~/_places.sav"
!     "~/.emacs-places")
    "*Name of the file that records `save-place-alist' value.")
  
  (defvar save-place-version-control 'nospecial
*** lisp/vip.e~0	Thu Jun 22 05:10:36 1995
--- lisp/vip.el	Mon Dec 18 18:31:42 1995
***************
*** 121,126 ****
--- 121,132 ----
  (defvar vip-tags-file-name "TAGS")
  
  (defvar vip-inhibit-startup-message nil)
+ 
+ (defvar vip-startup-file
+   (if (eq system-type 'ms-dos)
+       "~/_vip"
+     "~/.vip")
+   "filename used as strtup file for `vip-mode'.")
  
  ;; basic set up
  
***************
*** 243,249 ****
  	    (progn
  	      (save-excursion
  		(set-buffer
! 		 (find-file-noselect (substitute-in-file-name "~/.vip")))
  		(goto-char (point-max))
  		(insert "\n(setq vip-inhibit-startup-message t)\n")
  		(save-buffer)
--- 249,256 ----
  	    (progn
  	      (save-excursion
  		(set-buffer
! 		 (find-file-noselect
! 		  (substitute-in-file-name vip-startup-file)))
  		(goto-char (point-max))
  		(insert "\n(setq vip-inhibit-startup-message t)\n")
  		(save-buffer)
***************
*** 3020,3025 ****
  		(point-min)
  		(if (null ex-addresses) (point-max) (car ex-addresses))))))
  
! (if (file-exists-p "~/.vip") (load "~/.vip"))
  
  ;;; vip.el ends here
--- 3027,3032 ----
  		(point-min)
  		(if (null ex-addresses) (point-max) (car ex-addresses))))))
  
! (if (file-exists-p vip-startup-file) (load vip-startup-file))
  
  ;;; vip.el ends here
*** lisp/viper.e~0	Fri Nov 10 18:42:20 1995
--- lisp/viper.el	Mon Dec 18 18:33:26 1995
***************
*** 807,813 ****
  (defvar vip-always t
    "t means, arrange that vi-state will be a default.")
  
! (defvar vip-custom-file-name "~/.vip"
    "Viper customisation file.
  This variable must be set _before_ loading Viper.")
  
--- 807,816 ----
  (defvar vip-always t
    "t means, arrange that vi-state will be a default.")
  
! (defvar vip-custom-file-name
!   (if (eq system-type 'ms-dos)
!       "~/_vip"
!     "~/.vip")
    "Viper customisation file.
  This variable must be set _before_ loading Viper.")
  
*** lisp/ffap.e~0	Sun Nov 12 23:55:44 1995
--- lisp/ffap.el	Wed Dec 20 15:02:22 1995
***************
*** 686,693 ****
    ;; any empty string entry.
    (if (or empty (getenv env))		; should return something
        (let ((start 0) match dir ret)
! 	(setq env (concat (getenv env) ":")) ; note undefined --> ":"
! 	(while (setq match (string-match ":" env start))
  	  (setq dir (substring env start match) start (1+ match))
  	  ;;(and (file-directory-p dir) (not (member dir ret)) ...)
  	  (setq ret (cons dir ret)))
--- 686,693 ----
    ;; any empty string entry.
    (if (or empty (getenv env))		; should return something
        (let ((start 0) match dir ret)
! 	(setq env (concat (getenv env) path-separator)) ; note undefined -> ":"
! 	(while (setq match (string-match path-separator env start))
  	  (setq dir (substring env start match) start (1+ match))
  	  ;;(and (file-directory-p dir) (not (member dir ret)) ...)
  	  (setq ret (cons dir ret)))
*** lisp/dired-x.e~0	Tue Dec 19 19:33:50 1995
--- lisp/dired-x.el	Wed Dec 20 16:02:38 1995
***************
*** 819,825 ****
  ;;;   `dired-enable-local-variables' and run `hack-local-variables' on the
  ;;;   Dired Buffer.
  
! (defvar dired-local-variables-file ".dired"
    "Filename, as string, containing local dired buffer variables to be hacked.
  If this file found in current directory, then it will be inserted into dired
  buffer and `hack-local-variables' will be run.  See Emacs Info pages for more
--- 819,828 ----
  ;;;   `dired-enable-local-variables' and run `hack-local-variables' on the
  ;;;   Dired Buffer.
  
! (defvar dired-local-variables-file
!   (if (eq system-type 'ms-dos)
!       "_dired"  ; MS-DOS won't allow leading dot in a filename
!     ".dired")
    "Filename, as string, containing local dired buffer variables to be hacked.
  If this file found in current directory, then it will be inserted into dired
  buffer and `hack-local-variables' will be run.  See Emacs Info pages for more
***************
*** 1569,1575 ****
    ;; preference for looking backward when not directly on a symbol.  Not
    ;; perfect - point must be in middle of or end of filename.
  
!   (let ((filename-chars ".a-zA-Z0-9---_/:$+")
          (bol (save-excursion (beginning-of-line) (point)))
          (eol (save-excursion (end-of-line) (point)))
          start end filename)
--- 1572,1581 ----
    ;; preference for looking backward when not directly on a symbol.  Not
    ;; perfect - point must be in middle of or end of filename.
  
!   (let ((filename-chars
! 	 (if (eq system-type 'ms-dos)
! 	     ".a-zA-Z0-9---_/:$!&{}@%`'()^"
! 	   ".a-zA-Z0-9---_/:$+"))
          (bol (save-excursion (beginning-of-line) (point)))
          (eol (save-excursion (end-of-line) (point)))
          start end filename)
*** lisp/hippie-e.e~0	Sun Oct 15 12:53:38 1995
--- lisp/hippie-e.el	Wed Dec 20 18:42:54 1995
***************
*** 445,451 ****
    (cond ((memq system-type '(vax-vms axp-vms))
  	 "-a-zA-Z0-9_/.,~^#$+=:\\[\\]")
  	((memq system-type '(ms-dos ms-windows))
! 	 "-a-zA-Z0-9_/.,~^#$+=:\\\\")
  	(t			    ;; More strange file formats ?
  	 "-a-zA-Z0-9_/.,~^#$+="))
    "Characters that are considered part of the file name to expand.")
--- 445,451 ----
    (cond ((memq system-type '(vax-vms axp-vms))
  	 "-a-zA-Z0-9_/.,~^#$+=:\\[\\]")
  	((memq system-type '(ms-dos ms-windows))
! 	 "-a-zA-_0-9/.~#$!%&{}@`'():\\\\")
  	(t			    ;; More strange file formats ?
  	 "-a-zA-Z0-9_/.,~^#$+="))
    "Characters that are considered part of the file name to expand.")
*** lisp/thingatp.e~0	Wed Jul 19 01:35:34 1995
--- lisp/thingatp.el	Wed Dec 20 18:42:54 1995
***************
*** 138,144 ****
  
  ;;--- Filenames ---
  
! (defvar file-name-chars "~/A-Za-z0-9---_.${}#%,"
    "Characters allowable in filenames.")
  
  (put 'filename 'end-op    
--- 138,147 ----
  
  ;;--- Filenames ---
  
! (defvar file-name-chars
!   (if (eq system-type 'ms-dos)
!       "~/A-`a-z0-9---_.${}#%!()&',"
!     "~/A-Za-z0-9---_.${}#%,")
    "Characters allowable in filenames.")
  
  (put 'filename 'end-op    
*** lisp/startup.e~0	Wed Nov 15 17:23:52 1995
--- lisp/startup.el	Thu Dec 21 14:27:44 1995
***************
*** 227,233 ****
  This is initialized based on `mail-host-address',
  after your init file is read, in case it sets `mail-host-address'.")
  
! (defvar auto-save-list-file-prefix "~/.saves-"
    "Prefix for generating auto-save-list-file-name.
  Emacs's pid and the system name will be appended to
  this prefix to create a unique file name.")
--- 227,236 ----
  This is initialized based on `mail-host-address',
  after your init file is read, in case it sets `mail-host-address'.")
  
! (defvar auto-save-list-file-prefix
!   (if (eq system-type 'ms-dos)
!       "~/_s"  ; MS-DOS cannot have initial dot, and allows only 8.3 names
!     "~/.saves-")
    "Prefix for generating auto-save-list-file-name.
  Emacs's pid and the system name will be appended to
  this prefix to create a unique file name.")
***************
*** 285,295 ****
  	;; Specify the file for recording all the auto save files of this session.
  	;; This is used by recover-session.
  	(setq auto-save-list-file-name
! 	      (expand-file-name
! 	       (format "%s%d-%s"
! 		       auto-save-list-file-prefix
! 		       (emacs-pid)
! 		       (system-name))))
  	(run-hooks 'emacs-startup-hook)
  	(and term-setup-hook
  	     (run-hooks 'term-setup-hook))
--- 288,302 ----
  	;; Specify the file for recording all the auto save files of this session.
  	;; This is used by recover-session.
  	(setq auto-save-list-file-name
! 	      ;; Under MS-DOS our PID is almost always reused between
! 	      ;; Emacs invocations.  We need something more unique.
! 	      (if (eq system-type 'ms-dos)
! 		  (make-temp-name
! 		   (expand-file-name auto-save-list-file-prefix))
! 		(expand-file-name (format "%s%d-%s"
! 					  auto-save-list-file-prefix
! 					  (emacs-pid)
! 					  (system-name)))))
  	(run-hooks 'emacs-startup-hook)
  	(and term-setup-hook
  	     (run-hooks 'term-setup-hook))
***************
*** 652,664 ****
  			 (insert (substitute-command-keys
  				  "\n\nType \\[tmm-menubar] to use the menu bar."))))
  
! 		   ;; Windows and MSDOS (currently) do not count as
! 		   ;; window systems, but do have mouse support.
! 		   (if (or (memq system-type '(msdos windowsnt))
! 			   window-system)
  		       (insert "\n
  C-mouse-3 (third mouse button, with Control) gets a mode-specific menu."))
! 		   (if (directory-files "~/" nil "\\`\\.saves-" t)
  		       (insert "\n\nIf an Emacs session crashed recently,\n"
  			       "type M-x recover-session RET to recover"
  			       " the files you were editing."))
--- 659,672 ----
  			 (insert (substitute-command-keys
  				  "\n\nType \\[tmm-menubar] to use the menu bar."))))
  
! 		   (if window-system
  		       (insert "\n
  C-mouse-3 (third mouse button, with Control) gets a mode-specific menu."))
! 		   (if (directory-files "~/" nil
! 					(if (eq system-type 'ms-dos)
! 					    "\\`_s"
! 					  "\\`\\.saves-")
! 					t)
  		       (insert "\n\nIf an Emacs session crashed recently,\n"
  			       "type M-x recover-session RET to recover"
  			       " the files you were editing."))
*** lisp/files.e~0	Sat Nov 11 00:10:34 1995
--- lisp/files.el	Thu Dec 21 15:02:34 1995
***************
*** 630,639 ****
  	     ;; If the home dir is just /, don't change it.
  	     (not (and (= (match-end 0) 1)
  		       (= (aref filename 0) ?/)))
  	     (not (and (or (eq system-type 'ms-dos) 
  			   (eq system-type 'windows-nt))
  		       (save-match-data
! 			 (string-match "^[a-zA-Z]:/$" filename)))))
  	(setq filename
  	      (concat "~"
  		      (substring filename (match-beginning 1) (match-end 1))
--- 630,641 ----
  	     ;; If the home dir is just /, don't change it.
  	     (not (and (= (match-end 0) 1)
  		       (= (aref filename 0) ?/)))
+ 	     ;; MS-DOS root directories can come with a drive letter;
+ 	     ;; Novell Netware allows drive letters beyond `Z:'.
  	     (not (and (or (eq system-type 'ms-dos) 
  			   (eq system-type 'windows-nt))
  		       (save-match-data
! 			 (string-match "^[a-zA-`]:/$" filename)))))
  	(setq filename
  	      (concat "~"
  		      (substring filename (match-beginning 1) (match-end 1))
***************
*** 881,887 ****
  		    (prin1-to-string err)))))
  
  (defvar auto-mode-alist (mapcar 'purecopy
! 				'(("\\.text\\'" . text-mode)
  				  ("\\.c\\'" . c-mode)
  				  ("\\.h\\'" . c-mode)
  				  ("\\.tex\\'" . tex-mode)
--- 883,889 ----
  		    (prin1-to-string err)))))
  
  (defvar auto-mode-alist (mapcar 'purecopy
! 				'(("\\.te?xt\\'" . text-mode)
  				  ("\\.c\\'" . c-mode)
  				  ("\\.h\\'" . c-mode)
  				  ("\\.tex\\'" . tex-mode)
***************
*** 916,922 ****
  ;;; Less common extensions come here
  ;;; so more common ones above are found faster.
  				  ("\\.texinfo\\'" . texinfo-mode)
! 				  ("\\.texi\\'" . texinfo-mode)
  				  ("\\.s\\'" . asm-mode)
  				  ("ChangeLog\\'" . change-log-mode)
  				  ("change.log\\'" . change-log-mode)
--- 918,924 ----
  ;;; Less common extensions come here
  ;;; so more common ones above are found faster.
  				  ("\\.texinfo\\'" . texinfo-mode)
! 				  ("\\.te?xi\\'" . texinfo-mode)
  				  ("\\.s\\'" . asm-mode)
  				  ("ChangeLog\\'" . change-log-mode)
  				  ("change.log\\'" . change-log-mode)
***************
*** 1512,1518 ****
  			(setq setmodes (file-modes backupname)))
  		    (file-error
  		     ;; If trouble writing the backup, write it in ~.
! 		     (setq backupname (expand-file-name "~/%backup%~"))
  		     (message "Cannot write backup file; backing up in ~/%%backup%%~")
  		     (sleep-for 1)
  		     (condition-case ()
--- 1514,1523 ----
  			(setq setmodes (file-modes backupname)))
  		    (file-error
  		     ;; If trouble writing the backup, write it in ~.
! 		     (setq backupname (expand-file-name
! 				       (if (eq system-type 'ms-dos)
! 					   "~/%backup%.~" ; 8+3 restriction
! 					 "~/%backup%~")))
  		     (message "Cannot write backup file; backing up in ~/%%backup%%~")
  		     (sleep-for 1)
  		     (condition-case ()
***************
*** 1837,1843 ****
  	    (setq nogood t)
  	    ;; Find the temporary name to write under.
  	    (while nogood
! 	      (setq tempname (format "%s#tmp#%d" dir i))
  	      (setq nogood (file-exists-p tempname))
  	      (setq i (1+ i)))
  	    (unwind-protect
--- 1842,1852 ----
  	    (setq nogood t)
  	    ;; Find the temporary name to write under.
  	    (while nogood
! 	      (setq tempname (format
! 			      (if (eq system-type 'ms-dos)
! 				  "%s#%d.tm#" ; MSDOS limits files to 8+3
! 				"%s#tmp#%d")
! 			      dir i))
  	      (setq nogood (file-exists-p tempname))
  	      (setq i (1+ i)))
  	    (unwind-protect
