//
// Base scene for Preview
// Moray V2.5 (c) SoftTronics, '96
//
// Avoid adding any include files to this scene. The rendering of
// this file must fly!
//

    camera {  //  Camera PreviewCam
      location  <0.00, -8.500, 3>
      direction <0.0,     0.0,  3.00>
      sky       <0.0,     0.0,  1.0>  // Use right handed-system!
      up        <0.0,     0.0,  1.0>  // Where Z is up
      right     <1.3333,  0.0,  0.0>
      look_at   <0.000, -0.100, 0.000>
    }

    // *******  L I G H T S *******
    light_source {   // Light1
      <5.820, -8.500, 6.316>
      color rgb <1.000, 1.000, 1.000>
    }

    light_source {   // Light1
      <5.820, -1.500, 3>
      color rgb <0.400, 0.400, 0.400>
    }

    #declare FloorTxtr = texture {
      pigment {
        checker
          color rgb < 1.00,  1.00,  1.00>
          color rgb < 0.10,  0.10,  0.10>
        scale 0.45
      }
      finish {
        ambient   0.25
        diffuse   0.80
      }
    }
    #declare BackdropTxtr = texture {
      pigment {
        checker
          color rgb < 1.00,  1.00,  1.00>
          color rgb < 0.100,  0.100,  0.100>
          scale <1000, 0.2, 0.2>
          translate x*500
      }
      finish {
        ambient   0.25
        diffuse   0.80
      }
    }

    // ********  O B J E C T S *******

    #declare Floor = object {
      disc { <0,0,-1> z, 50 }
      texture { FloorTxtr }
    }

    #declare BackDrop = object {
      disc { <0,2.5,0> y, 50 }
      texture { BackdropTxtr }
    }

    #declare PreviewStone = object {
      merge {
        object { box    { <-1,-1,-1>, <1,1,1>} }
        object { sphere { <0,0,1.75>,1 } }
        texture {
          PreviewTexture
        }
        scale 0.6
        translate -0.399*z
        rotate z*60
      }
    }

    #declare PreviewSphere = object {
      sphere {<0,0,0>,1}
      texture {
        PreviewTexture
      }
    }

    #declare PreviewCube = object {
      box { <-1,-1,-1>,<1,1,1>}
      texture {
        PreviewTexture
      }
      rotate z*60
    }

    #declare PreviewPlane = object {
      plane { z,0 }
      texture {
        PreviewTexture
      }
    }

    #declare PreviewDisc = object {
      disc { <0,0,0>, z , 1.0 }
      texture {
        PreviewTexture
      }
      scale 1.5
    }

    #declare PreviewCylinder = object {
      cylinder { <0,0,-1>, <0,0,1>, 1 }
      texture {
        PreviewTexture
      }
    }

