/*
  Set sound blaster volume

  Written by Jih-Shin Ho, 1995
*/
    
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#define SB_MIXER_ADDRESS	0x04    /* Pro+ only */
#define SB_MIXER_DATA		0x05    /* Pro+ only */

/* For SB16 only. Left first, then Right */
#define SB_MASTER_VOL_16 0x30               
#define SB_DIGITAL_VOL_16 0x32
#define SB_FM_VOL_16 0x34
#define SB_CD_VOL_16 0x36

static unsigned int sb_ioaddr = 0x220;

static void set_volume(unsigned int vol_addr,unsigned int volume)
{
  if (volume > 31) volume = 31;
  outportb(sb_ioaddr + SB_MIXER_ADDRESS,vol_addr);         /* L */
  outportb(sb_ioaddr + SB_MIXER_DATA,volume << 3);
  outportb(sb_ioaddr + SB_MIXER_ADDRESS,vol_addr + 1);     /* R */
  outportb(sb_ioaddr + SB_MIXER_DATA,volume << 3);
}


static void usage(void)
{
  printf("\nSet Sound Blaster 16 volume.\n");
  printf("sbvol -a <address> (-c|-w|-m|-f) <volume>\n"
         "  <address> : Sound Blaster 16 I/O address, default is 220H\n"
         "  -c,-w,-m,-f : For CD, Wave, Master, FM(MIDI) volume\n"
         "  <volume> : sound volume. 0 .. 31\n");
}


int main(int argc,char *argv[])
{
  int index,cd_vol,wav_vol,mas_vol,fm_vol,id;

  if (argc == 1) { usage(); return(0); }

  cd_vol = wav_vol = mas_vol = fm_vol = -1;
  for (index = 1; index < argc; ++index) {
    if (argv[index][0] != '-') { usage(); return(1); }
    id = argv[index][1]; index++;
    switch (id) {
      case 'a': case 'A':
        sb_ioaddr = atoi(argv[index]); break;
      case 'c': case 'C':
        cd_vol = atoi(argv[index]); break;
      case 'w': case 'W':
        wav_vol = atoi(argv[index]); break;
      case 'm': case 'M':
        mas_vol = atoi(argv[index]); break;
      case 'f': case 'F':
        fm_vol = atoi(argv[index]); break;
      default:
        usage(); return(1);
    }
  }
  if (cd_vol >= 0) set_volume(SB_CD_VOL_16,cd_vol);
  if (wav_vol >= 0) set_volume(SB_DIGITAL_VOL_16,wav_vol);
  if (mas_vol >= 0) set_volume(SB_MASTER_VOL_16,mas_vol);
  if (fm_vol >= 0) set_volume(SB_FM_VOL_16,fm_vol);
  return(0);
}
