   Program Show_Font;
   {$I-}

   var font        :  array[0..4095] of byte;
       f           :  file;
       code,value  :  integer;
       read_from   :  string[18];
       rom_font    :  byte;


   { Sets the character height }
   Procedure Set_Character_Height(cheight : byte);assembler;
   asm
     mov ah,$11
     mov al,$10
     mov bh,[cheight]
     xor bl,bl
     xor cx,cx
     xor dx,dx
     int $10
   end;


   Procedure Font8x8_ROM;
   begin
   { Load the 8x8 default character set }
     asm;
       mov ax,3
       int $10
       mov ax,$1112
       xor bl,bl
       int $10
     end;
   end;


   Procedure Font8x14_ROM;
   begin
   { Load the 8x14 default character set }
     asm;
       mov ax,3
       int $10
       mov ax,$1111
       xor bl,bl
       int $10
     end;
   end;


   Procedure Font8x16_ROM;
   begin
   { Load the 8x16 default character set }
     asm;
       mov ax,3
       int $10
       mov ax,$1114
       xor bl,bl
       int $10
     end;
   end;


   Procedure Load_Font;assembler;
   { Load the font to memory }
   asm
     mov ax,3
     int $10

     mov ax,ds
     mov es,ax    { Because Font is an array, it's segment is DS }
     lea bp,font  { ES:BP --> user table }

     mov ah,$11   { Interrupt $10, function $1100 }
     mov al,$10

     mov cx,256   { Count of patterns to store }
     xor dx,dx    { Character offset into map 2 block }
     xor bl,bl    { Block to load in map 2 }
     mov bh,16    { Number of bytes per character pattern }

     int $10      { Execute Interrupt $10 }
   end;


   begin

     { Switchs on the 80x25 textmode }
     asm
       mov ax,3
       int $10
     end;

     { Checks if no parameters are given }
     if paramcount<1 then
     begin
       writeln('USAGE : SHOWFONT(.EXE) FILENAME.FNT [CHARACTER HEIGHT].');
       writeln;
       writeln('FILENAME.FNT is a font saved with Font Editor V1.1 or (/8x8, /8x14, /8x16).');
       writeln('Character height is optional (1-32, Default is 16).');
       writeln;
       writeln('Example : SHOWFONT /8X8 8.');
       writeln('(Loads 8x16 default font and sets character height to 8.)');
       writeln;
       writeln('Showfont v1.0 made by Ilvatar of Nordic Line. 8th of January, 1995.');
       halt;
     end;

     { Setting default values }
     read_from:=paramstr(1)+'.';
     rom_font:=0;

     { Check if a default ROM font is choosed }
     if ((paramstr(1)='/8x16') or (paramstr(1)='/8X16')) then
     begin
       font8x16_ROM;
       value:=16;
       read_from:=('8x16 default font.');
       rom_font:=16;
     end;

     if ((paramstr(1)='/8x14') or (paramstr(1)='/8X14')) then
     begin
       font8x14_ROM;
       value:=14;
       read_from:=('8x14 default font.');
       rom_font:=14;
     end;

     if ((paramstr(1)='/8x8') or (paramstr(1)='/8X8')) then
     begin
       font8x8_ROM;
       value:=8;
       read_from:=('8x8 default font.');
       rom_font:=8;
     end;

     if rom_font=0 then
     begin

       { Assigns and resets the font file indicated by parameter number 1 }
       assign(f,paramstr(1));
       reset(f,1);

       { Checks if an has occured during file resetting }
       if IOresult<>0 then
       begin
         writeln('An error has occured during font file loading!');
         writeln('Probably because of trying to load an unexisting file.');
         halt;
       end;

       { Read the font data }
       blockread(f,font,4096);
       close(f);

       Load_Font;  { Loads the entire font to font bank }

     end;

     if paramcount<2 then
       if rom_font=0 then value:=16 else value:=rom_font;

     if paramcount>1 then
     begin
       val(paramstr(2),value,code);
       if code<>0 then
       writeln('Incorrect value for character height!');

       if (value>0) and (value<=32) then set_character_height(value) else
         if rom_font=0 then value:=16 else value:=rom_font;
     end;

     writeln('Character height has been set to value ',value,'.');
     writeln('Font has been loaded from ',read_from);
     writeln;
     writeln('Showfont v1.0 made by Ilvatar of Nordic Line. 8th of January, 1995.');

   end.

   { This sample program was made by Ilvatar of Nordic Line. }
   { Date : 8th of January, 1995. If you use this program or a part of it
     in your own production you must credit me. }

