seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WAVCAP Plugin',1Ah
                DW offset MY_identification

                DW offset Check_for_correct_file_format
                DW offset Find_first
                DW offset Find_Next
                DW offset GetInfo
                DW offset Get_RAW

                include wcplg.inc

Check_for_correct_file_format:
                TestHeader sound_flx,CrusaderHdr,11
                retf

Find_first:
                Open sound_flx
                Seek 80h,SEEK_SET
                ReadCS FNptr,4
Find_Next:
                add word ptr cs:[PTRptr],8
                adc word ptr cs:[PTRptr+2],0

                mov cx,word ptr cs:[PTRptr+2]
                mov dx,word ptr cs:[PTRptr]
                xor al,al
                call Fseek
                jc IO_Error

                lds dx,Buffer
                add dx,ToPosition
                Read 4
                mov di,dx
                cmp word ptr ds:[di],0
                jne NextFileExist

                cmp word ptr ds:[di+2],0
                jne NextFileExist

                call Fclose
                mov ax,NoMoreFiles
                retf
NextFileExist:
                lds dx,Buffer
                add dx,ToFileSize
                Read 4                      ;Reading FileSize


                add word ptr cs:[FNptr],4
                adc word ptr cs:[FNptr+2],0

                mov cx,word ptr cs:[FNptr+2]
                mov dx,word ptr cs:[FNptr]
                xor al,al
                call Fseek
                jc IO_Error

                lds dx,Buffer
UntilZero:
                Read 1

                inc word ptr cs:[FNptr]
                adc word ptr cs:[FNptr+2],0

                mov di,dx
                inc dx
                cmp byte ptr ds:[di],0
                jne UntilZero

                lds di,Buffer
                mov byte ptr ds:[di+ToAttr],Attr_Read or Attr_Execute
                mov word ptr ds:[di+ToFileType],TYPE_sounds

                xor ax,ax
                retf

PTRptr      DD 80h
FNptr       DD ?
CrusaderHdr DB 'LockTagFlex'
sound_flx   DB 'sound.flx',0

;**********************************************************************
;*                    GET INFO                                        *
;**********************************************************************

GetInfo:
;                int 3
                lds dx,FromFile
                call Fopen
                jc IO_Error

                les di,CurFile
                mov cx,word ptr es:[di+ToPosition+2]
                mov dx,word ptr es:[di+ToPosition]
                mov al,SEEK_SET
                call Fseek
                jc IO_Error

                push cs
                pop ds
                mov dx,offset ASFheader
                mov si,dx
                mov cx,14h
                call Fread
                jc IO_Error

                mov ax,word ptr cs:[ASFheader+12h]      ;Frequency...
                mov bx,word ptr es:[di+ToFileSize]      ;LO
                mov cx,word ptr es:[di+ToFileSize+2]    ;HI
                lds si,SoundInfo
                mov word ptr ds:[si],ax
                sub bx,14h                              ;Header size...
                sbb cx,0
                mov word ptr ds:[si+ToRAWLength],bx
                mov word ptr ds:[si+ToRAWLengthHI],cx
                xor ax,ax
                retf

ASFheader       DB 14h dup (?)

Get_RAW:
;                int 3
                mov cx,cs:[ReadLength]
                cmp cx,0
                je CloseAndByeBye

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx
                jne IO_Error

                les di,Buffer
                lds si,Buffer

Swapping_up_and_down:
                lodsb
                xor al,80h
                stosb
                loop Swapping_up_and_down

                xor ax,ax
                retf
CloseAndByeBye:
                call Fclose
                jc IO_Error
                xor ax,ax
                retf

MY_identification:
                DB 'SOUND.FLX',0
                DW PLGID_sounds
                DB 'Game: Crusader I/II',0

                seg_a ends
                end     ProgrammStart
