;Short defines -
;mov ax,word ptr cs:[gdetotam]
;can be replaced with
;mov ax,W cs:[gdetotam]
B               equ byte ptr
W               equ word ptr
;typedef struct{                        Default values:
;   char fname[13];                     "NONAME.FIL"
;   char fattr;                         Attr_None        no attributes
;   long fsize;                         0
;   long pos;                           0
;   int  filetype;                      TYPE_autodetect
;   unsigned long captid;               This is not for you.
;}FILES;
BufferSize        equ   8000

TYPE_autodetect   equ   0
TYPE_sounds       equ   1
TYPE_music        equ   2
TYPE_pics         equ   3
TYPE_anim         equ   4
TYPE_other        equ   0FFFFh

PLGID_autodetect      equ   0
PLGID_sounds          equ   1
PLGID_music           equ   2
PLGID_pictures        equ   4
PLGID_animation       equ   8
PLGID_unknown         equ   8000h


Check_header      equ   dword ptr cs:[0]
Buffer            equ   dword ptr cs:[4]
Fopen             equ   dword ptr cs:[8]
FSeek             equ   dword ptr cs:[12]
;Seek to CX:DX
Fread             equ   dword ptr cs:[16]
Fclose            equ   dword ptr cs:[20]
CurFile           equ   dword ptr cs:[24]         ;char * to filename
FGetbytes         equ   dword ptr cs:[28]
GetFsize          equ   dword ptr cs:[36]
;ds:dx -> filename
;destroys ax,bx,cx,dx,es         -> size returned in CX:DX

ReportState_SEG   equ   word ptr cs:[0FEh]
ReportState_OFF   equ   word ptr cs:[0FCh]


;Return codes for Check_If_It_Is_A_Correct_Format
TRUE              equ   1       ;Correct format
FALSE             equ   0       ;Incorrect

;Return Codes for Find_First & Find_Next
NoMoreFiles       equ   1       ;If there are no more files inside
IOErrorState      equ   2       ;If there was somekind of error...
StillProcessing   equ   3       ;If need more time to process...
;If this code has been set - you'll have to set at
;cs:0FCh pointer to following block:
; *** State report ***
; Byte   if it is       0            1              2
;               DB Percents done     DD  left       DD complete
;                                    DD  total      DD total
OutOfMemory       equ   4

ToLastChar        equ   12
ToAttr            equ   13
ToFileSize        equ   14
ToPosition        equ   18
ToFileType        equ   22
ToOutOfStruct     equ   32

SEEK_SET          equ   0
SEEK_CUR          equ   1
SEEK_END          equ   2

Attr_None         equ   0
Attr_Read         equ   1
Attr_Write        equ   10b
Attr_Execute      equ   100b
Attr_StanRetrMeth equ   1000b
Attr_Standart     equ   1101b
Attr_RR           equ   1001b

;******** Function 4/5 ****************************************
CantRetriveInfo   equ   1

FromFile          equ   dword ptr cs:[32]
SoundInfo         equ   dword ptr cs:[0FCh]
ReadLength        equ   word ptr cs:[0FAh]
ToFreq            equ   0
ToRAWLength       equ   2
ToRAWLengthHI     equ   4
ToIsMono          equ   6
ToBits            equ   7

MonoSound         equ   0
StereoSound       equ   1
;typedef struct{
;   unsigned int freq;
;   unsigned long raw_length;
;   unsigned char is_mono;        //0-mono 1-stereo   by default=mono
;   unsigned int bits;            //Bits per sample - by default=8
;}SOUND_DATA;
;**************************************************************
IO_Error:
    call Fclose
    mov ax,IOErrorState
    retf



Open macro FNoff
    mov dx,offset FNoff
    call Fopen
    jc IO_Error
endm

OnErrorJump macro Locat
    jc Locat
endm

TestHeader macro FileN,Hdr,Bytes
                xor ax,ax
                mov cx,Bytes
                mov dx,offset FileN
                mov di,offset Hdr
                call Check_header
endm

Seek       macro Posit,SMode
                xor cx,cx           ;Seek to CX:DX

       if (Posit eq 0)
                xor dx,dx
       else
                mov dx,Posit
       endif

       if (SMode eq 0)
                xor al,al           ;al=0 - from beginning of file
       else
                mov al,SMode
       endif
                call Fseek
                jc IO_Error
endm

ReadCS     macro  PutToOff,NItems
       mov dx,offset PutToOff
       mov cx,NItems
       call Fread
       jc IO_Error
endm

Read       macro  NItems
       mov cx,NItems
       call Fread
       jc IO_Error
endm

