;This is File Format Descriptor - file
;Gives descriptionn about WAV-format !
seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WC Plugin',1Ah
                DW TYPE_sounds
                DW offset FFD_description
;                DB 'WAVCAP Plugin',1Ah       ;Identification
                DW 0                         ;No info - so plugin cannot be
                                             ;installed

                DW 0                         ;No functions - find first
                DW 0                         ;find next , check correct format
                DW 0                         ;
                DW offset GetInfo            ;Get info & Get RAW only !
                DW offset GetRAW
                include wcplg.inc

GetInfo:
;                int 3                       ;Breakpoint to debugger...
                mov cs:[aSP],sp              ;Remember stack position
                lds dx,FromFile
                call Fopen                   ;Open file...
                jc IO_Error

                lds si,CurFile
                mov cx,W ds:[si+ToPosition+2];Seek to some position -
                mov dx,W ds:[si+ToPosition]  ;Required if there are captured files
                mov al,SEEK_SET              ;From start of file
                call Fseek
                jc IO_Error

                call Read4                   ;Read 4 bytes

                cmp W cs:[aBuf],'IR'         ;Check RIFF-signature...
                jne UnsupFormat
                cmp W cs:[aBuf+2],'FF'
                jne UnsupFormat

                Seek 4,SEEK_CUR              ;No need for total size...

                call Read4

                cmp W cs:[aBuf],'AW'         ;Check for WAVE-signature
                jne UnsupFormat
                cmp W cs:[aBuf+2],'EV'
                jne UnsupFormat


GetBlock:
                call Read8                   ;Get 8 bytes

                cmp W cs:[aBuf],'mf'         ;"fmt " ?
                jne NextCheck
                cmp W cs:[aBuf+2],' t'
                je FormatChunkDetected
NextCheck:
                cmp W cs:[aBuf],'ad'         ;"data" ?
                jne NextCheck2
                cmp W cs:[aBuf+2],'at'
                je RawChunkDetected
NextCheck2:
                mov cx,W cs:[aBuf+6]
                mov dx,W cs:[aBuf+4]
                mov al,SEEK_CUR
                call Fseek
                jc IO_Error
                jmp GetBlock


FormatChunkDetected:
                mov dx,offset FormatChunk    ;Get format chunk
                mov cx,10h
                call Fread
                jc IO_Error
                cmp ax,cx
                jne UnsupFormat

                mov cx,W cs:[aBuf+6]         ;If format chunk have not
                mov dx,W cs:[aBuf+4]         ;size 10h - seek more...
                sub dx,10h
                sbb cx,0
                mov al,SEEK_CUR
                call Fseek
                jc IO_Error
                jmp GetBlock


RawChunkDetected:
                les di,SoundInfo             ;Fill out our Sound info
                mov ax,W cs:[FormatChunk+4]
                mov W es:[di+ToFreq],ax
                mov ax,W cs:[FormatChunk+6]
                mov W es:[di+ToFreq+2],ax    ;Frequency...

                mov ax,W cs:[aBuf+4]         ;RAW-size...
                mov W es:[di+ToRAWLength],ax
                mov ax,W cs:[aBuf+6]
                mov W es:[di+ToRAWLength+2],ax

                mov ax,W cs:[FormatChunk+0Eh];Bits per sample
                mov W es:[di+ToBits],ax

                mov ax,W cs:[FormatChunk+2]
                dec ax
                mov B es:[di+ToIsMono],al

                xor ax,ax                    ;Don't close file -
                retf                         ;so get RAW can read it...

UnsupFormat:
                mov sp,cs:[aSP]              ;Restore stack position...
                call Fclose                  ;Close file
                mov ax,CantRetriveInfo       ;Error code: CantRetriveInfo
                retf                         ;Bye bye !
Read8:
                mov cx,8                     ;Read 8 bytes to cs:[aBuf]
                jmp GoGoGo

Read4           proc
                mov cx,4                     ;Read 4 bytes to cs:[aBuf]
GoGoGo:
                push cs
                pop ds
                mov dx,offset aBuf
                call Fread
                jc IO_Error2
                cmp ax,cx
                jne UnsupFormat
                ret
Read4           endp

IO_Error2:
    mov sp,cs:[aSP]                          ;Restore stack position...
    call Fclose                              ;Close file
    mov ax,IOErrorState                      ;Error code: IOError !
    retf                                     ;Bye bye !

aSP             DW ?                         ;Space for stack position...
aBuf            DB 8 dup (?)                 ;Small buffer...
FormatChunk     DB 10h dup (?)               ;Format chunk space...

GetRAW:
;                int 3
                mov cx,cs:[ReadLength]       ;Length , that must be readed
                cmp cx,0                     ;into buffer
                je CloseAndByeBye            ;If zero - must close file

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx                    ;Not all bytes readed ?
                jne IO_Error                 ;Error return !!!!!!!
WellDone:
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !

CloseAndByeBye:
                call Fclose                  ;Close file
                jc IO_Error
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !

FFD_description DB 'Microsoft Windows RIFF WAVE',0

                seg_a ends
                end     ProgrammStart
