Buffering              equ 20h


seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WAVCAP Plugin',1Ah
                DW offset MY_identification

                DW offset Is_it_or_isnt_it
                DW offset Find_first
                DW offset Find_Next
                DW 0

                include wcplg.inc
Is_it_or_isnt_it:
    mov ax, TRUE            ;Check all files...
    retf                    ;May be we can exclude some known file formats ?

StateReproters:             ;This location is used by WAVCAP
                 DB 1       ;To print percent bar...
Left             DD ?       ;Left bytes to scan...
TotalSize        DD ?       ;Total bytes...

SeekTo           DD ?

Find_first:
;    int 3                   ;Breakpoint to debugger
    lds dx,CurFile          ;To current file...
    call Fopen              ;Try to open...
    jc IO_Error

    Seek 0h,SEEK_END        ;Seek to end - to get filesize...
    ;DX:AX new location
    mov word ptr cs:[TotalSize],ax     ;Total size=Left size - from start
    mov word ptr cs:[TotalSize+2],dx
    mov word ptr cs:[Left],ax
    mov word ptr cs:[Left+2],dx
    Seek 0h,SEEK_SET        ;And back to start...

    mov ax,cs               ;So WAVCAP can print out percent bar...
    mov ReportState_SEG,ax
    mov ReportState_OFF,offset StateReproters

    mov word ptr cs:[SeekTo],0
    mov word ptr cs:[SeekTo+2],0


Find_Next:
;    int 3                   ;Breakpoint...

    mov cx,word ptr cs:[SeekTo+2]
    mov dx,word ptr cs:[SeekTo]
    xor al,al
    call Fseek
    jc IO_Error

    cmp word ptr cs:[Left+2],0
    jne ReadFullBuffer
    cmp word ptr cs:[Left],BufferSize
    ja ReadFullBuffer

    cmp word ptr cs:[Left],0
    je NoMoreFilesLoc


    mov cx,word ptr cs:[Left]
    lds dx,Buffer
    call Fread
    jc IO_Error
    cmp ax,word ptr cs:[Left]
    jne IO_Error

    jmp GeneralSearch

ReadFullBuffer:
    mov cx,BufferSize
    lds dx,Buffer
    call Fread
    jc IO_Error
    cmp ax,BufferSize
    jne IO_Error

GeneralSearch:
    mov cx,ax
    mov cs:[mCX],ax

    mov bx,offset CreativeVoiceFileHdr
    les di,Buffer
    mov dx,(21-1)
    call SearchIt
    dec di
    jc VOC_found

    mov cx,cs:[mCX]
    mov bx,offset WaveHdr
    les di,Buffer
    mov dx,3
    call SearchIt
    dec di
    jnc ContinuingSoon

    cmp byte ptr es:[di+7],0
    jne ContinuingSoon         ;wav file is more than 16 MB ?
                               ;GET REAL !!!!!!!!!!!!!!!!!!!
    jmp WAV_found

ContinuingSoon:
    mov ax,cs:[mCX]
    sub word ptr cs:[Left],ax
    sbb word ptr cs:[Left+2],0
    add word ptr cs:[SeekTo],ax
    adc word ptr cs:[SeekTo+2],0

    inc cs:[delayX]
    cmp cs:[delayX],20
    jne Find_Next
    mov cs:[delayX],0
    mov ax,StillProcessing
    retf

NoMoreFilesLoc:
    call Fclose
    mov ax,NoMoreFiles
    retf

;******************************************************************
VOC_found:
    mov ax,word ptr es:[di+1Bh]
    mov bl,byte ptr es:[di+1Bh+2]
    xor bh,bh
    add ax,1Fh
    adc bx,0
    mov word ptr cs:[Fsize],ax
    mov word ptr cs:[Fsize+2],bx

    call Re_calc_left

    mov si,offset Pos
    call GetPosition

    mov si,offset aVOC
    call CopyStruct
    xor ax,ax
    retf                ;All OK !!!!!!!!!!!

;******************************************************************
WAV_found:
    mov ax,word ptr es:[di+4]
    mov bx,word ptr es:[di+6]
    add ax,8
    adc bx,0
    mov word ptr cs:[WAVFsize],ax
    mov word ptr cs:[WAVFsize+2],bx

    call Re_calc_left

    mov si,offset WAVpos
    call GetPosition

    mov si,offset aWAV
    call CopyStruct
    xor ax,ax
    retf                ;All OK !!!!!!!!!!!

Re_calc_left    proc
    mov dx,di
    sub dx,offset Buffer
    add ax,dx
    adc bx,0

    add word ptr cs:[SeekTo],ax
    adc word ptr cs:[SeekTo+2],bx
    sub word ptr cs:[Left],ax
    sbb word ptr cs:[Left+2],bx
    jnc All_Is_OK_I_think

    mov word ptr cs:[Left],0
    mov word ptr cs:[Left+2],0

All_Is_OK_I_think:
    ret

Re_calc_left    endp

;******************************************************************
SearchIt        proc
    mov al,byte ptr cs:[bx]
    sub cx,Buffering
    jc NothingHere

ContinueScan:
    repne scasb
    jnz NothingHere

    push di              ;On DS:SI is buffer...
    push cx
    mov si,bx
    inc si
    push cs
    pop ds               ;ES:DI - to "reative Voice File"
    mov cx,dx
    repe cmpsb
    pop cx
    pop di
    jz EsssWeFoundIt
    jmp ContinueScan

NothingHere:
    clc
    ret
EsssWeFoundIt:
    stc
    ret
SearchIt        endp

;******************************************************************
GetPosition     proc
                       ;ES:DI -> To start of VOC/WAV
                       ;cx- how mush left to the end of buffer...
    push cx

;**************************
    xor cx,cx
    xor dx,dx
    mov al,SEEK_CUR
    call Fseek
                       ;Seek from current position to 0 bytes forward
                       ;(in other words - get position to DX:AX)
    pop cx
    jc IO_Error
;   same as "Seek 0h,SEEK_CUR"
;   exept if there will be error - in stack still will be cx
;   =>   HARD BOOT ???????

    add cx,Buffering+1
    sub ax,cx
    sbb dx,0           ;Calculate correct position...
    mov word ptr cs:[si+2],dx
    mov word ptr cs:[si],ax
    ret
GetPosition     endp

;******************************************************************
CopyStruct      proc
    push cs
    pop ds
    les di,Buffer
    mov cx,24         ;Copy whole struct...
    rep movsb
    ret
CopyStruct      endp

mCX                    DW ?
delayX                 DW 0
CreativeVoiceFileHdr   DB 'Creative Voice File',26,26,0
WaveHdr                DB 'RIFF'

aVOC                   DB 'SND?04d.VOC',0,0
                       DB Attr_Read or Attr_StanRetrMeth or Attr_Execute
Fsize                  DD ?
Pos                    DD 0
                       DW TYPE_sounds

aWAV                   DB 'SND?04d.WAV',0,0
                       DB Attr_Read or Attr_StanRetrMeth or Attr_Execute
WAVFsize               DD ?
WAVPos                 DD 0
                       DW TYPE_sounds


;   char fname[13];                     "NONAME.FIL"
;   char fattr;                         Attr_None        no attributes
;   long fsize;                         0
;   long pos;                           0
;   int  filetype;                      TYPE_autodetect
;   unsigned long captid;               This is not for you.

;WaveHdr                DB 'RIFF',0
MY_identification:
                DB '*.*',0
                DW PLGID_sounds
                DB 'Search for WAV/VOC-headers',0


                seg_a ends
                end     ProgrammStart














