seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WC Plugin',1Ah
                DW TYPE_sounds
                DW offset FFD_description
                DW 0                         ;No identification - plugin
                                             ;cannot be installed

                DW 0
                DW 0
                DW 0
                DW offset GetInfo            ;Get info & Get RAW only !
                DW offset GetRAW
                include wcplg.inc

GetInfo:
                int 3
                lds dx,FromFile              ;Open file
                call Fopen
                jc IO_Error

                lds si,CurFile
                mov cx,W ds:[si+ToPosition+2];Seek to some position -
                mov dx,W ds:[si+ToPosition]  ;Required if there are captured files
                mov al,SEEK_SET              ;From start of file
                call Fseek
                jc IO_Error

                mov cx,14h+2                 ;Read header - 14h and 2 bytes more...
                push cs
                pop ds
                mov dx,offset aBuf
                call Fread
                jc IO_Error

                cmp ax,cx
                jne Unsupportedformat        ;This is not an IO_Error , but anyway...

                push cs
                pop es
                mov si,offset aHdr
                mov di,offset aBuf
                mov cx,14h/2
                rep cmpsw                    ;Compare...
                jc Unsupportedformat         ;Not equal ?

                mov dx,W cs:[aBuf+14h]       ;Usualy 1Ah - in intel notation...
                sub dx,16h                   ;We have readed already 16h bytes...
                xor cx,cx
                mov al,SEEK_CUR
                call Fseek
                jc IO_Error

                mov dx,offset aType
                mov cx,1
                call Fread
                jc IO_Error

                mov al,B cs:[aType]          ;Types...
                cmp al,1                     ;There could be from 1-9
                je useType1                  ;Currently checking just 1 & 9

                cmp al,9
                je useType9

                jmp Unsupportedformat
useType9:
                mov dx,offset aBuf
                mov cx,0Fh
                call Fread
                jc IO_Error
                cmp ax,cx
                jne Unsupportedformat

                les di,SoundInfo               ;Fill out our Sound info
                mov ax,W cs:[aBuf+3]
                mov W es:[di+ToFreq],ax
                mov ax,W cs:[aBuf]
                mov bl,B cs:[aBuf+2]
                xor bh,bh
                sub ax,12
                sbb bx,0
                mov W es:[di+ToRAWLength],ax
                mov W es:[di+ToRAWLength+2],bx

                mov al,B cs:[aBuf+7]
                mov B es:[di+ToBits],al

                xor ax,ax
                retf

useType1:
                mov dx,offset aBuf
                mov cx,5
                call Fread
                jc IO_Error

                cmp ax,cx
                jne Unsupportedformat

                mov bx,255
                sub bl,B cs:[aBuf+3]           ;Sample rate byte
                inc bx
                mov dx, 0Fh                    ;DX:AX=1000000
                mov ax, 4240h                  ;
                idiv bx                        ;1000000/(256-Byte)
                ;ax-frequency...
                les di,SoundInfo               ;Fill out our Sound info
                mov W es:[di+ToFreq],ax
                mov ax,W cs:[aBuf]
                mov bl,B cs:[aBuf+2]
                xor bh,bh
                sub ax,2
                sbb bx,0
                mov W es:[di+ToRAWLength],ax
                mov W es:[di+ToRAWLength+2],bx
                xor ax,ax
                retf

Unsupportedformat:
                call Fclose                  ;Close file
                mov ax,CantRetriveInfo       ;Error code: CantRetriveInfo
                retf                         ;Bye bye !

aType           DB 0FFh
aHdr            DB 'Creative Voice File',1Ah
aBuf            DB 16h dup (?)


;*************************
GetRAW:
;                int 3
                mov cx,cs:[ReadLength]       ;Length , that must be readed
                cmp cx,0                     ;into buffer
                je CloseAndByeBye            ;If zero - must close file

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx                    ;Not all bytes readed ?
                jne IO_Error                 ;Error return !!!!!!!
WellDone:
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !

CloseAndByeBye:
                call Fclose                  ;Close file
                jc IO_Error
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !


FFD_description DB 'Creative Lab',27h,'s Sound File',0

                seg_a ends
                end     ProgrammStart
