seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WAVCAP Plugin',1Ah
                DW offset MY_identification

                DW offset Check_for_correct_format
                DW offset Find_first
                DW offset Find_next
                DW offset GetInfo
                DW offset GetRAW
                include wcplg.inc

Check_for_correct_format:
                xor ax,ax
                mov cx,4
                lds dx,CurFile
                mov di,offset Hdr
                call Check_header
                retf
Hdr             DB 'RIFX'
Find_first:
                mov cs:[aSP],sp
                lds dx,CurFile
                call Fopen
                jc IO_Error

                Seek 16,SEEK_SET
                mov dx,offset aDword
                call get4
                call SeekCurX
                mov dx,offset aDword2
                call get4
                mov dx,offset aDword2
                call get4
                call SeekCurX
Find_next:
SkipThisOne:
                mov dx,offset aBuf
                mov cx,14h
                call Fread
                jc IO_Error

                cmp ax,cx
                jne IO_Error

                cmp word ptr cs:[aBuf+10h],0FFFFh
                je SorryNoMoreFiles

                mov si,offset KnownTypes
StillSearching:
                mov ax,word ptr cs:[si]

                cmp ax,0
                je SkipThisOne

                cmp ax,word ptr cs:[aBuf]
                jne NotThisOne

                mov bx,word ptr cs:[si+2]
                cmp bx,word ptr cs:[aBuf+2]
                jne NotThisOne

;!!!!!!!!!!!!!!! We found a file !!!!!!!!!!!!!!!!!!!!!!!!!!

                mov cx,word ptr cs:[si+4]
                mov word ptr cs:[OurType],cx      ;Type...

                cmp bh,' '
                jne NameOK
                mov bh,'_'
NameOK:
                cmp bl,' '
                jne NameOK2
                mov bl,'_'
NameOK2:
                mov word ptr cs:[OurStruct],ax
                mov word ptr cs:[OurStruct+2],bx

                mov ax,word ptr cs:[aBuf+8]
                mov bx,word ptr cs:[aBuf+10]
                xchg ah,al
                xchg bh,bl
                mov word ptr cs:[OurPos],bx
                mov word ptr cs:[OurPos+2],ax

                push cs
                pop es
                mov di,offset OurPos
                mov si,offset aBuf
                mov cx,8
                call FGetbytes
                jc IO_Error

                mov ax,word ptr cs:[aBuf+4]
                mov bx,word ptr cs:[aBuf+6]
                xchg al,ah
                xchg bl,bh
                mov word ptr cs:[OurSize],bx
                mov word ptr cs:[OurSize+2],ax

                les di,Buffer
                push cs
                pop ds
                mov si,offset OurStruct
                mov cx,24
                cld
                rep movsb

                xor ax,ax
                retf
NotThisOne:
                add si,6
                jmp StillSearching


SorryNoMoreFiles:
                mov cs:[aSP],sp
                call Fclose
                mov ax,NoMoreFiles
                retf


get4            proc
                push cs
                pop ds
                mov cx,4
                call Fread
                jc SafeExit
                cmp ax,cx
                jne SafeExit
                ret
get4            endp

SeekCurX        proc
                mov cx,word ptr cs:[aDword]
                mov dx,word ptr cs:[aDword+2]
                xchg ch,cl
                xchg dh,dl
                mov al,SEEK_CUR
                call Fseek
                jc SafeExit
                ret
SeekCurX        endp



SafeExit:
                mov sp,cs:[aSP]
                jmp IO_Error

aDword          DD ?
aDword2         DD ?
aSP             DW ?
aBuf            DB 14h dup (?)

;***************************************************************
OurStruct       DB '....?04d.DAT',0
                DB Attr_Read
OurSize         DD ?
OurPos          DD ?
OurType         DW ?
;***************************************************************


KnownTypes:
                DB 'snd '
                DW TYPE_sounds
;                DB 'BITD'
;                DW TYPE_other
                DW 0

GetInfo:
                les di,CurFile
                cmp word ptr es:[di+ToFileType],TYPE_sounds
                jne NotASounds

                lds dx,FromFile
                call Fopen
                jc IO_Error

                mov cx,word ptr es:[di+ToPosition+2]
                mov dx,word ptr es:[di+ToPosition]
                add dx,4Eh+8      ;Header size
                adc cx,0

                mov al,SEEK_SET
                call Fseek
                jc IO_Error

                mov dx,word ptr es:[di+ToFileSize]
                mov cx,word ptr es:[di+ToFileSize+2]
                sub dx,4Eh
                sbb cx,0
                lds si,SoundInfo
                mov word ptr ds:[si+ToRAWLength],dx
                mov word ptr ds:[si+ToRAWLength+2],cx

                xor ax,ax
                retf


NotASounds:
                lds dx,FromFile
                call Fopen
                jc IO_Error

                mov cx,word ptr es:[di+ToPosition+2]
                mov dx,word ptr es:[di+ToPosition]
                mov al,SEEK_SET
                call Fseek
                jc IO_Error

GetRAW:
                mov cx,cs:[ReadLength]
                cmp cx,0
                je CloseAndByeBye

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx
                jne IO_Error
                xor ax,ax
                retf
CloseAndByeBye:
                call Fclose
                jc IO_Error
                xor ax,ax
                retf


MY_identification:
                DB '*',0
                DW PLGID_autodetect
                DB 'Game: Virtual Valerie 2',0

                seg_a ends
                end     ProgrammStart
