seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WC Plugin',1Ah
                DW TYPE_sounds
                DW offset FFD_description
                DW 0

                DW 0
                DW 0
                DW 0
                DW offset GetInfo            ;Get info & Get RAW only !
                DW offset GetRAW
                include wcplg.inc

GetInfo:
                mov cs:[aSP],sp
                lds dx,FromFile
                call Fopen
                jc IO_Error

                lds si,CurFile
                mov cx,W ds:[si+ToPosition+2];Seek to some position -
                mov dx,W ds:[si+ToPosition]  ;Required if there are captured files
                mov al,SEEK_SET              ;From start of file
                call Fseek
                jc IO_Error

                call Get8bytes
                cmp W cs:[a8bytes],'NS'      ;"SND "-header
                jne Unsupportedformat
                cmp W cs:[a8bytes+2],' D'
                jne Unsupportedformat

                les di,SoundInfo
                mov W es:[di+ToFreq],22100   ;All files have frequency 22100 ?
                                             ;Quite weird...
GettingNextBlock:
                call Get8bytes
                cmp W cs:[a8bytes],'NS'       ;"SNDT"-block ?
                jne notSNDT
                cmp W cs:[a8bytes+2],'TD'
                je aSNDT

notSNDT:
                xor ax,ax
                call UseSeek
                jmp GettingNextBlock
aSNDT:
                mov dx,W cs:[a8bytes+4]
                mov cx,W cs:[a8bytes+6]
                mov W es:[di+ToRAWLength],dx
                mov W es:[di+ToRAWLength+2],cx

                mov sp,cs:[aSP]
                xor ax,ax
                retf


UseSeek         proc
                mov cx,W cs:[a8bytes+6]
                mov dx,W cs:[a8bytes+4]
                sub dx,ax
                sbb cx,0
                mov al,SEEK_CUR
                call Fseek
                jc IO_Error2
                ret
UseSeek         endp



Get8bytes:
                mov cx,8
                mov dx,offset a8bytes
                jmp GetXBytesXloc

GetXbytes       proc
                mov dx,offset aBuf
GetXBytesXloc:
                push cs
                pop ds
                call Fread
                jc IO_Error2
                cmp ax,cx
                jne Unsupportedformat
                ret
GetXbytes       endp

a8bytes         DB 8 dup (?)
aBuf            DB 50 dup (?)
aSP             DW ?

Unsupportedformat:
                mov sp,cs:[aSP]
                call Fclose                  ;Close file
                mov ax,CantRetriveInfo       ;Error code: CantRetriveInfo
                retf                         ;Bye bye !
IO_Error2:
                mov sp,cs:[aSP]
                call Fclose                  ;Close file
                mov ax,IOErrorState          ;Error code: I/O-error
                retf                         ;Bye bye !


;*************************
GetRAW:
                mov cx,cs:[ReadLength]       ;Length , that must be readed
                cmp cx,0                     ;into buffer
                je CloseAndByeBye            ;If zero - must close file

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx                    ;Not all bytes readed ?
                jne IO_Error                 ;Error return !!!!!!!

                lds si,Buffer                ;Uncomment this - if
Swapping:                                    ;you need swap for up & down
                mov al,B ds:[si]
                xor al,80h
                mov B ds:[si],al
                inc si
                loop Swapping
WellDone:
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !

CloseAndByeBye:
                call Fclose                  ;Close file
                jc IO_Error
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !


FFD_description  DB 'SBStudio II Sound File',0     ;Max 28 char


                seg_a ends
                end     ProgrammStart
