seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WC Plugin',1Ah
                DW TYPE_sounds
                DW offset FFD_description
                DW 0

                DW 0
                DW 0
                DW 0
                DW offset GetInfo            ;Get info & Get RAW only !
                DW offset GetRAW
                include wcplg.inc

GetInfo:
                mov cs:[aSP],sp
                lds dx,FromFile
                call Fopen
                jc IO_Error

                lds si,CurFile
                mov cx,W ds:[si+ToPosition+2];Seek to some position -
                mov dx,W ds:[si+ToPosition]  ;Required if there are captured files
                mov al,SEEK_SET              ;From start of file
                call Fseek
                jc IO_Error

                mov cx,12
                call GetXbytes
                cmp W cs:[aBuf],'OF'         ;"FORM"-header
                jne Unsupportedformat
                cmp W cs:[aBuf+2],'MR'
                jne Unsupportedformat

                les di,SoundInfo
                cmp W cs:[aBuf+8],'61'         ;"16SV"-header
                jne Nota16bitsample
                cmp W cs:[aBuf+10],'VS'
                jne Nota16bitsample

                mov W es:[di+ToBits],16
                mov cs:[a16bitUsed],1
                jmp ScanningBlocks
Nota16bitsample:
                cmp W cs:[aBuf+8],'S8'       ;"8SVX"-header ?
                jne Unsupportedformat        ;If this sample isn't 8 bit
                cmp W cs:[aBuf+10],'XV'      ;-then what the hell is it ?
                jne Unsupportedformat

ScanningBlocks:
                call Get8bytes               ;"VHDR"-block ?
                cmp W cs:[a8bytes],'HV'
                jne notaVHDR
                cmp W cs:[a8bytes+2],'RD'
                jmp aVHDR
notaVHDR:
                cmp W cs:[a8bytes],'HC'      ;"CHAN"-block ?
                jne notaCHAN
                cmp W cs:[a8bytes+2],'NA'
                jmp aCHAN
notaCHAN:
                cmp W cs:[a8bytes],'OB'      ;"BODY"-block ?
                jne notaBODY
                cmp W cs:[a8bytes+2],'YD'
                jmp aBODY
notaBODY:
                xor ax,ax
                call UseSeek
                jmp ScanningBlocks           ;Unknown block - Trying to retry

aBODY:
                cmp cs:[MayPass],0
                je Unsupportedformat         ;Not getted frequency ?
                                             ;Well... - Bye Bye !

                mov dx,W cs:[a8bytes+6]
                mov cx,W cs:[a8bytes+4]
                xchg ch,cl
                xchg dh,dl
                mov W es:[di+ToRAWLength],dx
                mov W es:[di+ToRAWLength+2],cx

                mov sp,cs:[aSP]
                xor ax,ax
                retf                         ;We found sample !

aCHAN:
                mov cx,4
                call GetXbytes
                mov ax,W cs:[aBuf+2]
                xchg al,ah
                cmp ax,2                     ;Is it mono ?
                je MonoMode
                cmp ax,6
                jne Unsupportedformat

                mov B es:[di+ToIsMono],StereoSound
MonoMode:
                mov ax,4
                call UseSeek
                jmp ScanningBlocks


aVHDR:
                mov cs:[MayPass],1
                mov cx,14h
                call GetXbytes
                mov ax,W cs:[aBuf+12]
                xchg al,ah
                mov W es:[di+ToFreq],ax
                mov ax,14h
                call UseSeek
                jmp ScanningBlocks


UseSeek         proc
                mov cx,W cs:[a8bytes+4]
                mov dx,W cs:[a8bytes+6]
                xchg ch,cl
                xchg dh,dl
                sub dx,ax
                sbb cx,0
                mov al,SEEK_CUR
                call Fseek
                jc IO_Error2
                ret
UseSeek         endp



Unsupportedformat:
                mov sp,cs:[aSP]
                call Fclose                  ;Close file
                mov ax,CantRetriveInfo       ;Error code: CantRetriveInfo
                retf                         ;Bye bye !
IO_Error2:
                mov sp,cs:[aSP]
                call Fclose                  ;Close file
                mov ax,IOErrorState          ;Error code: I/O-error
                retf                         ;Bye bye !

Get8bytes:
                mov cx,8
                mov dx,offset a8bytes
                jmp GetXBytesXloc

GetXbytes       proc
                mov dx,offset aBuf
GetXBytesXloc:
                push cs
                pop ds
                call Fread
                jc IO_Error2
                cmp ax,cx
                jne Unsupportedformat
                ret
GetXbytes       endp

a8bytes         DB 8 dup (?)
aBuf            DB 50 dup (?)
MayPass         DB 0
aSP             DW ?
a16bitUsed      DB 0
;*************************
GetRAW:
                mov cx,cs:[ReadLength]       ;Length , that must be readed
                cmp cx,0                     ;into buffer
                je CloseAndByeBye            ;If zero - must close file

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx                    ;Not all bytes readed ?
                jne IO_Error                 ;Error return !!!!!!!

                cmp cs:[a16bitUsed],1
                je WellDone

                lds si,Buffer
Swapping:
                mov al,B ds:[si]
                xor al,80h
                mov B ds:[si],al
                inc si
                loop Swapping
WellDone:
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !

CloseAndByeBye:
                call Fclose                  ;Close file
                jc IO_Error
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !


FFD_description  DB 'Interchange Format File',0     ;Max 28 char


                seg_a ends
                end     ProgrammStart
