seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WC Plugin',1Ah
                DW TYPE_sounds
                DW offset FFD_description
;                DB 'WAVCAP Plugin',1Ah
                DW 0

                DW 0
                DW 0
                DW 0
                DW offset GetInfo            ;Get info & Get RAW only !
                DW offset GetRAW
                include wcplg.inc

GetInfo:
                int 3
                lds dx,FromFile
                call Fopen
                jc IO_Error

                lds si,CurFile
                mov cx,W ds:[si+ToPosition+2];Seek to some position -
                mov dx,W ds:[si+ToPosition]  ;Required if there are captured files
                mov al,SEEK_SET              ;From start of file
                call Fseek
                jc IO_Error

                push cs
                pop ds
                mov dx,offset aHDR
                mov cx,24
                call Fread
                jc IO_Error
                cmp ax,cx
                jne IO_Error

                cmp W cs:[aHDR],'s.'        ;".snd" - header
                jne Unsupportedformat
                cmp W cs:[aHDR+2],'dn'
                jne Unsupportedformat

                mov cx,W cs:[aHDR+4]        ;There must be offset to
                mov dx,W cs:[aHDR+6]        ;start of sample
                xchg cl,ch
                xchg dl,dh
                sub dx,24                   ;This is what we have readed...
                sbb cx,0
                mov al,SEEK_CUR
                call Fseek
                jc IO_Error

                les di,SoundInfo
                mov cx,W cs:[aHDR+8]
                mov dx,W cs:[aHDR+10]
                xchg cl,ch
                xchg dl,dh
                mov W es:[di+ToRAWLength],dx
                mov W es:[di+ToRAWLength+2],cx

                mov ax,W cs:[aHDR+14]       ;Compression type
                xchg ah,al
                cmp ax,2
                je a8bits

                cmp ax,3
                jne Unsupportedformat

                mov W es:[di+ToBits],16     ;16 Bits
a8bits:
                mov ax,W cs:[aHDR+18]
                xchg ah,al
                mov W es:[di+ToFreq],ax

                mov ax,W cs:[aHDR+22]       ;How many channels...
                xchg al,ah
                cmp ax,1
                je ItsMono
                cmp ax,2
                jne Unsupportedformat

                mov B es:[di+ToIsMono],1
ItsMono:
                xor ax,ax
                retf

aHDR            DB 24 dup (?)

Unsupportedformat:
                call Fclose                  ;Close file
                mov ax,CantRetriveInfo       ;Error code: CantRetriveInfo
                retf                         ;Bye bye !

;*************************
GetRAW:
                int 3
                mov cx,cs:[ReadLength]       ;Length , that must be readed
                cmp cx,0                     ;into buffer
                je CloseAndByeBye            ;If zero - must close file

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx                    ;Not all bytes readed ?
                jne IO_Error                 ;Error return !!!!!!!


                mov ax,W cs:[aHDR+14]       ;Compression type
                xchg ah,al
                cmp ax,3
                je a16bitMassageAudio

                lds si,Buffer
Swapping:
                mov al,B ds:[si]
                xor al,80h
                mov B ds:[si],al
                inc si
                loop Swapping
WellDone:
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !

a16bitMassageAudio:
                shr cx,1
                lds si,Buffer
                les di,Buffer
DoingMassage:
                lodsw
                xchg ah,al
                stosw
                loop DoingMassage

                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !

CloseAndByeBye:
                call Fclose                  ;Close file
                jc IO_Error
                xor ax,ax                    ;Return code: All OK !
                retf                         ;Bye Bye !


FFD_description DB 'Sun/Next Audio File',0

                seg_a ends
                end     ProgrammStart
