seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WAVCAP Plugin',1Ah
                DW offset MY_identification

                DW offset Check_for_correct_format
                DW offset Find_first
                DW offset Find_next
                DW 0                              ;For "Copying not supported by
                DW 0                              ;plugin"-error
                include wcplg.inc

Check_for_correct_format:
                lds dx,CurFile
                xor ax,ax
                mov cx,12
                mov di,offset Signature
                call Check_header
                retf
Signature       DB 'RMAPresource'

Find_first:
                lds dx,CurFile
                call Fopen
                jc IO_Error

                push cs
                pop ds
                mov dx,offset Header
                mov cx,16
                call Fread
                jc IO_Error

                mov ax,word ptr cs:[Header+12]    ;lo
                mov bx,word ptr cs:[Header+14]    ;hi
                add ax,16
                adc bx,0
                mov word ptr cs:[TotalOff],ax
                mov word ptr cs:[TotalOff+2],bx

Find_next:
                Seek 0,SEEK_CUR      ;DX:AX

                sub ax,16
                sbb dx,0
                cmp word ptr cs:[Header+12],ax
                jne ThereAreFiles
                cmp word ptr cs:[Header+14],dx
                jne ThereAreFiles

                call Fclose
                mov ax,NoMoreFiles
                retf
ThereAreFiles:
                lds dx,Buffer
                mov si,dx
                mov cx,4
                call Fread
                jc IO_Error

;******************************************************
;*      Checking for extension                        *
;******************************************************
                mov cs:[addext],0FFFFh

                xor bx,bx
Checking:
                mov ax,word ptr cs:[Ext+bx]
                mov cx,word ptr cs:[Ext+bx+2]
                cmp ax,0
                je LetsGoNext
                cmp word ptr ds:[si],ax
                jne CheckingNext
                cmp word ptr ds:[si+2],cx
                jne CheckingNext

                mov cs:[addext],bx
                jmp LetsGoNext
CheckingNext:
                add bx,11
                jmp Checking
LetsGoNext:
;******************************************************

                mov cx,8
                call Fread
                jc IO_Error

                mov byte ptr ds:[si+8],0
                add dx,ToFileSize
                mov cx,4
                call Fread
                jc IO_Error

                mov ax,word ptr cs:[TotalOff]
                mov bx,word ptr cs:[TotalOff+2]
                add ax,16
                adc bx,0
                mov ds:[si+ToPosition],ax
                mov ds:[si+ToPosition+2],bx
                add ax,word ptr ds:[si+ToFileSize]
                adc bx,word ptr ds:[si+ToFileSize+2]
                mov word ptr cs:[TotalOff],ax
                mov word ptr cs:[TotalOff+2],bx


                mov byte ptr ds:[si+ToAttr], Attr_Read or Attr_StanRetrMeth

                mov bx, cs:[addext]
                cmp bx,0FFFFh
                je LetsGetOfHere

                int 3
                mov ax,word ptr cs:[Ext+bx+8]
                mov word ptr ds:[si+ToFileType],ax
                xor ah,ah
                mov al,byte ptr cs:[Ext+bx+10]
                add word ptr ds:[si+ToPosition],ax
                adc word ptr ds:[si+ToPosition+2],0
                sub word ptr ds:[si+ToFileSize],ax
                sbb word ptr ds:[si+ToFileSize],0

ScanningForAZero:
                lodsb
                cmp al,0
                jne ScanningForAZero
                dec si

                mov ax,word ptr cs:[Ext+bx+4]
                mov cx,word ptr cs:[Ext+bx+6]
                mov word ptr ds:[si],ax
                mov word ptr ds:[si+2],cx
                mov byte ptr ds:[si+4],0


LetsGetOfHere:
                xor ax,ax
                retf



Header          DB 16 dup (0)
TotalOff        DD ?
addext          DW 0

Ext             DB 'VOIC','.voc'
                DW TYPE_sounds
                DB 0
                DB 'TEXT','.txt'
                DW TYPE_other
                DB 0
                DB 'ANIM','.ani'
                DW TYPE_other
                DB 0
                DB 'DELT','.del'
                DW TYPE_other
                DB 0
                DB 'PLTT','.plt'
                DW TYPE_other
                DB 0
                DB 'SHIP','.shp'
                DW TYPE_other
                DB 0
                DB 'FILM','.flm'
                DW TYPE_other
                DB 0
                DB 'GMID','.mid'
                DW TYPE_music
                DB 1Eh
                DB 'BMAP','.map'
                DW TYPE_other
                DB 0
                DB 'BLAS','.voc'
                DW TYPE_sounds
                DB 0
                DW 0


MY_identification:
                DB '*.LFD',0
                DW PLGID_autodetect
                DB 'LFD-formatted files',0
;PLGID_autodetect      equ   0
;PLGID_sounds          equ   1
;PLGID_music           equ   2
;PLGID_pictures        equ   4
;PLGID_animation       equ   8
;PLGID_unknown         equ   8000h

                seg_a ends
                end     ProgrammStart
