uses crt;
var
pic,pic2 : array[0..8000] of byte;
f1 : file;
f2 : text;
count2,len : word;
count : word;
attr : byte;

procedure putch(b : byte);
begin
  pic2[count2] := b;
  inc(count2);
end;

function getch : byte;
begin
  getch := pic2[count2];
  inc(count2);
end;

function countb(b,attr : byte) : integer;
var
n : integer;
begin
  n := 0;
  while (pic[(count+n)*2]=b) and (pic[(count+n)*2+1]=attr) do begin
    inc(n);
  end;
  if n > 250 then n := 250;
  countb := n;
end;

procedure pack;
var
b,b2 : byte;
n : integer;
begin
  len := 0;
  attr := pic[1];
  count := 0;
  count2 := 0;
  putch(1);
  putch(attr);
  while count < 4000 do begin
    b := pic[count*2];
    b2 := pic[count*2+1];
    if b2 <> attr then begin
      putch(1);
      putch(b2);
      attr := b2;
    end;
    n := 0;
    n := countb(b,attr);
    if n > 1 then begin
      if b = 32 then begin
        putch(3);
        putch(n);
        inc(count,n-1)
      end
      else begin
        putch(2);
        putch(n);
        putch(b);
        inc(count,n-1);
      end;
    end
    else if b < 8 then begin
      putch(7);
      putch(b);
    end
    else putch(b);
    inc(count);
  end;
  putch(0);
  len := count2;
end;

procedure putpic(b : byte);
begin
  pic[count*2] := b;
  pic[count*2+1] := attr;
  memw[$b800:count*2] := attr*256+b;
  inc(count);
end;

procedure unpack;
var
b,b2 : byte;
n : integer;
begin
  attr := 7;
  count := 0;
  count2 := 0;
  while b <> 0 do begin
    b := getch;
    if b = 1 then begin
      attr := getch;
    end
    else if b = 2 then begin
      b2 := getch;
      b := getch;
      for n := 1 to b2 do putpic(b);
    end
    else if b = 3 then begin
      b2 := getch;
      for n := 1 to b2 do putpic(32);
    end
    else if b = 7 then begin
      b := getch;
      putch(b);
    end
    else putpic(b);
  end;
end;

procedure save;
var
n : integer;
x : integer;
begin
  x := 1;
  writeln(f2,'const');
  writeln(f2,'imagedata_len = ',len,';');
  writeln(f2,'imagedata : array[0..',len-1,'] of byte = (');
  for n := 1 to len-1 do begin
    write(f2,pic2[n-1],',');
    inc(x);
    if x > 12 then begin
      x := 1;
      writeln(f2);
    end;
  end;
  writeln(f2,pic2[len-1],');');
end;

begin
  textmode(co80 +font8x8);
  assign(f1,'adnpic.bin');
  assign(f2,'adnpic.inc');
  reset(f1,1);
  rewrite(f2);
  blockread(f1,pic,8000);
  fillchar(pic2,8000,0);
  move(pic,mem[$b800:0],8000);
  readkey;
  pack;
  clrscr;
  fillchar(pic,8000,0);
  unpack;
  {move(pic[0],mem[$b800:0],8000);}
  readkey;
  save;
  close(f1);
  close(f2);
  textmode(co80);
  writeln(len);
end.
