program MsgTrans;
{$G+,A+,S-,X+}

uses
 Dos;

var
 F, G: text;
 FN: PathStr;
 S: string;
 D: DirStr;
 N: NameStr;
 E: ExtStr;
 CP: string [6];
 I: byte;

const
 BufSize = 32768;
 XCodes: array [#128..#255] of string [2] =
  ('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '');

function UpStr (S: string): string; assembler;
asm
 push ds
 cld
 lds si, S
 les di, @Result
 lodsb
 stosb
 xor ah, ah
 xchg ax, cx
 jcxz @3
@1:
 lodsb
 cmp al, 'a'
 jb @2
 cmp al, 'z'
 ja @2
 sub al, 20h
@2:
 stosb
 loop @1
@3:
 pop ds
end;

procedure Help;
begin
 FSplit (ParamStr (0), D, N, E);
 WriteLn (#13#10'MsgTrans - language editing module for X1');
 WriteLn ('Copyright (C) 1996 Tomas Hajny, XHajT03@mbox.vol.cz on Internet');
 WriteLn ('GNU General Public License version 2 or higher should be applied to this program');
 WriteLn ('Syntax: ', UpStr (N), ' <filename> <xxx>');
 WriteLn (' xxx - codepage number (3 - 6 digits); file CPxxx.DEF with predefined');
 WriteLn ('       structure located in current directory will be used for translation');
 WriteLn ('       of characters from upper half of the ASCII table to pseudocodes');
 Halt;
end;

type
 PLongint = ^longint;

begin
 if ParamCount < 1 then
 begin
  WriteLn (#13#10'Filename missing!!');
  Help;
 end;
 PLongint (@S [0])^ := 0;
 FN := ParamStr (1);
 if (Pos (FN [1], '/-') > 0) and (Pos (FN [2], 'hH?') > 0) then Help;
 FSplit (FN, D, N, E);
 if (UpStr (E) = '.BAK') or (UpStr (E) = '.$$$') then
 begin
  WriteLn ('Sorry - the input file must have extension other than ''.$$$'' or ''.BAK''.');
  Halt;
 end;
 S := ParamStr (2);
 if (S [0] < #3) or (S [0] > #6) then
 begin
  WriteLn (#13#10'Incorrect or missing codepage number (3 - 6 digits expected)!!');
  Help;
 end;
 CP := S;
{$I-}
 Assign (F, 'CP' + CP + '.DEF');
 if MaxAvail > BufSize then GetMem (TextRec (F).BufPtr, BufSize);
 Reset (F);
 if IOResult <> 0 then
 begin
  WriteLn (#13#10'Cannot read from codepage definition file');
  Help;
 end;
 while not (Eof (F)) and (IOResult = 0) do
 begin
  ReadLn (F, S);
  if (S [0] > #0) and (S [1] <> '#') and (S [1] <> ';') then
  begin
   if (S [2] <> '=') or (S [1] < #128) or (S [0] > #4) then
   begin
    WriteLn (#13#10'Incorrect structure of codepage definition file!!');
    WriteLn ('Lines have to be in form ''x=yy'', where ''x'' is a character from upper half');
    WriteLn ('of ASCII (i.e. >= #128) and ''yy'' is a pseudocode definition (max. 2 chars).');
    Halt;
   end;
   if XCodes [S [1]][0] > #0 then WriteLn (#13#10'Warning - ', S [1],
           ' already defined - ''', Copy (S, 3, 2), ''' ignored.') else
                                              XCodes [S [1]] := Copy (S, 3, 2);
  end;
 end;
 Close (F);
 Assign (F, FN);
 Reset (F);
 if IOResult <> 0 then
 begin
  WriteLn (#13#10'Cannot open input file!!');
  Help;
 end;
 Assign (G, D + N + '.$$$');
 if MaxAvail > BufSize then GetMem (TextRec (G).BufPtr, BufSize);
 Rewrite (G);
 if IOResult <> 0 then
 begin
  WriteLn (#13#10'Cannot create temporary file!!');
  Help;
 end;
 WriteLn ('Converting ...');
 while not (Eof (F)) and (IOResult = 0) do
 begin
  ReadLn (F, S);
  for I := 1 to byte (S [0]) do
           if (S [I] < #128) or (XCodes [S [I]] [0] = #0) then
                    Write (G, S [I]) else Write (G, '$(', XCodes [S [I]], ')');
  Write (G, #13#10);
 end;
 S [0] := #0;
 ReadLn (F, S);
 if IOResult = 0 then ;
 Write (G, S + #13#10#26);
 Close (G);
 Assign (G, D + N + '.BAK');
 Erase (G);
 if IOResult = 0 then ;
{I+}
 Close (F);
 Rename (F, N + '.BAK');
 Assign (F, D + N + '.$$$');
 Rename (F, N + E);
 with TextRec (F) do if BufPtr <> @Buffer then
 begin
  FreeMem (BufPtr, BufSize);
  BufPtr := @Buffer;
 end;
 with TextRec (G) do if BufPtr <> @Buffer then
 begin
  FreeMem (BufPtr, BufSize);
  BufPtr := @Buffer;
 end;
 WriteLn ('Done.');
end.
