;---- args.asm ----------------------------------------------------------
; This file contains both an argument grabber and a simple heap.
;
; By: David Kirschbaum
;
; Args parses the command line into a unix-style parameter array.
; To use it, you should be a .COM program: that is,
; you must start your program as follows:
;       code    segment public 'CODE'
;       assume  CS:code,DS:code,ES:code
;       extrn   _Args:near,argc:word,argv:word          ;argc & argv in CS:
;
; and end the file as follows:
;       code    ends
;       end
; Link to your program with LINK YOURFILE,args; then EXE2BIN YOURFILE.
; Your program should start with an ORG 100H statement, and should
; CALL _Args to have it parse the cmdline.
; Argc and Argv are just as in C; argc = # of params on cmd line,
; argv is an array of pointers to strings (null terminated, of course).
; Because MS-DOS doesn't pass us the name used to invoke the program,
; argv[0] always points to a null string.
; _Shift updates ARGC.
;
; See the file \bin\asm\exist.asm for an example.
; Do not call NEW before calling _Args.
;
; Changes:
;   16 July 1984   DRK    Copy args out of default location; fixed argv[0].
;   1 Aug 1984     DRK    Added _Shift.
;   16 Oct 1984    MCN    _Shift updates argc
;   21 Mar 1985    DRK	  oh yeah?
;Toad Hall Tweak
;	16-11-1995 MPT	  Quick hack to support wildcard expansion.
;			  Removed _Shift.
;			  Changed segment name to _TEXT.
;
;--------------------------------------------------------------------------

	PUBLIC	SetArgv, argc, argv, New, Dispose

ARGV_INC    EQU 128			; Size and increment of argv buffer.

; Predeclared file handles
STDIN   equ     0
STDOUT  equ     1
STDERR  equ     2
STDSIO  equ     3
STDPRN  equ     4


FILEINFO	   STRUC
	fiReserved	db	21 dup (?)
	fiAttribute	db	?
	fiTime		dw	?
	fiDate		dw	?
	fiSize		dd	?
	fiFileName	db	13 dup (?)
FILEINFO	   ENDS


; Declarations for accessing command line
NCHAR   equ     80h             ; address of number of chars in argument line
PARAMS  equ     81h             ; address of argument line

;---- code starts here --------------------------------------------------------


_TEXT	SEGMENT BYTE PUBLIC  'CODE'
	ASSUME	CS:_TEXT, DS:_TEXT, ES:_TEXT


SetArgv   PROC NEAR
	LOCAL	ArgStr:BYTE:128, \
		ArgvLen:WORD, ArgvLim:WORD, pArgs:WORD, \
		WildArg:WORD, WildArgc:WORD, WildPathLen:WORD \
		=@FrameSize

	push	bp
	mov	bp,sp
	sub	sp,@FrameSize

	; initialize

	mov	argc,0

	call	near ptr Newinit

	cld				; clear decrement mode
	mov	si, 0080h
	mov	ch,0
	mov	cl, [si]		; *CX = # of chars in command line
	inc	si
	jcxz	ExpandDone		; no arg chars -> we're done.

	push	cx			; Allocate the initial buffer for
	mov	cx,ARGV_INC		; expanding the command line into.
	call	New
	mov	pArgs,bx
	mov	ArgvLim,cx
	mov	ArgvLen,0
	pop	cx

	lea	di,ArgStr

	; Move arguments out of default DTA on the stack.

	push	cx
        push    di
        rep     movsb
	pop	si
        pop     cx

;Toad Hall:  When he's using redirection
;StdIn alone ("<") produces a command line length of 1 (space, CR)
;StdOut alone (">" : same result.
;StdIn and StdOut ("<wherever >wherever") produces a command line
;length of 2 (space, space, CR).
;A question mark alone would produce a command line length of 2
;(space, "?", CR).

        ; Big loop- find arguments...
ParmL:
        ; Little loop #1: strip leading blanks from argument.
	; while (i<NCHAR && PARAMS[i] = ' ') do i++;

StripL: lodsb                   ; al = [si++]
        cmp     al, ' '         ; space?
        loopz   StripL          ; if so, keep skipping.
        jne     GotOne          ; If we found a nonblank, skip zero test.
	jcxz	ExpandDone	; found no unblank chars -> we're done.

GotOne:
	dec	si		; bump SI back to start of nonblank.
	inc	cx

	mov	ah,0		; AH=Flags, 20h=Quoted 01h=Wild
	mov	di,si		; save pointer to this string

        ; Little loop #2: skip nonblank chars.
	; while (i<NCHAR && PARAMS[i] <> ' ') do i++;

SkipL:
	lodsb

	test	ah,020h
	jz	NotQuoted
	cmp	al,'"'
	jne	DoneChar
	and	ah,NOT 020h
	jmp	DoneChar

NotQuoted:
	cmp	al,'*'
	je	IsWild
	cmp	al,'?'
	jne	NoWild
IsWild:
	or	ah,01h
	jmp	DoneChar

NoWild:
	cmp	al,'"'
	jne	NotQuote
	or	ah,20h
NotQuote:

        cmp     al, ' '
	jz	GotArg
DoneChar:
	dec	cx
	jnz	SkipL

			; Last char of line was not blank.
	inc    si	; make next statement put null AFTER arg.

GotArg:
	dec	si

	push	si
	push	cx

	test	ah,01h
	jz	NoWildExpand

	mov	al,[si]
	mov	byte ptr [si],0
	push	si
	push	ax
	mov	si,di
	call	WildExpand
	pop	ax
	pop	si
	mov	[si],al

	add	argc,cx

	jmp	DoneArg

NoWildExpand:

	mov	cx,si
	sub	cx,di
	mov	si,di
	call	CopyToArgV

	inc	argc

DoneArg:

	pop	cx
	pop	si

	or	cx,cx
	jnz	ParmL		; if we ran off end of cmdline, no more args.

ExpandDone:

	mov	cx,argc 			; Allocate argv array, one
	inc	cx				; pointer for each argument
	inc	cx				; plus argv[0] and NULL.
	shl	cx,1
	call	New
	mov	argv,bx
	mov	word ptr [bx],0 		; argv[0] is the name of the
	inc	bx				; program and is unused at
	inc	bx				; the moment.

	mov	cx,argc
	jcxz	NoArgs

	mov	si,pArgs			; Find the nul terminator
BuildArgV:					; in the strings and transfer
	mov	di,si				; the string pointer to the
FindArg:					; argv array.
	lodsb
	or	al,al
	jnz	FindArg

	mov	[bx],di
	inc	bx
	inc	bx
	loop	BuildArgV

NoArgs:
	mov	word ptr [bx],0

	mov	sp,bp
	pop	bp

        ret
SetArgv   endp


CopyToArgV  PROC NEAR
	; SI=string CX=Number of characters


CheckLimit:
	mov	ax,ArgvLen
	add	ax,cx
	cmp	ax,ArgvLim			; Will the string fit inside
	jb	InLimit 			; the current argument buffer.
	push	cx
	mov	cx,ARGV_INC			; No, then extend the buffer.
	call	New
	add	ArgvLim,cx
	pop	cx
	jmp	CheckLimit
InLimit:
	mov	di,pArgs
	add	di,ArgvLen
	inc	ax
	mov	ArgvLen,ax

	jcxz	NoArg
	rep	movsb
NoArg:

	mov	al,0
	stosb
	ret
CopyToArgV  ENDP


WildExpand	PROC NEAR
	;SI=argument string, CX=number of expanded arguments (0 = no match)

	mov	WildArg,si
	mov	WildArgc,0

		; Find the length of the path prefix, if any.

	mov	bx, si
WildFindPath:
	lodsb
	and	al, al
	jz	WildEndPath
	cmp	al, '\'
	je	WildDelimiter
	cmp	al, ':'
	jne	WildFindPath
WildDelimiter:
	mov	bx, si				; save addr past last delimiter
	jmp	SHORT WildFindPath
WildEndPath:
	sub	bx,WildArg
	mov	WildPathLen,bx

	mov	ah,4Eh
	mov	cx,0			; file attribute
	mov	dx,WildArg
	int	21h			; DOS: Find First.
	jc	WildDone

		; We have a matching file. Add it to the destination string

WildAddArg:

	inc	WildArgc

	mov	si,WildArg		  ; Copy the argument path
	mov	cx,WildPathLen		      ; to the argument buffer.
	call	CopyToArgV
	dec	ArgvLen 			; **Remove the nul terminator**

	mov	si,0080h+fiFileName		; Find the length of the file
	mov	cx,0-1				; name.
WildNameLoop:
	lodsb
	inc	cx
	or	al,al
	jnz	WildNameLoop
WildNameNext:
	mov	si,0080h+fiFileName		; Copy the filename from FILEINFO.
	call	CopyToArgV

	mov	ah,4Fh
	int	21h			; DOS: Find Next.
	jnc	WildAddArg

WildDone:
	mov	cx,WildArgc

	ret
WildExpand	ENDP


;----- Newinit- initialize heap

Newinit proc    near
        mov     CS:firstfree, offset lastcode
        ret
Newinit endp


; Given length in CX, returns pointer in BX.
; Does not affect CX.
New     proc    near
        push    cx
        mov     bx, CS:firstfree
        add     cx, CS:firstfree
        mov     CS:firstfree, cx
        cmp     sp, cx
        pop     cx
        jbe     Newerror
        ret

stackmsg        db      '?New: heap overflow', 7, 13, 10
Newerror:
SML     equ     Newerror - stackmsg
        push    cs
        pop     ds
        mov     dx, offset stackmsg
        mov     cx, SML
        mov     bx, STDERR
        mov     ah, 40h
        int     21h
        mov     ax, 4c02h               ; terminate- error code 2
        int     21h
New     endp

;---- Call Dispose with ptr in BX, length in CX.
Dispose proc    near
        ret
Dispose endp

;------ Heap variables ------
firstfree       dw      ?

;---- parameter count, array ------------------------------------
; Pointers to parameter strings are held here.

null    dw      0               ; the null string
argc    dw      ?
argv	dw	?

lastcode        label   near

_TEXT	ENDS
	END
