/*
   filename: WCD.C

   Handy directory changer for MS-DOS and Unix.

   This program jumps to a (sub)directory.
   The directory to jump to can be given by only the first
   characters or with wildcards.

   wcd generates a treedata-file were it searches the directory.

   >wcd adir
   searches for a directory matching adir*
   wcd jumps to the last adir* matching directory found.
   A 100 % match of adir goes first and lets the user make a choise.

   Wildcards * and ? are supported.

Erwin Waterlander

Address :

	  Jongemastate 125
	  5655 HS Eindhoven, The Netherlands

E-mail  : waterlan@natlab.research.philips.com
 or     : waterlan@xs4all.nl
WWW     : http://www.xs4all.nl

======================================================================
= Copyright                                                          =
======================================================================
Copyright (C) 1997 Erwin Waterlander

This program is freeware.
Permission is granted to any individual or institution to use,
copy, redistribute or modify this program, provided this
copyright notice is retained.

For the DOS-16-bit and the Unix version I used DOSDIR. See copyright
below.
I used the matching algorithm of Info-Zip's unzip program. See copyright
below.

Both DOSDIR and UNZIP are distributed by the Simtel.Net(sm)
world-wide network

......................................................................

DOSDIR: A Portable DOS/UNIX/VMS
Directory Interface, version 2.1 by Jason Mathews,
NASA/Goddard Space Flight Center, Greenbelt, Maryland  20771-0001 USA

Copyright (C) 1994 Jason Mathews.

Permission is granted to any individual or institution to use, copy
or redistribute this software so long as it is not sold for profit,
provided this copyright notice is retained.
......................................................................

Copyright on recmatch() from Zip's match.c

Copyright (C) 1990-1992 Mark Adler, Richard B. Wales, Jean-loup Gailly,
Kai Uwe Rommel and Igor Mandrichenko.

Permission is granted to any individual or institution to use, copy,
or redistribute this software so long as all of the original files are
included unmodified, that it is not sold for profit, and that this copy-
right notice is retained.
=======================================================================
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <memory.h>
#include <dirent.h>
#include <dir.h>
#include <errno.h>
#include <unistd.h>
#include "match.h"

#define DD_MAXDIR 1024
#define DD_MAXDRIVE 3
#define EXIT_OK 0
#define ALT_SW || *argv[i]=='/'
#define TREEFILE "/treedata.wcd"
#define EXTRA_TREEFILE "/extra.wcd"
#define BANFILE "/ban.wcd"
#define ALIASFILE "/alias.wcd"
#define ROOTDIR "/"
#define DIR_SEPARATOR '/'
#define DIR_END '/'
#define ALL_FILES_MASK "*"
#define DIR_CUR	"."
#define DIR_PARENT  ".."
#define DIR_END	'/'

#define MAX_LIST 22   /* max list of perfect match directories */
#define MAX_WILD_LIST 22   /* max list of wild match directories */
#define MAX_EF 10         /* max nr. of extra tree-files */
#define VERSION      "1.8.2"
#define VERSION_DATE "Feb 13 1998"

#ifdef BASH
#  define GO_FILE "/wcd.go"
#endif


/* Global variables */

FILE *outfile;
char dir[DD_MAXDIR];
char org_dir[DD_MAXDIR];
char best_match[DD_MAXDIR];
char pm[MAX_LIST][DD_MAXDIR];
char wm[MAX_WILD_LIST][DD_MAXDIR];
char no_match =1, perfect_match = 0;
int  perfect_match_nr = 0, wild_match_nr = 0;
char quiet = 1;

/********************************************************************/

int
     ff_walker(const char *path, const struct ffblk *ff)
     {
	    if (ff->ff_attrib & FA_DIREC)

		 fprintf(outfile,"%s\n", path);

	   return 0;
     }


/********************************************************************
 *
 *                    finddirs(dir)
 *  Get the directory tree.
 *
 ********************************************************************/

void finddirs(char *dir)
{  int error;

	error = __file_tree_walk(dir, ff_walker);
	if (error)
	printf("error %d\n",error);

}
/********************************************************************
 *
 *                    checkban(char *dir,char *banfilename)
 *
 *  Returns 0 if directory is not banned.
 *  Returns 1 if directory is banned.
 *
 ********************************************************************/

int checkban(char *dir,char *banfilename)
{
	FILE *infile;
	char ban[DD_MAXDIR];
	char temp[DD_MAXDIR];
	int banned = 0;

	/* open treedata-file */
	if  ((infile = fopen(banfilename,"r")) == NULL)
	{
		banned = 0;
	}
	else
	{
		while ((!feof(infile) )&&(banned==0))
		{
			if(fscanf(infile,"%s",ban)==1)
			{
				if(strlen(dir)>=strlen(ban))
				{
					strncpy(temp,dir,strlen(ban));
					temp[strlen(ban)]='\0';
					if (stricmp(temp,ban)== 0)
					{
						banned = 1;
					}
				}
			}
		} /* while (!feof(infile) ) */
		fclose(infile);
	}
	return(banned);
}
/********************************************************************
 *
 *                    scanfile(char *filename)
 *
 *
 ********************************************************************/

void scanfile(char *filename, char *banfilename)
{
	FILE *infile;
	char line[DD_MAXDIR];
	char help1_str[DD_MAXDIR];
	char c;
	char *line_end,*help_str;
	int  i,j;
	char error = 0;

	if  ((infile = fopen(filename,"r")) == NULL)
	{
		fprintf(stderr,"Error opening file %s.\n",filename);
	}
	else
	{

		if( (help_str = strrchr(org_dir,DIR_SEPARATOR)) != NULL)
		 help_str++;
		else help_str = org_dir;

		if (!dd_iswild(help_str))
			{
			  strcpy(dir,org_dir);
			  strcat(dir,"*");
			}

		while (!feof(infile) )
		{
			j=0;                  /* read a line */
			error = 0;
			for(i=0; ((c=getc(infile)) != '\n') && (c!=EOF) ;i++)
				if (i < (DD_MAXDIR-1))
				{
					line[i]=c;
					j++;
				}
				else error = 1;
			line[j]='\0';  /* end string */


			if(error)
				printf("Error: line too long ( %d > %d). Fix: increase DD_MAXDIR.\n",i,(DD_MAXDIR-1));


			if( (line_end = strrchr(line,DIR_SEPARATOR)) != NULL)
				line_end++;
			else
				line_end = line;

			/* does the search string have a DIR_SEPARATOR? */

			  if( (help_str = strrchr(org_dir,DIR_SEPARATOR)) != NULL)
			    help_str++;
			  else help_str = org_dir;

			  strcpy(help1_str,"*");
			  strcat(help1_str,dir);

		 /* test for a perfect match */
			/* ignore case on a DOS platform */


			if ( (stricmp(line_end,help_str)==0) && (dd_match(line,help1_str,1)) )
			{

				  if(!quiet) printf("%s\n",line);
				  if(perfect_match_nr<=MAX_LIST)
				  if (checkban(line,banfilename) == 0)
				  {
				  	perfect_match =1;
					if(perfect_match_nr<MAX_LIST) strcpy(pm[perfect_match_nr],line);
					strcpy(best_match,line);
					perfect_match_nr++;
					no_match = 0;
				  }
			}
			else
			{
			  if( (help_str = strrchr(dir,'/')) != NULL)
			    help_str++;
			  else help_str = dir;


			/* test for a wild match if no perfect match */
			/* ignore case on a DOS platform */

			if ( (dd_match(line_end,help_str,1)) && (dd_match(line,help1_str,1)) && !perfect_match)
			{
				  if(!quiet) printf("%s\n",line);
				  if(wild_match_nr<=MAX_WILD_LIST)
	              if(checkban(line,banfilename) == 0)
	              {
		              if(wild_match_nr<MAX_WILD_LIST) strcpy(wm[wild_match_nr],line);
		              strcpy(best_match,line);
		              wild_match_nr++;
		              no_match = 0;
				  }
			}
			}

		}   /* while (!feof(infile) ) */
		fclose(infile);
	}


}
/********************************************************************
 *
 *                    scanaliasfile(char *filename)
 *
 *
 ********************************************************************/

void scanaliasfile(char *filename)
{
	FILE *infile;
	char line[DD_MAXDIR];
	char alias[256];

	/* open treedata-file */
	if  ((infile = fopen(filename,"r")) != NULL)
	{

		while (!feof(infile) )
		{

			if(fscanf(infile,"%s %s",alias,line)==2)
			{


			/* Only a perfect match counts, case sensitive */
				if  (strcmp(alias,org_dir)==0)
					{
						if(!quiet) printf("%s\n",line);

				/*		if(perfect_match_nr<=MAX_LIST)
							if (checkban(dir,banfilename) == 0)
							{    */
								perfect_match =1;
								if(perfect_match_nr<MAX_LIST) strcpy(pm[perfect_match_nr],
								    line);
								strcpy(best_match,line);
								perfect_match_nr++;
								no_match = 0;

						/*	} */
					}
			}
		}   /* while (!feof(infile) ) */
	fclose(infile);
	}
}

/********************************************************************
 *
 *                 Get int
 *
 ********************************************************************/

int wcd_get_int()
{
  int i;
  char string[256];

    gets(string);
    fflush(stdin); /* flush the input stream in case of bad input */

    i=atoi(string);

  return(i);
}

/********************************************************************
 *
 *                 Print help
 *
 ********************************************************************/
void printhelp()
{
#ifdef BASH
	printf("WCD  - Waterlander Change Directory %s (32 bit DOS BASH version)\n",VERSION);
#else
	printf("WCD  - Waterlander Change Directory %s (32 bit)\n",VERSION);
#endif
	printf("     - by Erwin Waterlander, %s.   Powerful chdir for Dos and Unix.\n\n",VERSION_DATE);
	printf("Usage:  wcd [drive:][dir] [-h] [-s] [-a] [-e] [-q] [-Q] [-c] [-v]\n");
	printf("            [-b] [-l] [-u <username>] [-f <treefile>]\n");
	printf("  dir (partial) name of directory to change to.\n");
	printf("      Wildcards *, ? and [SET] are supported!\n");
	printf("  -a  Add current directory to treedata\n");
	printf("  -e  add current directory to Extra treedata\n");
	printf("  -u  add treefile of other User (Unix only)\n");
	printf("  -q  Quiet operation (Unix)     unQuiet operation (DOS)\n");
	printf("  -Q  Quieter operation               -c  direct CD mode\n");
	printf("  -f  add extra treeFile              -l  aLias current dir (case sensitive)\n");
	printf("  -s  (re)Scan disk                   -b  Ban current path\n");
	printf("  -h  show this Help                  -v  print Version info\n");
	printf("\nExamples:\n");
	printf("   wcd Un -s               wcd src/wcd\n");
	printf("   wcd *ix                 wcd doe*/vhdl -u doe\n");
	printf("   wcd w*[1-3]             wcd src -q -f /home/doe/.extra.wcd\n");
	printf("   wcd d:games             wcd -a\n\n");
	printf("e-mail: waterlan@natlab.research.philips.com\n");
#ifdef BASH
	printf("---\nThis version works only in the DJGPP DOS bash\n");
	printf("---\nBourne Again Shell installation:\n");
	printf("Copy wcd.exe to your ~/bin directory.\n");
	printf("Add the following function to your ~/_bashrc file.\n");
	printf("   function wcd\n   {\n   c:/bin/wcd.exe $*\n   source ~/wcd.go\n   }\n");
	printf("Start a new bash and go.\n");
#endif
}
/********************************************************************
 *
 *             empty wcd.go file
 *
 ********************************************************************/

#ifdef BASH
void empty_wcdgo(char *go_file, int changedrive, char *drive)
{

	if  ((outfile = fopen(go_file,"w")) == NULL)
	{
		fprintf(stderr,"Error opening file %s for write.\n", go_file);
		exit(0);
	}
	if(changedrive == 1)
	fprintf(outfile,"cd %s\n",drive);
	else
	fprintf(outfile,"\n");
	fclose(outfile);

}
#endif

/********************************************************************
 *
 *                             MAIN
 *
 ********************************************************************/

int main(int argc, char **argv)
{

	int  i;
	char rootdir[DD_MAXDIR],treefile[DD_MAXDIR],banfile[DD_MAXDIR],aliasfile[DD_MAXDIR];
	FILE *infile;
	char scan_disk = 0;
	char *ptr;
	char extra_files[MAX_EF][DD_MAXDIR];
	char nr_extra_files = 0;
	int  quieter = 0, cd = 0;
	DIR* dirp; /* GJM */
	int len;
	static char tmp[DD_MAXDIR];      /* tmp string buffer */
	int destDisk;
	char drive[DD_MAXDRIVE];
	char string[256];

#ifdef BASH
	int  j,k;
	char help1_str[DD_MAXDIR];
	char go_file[DD_MAXDIR];
	int changedrive = 0;
	int disk = -1;
	strcpy(go_file,GO_FILE);
#endif
	strcpy(rootdir,ROOTDIR);
	strcpy(treefile,TREEFILE);
	strcpy(banfile,BANFILE);
	strcpy(aliasfile,ALIASFILE);

	if (argc == 1 )
	{
		printhelp();
		return EXIT_OK;
	}

	strcpy(dir,"");
	strcpy(org_dir,"");

	/* ---------------------- parse the commandline ------------*/


	for (i=1; i < argc; i++)
	{
		if (*argv[i]=='-' ALT_SW) /* is it a switch? */
			switch (argv[i][1]) {
			case 'S':
			case 's':
				  scan_disk = 1;
				break;
			case 'A':
			case 'a':
				getcwd(tmp, sizeof(tmp));
				if(tmp != NULL)
				{
				  len = strlen(tmp);
				  if (len==0 || tmp[--len] == DIR_END)
					tmp[len] = '\0';

				  /* open the treedata file */
				  if  ((outfile = fopen(treefile,"a")) == NULL)
				  {
				   fprintf(stderr,"Error opening file %s for write.\n", treefile);
				   exit(0);
				  }
				  else
				  {
				   while ((ptr=strchr(tmp,'\\'))) * ptr= DIR_SEPARATOR;
				   if ( (ptr=strstr(tmp,"/")) != NULL)
				   {
				   	fprintf(outfile,"%s\n",ptr);
				    printf("%s added.\n",ptr);
				   }
				  }
				  fclose(outfile);
				}
				break;
			case 'E':
			case 'e':
				getcwd(tmp, sizeof(tmp));
				if(tmp != NULL)
				{
					len = strlen(tmp);
					if (len==0 || tmp[--len] == DIR_END)
						tmp[len] = '\0';
					if  ((outfile = fopen(EXTRA_TREEFILE,"a")) == NULL)
					{
						fprintf(stderr,"Error opening file %s for write.\n", EXTRA_TREEFILE);
					}
					else
					{
						while ((ptr=strchr(tmp,'\\'))) * ptr= DIR_SEPARATOR;
				        if ( (ptr=strstr(tmp,"/")) != NULL)
				        {
						  fprintf(outfile,"%s\n",ptr);
						  printf("%s added.\n",ptr);
						}
						fclose(outfile);
					}
				}
				break;
			case 'c':
			case 'C':
				  cd = 1;
				break;
			case 'B':
			case 'b':
				getcwd(tmp, sizeof(tmp));
				if(tmp != NULL)
				{
					len = strlen(tmp);
					if (len==0 || tmp[--len] == DIR_END)
						tmp[len] = '\0';

					/* open the treedata file */
					if  ((outfile = fopen(banfile,"a")) == NULL)
					{
						fprintf(stderr,"Error opening file %s for write.\n", banfile);
					}
					else
					{
						while ((ptr=strchr(tmp,'\\'))) * ptr= DIR_SEPARATOR;
						if ( (ptr=strstr(tmp,"/")) != NULL)
						{
							fprintf(outfile,"%s\n",ptr);
							printf("%s added to banfile %s.\n",ptr,banfile);
						}
						fclose(outfile);
					}
				}
				break;
			case 'L':
			case 'l':
				printf("Enter alias for current directory: ");
				gets(string);
				fflush(stdin); /* flush the input stream in case of bad input */

				if(strcmp(string,"")!=0)
				{

				getcwd(tmp, sizeof(tmp));
				if(tmp != NULL)
				{
					len = strlen(tmp);
					if (len==0 || tmp[--len] == DIR_END)
						tmp[len] = '\0';

					/* open the treedata file */
					if  ((outfile = fopen(aliasfile,"a")) == NULL)
					{
						fprintf(stderr,"Error opening file %s for write.\n", aliasfile);
					}
					else
					{
						while ((ptr=strchr(tmp,'\\'))) * ptr= DIR_SEPARATOR;
						if ( (ptr=strstr(tmp,"/")) != NULL)
						{
							fprintf(outfile,"%s %s\n",string,ptr);
							printf("%s added to aliasfile %s.\n",ptr,aliasfile);
						}
						fclose(outfile);
					}
				}
				}
				break;
			case 'q':
				  quiet = 0;
				break;
			case 'Q':
				  quiet = 1;
				  quieter = 1;
				break;
			case 'v':
			case 'V':
				printf("WCD %s, %s\n",VERSION,VERSION_DATE);
				printf("Powerful chdir for Dos and Unix.\n\n");
				printf("WCD is freeware.\n\n");
				printf("Copyright (C) 1997-1998 Erwin Waterlander\n");
				printf("Copyright (C) 1994 Jason Mathews on DOSDIR\n");
				printf("Copyright (C) 1990-1992 Mark Adler, Richard B. Wales, Jean-loup Gailly,\n");
				printf("Kai Uwe Rommel and Igor Mandrichenko on recmatch()\n\n");
				printf("See also file wcd.txt\n\n");
				printf("Download the latest executables and sources from:\n");
				printf("http://www.xs4all.nl/~waterlan/\n");

				break;
			case 'f':
				break;
			default:               /* any switch except the above */
				printhelp();
#ifdef BASH       /* empty wcd.go file */
		empty_wcdgo(go_file,0,drive);
#endif
				return EXIT_OK;
			}
		else /* Not a switch. Must be a dir of filename. */
		{
                    if ((strcmp(argv[i-1],"-f") == 0 )
                       && (nr_extra_files < MAX_EF))
                        {
                          strcpy(extra_files[nr_extra_files],argv[i]);
                          nr_extra_files++;
                         }
                         else
						 {

						 strcpy(dir,argv[i]);
			             strcpy(org_dir,argv[i]);

		/* Change DIR_SEPARATOR to '/' if a '\' was typed
		   Avoid doing compares on strings
		   with backslashes. */
		                 while ((ptr=strchr(dir,'\\'))) * ptr='/';
		                 while ((ptr=strchr(org_dir,'\\'))) *ptr='/';
						 }
		}
	} /* for */


	/*--- end parsing commandline -----------*/



	if ((cd == 1)&&(strcmp(dir,"")!=0)) /* Try open dir direct. */
	{

		if((dirp=opendir(org_dir)) != NULL) /* GJM */
		{
			closedir(dirp); /* GJM */
			strcpy(best_match,org_dir);
			if (!quieter)
	   			printf("-> %s\n",best_match);

#ifdef BASH
	        j = strlen(best_match);
	        k = 0;
			for (i=0; i < j ; i++)
			{ if ( (best_match[i] == '$') || (best_match[i] == '"') )
	   			{
	   			help1_str[k] = '\\'; k++;
	   			}
	  		help1_str[k] = best_match[i];
	  		k++ ;
			}
			help1_str[k] = '\0' ;

			strcpy(best_match,"\"");
			strcat(best_match,help1_str);
			strcat(best_match,"\"");

			if  ((outfile = fopen(go_file,"w")) == NULL)
			{
				fprintf(stderr,"Error opening file %s for write.\n", go_file);
				exit(0);
			}
			fprintf(outfile,"cd %s\n", best_match);
			fclose(outfile);

#else
	   		chdir(best_match); /* change to directory */
#endif
	  		return EXIT_OK;
		}


	}

	/* is there a drive to go to ? */

	if (strlen(dir)>1)
	{

	strncpy(drive,dir,2);
	drive[DD_MAXDRIVE-1] = '\0';
	if (dd_match(drive,"[a-z]:",1))
	{
		destDisk = islower(*drive) ? *drive-'a' : *drive-'A';
#ifdef BASH
		changedrive = 1;
		disk = getdisk();
#endif
		if (destDisk >= 0)
		{
	   		setdisk(destDisk);
		}
		ptr = dir + 2;
		strcpy(org_dir,ptr);
		strcpy(dir,org_dir);

	}
	}


	/* does treedata-file exist? */
	if  ((infile = fopen(treefile,"r")) == NULL)
		scan_disk = 1;
	else fclose(infile);


	if (scan_disk)     /* (re)Scan the disk? */
	{
		printf("Please wait. (re)Scanning disk. Building treedata-file.\n");


	/* open the output file */
	if  ((outfile = fopen(treefile,"w")) == NULL)
          if  ( (ptr = getenv("TEMP")) != NULL )
           { strcpy(treefile,ptr);
             strcat(treefile,TREEFILE);
             if ((outfile = fopen(treefile,"w")) == NULL)
                if  ( (ptr = getenv("TMP")) != NULL )
                 { strcpy(treefile,ptr);
                   strcat(treefile,TREEFILE);
                   if ((outfile = fopen(treefile,"w")) == NULL)
                     if  ( (ptr = getenv("TMPDIR")) != NULL )
                       { strcpy(treefile,ptr);
			             strcat(treefile,TREEFILE);
                          if ((outfile = fopen(treefile,"w")) == NULL)
		                   {
			                 fprintf(stderr,"Error opening treefile for write.\n");
			                 exit(0);
		                   }
                       }
                  }
           }

           finddirs( rootdir ); /* Build treedata-file */
		fclose(outfile);

	}

	if (strcmp(dir,"")==0) /* is there a directory to go to? */
	{
#ifdef BASH       /* empty wcd.go file */
         /* restore original disk (if necessary) */
        if (disk >= 0) setdisk(disk);
		empty_wcdgo(go_file,changedrive,drive);
#endif
		return EXIT_OK;
	}
       scanfile(treefile,banfile); /* scan the treedata file */


	   if  ((outfile = fopen(EXTRA_TREEFILE,"r")) != NULL)
	   {
		 fclose(outfile);
		 scanfile(EXTRA_TREEFILE,banfile); /* scan the extra treedata file */
	   }

       /* search extra files */
       for (i=0;i<nr_extra_files;i++)
       {
         scanfile(extra_files[i],banfile); /* scan the extra treedata file */
       }

	   /* search alias file */
	   scanaliasfile(aliasfile);

	/* search is done */

#ifdef BASH
  /* restore original disk (if necessary) */
  if (disk >= 0) setdisk(disk);
#endif


	if ((perfect_match_nr > 1)&&(perfect_match_nr <= MAX_LIST))
	{
		for (i=0;(i<perfect_match_nr)&&(i<MAX_LIST);i++)
			printf("%d  %s\n",i+1,pm[i]);
		i= -1;
		printf("\nPerfect match for %d directories.\n",perfect_match_nr);
		printf("Please choose one (<Enter> to abort): ");
		i = wcd_get_int();

		if ( (i>0) && (i<=perfect_match_nr))
		{
			i--;
			strcpy(best_match,pm[i]);
		}
		else
		{
#ifdef BASH       /* empty wcd.go file */
		empty_wcdgo(go_file,changedrive,drive);
#endif
		return EXIT_OK;
		}
	}
	else if ((perfect_match==0)&&(wild_match_nr > 1)&&(wild_match_nr <= MAX_WILD_LIST))
	{
		for (i=0;(i<wild_match_nr)&&(i<MAX_WILD_LIST);i++)
			printf("%d  %s\n",i+1,wm[i]);
		printf("\nWild match for %d directories.\n",wild_match_nr);
		printf("Please choose one (<Enter> to abort): ");
		i=wcd_get_int();

		if ( (i>0) && (i<=wild_match_nr))
		{
			i--;
			strcpy(best_match,wm[i]);
		}
		else
		{
#ifdef BASH       /* empty wcd.go file */
		empty_wcdgo(go_file,changedrive,drive);
#endif
		return EXIT_OK;
		}
	} else if ((perfect_match==0)&&(wild_match_nr > MAX_WILD_LIST))
		no_match = 1;


	/*******************************/


	if ((no_match)&&(wild_match_nr > MAX_WILD_LIST))
	{  /* No perfect match, to many wild matches */

		printf("More than %d directories found matching %s\n",MAX_WILD_LIST,dir);
		printf("Try a more unique searchstring.\n");
#ifdef BASH       /* empty wcd.go file */
		empty_wcdgo(go_file,changedrive,drive);
#endif

	}
	else if ((no_match)&&(cd==0)) /* No match at all */
	{

		if((dirp=opendir(org_dir)) == NULL) /* GJM */
		{
			printf("No directory found matching %s\nPerhaps you need to rescan the disk or path is banned.\n",dir);
#ifdef BASH       /* empty wcd.go file */
		empty_wcdgo(go_file,changedrive,drive);
#endif
		}
		else
		{
			closedir(dirp); /* GJM */
			no_match = 0;
			strcpy(best_match,org_dir);
		}


	}else if (no_match)
	  	printf("No directory found matching %s\nPerhaps you need to rescan the disk or path is banned.\n",dir);


	/*******************************/


 	if ((no_match==0)&&(perfect_match_nr > MAX_LIST))
	{  /* Too many perfect matches */

		printf("More than %d directories found matching %s\n",MAX_LIST,org_dir);
		printf("Use subdirectory definition. Eg. wcd src/wcd\n");
#ifdef BASH      /* empty wcd.go file */
		empty_wcdgo(go_file,changedrive,drive);
#endif

	}
	else
    if (no_match==0) /* yes, a match */
	{
	   if (!quieter)
	   printf("-> %s\n",best_match);
#ifdef BASH
	j = strlen(best_match);
	k = 0;
	for (i=0; i < j ; i++)
	{ if ( (best_match[i] == '$') || (best_match[i] == '"') )
	   {
	   help1_str[k] = '\\'; k++;
	   }
	  help1_str[k] = best_match[i];
	  k++ ;
	}
	help1_str[k] = '\0' ;

	strcpy(best_match,"\"");
	strcat(best_match,help1_str);
	strcat(best_match,"\"");

		if  ((outfile = fopen(go_file,"w")) == NULL)
		{
			fprintf(stderr,"Error opening file %s for write.\n", go_file);
			exit(0);
		}

		if (changedrive)
		fprintf(outfile,"cd %s ; cd %s\n", drive, best_match);
		else
		fprintf(outfile,"cd %s\n", best_match);
		fclose(outfile);

#else
	   chdir(best_match); /* change to directory */
#endif
	}
	return EXIT_OK;
}
