echo off
echo.
echo Ŀ
echo  Unzip and then zip again a .zip file to remove -av label  
echo  By Prof. Timo Salmi, ts@chyde.uwasa.fi, Thu 27-Aug-1992   
echo 

rem If no parameters then give the instructions
if "%1"=="" goto _help

rem Check that the zip file exists
if not exist %1 goto _nofile

rem Check that there are no wild cards in the file name
for %%f in (%1) do if "%%f"=="%1" goto _is_ask
echo Wildcards are not allowed in %1
goto _out

rem Check that the ask.exe program is available
:_is_ask
set _found=
if exist ask.exe set _found=yes
for %%d in (%path%) do if exist %%d\ask.exe set _found=yes
if "%_found%"=="yes" goto _isunzip
echo Timo's batch enhancement ask.exe must be at path or in the current directory
goto _out

rem Check that the pkunzip.exe program is available
:_isunzip
set _found=
if exist pkunzip.exe set _found=yes
for %%d in (%path%) do if exist %%d\pkunzip.exe set _found=yes
if "%_found%"=="yes" goto _ispkzip
echo pkunzip.exe must be at path or in the current directory
goto _out

rem Check that the pkzip.exe program is available
:_ispkzip
set _found=
if exist pkzip.exe set _found=yes
for %%d in (%path%) do if exist %%d\pkzip.exe set _found=yes
if "%_found%"=="yes" goto _chk_r
echo pkzip.exe must be at path or in the current directory
goto _out

rem Check that there is a r: drive available
:_chk_r
if not exist r:\nul goto _noram

rem Make a temporary directory
if not exist r:\tmp$$$\nul md r:\tmp$$$

:_isempty
if not exist r:\tmp$$$\*.* goto _test
echo The auxiliary directory r:\tmp$$$ is not empty
:_ask1
ask Delete the files (y/n)? /d /u
if errorlevel==89 if not errorlevel==90 goto _del
if errorlevel==78 if not errorlevel==79 goto _out
goto _ask1

rem Delete files from r:\tmp$$$
:_del
del r:\tmp$$$\*.*
goto _isempty

rem Test archive integrity
:_test
pkunzip -t %1
if errorlevel==1 goto _unziperr
goto _ask2

:_unziperr
echo Error in %1
ask Continue nevertheless (y/n)? /d /u
if errorlevel==89 if not errorlevel==90 goto _ask2
if errorlevel==78 if not errorlevel==79 goto _out
goto _unziperr

:_ask2
ask Old %1 will be deleted, ok (y/n)? /d /u
if errorlevel==89 if not errorlevel==90 goto _pkunzip
if errorlevel==78 if not errorlevel==79 goto _out
goto _ask2

rem Unzip the .zip archive
:_pkunzip
pkunzip %1 r:\tmp$$$
if not exist r:\tmp$$$\*.zip goto _ask3
echo Warning: There are .zips within %1
pause

:_ask3
ask Insert e:\arczip\comment.txt as zip comment (y/n)? /d /u
if errorlevel==89 if not errorlevel==90 goto _com_yes
if errorlevel==78 if not errorlevel==79 goto _com_no
goto _ask3

rem Check that the comment.txt file program is available
:_com_yes
if exist e:\arczip\comment.txt goto _with_com
echo e:\arczip\comment.txt not found
echo Adjust the path as necessary
goto _out

rem Delete and make a new .zip archive with zip comment
:_with_com
del %1 > nul
pkzip -br:\ -mu -o -z %1 r:\tmp$$$\*.* < e:\arczip\comment.txt
goto _rd

rem Delete and make a new .zip archive without zip comment
:_com_no
del %1 > nul
pkzip -br:\ -mu -o %1 r:\tmp$$$\*.*
goto _rd

:_rd
pkzip -v %1
rd r:\tmp$$$
goto _out

rem Error messages
:_nofile
echo File %1 not found
goto _out

:_noram
echo You must have a (ram)disk available as drive r:
goto _out

:_help
echo                      Ŀ
echo Usage REZIP FileName  No wildcards  (paths are ok)
echo                      
echo Since someone cracked the pkzip 1.10 authenticity (-av) code some BBSes
echo have been putting in their own ads as the authenticity labels. The
echo purpose of this batch is to remove these labels, which may give the
echo users a false sense of security.
echo Note that any .zips within the .zip will not be cleaned.
echo.
echo You will need the following shareware and PD programs to use this batch.
echo They are available from good BBSes or from garbo.uwasa.fi by anonymous ftp.
echo      PKUNZIP.EXE and PKZIP.EXE from PKZ110.EXE or PKZ110EU.EXE
echo      ASK.EXE from TSBAT37.ZIP
echo.
echo Advanced trick for MsDos 3.30+: To use wildcards apply:
echo   for %%f in (*.zip) do call rezip %%f
echo If you get an "Out of environment space" message, increase your
echo environment space by using shell configuration in config.sys:
echo MsDos 3.30 example: shell=c:\bin\command.com /e:1024 /p
goto _out

:_out
set _found=
echo on
